TCJ #43

                            The Z-System Corner

                                  Jay Sage


   This time my column is going to be quite short.  In response to my
requests, a number of authors have submitted some very interesting articles,
but there has not been enough space to print them.  I want to make sure that
those articles are not delayed further.  One of them is on the superb LSH
history shell by Rob Friefeld, who has contributed quite a number of
excellent Z-System programs (SALIAS, VCOMP, and BCOMP, to name a few).  You
should not miss that article.

   After working first with the original Z-System history shell (HSH by
Michael Rubenstein) and then with EASE by Paul Pomerleau, it occurred to me
that it would be even nicer to have a full-screen history shell.  What I
envisioned was bringing the full resources of a wordprocessor to bear on the
command transcript, so that commands could be easily viewed, modified,
reordered, and regrouped.  If the history file were a standard ASCII file,
then one could massage the file with a standard editor or even prepare
'history' scripts in advance for special purposes.

   After seeing the splendid full-screen work Rob Friefeld had done in his
SALIAS (Screen ALIAS editor), I asked him if he would take on the task of
writing such a history shell.  He did, and he has done a splendid job.  I
would, therefore, like to publicly take credit for that all-important
management skill of asking the right person to do a job!


                          Software Update Service

   While Echelon was still in business marketing the Z-System, they offered
a very nice product called SUS or Software Update Service.  People who have
modems and a nearby Z-Node or RCP/M system generally do not have much
trouble picking up the latest releases of public-domain Z-System and general
CP/M software.  However, for those who do not have modems or for whom the
nearest Z-Node is an expensive long-distance call, obtaining a full set of
Z-System tools or keeping up with new releases is much more difficult.    
The Echelon SUS was designed to solve that problem by making the material
available on diskette by mail.  It was a disk subscription service, and
roughly every month subscribers would get a diskette full of public-domain
software.

   I am happy to announce that SUS is coming back, thanks to the urging and
energy of Chris McEwen, sysop of the Socrates Z-Node (#32), in Plainfield,
NJ.  Chris and Bill Tishey, together with Sage Microsystems East, will be
offering an even more extensive service than Echelon's.  Bill Tishey, as
most of you know, has for some time been maintaining a complete catalog of
Z-System programs (ZFILESnn.LST) and a compendium of HLP files covering all
of them.  At frequent intervals, Bill releases an update LBR with all the
new help files.  Now, in addition to that service, Bill will be putting
together diskettes with the software as well as the documentation.

   This means that you will be able to purchase diskettes with the complete
set of Z-System programs and/or subscribe to a monthly update service.  Bill
and Chris will be handling most of the diskette production; SME will handle
the orders and bookkeeping and will produce diskettes in the few formats
that Chris and Bill cannot handle (8" IBM SSSD, NorthStar hard-sector, and
Amstrad 3").

   We have not yet worked out all the pricing details for all the options,
but by the time you are reading this column, we will have flyers available
with all the information.  Just drop me a letter or postcard, or leave a
message for me in any of the ways indicated in the sidebar to this column,
and I will get a flyer to you.  To give you some idea of what we are talking
about, a 6-month SUS subscription to a US address will probably be $48 ($8
per disk) and a year's subscription $72 ($6 per diskette).  As you can see,
we are trying to keep the price very low.  We really want all of you to be
able to get and use all these wonderful programs.


                          Fully Customizing NZCOM

   My technical topic for this time will be about designing fully customized
NZCOM Z-Systems.  I have always been satisfied with the systems that can be
produced so easily using the MKZCM (MaKe nZCoM) menu-driven utility, and so
I never really delved into this area very much.  About a week or so ago,
however, Dave Goodman brought the problem to me.  He has a NorthStar Horizon
with an add-on hard disk, and the operating system has a ROM stuck somewhere
in the middle of the address space.  That left some disjoint blocks of free
memory, and Dave really wanted to make use of all the space.  I told him my
standard answer to that problem.

   In section 5 (especially subsection 5.2.3) of the NZCOM manual, I point
out that the NZCOM system is defined by a descriptor file and that this file
(with type ZCM) is a pure ASCII file that can be edited with one's favorite
text editor.  The manual recommends that everyone make certain changes so
that the descriptor will properly reflect the user's hardware environment,
such as the disk drives available and the characteristics of the system's
printer and terminal.

   I did not actually come out and say it explicitly, but there is an
implication that other values in the ZCM file can also be changed.  The
truth is, I believe, that I avoided this subject in part because I was not
entirely sure which values could and which values could not be changed.  My
suggestion to Dave Goodman was that he experiment with designing a custom
memory map for his system, edit the values into the ZCM file, and see what
happened when he tried to load it.

   Dave's report back to me, now confirmed by my own experiments on my
Televideo 803H, indicated that ALL values can be changed.  The only
requirement is that the values provide a memory map with no modules
overlapping.  When you use MKZCM to design the system, it takes over the
responsibility for generating a valid memory map; if you do the design
yourself, you better be careful.

A Helpful Utility

   This suggests a very nice utility program that some thoughtful soul could
contribute to the community.  This utility (let's call it ZMAP) might do a
number of helpful things.  First, it could display, perhaps in some
graphical or semi-graphical way, the memory map of a Z-System, the one
actually running or one specified in the form of a ZCM or ENV file (and
maybe even the Z3PLUS descriptor file of type Z3P).  Present utilities, such
as SHOW (ZSHOW) and Z3LOC, list the module addresses in a fixed order, not
in order of increasing memory address.  Thus they are not very helpful in
determining if there are gaps or overlaps in the map.  Ideally, ZMAP would
flag any such defects or potential defects in the map so that they could be
corrected before they cause harm.

   The final item on my wishlist -- and this might better be implemented in
a second, independent program (ZDESIGN perhaps) -- would be a general Z
System designer, along the lines of MKZCM but without its restrictions.  One
would be able to specify the order of all the modules in memory and their
sizes.  Given the highest memory address available, the program would then
figure out and display the memory map.  One should be able easily to alter
the order of the modules, and one should be able to override specific
addresses to create gaps if necessary (but not to force overlaps).  Once the
desired system has been designed, the program should write out a ZCM or ENV
file for it.  Such a program is a good candidate for implementation with a
high level language such as BDS Z or Turbo Pascal.  And it sure would have
helped me with the experiments that I am about to describe (several mistakes
resulted in crashes).

My Experiments

   Fig. 1 shows a printout of the standard NZCOM.ZCM file on my Televideo
803H.  It has already been customized in several ways using MKZCM.  First,
it allocates a 4-record VBIOS.  I use a version that fixes the 803's faux
pas of clobbering the index registers during BIOS calls and implements a
check of the Z-System drive vector for BIOS disk-select calls as described
in a previous column.  It also has room for a 20-record RCP, which allows me
to use a full-featured RCP with Carson Wilson and Rob Friefeld's resident
history shell, CLED (see RCPZRL11.LBR on Z-Nodes).

-----------------------------------------------------------------------------

E606 CBIOS	0080 ENVTYP	E3F4 EXPATH	0005 EXPATHS	D300 RCP
0014 RCPS	0000 IOP	0000 IOPS	DD00 FCP	0005 FCPS
DF80 Z3NDIR	0023 Z3NDIRS	E400 Z3CL	00CB Z3CLS	E280 Z3ENV
0002 Z3ENVS	E200 SHSTK	0004 SHSTKS	0020 SHSIZE	E380 Z3MSG
E3D0 EXTFCB	E4D0 EXTSTK	0000 QUIET	E3FF Z3WHL	0004 SPEED
0010 MAXDRV	001F MAXUSR	0001 DUOK	0000 CRT	0000 PRT
0050 COLS	0018 ROWS	0016 LINS	FFFF DRVEC	0000 SPAR1
0050 PCOL	0042 PROW	003A PLIN	0001 FORM	0000 SPAR2
0000 SPAR3	0000 SPAR4	0000 SPAR5	BB00 CCP	0010 CCPS
C300 DOS	001C DOSS	D100 BIO	0000 PUBDRV	0000 PUBUSR

Figure 1.  The ZCM descriptor file for the normal NZCOM system I use on my
Televideo 803H computer.

-----------------------------------------------------------------------------

   I decided to be cautious, especially after one of my new system designs
caused the system to hang, and I made a series of systems, each different
from the previous one in a relatively small way.  I am not going to show you
all the steps along the way but will go right to the most radically
different version.  See Fig. 2.  If you look carefully, I think you will
find that only the command line buffer (Z3CL) is still in the same place as
it was in the original system (but it is bigger now).

-----------------------------------------------------------------------------

E606 CBIOS	0080 ENVTYP	E3F4 EXPATH	0005 EXPATHS	D700 RCP
0014 RCPS	0000 IOP	0000 IOPS	D480 FCP	0005 FCPS
D200 Z3NDIR	0023 Z3NDIRS	E400 Z3CL	00FB Z3CLS	E180 Z3ENV
0002 Z3ENVS	E100 SHSTK	0004 SHSTKS	0020 SHSIZE	E280 Z3MSG
E2D0 EXTFCB	E300 EXTSTK	0000 QUIET	E2FF Z3WHL	0004 SPEED
0010 MAXDRV	001F MAXUSR	0001 DUOK	0000 CRT	0000 PRT
0050 COLS	0018 ROWS	0016 LINS	000F DRVEC	0000 SPAR1
0050 PCOL	0042 PROW	003A PLIN	0001 FORM	0000 SPAR2
0000 SPAR3	0000 SPAR4	0000 SPAR5	BA00 CCP	0010 CCPS
C200 DOS	001C DOSS	D000 BIO	0000 PUBDRV	0000 PUBUSR

Figure 2.  A radically reconfigured NZCOM system produced by manually
editing the ZCM file.

-----------------------------------------------------------------------------

   Perhaps you are wondering why I didn't make the most dramatic
demonstration possible by changing absolutely every address (and perhaps
size, too).  Well, there was an extra constraint that I was exploring with
this system.  I am running ZDDOS, and I have specified that the clock driver
be loaded into the so-called user buffer.  I have even applied the NZCOM
patch (NZCOMPAT.HEX) that comes with the ZSDOS/ZDDOS package so that when
new system configurations are loaded, the clock driver will be reconnected
to the DOS automatically without the need for running LDTIM again.

   If you know a lot about Z-System, you will know that there is no such
thing as a user buffer!  The user buffer is a special creature of NZCOM; it
is not defined in the Z-System environment descripter (or -- look closely --
in the ZCM file).  How, then, does one determine where this special gap in
the memory map of an NZCOM system is located?  That is exactly what I
wondered myself.  I could have called ZDOS authors Cam Cotrill or Hal Bower
and asked them how they infer its location, but I decided to experiment
instead.  What I found after various trials and errors was that the NZCOM
patch seemed to be happy and able to find the LDTIM clock module so long as
the command line buffer stayed in the same place.  Apparently, the
assumption is made that the user buffer is the memory from 100H above the
start of the command line buffer up to the real CBIOS (E400 to E5FF in my
case).

   I did not perform exhaustive tests of this hypothesis.  Let us just say
that it is not terribly prudent to try to make use of a 'user buffer' with a
fully customized system.  It would be wiser to design the system with a gap
below the CBIOS for the clock driver and to create a version of LDTIM with
an explicit load address.  The NZCOMPAT patch should be omitted from NZCOM
if such custom systems are going to be used.

A Few Bugs

   There were a few bugs in NZCOM that surfaced during this testing that
suggest that NZCOM.COM was not quite designed to work rigorously and to
handle the most general system loading situations.  Sometimes I found that
NDR modules became empty, and the command search path was rarely preserved
with these systems.  Code-containing modules, such as the FCP, RCP, DOS, and
so on, cannot be moved from one address to another.  If their starting
address changes, the code must be reloaded fresh from the ZRL file.  On the
other hand, modules that contain data, such as the NDR, shell stack, path,
message buffer, and so on, can and should be moved to any new address, so
long as there is room for the old contents in the new home.  NZCOM sometimes
failed to do this.  Maybe now that I have uncovered these small problems, I
can pass the information on to Joe Wright, and he can fix up the code to
handle these situations.
                                                                            