;
;	WHODERE.ASM by R.H.JOHNSON
;	Modifications by BILL WOOD (New name WHODERE1.ASM)
;
;	What you say in secret,
;		shall be shouted from the house tops.
;
; An SAU to display sneaky Bios reads and writes.
;
;	   A DEBUG PROGRAM FOR DISK READS AND WRITES
; This program will list all disk reads and writes to the
; CRT: (if CRT is TRUE) or to the LST: (if CRT is FALSE).
;
; N O T E :  This program runs in HI memory.
;	     CP/M must be moved below HI memory to allow
;	     room for this program. Set LOAD above CP/M.
;
;MODIFICATIONS:
;			------------
;03/30/82
;	Added routine to locate the address of BIOS.
;	Added conditional for output to CRT: or LST: .
;	Removed LDIR macro and added subroutine LDIR
;	to move memory. Program will now assemble with
;	ASM.COM .
;	Made other minor changes to program.
;
;		Bill Wood , Mississauga, Ontario, Canada.
;			------------
;
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
LOAD	EQU	62	;FREE MEMORY SPACE ABOVE CP/M (IN K)
;
NEWBIOS EQU	(LOAD*1024)+1
;
CRT	EQU	TRUE	;OUTPUT TO CRT: IF TRUE (LST: IF FALSE)
;
BASE	EQU	0
BDOS	EQU	BASE+5
CR	EQU	0DH
LF	EQU	0AH
;
;
	ORG	100H
;
START:	LHLD	BASE+1	 ;GET BIOS ADDRESS IN HL
	LXI	B,18H	 ;OFFSET TO SETDSK
	DAD	B	 ;ADD BC TO HL
	SHLD	WASBIOS  ;STORE IT
	LHLD	BASE+1	 ;GET BIOS ADDRESS IN HL
 ;
	IF	CRT
	LXI	B,9H	 ;CONOUT (CRT:)
	ENDIF
;
	IF	NOT CRT
	LXI	B,12	 ;LIST	(LST:)
	ENDIF
;
	DAD	B	 ;ADD BC TO HL
	SHLD	OVRLAY+1 ;OVERLAY BIOS CALL +1
;
;	COPY PROGRAM TO HIGH CORE
	LXI	H,PROGRAM
	LXI	D,NEWBIOS
	LXI	B,PROEND-PROGRAM
	CALL	LDIR
;
;	COPY OLD BIOS JUMPS TO TABLE
	LHLD	WASBIOS
	LXI	D,OLDDSK
	LXI	B,18
	CALL	LDIR
;
;	COPY IN NEWBIOS TABLE
	LHLD	WASBIOS
	XCHG
	LXI	H,SELDSK
	LXI	B,18
	CALL	LDIR
;
	LXI	D,SIGNIN
	MVI	C,9	;PRINT STRING
	CALL	BDOS
;	DONE
	JMP	BASE
;
;
WASBIOS:DS	2
;
SIGNIN: DB	' WHODERE1.ASM '
	DB	' VERSION 2.1 '
	DB	' 3/03/82  R.H.JOHNSON',CR,LF
	DB	' REV(1) BY BILL WOOD 03/30/82',CR,LF,LF
	IF	CRT
	DB	' ALL DISK READS AND WRITES WILL DISPLAY ON CRT:',CR,LF,LF
	ENDIF
	IF	NOT CRT
	DB	' ALL DISK READS AND WRITES WILL DISPLAY ON LST:',CR,LF,LF
	ENDIF
	DB	'$'
;
;
;	MOVE MEMORY
;	HL=GET	  DE=PUT     BC=COUNT
;
LDIR:	MOV	A,B
	ORA	C
	RZ		;RETURN IF COUNT IS 0
	MOV	A,M	;GET IT
	INX	H
	XCHG
	MOV	M,A	;PUT IT
	INX	H
	XCHG
	DCX	B	;COUNT
	JMP	LDIR
;
;
;
;	BIOS OVERLAY TABLE
;
SELDSK: JMP	NEWDSK
SETTRK: JMP	NEWTRK
SETSEC: JMP	NEWSEC
SETDMA: JMP	NEWDMA
SETRED: JMP	NEWRED
SETWRT: JMP	NEWWRT
;
;
;	START OF RELOCATED CODE
;
PROGRAM:EQU	$
OFFSET: EQU	NEWBIOS-PROGRAM
;
NEWDSK: EQU	$+OFFSET	;CONVERT DISK # TO LETTER
	PUSH	PSW		;PUT IN TABLE,
	MOV	A,C		;AND DOIT
	STA	TDISK
	POP	PSW
	JMP	OLDDSK
;
NEWTRK: EQU	$+OFFSET	;SEEK TO TRACK
	PUSH	PSW		;PUT IN TABLE,
	MOV	A,C		;AND DOIT
	STA	TTRACK
	POP	PSW
	JMP	OLDTRK
NEWSEC: EQU	$+OFFSET	;SET SECTOR NUMBER
	PUSH	PSW		;PUT IN TABLE,
	MOV	A,C		;AND DOIT
	STA	TSECT
	POP	PSW
	JMP	OLDSEC
NEWDMA: EQU	$+OFFSET	;SET START ADDRESS FOR I/O
	PUSH	PSW		;PUT IN TABLE,
	MOV	A,B		;AND DOIT
	STA	TDMA
	MOV	A,C
	STA	TDMA+1	
	POP	PSW
	JMP	OLDDMA
NEWRED: EQU	$+OFFSET	;READ SELECTED SECTOR
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MVI	A,'R'		;AND DOIT
	STA	OPCD
	CALL	CNVERT
	POP	PSW
	JMP	OLDRED
NEWWRT: EQU	$+OFFSET	;WRITE SELECTED SECTOR
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MVI	A,'W'		;AND DOIT
	STA	OPCD
	CALL	CNVERT
	POP	PSW
	JMP	OLDWRT
;
; CONVERTS STRING POINTED TO BY HL AND PUTS
; RESULT IN MEMORY POINTED TO BY DE
CNVERT: EQU	$+OFFSET
	PUSH	H
	PUSH	D
	PUSH	B
	LXI	H,TDISK
	LXI	D,DISK
	CALL	CVERT
;
	LXI	H,TTRACK
	LXI	D,TRACK
	CALL	CVERT
;
	LXI	H,TSECT
	LXI	D,SECT
	CALL	CVERT
;
	LXI	H,TDMA
	LXI	D,DMA
	CALL	CVERT
;
	LXI	H,TDMA+1
	LXI	D,DMA+2
	CALL	CVERT
;
	LXI	H,TABSTG
	CALL	MSG	
	POP	B
	POP	D
	POP	H
	RET
;
;
CVERT:	EQU	$+OFFSET
	MOV	A,M
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC	;CONVERT THE HIGH NIBBLE FIRST
	CALL	ASCII
	STAX	D	
	INX	D
	MOV	A,M	;STORE CHAR IN PRINT LINE
	ANI	0FH
	CALL	ASCII
	STAX	D
	RET		;CONVERT LOW NIBBLE
;
;
;CONVERT A TO ASCII
;
ASCII:	EQU	$+OFFSET
	ADI	30H
	CPI	'9'+1	;FE 3A OPCODE
	RM		
	ADI	7
	RET		;A NOW IN ASCIIFORM
;
;PMSG STRING POINTED TO BY HL TO CONSOLE
;MSB OF 1 IN LAST CHARACTER SENDS CR,LF.
;ZERO WILL ALSO END STRING WITH NO CR,LF...
;
;
MSG:	EQU	$+OFFSET
	MOV	C,M	;C=CHAR TO SEND TO CONSOLE
	CALL	CONOUT
	MOV	A,M
	ANI	80H
	JNZ	LFCR	;LAST ONE IF MSB=1
	INX	H
	MOV	A,M
	ORA	A	;TEST CHAR
	RZ		;C8 OPCODE
	JMP	MSG
;
;SEND CR,LF TO CONSOLE
;
LFCR:	EQU	$+OFFSET
	PUSH	B
	MVI	C,0DH
	CALL	CONOUT
	MVI	C,0AH
	CALL	CONOUT
	POP	B
	RET
;
CONOUT: EQU	$+OFFSET
	PUSH	H
	PUSH	D
	PUSH	B
	MOV	A,C
	ANI	7FH	;STRIP HIGH BIT
	MOV	C,A	;PUT IT BACK IN C FOR BIOS
OVRLAY: CALL	$-$	;CALL BIOS (ADDRESS OVERLAYED)
	POP	B
	POP	D
	POP	H
	RET
;
;
;	OLD BIOS STORAGE
OLDDSK: EQU	$+OFFSET
	DB 0,0,0
OLDTRK: EQU	$+OFFSET
	DB 0,0,0
OLDSEC: EQU	$+OFFSET
	DB 0,0,0
OLDDMA: EQU	$+OFFSET
	DB 0,0,0
OLDRED: EQU	$+OFFSET
	DB 0,0,0
OLDWRT: EQU	$+OFFSET
	DB 0,0,0
;
;PRINT TABLE STORAGE
TABSTG: EQU	$+OFFSET
	DB	' DSK- '
;
DISK:	EQU	$+OFFSET
	DB	20H,20H
	DB	' TRK- '
;
TRACK:	EQU	$+OFFSET
	DB	20H,20H
	DB	' SEC- '
;
SECT:	EQU	$+OFFSET
	DB	20H,20H
	DB	' DMA- '
;
DMA:	EQU	$+OFFSET
	DB	20H,20H,20H,20H
	DB	' OPCD-  '
;
OPCD:	EQU	$+OFFSET
	DB	20H,0A0H
;
;
;TEMP VALUE STORAGE
;
TDISK:	EQU	$+OFFSET
	DB	0
TTRACK: EQU	$+OFFSET
	DB	0
TSECT:	EQU	$+OFFSET
	DB	0
TDMA:	EQU	$+OFFSET
	DB	0,0
TOPCD:	EQU	$+OFFSET
	DB	0
;
;
PROEND: EQU	$
;
;
	END	START
