;COMPARE.ASM
;11/??/77 ORIGINALLY WRITTEN BY WARD CHRISTENSEN
;12/31/77 ADD PICKUP OF SECOND FILENAME IF BLANK
;01/08/77 ADD SEQIO MACLIB TO READ BIG BLOCKS
BSIZE	EQU	4096	;DISK BUFFER SIZE (TIMES 2)
	ORG	100H
	MACLIB	SEQIO
MOVE	MACRO	?F,?T,?L
	MVI	B,?L
	LXI	D,?F
	LXI	H,?T
	CALL	MOVER
	ENDM
;TYPE SINGLE CHAR OR CHAR IN A
TYPE	MACRO	?C
	IF	NOT NUL ?C
	MVI	A,?C
	ENDIF
	PUSH	B
	PUSH	D
	PUSH	H
	PUT	CON
	POP	H
	POP	D
	POP	B
	ENDM
PRINT	MACRO	?L
	LOCAL	Z
	CALL	Z
	IRP	?M,<?L>
	DB	?M
	ENDM
	DB	'$'
Z	POP	D
	MVI	C,@MSG
	CALL	@BDOS
	ENDM
;
;COMPARE.ASM - COMPARES 2 FILES
;
;COMMAND FORMAT: COMPARE NAME1 NAME2
;	IF NAME2 = NAME1 BUT IS ON B DISK,
;	JUST TYPE: COMPARE NAME1 B:
;
	PRINT	<'COMPARE.COM 1/8/78',0DH,0AH>
;
;INIT STACK
;
	POP	H	;GET CP/M RET ADDR
	SHLD	EXIT+1	;MODIFY RETURN ADDR
	LXI	SP,STACK	;GET MY STACK
;
;IF THE SECOND FCB IS BLANK,
;MOVE IN THE NAME FROM THE FIRST
;
	LDA	@TFCB+17
	CPI	' '
	JNZ	MOVE2	;NOT BLANK
	MOVE	@TFCB+1,@TFCB+17,11
;
;'DECLARE' BOTH FCB'S
;
MOVE2	FILE	INFILE,FILE1,,1,,BSIZE
	FILE	INFILE,FILE2,,2,,BSIZE
;
;COMPARE THE 2 FILES 1 BYTE AT A TIME
;
COMP	CALL	READ1
	MOV	B,A	;SAVE CHAR
	PUSH	B
	CALL	READ2
	POP	B
	CMP	B
	JZ	COMP
;
;FILES UNEQUAL
;
UNEQUAL	PRINT	'FILES UNEQUAL AFTER '
PRBYTES	LXI	D,BYTES
	MVI	C,@MSG
	CALL	@BDOS
	PRINT	<'LAST DATA READ FROM FILE 1:',0DH,0AH>
	LHLD	PRTPTR
	DCR	L
	MVI	B,0
PRTLP	INR	L
	MOV	A,M
	CPI	0DH
	JZ	GOTCR
	CPI	0AH
	JZ	TYPEIT
	CPI	9	;TAB
	JZ	TYPEIT
	CPI	' '
	JC	HEX
	CPI	7FH
	JNC	HEX
TYPEIT	TYPE
	LDA	COL
	INR	A
	STA	COL
	CPI	60
	JC	NEXT
	XRA	A
	STA	COL
	PUSH	B
	PUSH	H
	PRINT	<0DH,0AH>
	POP	H
	POP	B
	JMP	NEXT
GOTCR	XRA	A
	STA	COL
	MVI	A,0DH
	JMP	TYPEIT
HEX	PUSH	PSW	;SAVE CHAR
	TYPE	'('
	POP	PSW
	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
	CALL	NIBBL
	LDA	COL
	ADI	3
	STA	COL
	MVI	A,')'
	JMP	TYPEIT
NEXT	DCR	B
	JNZ	PRTLP
	JMP	EXIT
;
;READ BYTE FROM FILE 1
;
READ1	GET	FILE1
	JZ	EOF1	;GOT EOF?
	LHLD	PRTPTR
	MOV	M,A
	INR	L
	SHLD	PRTPTR
	PUSH	PSW	;SAVE CHAR
	LXI	H,BYTES+5
READI	MOV	A,M
	ORI	'0'	;IN CASE IT WAS BLANK
	INR	A
	MOV	M,A
	CPI	'9'+1	;TIME TO CARRY?
	JNZ	READNC
	MVI	M,'0'
	DCX	H
	JMP	READI
READNC	POP	PSW
	RET
;
;EOF ON FILE 1 - SET FLAG, READ 2
;
EOF1	MVI	A,'Y'
	STA	EOFLG
	CALL	READ2
	PRINT	<'EOF FILE 1, NOT FILE 2',0DH,0AH>
	JMP	UNEQUAL
;
READ2	GET	FILE2
	RNZ		;NO EOF
;

;GOT EOF ON FILE 2, MUST HAVE GOTTEN IT ON FILE 1
;
EOF2	LDA	EOFLG
	CPI	'Y'
	JZ	AOK
	PRINT	<'EOF FILE 2 BEFORE FILE 1',0DH,0AH>
	JMP	UNEQUAL
;
;A-OK - FILES MATCH
;
AOK	PRINT	'FILES MATCH, LENGTH IS '
	LXI	D,BYTES
	MVI	C,@MSG
	CALL	@BDOS
;NOTE THE FOLLOWING DOES NOT RESTORE CP/M'S
;STACK POINTER, BUT THAT IS 'OK' BECAUSE THE
;FIRST INSTRUCTION IN CP/M IS A LXI SP
EXIT	JMP	$-$	;CP/M RET ADDR (MODIFIED)
ERXIT	POP	D	;GET MESSAGE
	MVI	C,@MSG
	CALL	@BDOS
	JMP	EXIT
NIBBL	ANI	0FH
	CPI	10
	JC	NUM
	ADI	7
NUM	ADI	'0'
	TYPE
	RET
;MOVE FROM (DE) TO (HL) LENGTH IN B
MOVER	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVER
	RET
EOFLG	DB	'N'
COL	DB	0
BYTES	DB	'        BYTES',0DH,0AH,'$'
PRTPTR	DW	BUFF
	DS	30	;STACK
STACK	EQU	$
;ORG TO PAGE BECAUSE 'INR L' USED TO LOOP THRU IT
	ORG	($+255) AND 0FF00H ;TO PAGE
BUFF	EQU	$
	REPT	16
	DB	'                '
	ENDM
BUFFERS	EQU	$
MEMSIZE	EQU	BUFFERS+@NXTB
	END
    