;	PROGRAM NECSET.ASM
;
;	WRITTEN BY KENT WALKER
;	OCTOBER, 1982
;
;	8080 ASSEMBLER CODE
;	USING CP/M BDOS FUNCTIONS
;
;	THIS PROGRAM IS DESIGNED
;	TO SET THE
;	>>>>>>>>NEC-8023A-C<<<<<<<<
;	PRINTER PARAMETERS
;	VIA KEYBOARD INPUT.
;
;	A TABLE OF OPTIONS IS PRESENTED ON THE MONITOR.
;	INPUT IS TERMINATED BY A CARRIAGE RETURN.
;	INPUT CHARACTERS MUST BE IN UPPER CASE.
;
	ORG	100H
BDOS	EQU	0005H
INCHR	EQU	1	;KEYBOARD INPUT FUNCTION
LSTCHR	EQU	5	;CHARACTER TO LIST DEVICE FUNCTION
CR	EQU	000DH	;CARRIAGE RETURN
LF	EQU	000AH	;LINE FEED
TAB	EQU	0009H	;TAB CHARACTER
CLRSCR	EQU	001AH	;CLEAR SCREEN - CTRL Z - OSBORNE & TELEVIDEO
ESC	EQU	001BH	;ESCAPE CODE
SO	EQU	000EH	;SOCODE
SI	EQU	000FH	;SI CODE
PRSTR	EQU	9	;PRINT STRING FUNCTION
BOOT	EQU	0	;WARM BOOT
;
	LXI	SP,STACK	;SET UP STACK
	LXI	D,MESAGE	;POINT TO MESSAGE
	MVI	C,PRSTR		;STRING PRINT FUNCTION
	CALL	BDOS
;
LOOP	MVI	C,INCHR
	CALL	BDOS
	CPI	CR		;CARRIAGE RETURN ENDS INPUT
	JZ	BOOT
;
	LXI	H,PICA		;TEST FOR 'B'
	CPI	'B'
	JZ	LIST
;
	LXI	H,ELITE		;TEST FOR 'C'
	CPI	'C'
	JZ	LIST
;
	LXI	H,MICRON	;TEST FOR 'D'
	CPI	'D'
	JZ	LIST
;
	LXI	H,PROP		;TEST FOR 'P'
	CPI	'P'
	JZ	LIST
;
	LXI	H,EMPH		;TEST FOR 'E'
	CPI	'E'
	JZ	LIST
;
	LXI	H,NOEMPH	;TEST FOR 'F'
	CPI	'F'
	JZ	LIST
;
	LXI	H,DBLWD		;TEST FOR '2'
	CPI	'2'
	JZ	LIST
;
	LXI	H,SNGLWD	;TEST FOR '1'
	CPI	'1'
	JZ	LIST
;
	LXI	H,SIXLPI	;TEST FOR '6'
	CPI	'6'
	JZ	LIST
;
	LXI	H,EITLPI	;TEST FOR '8'
	CPI	'8'
	JZ	LIST
;
	JMP	LOOP
;
;
;	SUBROUTINE TO OUTPUT ESCAPE CODE TO PRINTER
;
LIST	MOV	E,M	;MOVE CHAR TO REG E
	PUSH	H	;SAVE STRING POINTER
	MVI	C,LSTCHR ;SET UP FOR LINE PRINTER
	CALL 	BDOS	;PRINT CHARACTER
	POP	H	;RESTORE STRING POINTER
	INX	H	;POINT TO NEXT CHAR
	MOV 	A,M	;MOVE NEXT CHAR TO REG A
	CPI	'$'	;IS IT THE TERMINATOR ($) ?
	JZ	LOOP	;RETURN IF YES
 	JMP	LIST	;ELSE REPEAT
;
;	END OF SUBROUTINE
;
;
;		MESSAGES
;
MESAGE	DB	CLRSCR,TAB,'NEC-8023 PRINTER FUNCTIONS',CR,LF,LF
	DB	TAB,'B = 10 CHARACTERS PER INCH',CR,LF
	DB	TAB,'C = 12 CHARACTERS PER INCH',CR,LF
	DB	TAB,'D = 17 CHATACTERS PER INCH',CR,LF
	DB	TAB,'P = PROPORTIONAL SPACING'	,CR,LF,LF
	DB	TAB,'E = EMPHASIZED PRINT'	,CR,LF
	DB	TAB,'F = NON-EMPHASIZED PRINT'	,CR,LF,LF
	DB	TAB,'2 = DOUBLE WIDTH PRINT'	,CR,LF
	DB	TAB,'1 = SINGLE WIDTH PRINT'	,CR,LF,LF
	DB	TAB,'6 = 6 LINES PER INCH'	,CR,LF
	DB	TAB,'8 = 8 LINES PER INCH'	,CR,LF,LF
	DB	'$'
;
;	TABLE OF PRINTER ESCAPE CODES
;
PICA	DB	ESC,'N$'
ELITE	DB	ESC,'E$'
MICRON	DB	ESC,'Q$'
PROP	DB	ESC,'P$'
EMPH	DB	ESC,'!$'
NOEMPH	DB	ESC,'"$'
DBLWD	DB	SO, '$'
SNGLWD	DB	SI, '$'	
SIXLPI	DB	ESC,'A$'
EITLPI	DB	ESC,'B$'
;
;	STACK AREA	
;
	DS	10H
STACK
;
	END
