;--------------------------------------------------------------
; MXT-AP31.ASM
;
REV	equ	30
;
; MEXplus Terminal Overlay for Apple ][+ and //e
;		     (][+ assumes videoterm card)
;--------------------------------------------------------------
; Revision History:
;--------+--------+----------+---------------------------------
;revision|  Date  |  Author  |	      Description
;--------+--------+----------+---------------------------------
;  3.1   | 7/6/87 | Jim Lill | Renamed using current MXT 
;        |	  |	     | convention. Fixed attributes 
;	 |	  |	     | take space problem.
;  3.0	 | 6/21/86| Jim Lill | Renamed properly with revision
;	 |	  |	     | control. Extensive attribute
;	 |	  |	     | changes. Added IF control for
;	 |	  |	     | assembly of ][+ and //e versions.
;	 |	  |	     | Added fkeys for PCPI-//e
;	 |	  |	     | Tested thoroughly with PCPI
;	 |	  |	     | 2nd hand report Softcard OK
;--------+--------+----------+---------------------------------
;APPLETER|  3/86  | jpl      | no revision number. Bug in Code
;	 |	  |	     | DO NOT USE
;--------+--------+----------+---------------------------------
;APLPCPI |  2/86  | jpl      | original version derived from
;	 |	  |	     | TVI950.ASM
;--------------------------------------------------------------
; This file must assemble in 384 bytes or less.
;
;
	org	01E80H
;
false	equ	0
true	equ	not false
esc	equ	1bh
;
;--------------------------------------------------------------
				;******************************
plus	equ	false		;set true for ][+, false for //e
pcpi	equ	true		;set true for Applicard
				;******************************
;--------------------------------------------------------------
;
;				;print title, must be 32 chars
;				;no more, no less
if plus
	db	'Apple ][+ '	;ten characters
endif
;
if not plus
	db	'Apple //e '	;ten characters
endif
;
if pcpi
	db	'and Applicard, v'	;sixteen chars.
endif
;
if not pcpi
	db	'and Softcard,  v'	;sixteen chars.
endif
;
	db	rev/10+'0','.'	;add revision number, two chars.
	db	rev MOD	10+'0'	;add rest of rev, one char
	db	'   '		;make up the balance for 32 total
	db	24		;# rows
	db	80		;# cols
	db	'R'		;Row, column first ("R" or "C")
	db	'B'		;Variable, binary x,y ("V" or "B")
	db	31		;Row offset \ Related to top col # and
	db	31		;Col offset / top column #, 13 lines below
	db	0 		;XY delay     (all delays in milliseconds)
	db	0		;CLS delay
	db	0		;CLREOS delay
	db	0		;CLRBOS delay
	db	0		;CLREOL delay
	db	0		;CLRBOL delay
	db	0		;CLREOL delay
	db	'N'		;Y/N Attributes take screen space
	db	'Y'		;Y/N Attributes can accumulate
	db	'Y'		;Lower case ok
	db	'Y'		;Generates control characters (most do)
	db	'N'		;ANSI compatible
	db	1		;top row # \ Added to r/c offsets above, 'cause
	db	1		;top col # / that's how Atlantis database works
	db	0,0,0		;rsvd
;
; End of fixed area.  The remainder of the record consists
; of variable-length function strings, each terminated in
; a zero.  If your terminal doesn't have a particular
; function, its string should be a "DB 0".
;
	db	esc,30,0	;home cursor
	db	esc,'*',0	;clear scrn
	db	esc,'=',0	;xy leadin
	db	0		;xy separator
	db	0		;xy end sequence
	db	esc,'Y',0	;clear from cursor to end of screen
	db	0		;clear from start of scrn to cursor
	db	esc,'T',0	;clear from cursor to end of line
	db	0		;clear from beginning of line to cursor
	db	13,esc,'T',0	;erase line  (synthesized from <cr> & CEOL)
	db	esc,')',0	;enter blink mode  \ uses reverse video
	db	esc,'(',0	;exit blink mode   / instead
	db	esc,')',0	;enter reverse video
	db	esc,'(',0	;exit reverse video
	db	esc,')',0	;enter underline mode \ uses reverse video
	db	esc,'(',0	;exit underline mode  / instead
	db	0		;enter bright-character mode\ don't try to use
	db	0		;exit bright		    / reverse here
	db	0		;enter dim-character mode   \ seems to have
	db	0		;exit dim		    / no effect
	db	esc,'(',0	;all attributes off
;
;keyboard stuff.... Used the familiar Wordstar keys
;
	db	5,0		;cur up key    ctrl-E
	db	18,0		;cur dn key    ctrl-X
	db	4,0		;cur rt key    ctrl-D
	db	13,0		;cur lt key    ctrl-S
;
; more codes
;
	db	7,0		;bell
;
if plus				;][+ doesn't support insert line
	db	0		;insert line
endif
;
if not plus
	db	esc,'E',0	;insert line on cursor's line
endif
;
	db	esc,'R',0	;delete cursor's line
	db	esc,'Q',0	;insert char at cursor position
	db	esc,'W',0	;delete char at cursor position
	db	0		;cursor on (enabled)
	db	0		;cursor off (disabled)
;
; The following are sequences generated by the terminal's
; function keys.  If your terminal doesn't have function
; keys, these should all be "DB 0"
;
if plus

	db	0		;fk 1
	db	0		;fk 2
	db	0		;fk 3
	db	0		;fk 4
	db	0		;fk 5
	db	0		;fk 6
	db	0		;fk 7
	db	0		;fk 8
	db	0		;fk 9
	db	0		;fk 10
;
endif
;
if (not	plus) and pcpi
;
; The //e and Applicard combination offers the nicety of the FUNCTION
; key assignments working with the open and closed Apple keys. If you
; want to be more like a TVI-950, make a file with the numeric keys
; assigned as follows and use one of the "Apple" keys to send the
; string.  You still can use the numerics with a MEX.KEY file for
; something else, accessed by ESC n
;
	db	1,'@',13,0		;fk 1
	db	1,'A',13,0		;fk 2
	db	1,'B',13,0		;fk 3
	db	1,'C',13,0		;fk 4
	db	1,'D',13,0		;fk 5
	db	1,'E',13,0		;fk 6
	db	1,'F',13,0		;fk 7
	db	1,'G',13,0		;fk 8
	db	1,'H',13,0		;fk 9
	db	1,'I',13,0		;fk 10

endif
;
; Graphics characters (line drawing).  If your terminal supports
; a graphic character mode, fill in the first two sequences; each
; time MEX prints a graphics character, it prints the enter-mode
; string, followed by the particular graphics character's string,
; followed by exit-graphics.  Some terminals do not have a graph-
; ics or line-drawing mode, but instead use a sequence to print a
; particular graphics character.  If that's the case with your
; terminal, define the enter and exit strings as "DB 0".
;
	db	0		;enter graphics mode
	db	0		;exit graphics mode
;
; These are the characters supported by MEX.  If your terminal
; doesn't support line-drawing characters, change each of these
; to a "DB 0".
;
	db	0		;vertical bar
	db	0		;horizontal bar
	db	0		;upper left corner character
	db	0		;upper right corner
	db	0		;lower left corner
	db	0		;lower right corner
	db	0		;crossed lines
	db	0		;vbar with right hand extension
	db	0		;vbar with left extension
	db	0		;hbar with upper extension
	db	0		;hbar with lower extension
	db	0		;small dot
	db	0		;solid white block
	db	0		;checkerboard
;
	db	0		;terminal init string
	db	0		;terminal de-init string
;
	end
