;TITLE - DIAL - Dialing Directory to phone nos. via POPCOM modem
; C.A.D. (Computer Aided Dialing ) Prog by R. Hirsh, 5-19-85  VER 1.1
;
; Program from REMARK Vol 6, Issue 10, Oct 85, page 73
;
;Prog is invoked with SHIFT-F12 key after installation.
;
BIOS	SEGMENT AT 40H
	ORG	9	;DISPLAY CHAR IN AL
BIOS_CONOUT LABEL FAR	; ON CONSOLE - SEE BCONIO.ASM
	ORG	18	;OUTPUT CHAR IN AL
BIOS_AUXOUT LABEL FAR	; TO AUX DEVICE - SEE BAUXIO.ASM
BIOS 	ENDS
;
;DEFINITIONS
ESC	EQU	27
CR	EQU	13
LF	EQU	10
TAB	EQU	9
DEN	EQU	21	;NO. OF ENTRIES IN DIRECTORY
KBDD	EQU	0F4H	;KEYBOARD DATA PORT
KBDS	EQU	0F5H	;KEYBOARD STATUS PORT: BIT 0, 1=> CHAR TO READ
			; BIT 1, 0=>KBD PROCESSOR READY
;
CODE	SEGMENT PARA PUBLIC 'CODE'
	ASSUME CS:CODE, DS:CODE, SS:CODE
	ORG	100H
;
START:	JMP 	INIT	;INIT INSTALLS INT SERV ROUT ADDR INTO VECTOR TABLE
;
;VARIABLES
BUFF	DB 	3 DUP (?)	;KEYBOARD INPUT BUFFER
CHRS	DB 	37		;CHARS IN DIALING STRING
INVMSG	DB 	CR,ESC,'K','INVALID ENTRY!  ENTER A NUMBER: ',0
;
OPTIONS	DB 	ESC,'m70',ESC,'E',CR,LF
	DB 	ESC,'m50',TAB,TAB,TAB,TAB,'MODEM DIALER',ESC,'m70',CR,LF,CR,LF
	DB 	ESC,'m40','COMPUTERS:',ESC,'m70'
	DB 	    '    0...VAX, Node A		6...Another BBS',CR,LF
	DB 	TAB,'    1...VAX, Node B		7...Byte BBS',CR,LF
	DB 	TAB,'    2...VAX, Node C		8...CompuServe',CR,LF
	DB 	TAB,'    3...VAX, Node D		9...	',CR,LF
	DB 	TAB,'    4...DEC10			10...	',CR,LF	
	DB 	TAB,'    5...Zenith BBS		11...	',CR,LF
	DB 	ESC,'m20','HUMAN:	',ESC,'m70'
	DB 	    '   12...Blaze Pascal, Joliet, IL',CR,LF
	DB 	TAB,'   13...Connie Cobol, Chgo, IL',CR,LF
	DB 	TAB,'   14...Frank Fortran, Tampa, FL',CR,LF
	DB 	TAB,'   15...	',CR,LF
	DB 	TAB,'   16...Weather	',CR,LF
	DB 	TAB,'   17...Smart Graphics, StL, MO',CR,LF
	DB 	TAB,'   18...Heath Soft. Consult., OS and LangSoft.',CR,LF
	DB 	TAB,'   19...Heath Soft Consult., Appl. Pgms.',CR,LF
	DB 	TAB,'   20...	',CR,LF
	DB 	TAB,'   21...EXIT DIAL',CR,LF,CR,LF
	DB 	ESC,'m60','Enter the number of the device or person you want to call and hit return: ',ESC,'m71',0
HGMG	DB 	CR,ESC,'K','Hit "H" to hang up or RETURN to exit DIAL program',0
;
;Enter numbers and special characters here (comma = 2 second pause)
MSG0	DB 	'ATD 123-4567,,,,,890123-111		',CR	;NODE A
	DB 	'ATD 123-4567,,,,,890123-222		',CR	;Node B
	DB 	'ATD 123-4567,,,,,890123-333		',CR	;Node C
	DB 	'ATD 123-4567,,,,,890123-444		',CR	;Node D
	DB 	'ATD 123-4567,,,,,890123-555		',CR	;Node D
	DB 	'ATD 616-982-3503			',CR	;ZEN 5
	DB 	'ATD					',CR	;6
	DB 	'ATD 603-924-9820			',CR	;BYTE 7
	DB 	'ATD 241-3101			',CR	;COMS 8
	DB 	'ATD					',CR	;9
	DB 	'ATD 				',CR	;10
	DB 	'ATD					',CR	;11
	DB 	'ATD					',CR	;12
	DB 	'ATD					',CR	;13
	DB 	'ATD					',CR	;14
	DB 	'ATD					',CR	;15
	DB 	'ATD 321-2222			',CR	;WEA 16
	DB 	'ATD 314-962-7833			',CR	;SG 17
	DB 	'ATD 616-982-3860			',CR	;ZEN OS 18
	DB 	'ATD 616-982-3884			',CR	;ZEN PG 19
	DB 	'ATD					',CR	;20
	DB 	'ATD					',CR	;EXIT 21
;
HGUP	DB 	'ATH0',CR	;HANG UP
;
;INT 5 SERVICE ROUTINE
INT5:	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	PUSH 	CS
	POP	DS

	CALL	MAIN

	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	BP
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	IRET
;
;MAIN PROGRAM
MAIN	PROC	NEAR
	MOV	SI,OFFSET OPTIONS	;LIST THE DIRECTORY NUMBERS
	CALL 	DISPLAY
;
GET_NUM:   CALL READKEYS		;READ IN THE CHARS
	CALL 	ASCII_BIN		;CONVERTS TO BINARY (NO. IN AX)
	JNC 	VALID			;IS THE ENTRY VALID?
	MOV 	SI,OFFSET INVMSG		; NO, DISPLAY ERROR MSG
	CALL 	DISPLAY
	JMP 	GET_NUM			; AND TRY AGAIN
VALID:	CMP 	AL,DEN
	JNB 	THRU			;EXI IF "DEN" OR GREATER IS CHOSEN
;
	MOV 	BX, OFFSET MSG0		;POINT TO MSG0
	MUL 	CHRS			;AX=AX*37
	ADD 	BX,AX			;POINT TO DESIRED MSG
;
	MOV 	CX,37			;GET SET TO SEND 37 CHARS
	CALL 	AUX_IT			;SEND STRING OUT TO AUX PORT
;
	MOV 	SI,OFFSET HGMG		;GIVE OPTION OF HANGING UP
	CALL 	DISPLAY
;
	CALL 	GET_KEY
	CMP 	AL,'H'			;IS IT AN H?
	JNE 	THRU			;NO, EXIT
;
	MOV 	BX, OFFSET HGUP		; YES, HANG UP
	MOV 	CX,5			;GET SET TO SEND 5 CHARS
	CALL 	AUX_IT			;SEND STRING OUT AUX PORT
;
THRU:	RET				;EXIT DIAL PROG
MAIN	ENDP
;
;PROC READS KEYS INTO BUFF UNTIL RETURN IS HIT.  ALLOWS THREE KEYS MAX.
READKEYS  PROC 	NEAR		;ON RETURN, BUFF'S STARTING ADDRESS IS IN BX AND
				;CHAR COUNT IS IN CX - FROM LJ SCANLON, P 236
	MOV 	DI,0		;DI IS KEY COUNT
	MOV 	CX,3		;GET READY FOR 3 KEYSTROKES MAX
GETKEY:	CALL 	GET_KEY		;READ A KEY, PUT CHAR IN AL
	CALL 	BIOS_CONOUT	;DISPLAY IT
	CMP 	AL,0DH		;IS IT A RETURN?
	JE 	SAV_CNT		;IF SO, EXIT VIA SAV_CNT
	MOV 	BUFF[DI],AL	;IF NOT, STORE THE CHAR (AL) IN MEMORY
				;LOCATION BUFF+DI (DI IS KEY COUNT)
	INC 	DI		; AND UPDATE THE KEY COUNT
	LOOP 	GETKEY		;GET NEXT KEY
SAV_CNT: MOV 	CX,DI		;FINAL KEY COUNT IS PUT INTO CX
	MOV 	BX,OFFSET BUFF	; AND LEAVE ADDRESS OF BUFF IN BX
	RET
READKEYS  	ENDP
;
;UPON ENTRY, STARTING ADRESS OF STRING SHOULD BE IN BX AND
; NO. OF CHARS IN CX. UPON RET. BIN NO. IS IN AX.
; IF NO. TYPED IS NON VALID CHAR, CARRY FLAG IS SET TO SIGNAL ERROR.
ASCII_BIN  PROC  NEAR
	XOR	AX,AX
; CONVERT THE STRING
RANGE:	CMP 	BYTE PTR [BX],'0'	;IS CHAR A NUMBER?
	JB	NON_DIG			;NO, JMP TO NON_DIG (ASCII CODE<30)
	CMP 	BYTE PTR [BX],'9'	;IS CHAR A NUMBER?
	JBE	DIGIT			;YES, JMP TO DIGIT (ASCII CODE<=39)
NON_DIG:	STC		;IF NOT A DIGIT, SET CF FOR ERROR MARKING
	JC 	END_CONV	; AND EXIT
DIGIT:	MOV	SI,10		;THE CHAR IS A NUMBER
	PUSH	DX
	MUL	SI		; SO MULTIPLY AX BY 10
	POP	DX		
	MOV	DL,[BX]	    ;FETCH CHAR AND PUT IT IN DL (6 IN ASCII IS 36)					
	AND	DX,0FH		;SAVE ONLY LOW BITS (36H--> 06H)
	ADD	AX,DX		;UPDATE PARTIAL RESULTS
	JC	END_CONV	;EXIT IF RESULT IS TOO BIG (IF CF SET)
	INC	BX		;OTHERWISE, INC BX AND CONTINUE
	LOOP	RANGE
	CLC			;WHEN DONE, CLEAR CF
END_CONV:	RET
ASCII_BIN	ENDP
;
;DISPLAY STRING AT SI ON CONSOLE
DISPLAY	PROC	NEAR
	MOV	AL,BYTE PTR [SI]
	OR	AL,AL		;DISPLAY IT UNTIL A '0' IS FOUND
	JNZ	DISCALL
	RET
DISCALL:  CALL	BIOS_CONOUT	;DISPLAY CHAR IN AL
	INC	SI
	JMP	SHORT DISPLAY
DISPLAY	ENDP
;
;PROC WAITS FOR A KEY TO BE HIT AND RETURN WITH CHAR IN AL
GET_KEY	PROC	NEAR
WAIT:	IN	AL,KBDS		;CHECK STATUS PORT
	AND	AL,1		; IF AL=1, CHAR TO READ
	JZ	WAIT
	IN	AL,KBDD		;READ CHAR
	RET
GET_KEY	ENDP
;
;PROC SEND A STRING OUT THE AUX PORT.  ENTER WITH NO. OF CHARS TO SEND IN CX
; AND BX-->STARTING ADDRESS OF SRRING.
AUX_IT	PROC	NEAR
LOOP1:	MOV	AL,[BX]		;PUT CHAR IN AL
	CALL	BIOS_AUXOUT	;OUTPUT CHAR TO MODEM PORT
	INC	BX
	LOOP	LOOP1		;OUTP[UT ALL THE CHARS
	RET
AUX_IT	ENDP
;
PGM_END	LABEL	NEAR	;*CODE BEYOND THIS POINT IS LOST AFTER INSTALLATION
;
;INSTALL INTERUPT SERVICE ROUTINE ADDRESS IN JUMP TABLE
INIT:	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX		;DS=SEGMENT OF INT SERV RT JMP TABLE (=0)
	MOV	SI,5*4		;OFFSET OF INT 5
	CLI			;INTS OFF
	MOV	WORD PTR [SI],OFFSET INT5	;INSTALL OFFSET OF ROUTINE
	MOV	WORD PTR [SI+2],CS		;INSTALL SEGMENT OF ROUTINE
	STI					;START INTS
	POP	DS
	MOV	SI,OFFSET MG		;PRINT INSTALLATION MESSAGE ON CRT
	CALL	DISPLAY
	MOV	DX,OFFSET PGM_END	;TERMINATE AND STAY RESIDENT
	INT	27H
;
MG	DB	ESC,'m20','DIAL Software Installed!',ESC,'m40',CR,LF
	DB	'Hit SHIFT-F12 when ready to dial.',ESC,'m70',CR,LF,0
;
CODE	ENDS
	END	START
