;
;	DURA-SELECTRIC I/O DRIVER
;
;	4/21/79    J. A. PREST
;
;	THIS IS A SIMPLE CODE CONVERTER FOR THE DURA MACH 10
;	I/O TYPEWRITER.  THIS MACHINE IS SIMILAR TO THE
;	IBM SELECTRIC AND USES THE SAME TYPE ELEMENTS.
;	THE PROGRAM IS SET UP WITH TWO CODE TABLES ONE FOR
;	THE COURIER 12, 12-PITCH (PART #132) BALL AND ONE FOR
;	THE MANIFOLD 72, 10-PITCH (PART #019) BALL.  THE
;	COURIER CAN BE USED FOR CORRESPONDENCE AND REPORT
;	WRITING.  THE MANIFOLD BALL IS USED FOR HEX PRINTOUTS
;	SINCE THERE IS NO NEED TO SWITCH CASE WHEN GOING FROM
;	ALPHA TO NUMERIC.  THIS WILL SAVE WEAR AND TEAR ON THE
;	PRINTER.  
;
STATUS:	EQU	2	;DURA STATUS PORT
SELSTA:	EQU	2	;DURA READY FLAG
SELDTA:	EQU	1	;DURA DATA PORT
UCSHFT:	EQU	88H	;SELECTRIC UP-SHIFT CODE
LCSHFT:	EQU	90H	;    "    DOWN  "    "
CASE:	EQU	0FB4FH	;RAM FOR CASE FLAG
COURIER:   EQU	1	;1=COURIER   0=MANIFOLD
MANIFOLD:  EQU	NOT COURIER
;
;	UNIVERSAL SELECTRIC OUTPUT
;
	 ORG	0E100H	;COURIER 12 ROM
SELCONC: MOV	A,C	;ENTER HERE WITH DATA IN REG C
	 DB	0FEH	;DUMMY CPI TO GET AROUND NEXT BYTE
SELCONB: MOV	A,B	;ENTER HERE WITH DATA IN REG B
SELCONA: PUSH	H	;ENTER HERE WITH DATA IN REG A
	 PUSH	B	;SAVE HL AND BC
	 CALL	SELCON	;CONVERT AND PRINT
	 POP	B
	 POP	H
	 RET		;BACK WE GO
;
SELCON:	CPI	' '+1	;SPACE IS A CONTROL CHAR
	JC	CTLCHR
	LXI	H,TABLE-20H
	ANI	7FH	;STRIP OFF MSB
	MVI	B,0
	MOV	C,A
	DAD	B
	MOV	A,M
	ANI	0C0H	;SAVE 2 MSB'S
	RZ		;IF BOTH BIT 6&7 ARE 0 NO CONVERSION
	CPI	0C0H
	JZ	NOSHFT	;PRINT IN ANY CASE
	CPI	80H
	LDA	CASE
	JNZ	UPPER	;AN UPPER CASE CHAR
LOWER:	CPI	LCSHFT
	JZ	NOSHFT
	MVI	A,LCSHFT
LOWER2:	STA	CASE
	CALL	PRINT
NOSHFT:	MOV	A,M	;GET THE CHAR BACK
	ORI	0C0H	;SET 2 MSB = 1
PRINT:	PUSH	H
	PUSH	PSW
PRINT4:	IN	STATUS
	ANI	SELSTA
	JZ	PRINT4
PRINT6:	POP	PSW
	OUT	SELDTA
	POP	H
	RET
;
CTLCHR:	LXI	H,FNTABL-1
CTLCH2:	INX	H
	CMP	M
	INX	H
	RC
	JNZ	CTLCH2
	MOV	A,M
	JMP	PRINT
;
UPPER:	CPI	UCSHFT
	JZ	NOSHFT
	MVI	A,UCSHFT
	JMP	LOWER2
;
;	FUNCTION TABLE
;
FNTABL:	DB	9,81H	  ;TAB
	DB	0DH,82H	  ;RETURN
	DB	1AH,0A0H  ;BACKSPACE
	DB	1CH,88H   ;SHIFT UP
	DB	1DH,90H   ;SHIFT DOWN
	DB	20H,84H   ;SPACE
	DB	0FFH	  ;END OF TABLE
;
;	LOOK-UP TABLES FOR TYPE ELEMENTS
;	BIT 6&7 ARE USED AS FLAGS:
;
;	BIT 7     BIT 6      CHARACTERISTICS
;	  0	   0	     NO CONVERSION
;	  0	   1	     UPPER CASE
;	  1	   0	     LOWER CASE
;	  1	   1	     PRINTS IN EITHER CASE
;
	IF	COURIER
;
;	COURIER 12 TYPE ELEMENT
;	UPPER AND LOWER CASE ALPHA, NUMERALS AND MOST
;	PUNCTUATION MARKS.  BRACKETS AND BRACES CONVERT
;	TO ( AND ).
;
TABLE:	DB	4,7FH,55H,7EH	     ;SPACE EX.PT   "     #
	DB	79H,75H,7DH,95H	     ;  $     %     &     '
	DB	70H,71H,7CH,46H	     ;  (     )     *     +
	DB	0CCH,80H,0D6H,89H    ;  ,     -     .     /
	DB	0B1H,0BFH,0B6H,0BEH  ;  0     1     2     3
	DB	0B9H,0B5H,0B4H,0BDH  ;  4     5     6     7
	DB	0BCH,0B0H,4DH,8DH    ;  8     9     :     ;
	DB	70H,86H,71H,49H	     ;  (     =     )     ?
	DB	76H,5CH,60H,6CH	     ;  @     A     B     C
	DB	6DH,65H,4EH,4FH	     ;  D     E     F     G
	DB	61H,54H,47H,64H      ;  H     I     J     K
	DB	69H,5FH,66H,59H      ;  L     M     N     O
	DB	45H,44H,5DH,51H      ;  P     Q     R     S
	DB	67H,6EH,5EH,50H      ;  T     U     V     W
	DB	6FH,41H,77H,70H	     ;  X     Y     Z     (
	DB	89H,71H,97H,40H	     ;  /     )    1/2    US
	DB	95H,9CH,0A0H,0ACH    ;  '     A     B     C
	DB	0ADH,0A5H,8EH,8FH    ;  D     E     F     G
	DB	0A1H,94H,87H,0A4H    ;  H     I     J     K
	DB	0A9H,9FH,0A6H,99H    ;  L     M     N     O
	DB	85H,84H,9DH,91H      ;  P     Q     R     S
	DB	0A7H,0AEH,9EH,90H    ;  T     U     V     W
	DB	0AFH,81H,0B7H,70H    ;  X     Y     Z     (
	DB	7FH,71H,57H,0	     ;EX.PT   )    1/4    NC
	ENDIF
;
;
	IF MANIFOLD
;
;	MANIFOLD 72 TYPE ELEMENT
;	UPPER CASE ALPHA, NUMERALS, AND MOST PUNCTUATION
;
TABLE:	DB	0,97H,55H,7EH	     ;SPACE EX.PT   "     #
	DB	79H,75H,7DH,95H	     ;  $     %     &     '
	DB	70H,71H,7CH,46H	     ;  (     )     *     +
	DB	0CCH,80H,0D6H,89H    ;  ,     -     .     /
	DB	0B1H,0BFH,0B6H,0BEH  ;  0     1     2     3
	DB	0B9H,0B5H,0B4H,0BDH  ;  4     5     6     7
	DB	0BCH,0B0H,4DH,8DH    ;  8     9     :     ;
	DB	70H,86H,71H,49H	     ;  (     =     )     ?
	DB	76H,0DCH,0E0H,0ECH   ;  @     A     B     C
	DB	0EDH,0E5H,0CEH,0CFH  ;  D     E     F     G
	DB	0E1H,0D4H,0C7H,0E4H  ;  H     I     J     K
	DB	0E9H,0DFH,0E6H,0D9H  ;  L     M     N     O
	DB	0C5H,0C4H,0DDH,0D1H  ;  P     Q     R     S
	DB	0E7H,0EEH,0DEH,0D0H  ;  T     U     V     W
	DB	0EFH,0C1H,0F7H,70H   ;  X     Y     Z     (
	DB	89H,71H,57H,40H	     ;  /     )    DEG    US
	DB	95H,0DCH,0E0H,0ECH   ;  '     A     B     C
	DB	0EDH,0E5H,0CEH,0CFH  ;  D     E     F     G
	DB	0E1H,0D4H,0C7H,0E4H  ;  H     I     J     K
	DB	0E9H,0DFH,0E6H,0D9H  ;  L     M     N     O
	DB	0C5H,0C4H,0DDH,0D1H  ;  P     Q     R     S
	DB	0E7H,0EEH,0DEH,0D0H  ;  T     U     V     W
	DB	0EFH,0C1H,0F7H,70H   ;  X     Y     Z     (
	DB	97H,71H,7FH,0	     ;EX.PT   )     +-    NC
	ENDIF
	END	START
