;	    UIMS.ASM ver 1.0
;    adapted by Keith Petersen, W8SDZ
;	    (revised 3/14/81)
;
;USER AREA FOR BSTAM VER 4.3 FOR USE WITH THE
;INDUSTRIAL MICROSYSTEMS SERIAL PRINTER PORT
;
LSTSTAT	EQU	12H	;STATUS PORT
LSTDAT	EQU	13H	;DATA PORT
;
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
;
;	IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;	(NOT INCLUDING  SP  REGISTER).  BE SURE TO PUSH BSTAM'S
;	REGISTERS ON TO STACK AND POP THEM BACK OFF BEFORE
;	RETURNING TO BSTAM.  THERE IS AMPLE ROOM TO PUSH ALL
;	REGISTERS ONTO BSTAM'S STACK, PLUS ROOM FOR 10 LEVELS
;	OF CALLS.  THERE ARE 300 BYTES OF USER SPACE AVAILABLE
;	TO YOU.  THE JUMPS CODED AT THE BEGINNING OF THIS PROGRAM
;	CANNOT BE MOVED IN ANY WAY.
;
BEGIN	ORG	103H			
INITIL	JMP	INITIU	;UART/USART INITIALIZATION ENTRY POINT
INSPORT	JMP	INSPRU	;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU	;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU	;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU	;WRITE DATA PORT ENTRY POINT
;
;
INITIU	EQU	$
;
;	THIS IS THE UART/USART INITIALIZATION ROUTINE.
;	TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;	INITIALIZATION GUIDE LINES:
;
;		1. USE 1 STOP BIT	(OPTIONAL - 2)
;		2. USE 8 DATA BITS	(MUST)
;		3. USE 1 START BIT	(MUST)
;		4. USE 16X FOR CLOCK RATE 	(MUST)
;		5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
	CALL	SIGNON	;TELL USER WHAT'S IMPLEMENTED
	IN	LSTDAT	;CLEAR DATA FROM INPUT PORT
	IN	LSTDAT	;MAKE SURE IT'S CLEAR
	RET
;
;
INSPRU	EQU	$
;
;	THIS IS THE STATUS READ PORT ROUTINE.
;	WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;	THE FOLLOWING BITS TO BE SET IF NEEDED:
;		1. 20 BIT SET IF FRAMING ERROR
;		2. 10 BIT SET IF OVERRUN ERROR
;		3. 08 BIT SET IF PARITY  ERROR
;		4. 04 BIT SET IF TRANSMITTER EMPTY
;			IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;			EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;		5. 02 BIT SET IF RECEIVER READY
;		6. 01 BIT SET IF TRANSMITTER READY
;		7. DO NOT SET THE 80 BIT OR 40 BIT
;
	IN	LSTSTAT	;GET STATUS BITS FROM IMS STATUS PORT
	RLC		;MOVE INTO PLACE FOR BSTAM
	ANI	6	;REMOVE UNWANTED BITS
	ORI	1	;OR-IN BOGUS TRANS READY BIT
	RET		;RETURN TO BSTAM
;
;
ERRSTU	EQU	$
;
;	THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;	YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;	OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;	CASE, JUST DO A RETURN.
;
	IN	LSTDAT	;CLEAR DATA FROM INPUT PORT
	IN	LSTDAT	;MAKE SURE IT'S CLEAR
	RET		;RETURN TO BSTAM
;
;
INPRTU	EQU	$
;
;	THIS IS THE READ DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;	STATUS READ ROUTINE MUST HAVE BEEN SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;	RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
	IN	LSTDAT	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
OUTPRU	EQU	$
;
;	THIS IS THE WRITE DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;	OF STATUS READ MUST BE SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;	REGISTER A CONTAINS THE OUTPUT DATA.
;
	OUT	LSTDAT	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
;
MESSGE:	DB	CR,LF,CR,LF
	DB	'INDUSTRIAL MICROSYSTEMS SERIAL PRINTER PORT '
	DB	'- ver 1.0',CR,LF,'$'
;
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5	;ANNOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
