;
;VERSION UH89 	(revised JANUARY 30, 1981)
;
;User routines for BSTAM version 4.3, for use with
;Heath H8 with H8-4 or H89 with H-3 serial port.
;TBE=20H, RDA=01H.  By Keith Petersen, W8SDZ
;
;BASE ADDRESS OF CP/M
;USE:	4200H FOR CP/M VERSION 1.43 AND BELOW.
;	0000H FOR CP/M VERSION 2.0 AND ABOVE.
;
BASE	EQU	0000H	;OFFSET OF CP/M FROM 0H
;
;DEFINE PORT
;
PORT	EQU	330Q	;8250 PORT BASE ADDRESS
;
;DEFINE BAUD RATE DIVISORS
;
B75	EQU	0600H	;75 BAUD
B110	EQU	041FH	;110 BAUD
B150	EQU	0300H	;150 BAUD
B300	EQU	0180H	;300 BAUD
B600	EQU	00A0H	;600 BAUD
B1200	EQU	0060H	;1200 BAUD
B2400	EQU	0030H	;2400 BAUD
B4800	EQU	0018H	;4800 BAUD
B9600	EQU	000AH	;9600 BAUD
B19200	EQU	0006H	;19200 BAUD
;
;DEFINE ASCII CHARACTERS USED
;
CR	EQU	0DH
LF	EQU	0AH
;
;	IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;	(NOT INCLUDING  SP  REGISTER)
;	BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;	THEM BACK OFF BEFORE RETURNING TO BSTAM.
;	THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;	STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;	THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;	THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;	CANNOT BE MOVED IN ANY WAY.
;
BEGIN	ORG	103H
;
INITIL	JMP	INITIU	;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU	;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU	;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU	;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU	;WRITE DATA PORT ENTRY POINT
;
INITIU	EQU	$
;	THIS IS THE UART/USART INITIALATION ROUTINE.
;	TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;	INITIALATION GUIDE LINES:
;	1. USE 1 STOP BIT	(OPTIONAL - 2)
;	2. USE 8 DATA BITS	(MUST)
;	3. USE 1 START BIT	(MUST)
;	4. USE 16X FOR CLOCK RATE 	(MUST)
;	5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
	MVI	A,0	;CLEAR
	OUT	PORT+1	;TO INTERRUPT ENABLE REGISTER
	MVI	A,80H	;OPEN DIVISOR LATCHES (DLAB BIT = 80H)
	OUT	PORT+3	;TO LINE CONTROL REGISTER
	LXI	H,B300	;BAUD RATE DIVISOR (300 BAUD)
	MOV	A,L	;LEAST SIGNIFIGENT BYTE
	OUT	PORT	;TO DIVISOR LATCH (LS)
	MOV	A,H	;MOST SIGNIFIGENT BYTE
	OUT	PORT+1	;TO DIVISOR LATCH (MS)
	MVI	A,3	;8 BITS, NO PARITY, 1 STOP BIT
	OUT	PORT+3	;TO LINE CONTROL REGISTER
	MVI	A,0	;CLEAR
	OUT	PORT+4	;TO MODEM CONTROL REGISTER
	CALL	SIGNON	;TELL USER WHAT'S IMPLEMENTED
	RET		;RETURN TO BSTAM
;
INSPRU	EQU	$
;	THIS IS THE STATUS READ PORT ROUTINE.
;	WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;	THE FOLLOWING BITS TO BE SET IF NEEDED:
;	1. 20 BIT SET IF FRAMING ERROR
;	2. 10 BIT SET IF OVERRUN ERROR
;	3. 08 BIT SET IF PARITY  ERROR
;	4. 04 BIT SET IF TRANSMITTER EMPTY
;		IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;		EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;	5. 02 BIT SET IF RECEIVER READY
;	6. 01 BIT SET IF TRANSMITTER READY
;	7. DO NOT SET THE 80 BIT OR 40 BIT
;
	PUSH	B
	IN	PORT+5	;TBE = 20H, RDA = 01H
	ANI	01H	;ISOLATE RDA BIT
	RAL		;MOVE TO 02 BIT
	MOV	B,A	;SAVE RDA IN B REGISTER
	IN	PORT+5	;GET STATUS AGAIN
	ANI	20H	;ISOLATE TBE BIT
	RAR		;MOVE TO 04 BIT
	RAR
	RAR
	ORA	B	;COMBINE TBE AND RDA BITS
	POP	B
	ORI	1	;PRESET TRANSMIT READY BIT
	RET
;
ERRSTU	EQU	$
;	THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;	YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;	OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;	CASE, JUST DO A RETURN.
;
	RET		;RETURN TO BSTAM
;
INPRTU	EQU	$
;	THIS IS THE READ DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;	STATUS READ ROUTINE MUST HAVE BEEN SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;	RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
	IN	PORT+0	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
OUTPRU	EQU	$
;	THIS IS THE WRITE DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;	OF STATUS READ MUST BE SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;	REGISTER A CONTAINS THE OUTPUT DATA.
;
	OUT	PORT+0	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
MESSGE:	DB	CR,LF,CR,LF
	DB	'Version 1.0 for H8/H89 as of 1/30/81',CR,LF
	DB	'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	BASE+5		;ANNOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END
