/*
 *	The BDS C Standard I/O header file --  v1.50	7/27/82
 *
 *	This file contains global definitions, for use in all C programs
 *	in PLACE of (yechhh) CONSTANTS. Characteristics of your system such
 *	buffered I/O allocations, storage allocator state, etc., should all
 *	be configured just once within this file. Any program which needs
 *	them should contain the preprocessor directive:
 *
 *		#include "bdscio.h"
 *
 *	near the beginning. 
 */


/*
 *	General purpose Symbolic constants:
 */

#define BASE 0		/* Base of CP/M system RAM (0 or 0x4200)  */
#define NULL 0
#define EOF -1		/* Physical EOF returned by low level I/O functions */
#define ERROR -1	/* General "on error" return value */
#define OK 0		/* General purpose "no error" return value */
#define JBUFSIZE 6	/* Length of setjump/longjump buffer	*/
#define CPMEOF 0x1a	/* CP/M End-of-text-file marker (sometimes!)  */
#define SECSIZ 128	/* Sector size for CP/M read/write calls */
#define MAXLINE 150	/* Longest line of input expected from the console */
#define TRUE 1		/* general purpose true truth value	*/
#define FALSE 0		/* general purpose false truth value 	*/

/*
 *	The NSECTS symbol controls the compilation of the buffered
 *	I/O routines within STDLIB2.C, allowing each user to set the
 *	buffer size most convenient for his system, while keeping
 *	the numbers totally invisible to the C source programs using
 *	buffered I/O (via the BUFSIZ defined symbol.) For larger
 *	NSECTS, the disk I/O is faster...but more ram is taken up.
 *	To change the buffer size allocation, follow these steps:
 *
 *	1) Alter NSECTS to the desired value here in bdscio.h
 *	2) Re-compile STDLIB1.C and STDLIB2.C
 *	3) Use CLIB to combine STDLIB1.CRL and STDLIB2.CRL to make
 *	   a new DEFF.CRL.
 *
 *	Make sure you use declare all your I/O buffers with the a
 *	statement such as:
 *
 *		char buf_name[BUFSIZ];
 */

#define NSECTS 8	/* Number of sectors to buffer up in ram */

#define BUFSIZ (NSECTS * SECSIZ + 7)	/* Don't touch this */

struct _buf {				/* Or this...	    */
	int _fd;
	int _nleft;
	char *_nextp;
	char _buff[NSECTS * SECSIZ];
	char _flags;
};

#define FILE struct _buf	/* Poor man's "typedef" */

#define _READ 1
#define _WRITE 2


/*
 *	If you plan to use the high-level storage allocation functions
 *	from the library ("alloc" and "free") then:
 *
 *	  1) Uncomment (enable) the "ALLOC_ON" definition, and comment out the
 *	     "ALLOC_OFF" definition from this file.
 *
 *	  2) Re-compile STDLIB1.C, and use CLIB to transfer "alloc"
 *	     and "free" into the DEFF.CRL library file.
 *
 *	Remember to include bdscio.h in all files of your C program.
 *
 */

/*
#define ALLOC_OFF 1	/* disables storage allocation if uncommented */
*/
			/* only ONE of these two lines should be uncommented */

#define ALLOC_ON 1	/* enables storgage allocation if uncommented */

#ifdef ALLOC_ON			/* if storage allocation enabled, */

struct _header  {
	struct _header *_ptr;
	unsigned _size;
 };

struct _header _base;		/* declare this external data to  */
struct _header *_allocp;	/* be used by alloc() and free()  */

#endif

