; This patch turns the MAC assembler into a partial ZCPR3 utility.  When it
; runs, it automatically sets the program error flag in the message buffer
; to show whether or not MAC encountered any errors in assembly.  The flow
; control command IF ERROR can then be used to control command flow.
;
; (NOTE: int the original distribution of SYSFCP.ASM there is an error that
; reverses the sensing of the program error flag.  You must either correct
; that error or use the reverse test IF ~ERROR.  The com file IF12.COM has
; the correct sensing.)
;
; Jay Sage, sysop, Newton Centre (Massachusetts) Z-Node
; July 8, 1985

patch		equ	2b70h		;place to intercept MAC
conout		equ	2ac9h		;address called at patch originally
newcode		equ	2e70h		;place to put new flag setting code
macstart	equ	0128h		;where MAC code really begins
signon		equ	2cd3h		;loacation of signon message

cr		equ	0dh
lf		equ	0ah

;-----------------------------------------------------------------------------

; First we patch the beginning of the program to make it look like a ZCPR3
; utility program.  It can then be installed using Z3INS to know the address
; of the environment descriptor.  From that it can find the program error
; flag in the message buffer and patch it into the flag-setting code at
; at newcode.  The code patched in at 100h overwrites the copyright message.

		org	100h

		jmp	start

		db	'Z3ENV'
		db	1		;external environment
z3env:		dw	0de00h		;this address set by Z3INS

start:		lhld	z3env		;get env address into hl
		lxi	d,22h		;offset to message buffer address
		dad	d		;hl points to address of message buf
		mov	a,m		;read address out
		inx	h
		mov	h,m
		mov	l,a		;hl now points to start of message buf
		lxi	d,6		;offset to program error flag
		dad	d		;now hl points to program error flag
		mvi	m,0		;set it to no error status
		shld	store+1		;patch flag-setting code below
		jmp	macstart	;continue with original code

;-----------------------------------------------------------------------------

; We intercept MAC execution at address PATCH.  The original instruction here
; was CALL CONOUT.  We replace it with a call to our new code, which in turn
; will jump to conout.

		org	patch

		call	newcode

;-----------------------------------------------------------------------------

; At NEWCODE, which appears to be some extra space at the end of MAC, we
; place the code to set the error flag.

		org	newcode

		push	psw		;make sure we don't mess anything up
		mvi	a,0ffh		;value to set the flag
store:		sta	0		;address will be filled in by code
		pop	psw		;restore registers
		jmp	conout		;go to where MAC went originally

;-----------------------------------------------------------------------------

; Just for the hell of it, patch the signon message to show it is a ZCPR3
; version.  Twenty characters max, not including final mandatory carriage
; return.

		org	signon

		db	lf
		db	'Z3 MACRO ASSEMBLER',cr

		end
                                                        