#include "stdio.h"
#include "fcntl.h"

#define NEEDNAME 8
int gotname;		/* we have to fine NEEDNAME names in ME.SYM */

#define	METACH	0x1B			/* M- prefix,   Control-[, ESC	*/
#define CMINUSCH 0x1c

#define	META	0x0200			/* Meta flag, or'ed in		*/
#define	CTLX	0x0400			/* ^X flag, or'ed in		*/

typedef	struct
{	short	k_code;			/* Key code			*/
	int	(*k_fp)();		/* Routine to handle it		*/
}	KEYTAB;

typedef struct
{	short k_code;		/* same as KEYTAB */
	char  ovcode;		/* which overlay. */
	char ovparm;		/* which routine in overlay. */
}	OVERTAB;

KEYTAB	* pMyKeytab;	/* where I will malloc() my version. */
int myNKEYTAB;		/* contents of NKEYTAB from me.com */
int pkeytab;		/* address of keytab[] in me.com */
int pNKEYTAB;		/* address of NKEYTAB in me.com */
char * NKname = "NKEYTAB_";	/* name of NKEYTAB in me.sym */
char * KTname = "keytab_";	/* name of keytab[] in me.sym */

OVERTAB * pMyOvertab;
int myNOVERTAB;
int povertab;
int pNOVERTAB;
char * NOname = "NOVERTAB";
char * OTname = "overtab_";

struct bitab
{	/* built-in commands. */
	char * bifname;		/* name in ME.SYM */
	int (*biffunc)();	/* Address from ME.SYM */
	char * biUECSname;	/* UECS name. */
	int biUM;		/* UM/UECS mapping. */
	int biUECS;		/* UECS number. */
} bi [] =
{	/* static initializers. */
	{	"ctrlg_"  , 0, "CI-Abort-Cancel",  7, 11 },
	{	"backchar", 0, "EC-Arrow-Left",    8, 80 },
	{	"forwchar", 0, "EC-Arrow-Right",  12, 81 },
	{	"linsert_", 0, "EC-Self_Insert",  -1, 245 },
	{	"", 0, "", -1, -1 }
};

struct ovlytab
{	/* overlays to be mapped. */
	char * ovUECSname;
	int    ovUM;
	char   xovnum;
	char   xovparm;
	int ovUECS;
} ovly[] =
{	/* and here they are! */
#include "cfgnames.h"
	{       "", -1, 0, 0, -1 }
};

char symbuf[80];
FILE * symf;
int i;
char * cp;
int comfd;
char * symname = "ME.SYM";
char * comname = "ME.COM";
long lspos;
char * maptname =  "maptable.zme";
int maptfd;

main()
{
	symf = fopen( symname, "r" );
	if ( symf == NULL )
	{	printf( "%s not found\n", symname );
badex:		exit ( 1 );
	}

	maptfd = open( maptname, O_RDONLY );
	if ( maptfd < 0 )
	{	printf( "%s not found\n", maptname );
		goto badex;
	}

	gotname = 0;
	while ( gotname < NEEDNAME && fgets( symbuf, 79, symf ) != NULL )
	{	i = strlen( symbuf ) -1;
		while ( symbuf[i] == '\r' || symbuf[i] == '\n' )
			symbuf[ i-- ] = 0;
		cp = &symbuf[ 5 ];
		for ( i = 0; bi[i].bifname[0]; i++)
		{	if ( ! strcmp( cp, &bi[i].bifname[0] ))
			{	cvout( &bi[i].biffunc );
				continue;
			}
		}
		if ( ! strcmp( cp, KTname ))
		{	cvout( &pkeytab );
			continue;
		}
		if ( ! strcmp( cp, OTname ))
		{	cvout( &povertab );
			continue;
		}
		if ( ! strcmp( cp, NKname ))
		{	cvout( &pNKEYTAB );
			continue;
		}
		if ( ! strcmp( cp, NOname ))
		{	cvout( &pNOVERTAB );
			continue;
		}
	}
	fclose( symf );
	if ( gotname < NEEDNAME )
	{	printf( "only %d out of %d names found in %s\n",
			gotname, NEEDNAME, symname );
		goto badex;
	}
	comfd = open( comname, O_RDWR );
	if ( comfd < 0 )
	{	printf( "%s not found\n", comname );
		goto badex;
	}

		/* We have opened the .COM file; now we need to
		** do some lpos() and read() operations: the purpose is
		** to get the number of entries for the KEYTAB and
		** OVERTAB arrays, then to read in the arrays from
		** the .COM file.
		*/

	dolseek( pNOVERTAB );	/* address in .COM of NOVERTAB */

	if ( read( comfd, &myNOVERTAB, 2 ) != 2 )
	{	printf( "read myNOVERTAB fails\n" );
		goto badex;
	}	/* now we havew retrieved a value from .COM file. */

	if ( ( pMyOvertab = (OVERTAB *)malloc( sizeof(OVERTAB) * myNOVERTAB ))
		== NULL )
	{	printf( "failed: pMyOvertab = malloc( %d * %d )\n",
			sizeof( OVERTAB ), myNOVERTAB );
		goto badex;
	}

	dolseek( povertab );

	if ( read( comfd, pMyOvertab, sizeof(OVERTAB) * myNOVERTAB ) !=
		( sizeof(OVERTAB) * myNOVERTAB ))
	{	printf( " failed: read overlay dispatch table\n" );
		goto badex;
	}

	dolseek( pNKEYTAB );

	if ( read( comfd, &myNKEYTAB, 2 ) != 2 )
	{	printf( "read myNKEYTAB fails\n" );
		goto badex;
	}

	if ( ( pMyKeytab = (KEYTAB *)malloc( sizeof(KEYTAB) * myNKEYTAB ))
		== NULL )
	{	printf( "failed: pMyKeytab = malloc( %d * %d )\n",
			sizeof( KEYTAB ), myNKEYTAB );
		goto badex;
	}

	dolseek( pkeytab );

	if ( read( comfd, pMyKeytab, sizeof(KEYTAB) * myNKEYTAB ) !=
		( sizeof(KEYTAB) * myNKEYTAB ))
	{	printf( " failed: read builtin dispatch table\n" );
		goto badex;
	}

	verify();
	readmap();

	dolseek( povertab );

	if ( write( comfd, pMyOvertab, sizeof(OVERTAB) * myNOVERTAB ) !=
		( sizeof(OVERTAB) * myNOVERTAB ))
	{	printf( "failed: write overlay dispatch table\n" );
		goto badex;
	}

	dolseek( pkeytab );

	if ( write( comfd, pMyKeytab, sizeof(KEYTAB) * myNKEYTAB ) !=
		( sizeof(KEYTAB) * myNKEYTAB ))
	{	printf( " failed: write builtin dispatch table\n" );
		goto badex;
	}

	close( comfd );
	exit ( 0 );
}

dolseek( x )
{	lspos = x - 0x100;
	if ( lseek( comfd, lspos, 0 ) < 0L )
	{	printf( "lseek failure %x\n", x );
		exit ( 5 );
	}
}

char * hexd = "0123456789ABCDEF";

cvout( ip )
int * ip;
{	int ii, jj;
	*ip = 0;
	for ( ii = 0; ii < 4; ++ii )
	{	*ip <<= 4;
		for ( jj = 0; jj < 16; ++jj )
		{	if ( symbuf[ii] == hexd[jj] )
			{	*ip += jj ;
				break;
			}
		}
	}
	++gotname;
}
verify()
{	/* verify keytab. */
	int bix, ktx;
	for ( bix = 0; bix < 3; ++bix )
	{	for ( ktx = 0; ktx < myNKEYTAB; ++ktx )
		{	if ( pMyKeytab[ktx].k_fp == bi[bix].biffunc )
				goto foundit;
		}
		printf( "No match for UECS number %d\n", bi[bix].biUECS );
		printf( "UECS Name: %s\n", bi[bix].biUECSname );
		printf( "Function Name: %s\n", bi[bix].bifname );
		printf( "Core Address: %x\n", pMyKeytab[ktx].k_fp );
		printf( "Address From %s: %x\n", symname,
			bi[bix].biffunc );
		exit ( 1 );
foundit:	continue;
	}
	printf( "Version Information Verified\n" );
}

struct { int UECS; int key; } x;

int mapdone;

readmap()
{	int x_entries;
	mapdone = x_entries = 0;
	while ( read( maptfd, &x, 4 ) == 4 )
	{	if ( x.UECS == 0x1a1a ) break;
		++x_entries;
		if ( x.UECS == 999 ) delkey();
		else stashkey();
	}
	printf( "Read %d Mapping Entries\n", x_entries );
	printf( "Succeeded in Mapping %d of them\n", mapdone );
	printf( "\nShall we update the .COM file? " );
	x_entries = getchar();
	if ( x_entries != 'y' && x_entries != 'Y' )
	{	printf( "\nSo long, then!\n" );
		exit ( 0 );
	}
}
stashkey()
{	int bix, ktx;
	for ( bix = 0; bi[bix].biUECS != -1; ++bix )
	{	if ( x.UECS != bi[bix].biUECS )
			continue;
		for ( ktx = 0; ktx < myNKEYTAB; ++ktx )
		{	if ( pMyKeytab[ktx].k_code != -1 )
				continue;
			pMyKeytab[ktx].k_code = x.key;
			pMyKeytab[ktx].k_fp = bi[bix].biffunc;
			++mapdone;
			return;
		}
		printf( "Built-in table full, cannot map %s\n",
			bi[bix].biUECSname );
		return;
	}
	for ( bix = 0; ovly[bix].ovUECS != -1; ++bix )
	{	if ( x.UECS != ovly[bix].ovUECS )
			continue;
		for ( ktx = 0; ktx < myNOVERTAB; ++ktx )
		{	if ( pMyOvertab[ktx].k_code != -1 )
				continue;
			pMyOvertab[ktx].k_code = x.key;
			pMyOvertab[ktx].ovcode = ovly[bix].xovnum;
			pMyOvertab[ktx].ovparm = ovly[bix].xovparm;
			++mapdone;
			return;
		}
		printf( "Overlay table full, cannot map %s\n",
			ovly[bix].ovUECSname );
		return;
	}
	printf( "UECS function number %d is unknown to me.\n",
		x.UECS );
}
delkey()
{	int bix, ktx;
	for ( bix = 0; bi[bix].biUECS != -1; ++bix )
	{	for ( ktx = 0; ktx < myNKEYTAB; ++ktx )
		{	if ( pMyKeytab[ktx].k_code != x.key )
				continue;
			pMyKeytab[ktx].k_code = -1;
			++mapdone;
			return;
		}
	}
	for ( bix = 0; ovly[bix].ovUECS != -1; ++bix )
	{	for ( ktx = 0; ktx < myNOVERTAB; ++ktx )
		{	if ( pMyOvertab[ktx].k_code != x.key )
				continue;
			pMyOvertab[ktx].k_code = -1;
			++mapdone;
			return;
		}
	}
	printf( "Key %04x was not mapped!\n", x.key );
}
