/***********************************************************************
 * fvshell	- The FV account's shell
 **********************************************************************/
 
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/stat.h>

#include "fv.h"      /* SCOPE undefined so global data is created */

void cleanup();                 /* Restore tty settings upon exit */
void trap_hangup();		/* trap connections losses */
void logout();
int master();
int slave();
int mailscan();
int process_mail();

char *pname;

/* External functions */

int
main(argc, argv)
  int argc;
  char *argv[];
{
  TERMSTRUCT      mystty;
  FILE            *fp;
  char            c, *cp;
  int             errflag = 0;
  extern int      optind;
  extern char     *optarg;

  pname = (pname = (char *) strrchr (argv [0], '/')) ? pname + 1 : argv [0];

#ifndef SYSTEMID
  if ((fp = fopen("/etc/systemid", "r")) == NULL) {
    fprintf(stderr, "%s: can't get hostname\n", *argv);
    return(ERROR);
  }
  fgets(hostname, SITELEN_MAX, fp);
  fclose(fp);
  if ((cp = strchr(hostname, '\n')))
    *cp = '\0';
#endif /* SYSTEMID */


        /* Open syslog if required with appropriate BSD 4.2/4.3 call */
#ifdef SYSLOG
        openlog(pname, LOG_PID, SYSLOG);
#endif

        ioctl(fileno(stdin), TERMGET, &mystty);
        default_stty = mystty;
 
#if SGTTY
        mystty.sg_flags &= ~ECHO;        
        mystty.sg_flags |= TIOCHPCL; 
        mystty.sg_flags |= RAW;      
#else
        mystty.c_oflag = mystty.c_iflag = mystty.c_lflag = 0; 
        mystty.c_cflag |= (CS8|CREAD|HUPCL);
        mystty.c_cc[VMIN] = 1;
        mystty.c_cc[VTIME] = 0;
#endif
 
        ioctl(fileno(stdin), TERMSET, &mystty);
 
        signal(SIGINT, SIG_IGN);    
        signal(SIGQUIT, SIG_IGN);   
        signal(SIGHUP, trap_hangup);

  syslog (LOG_INFO,"Login");
  sprintf(dpath, "%s%s/", spooldir, sitename); /* make sitedir path */
  chdir(dpath);
  master();
  logout();
  mailscan();
  cleanup(NO_ERROR);
  return(NO_ERROR);
}
 
int slave(exit_code)
     char exit_code;
{
  printf("SLAVE\n");
  execl("/usr/local/bin/rz","rz",(char *)0);
}

int process_mail(tempfile1, tempfile2)
        char *tempfile1, *tempfile2;
{ 
  register FILE *file1,*file2;
  register char c,*cp;
  int n;
  printf("MAILER: file %s\n",tempfile1);
  file1=fopen(tempfile1,"r");
  file2=fopen(tempfile2,"w"); /* kills the file no matter what */
  *towho = '\0';
  while ((fgets(buf, BUFLEN, file1) != NULL) && (*buf != '\n')) {
    if (!strncmp("To: ",buf,4)) {
      cp=buf+4;
      strcpy(towho,cp);
    } else
      fputs(buf,file2);
  }
  while ((n=fread(buf,sizeof(char),BUFLEN,file1))) {
    while (!buf[n-1] && n>0)
      n--;
    fwrite(buf,sizeof(char),n,file2); 
  }
  fclose(file1);
  unlink(tempfile1);
  fclose(file2);
  if (!*towho) {
    unlink(tempfile2);
    return(ERROR);
  }
  return (NO_ERROR);
}

int mailscan(exit_code)
  char exit_code;
{
  int i,pid, pipefds[2];
  FILE *outfile;	    
  DIR *outdir;
  struct direct *next;
  char tmpfile[16];
  printf("\nScanning mail dir=%s\n",dpath);
  strcpy(tmpfile,"/tmp/fvmail");  
/*  unlink(tmpfile); */
  chdir(dpath);
  outdir = opendir(dpath);
  while ((next = readdir(outdir)) != NULL) {  
    if (next->d_name[0] == '.') continue;  
    if (next->d_name[0] == 0) continue;
    if (strncmp("m.",next->d_name,2) <=2 ) {
      printf("Mail file %s\n",next->d_name); 
      if (process_mail(next->d_name,tmpfile))
        break;
      if (!(pid = fork())) { 
        freopen("/dev/null","a",stderr);
	freopen(tmpfile,"r",stdin);
	execlp("/usr/lib/sendmail","sendmail",towho,(char *)NULL);
	perror("execclp");
	exit(1);
        cleanup(errno);
      } else if (pid == -1) {
	cleanup(errno);
      }
      pwait(pid);
      unlink(tmpfile);
    }
  }

  closedir(outdir); 
}

int master(exit_code)
  char exit_code;
{
  char *cmdptr[5000];       /* ptrs to the command line options */
  int cmd,f,i;				/* # of files to send out */
  char strs[NSTRS][STRLEN];       /* array for filenames */
  int pid,status;
  FILE *outfile;		/* File to send */
  DIR *outdir;
  struct direct *next;	/* Next directory entry to send */
	
  outfile= fopen(packet,"w");
  fclose(outfile);
  cmd=0;
  strcpy(strs[0],"sz");
  strcpy(strs[1],"-a");
  strcpy(strs[2],"-u");
  cmdptr[cmd++]=strs[0];
  cmdptr[cmd++]=strs[1];
  cmdptr[cmd++]=strs[2];
  f=2;
  outdir = opendir(dpath);
  i=0;
  printf("Cmd=%d F=%d and cmd(cmd)=%s\n",cmd,f,cmdptr[cmd]);
  while ((next = readdir(outdir)) != NULL) {  
    if (next->d_name[0] == '.') continue;	/* Skip dot files */
    if (next->d_name[0] == 0) continue;
    if (strncmp("D.",next->d_name,2) >=0) {
      f++;
      i++;
      strcpy(strs[f],next->d_name);
      cmdptr[cmd]=strs[f];
/*      printf("----Cmd #%d F#%d File %s\n",cmd,f,next->d_name); */
      cmd++;
    }
  }
  closedir(outdir); 
/*  for (i=0; i<=cmd; i++)
    printf("cmd #%d =%s\n",i,cmdptr[i]);

  exit(1);
*/
  if ((pid=fork()) < 0) {
    perror("fork");
    exit(1);
  }
  if (pid ==0) {
    execv("/usr/local/bin/sz",cmdptr);
    perror("sz");
    exit(1);
  }
  pwait(pid);
  if ((pid=fork()) < 0) {
    perror("fork");
    exit(1);
  }
/*  printf("unlinking files...\n");
  for (f=1; f<=i; f++)
    printf("--file %s\n",strs[f+2]);
    unlink(strs[f+2]);
*/
  if (pid ==0) {
    execl("/usr/local/bin/rz","rz",(char *)0);
    perror("rz");
    exit(1);
  }
  pwait(pid);
  unlink("null.file");
  unlink("D.packet");
  return (NO_ERROR);
}


pwait(pid)                      /* wait on the process pid */

  register int pid;
{
  register int w;
  int status;
  while ((w = wait(&status)) != pid && w != -1)
    ;
  if (w == -1)
    status = -1;
  return(status);
}
      

/*
 *	trap_hangup()	Trap HUP signals, make a log entry, and exit
 */

void trap_hangup()
{
  /* logentry("*", "<ALERT: DISCONNECTED>"); */
  unlink(packet);
  cleanup(ERROR);
}


void logout(exitflag)
  int exitflag;
{
  signal(SIGHUP, SIG_IGN);                /* Ignore this now */
#ifdef BOSCO
  fflush(stdout);
  TERMHUP;
  ioctl(fileno(stdin), TERMSET, &default_stty);
#endif /* BOSCO */
#ifndef BOSCO
  ioctl(fileno(stdin), TERMSET, &default_stty);
#endif
}

/*
 *      cleanup()       Clean up tty modes, close log file, etc.
 */
 
void cleanup(exitflag)
  int exitflag;
{
  signal(SIGHUP, SIG_IGN);                /* Ignore this now */
#ifdef BOSCO
  fflush(stdout);
  TERMHUP;
  ioctl(fileno(stdin), TERMSET, &default_stty);
#endif /* BOSCO */
#ifndef BOSCO
  ioctl(fileno(stdin), TERMSET, &default_stty);
#endif

  if (exitflag)
    syslog(LOG_INFO,"ERROR :%d",exitflag);
 
  syslog (LOG_INFO, "CleanupLogout");
  if (exitflag)
    exit(exitflag);
}
 
