' **********************************************************************
' ***
' ***	uutraf.b	UUCP file transfer statistcs
' ***			ProLine System Software
' ***			(C)opyright 1994 Morgan Davis Group
' ***
#define	USAGE "Usage: " argv$[0] " " \
	"[-aps] [-bcnhrtx] [logfile]"
' ***
' *** Options:
' ***
' *** -a	Sort in ascending order
' *** -p	Track connections by poll carrier stamp
' *** -s	Track connections by speed
' *** -b[rxt]	Sort by bytes (recv, xmit, or total)
' *** -c[rxt]	Sort by CPS (recv, xmit, or total)
' *** -h[rxt]	Sort by hours (recv, xmit, or total)
' *** -n[rxt]	Sort by number of files (recv, xmit, or total)
' ***
' *** When    Who Ver	Description
' *** ======= === ===== ================================================
' *** 21aug91 mwd 1.0	Creation
' *** 26aug91 mwd 1.1	Fixed div/zero error in time calcs.  Reformatted
' ***			summary to be line of totals.
' ***

#define	IDENT_PROG "uutraf"
#define	IDENT_VERS "1.1"
#define	IDENT_DATE "26aug91"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	MAX_SITES	100

#define	SECS_PER_HOUR	3600

#define	ACTIVE_SITES	0
#define	POLL_TYPES	1
#define	BAUD_RATES	2

#define	BRECV		0
#define	BSENT		1
#define	BTOTAL		2
#define	SECSRECV	3
#define	SECSSENT	4
#define	SECSTOTAL	5
#define	CPSRECV		6
#define	CPSSENT		7
#define	CPSTOTAL	8
#define	NRECV		9
#define	NSENT		10
#define	NTOTAL		11

#define	SHOW_IT		0
#define	INTPLACES	1
#define	DECPLACES	2
#define	DIVUNIT		3

header$ = \
"              ___________K-Bytes___________ ____Hours____ __Avg_CPS__ __Files__^M"\
"Entry              Rcvd      Sent     Total   Recv   Send  Recv  Send Rcvd Sent"
separator$ = \
"------------- --------- --------- --------- ------ ------ ----- ----- ---- ----"

sep2$ =                                     "============= =========== ========="

data	"Bytes Received",	1,6,2,1024,\
	"Bytes Sent",		1,6,2,1024,\
	"Total Bytes",		1,6,2,1024,\
	"Hours in Receive",	1,3,2,SECS_PER_HOUR,\
	"Hours in Send",	1,3,2,SECS_PER_HOUR,\
	"Total Hours",		0,3,2,SECS_PER_HOUR
data	"Avg. CPS Receive",	1,5,0,1,\
	"Avg. CPS Send",	1,5,0,1,\
	"Total Avg. CPS",	0,5,0,1,\
	"Files Received",	1,4,0,1,\
	"Files Sent",		1,4,0,1,\
	"Total Files",		0,4,0,1
	
	dim	site$[MAX_SITES], \
		n[MAX_SITES,NTOTAL], \
		label$[NTOTAL], \
		col%[NTOTAL,DIVUNIT] \

	gosub AppInit

	sortBy		= BRECV		' Bytes...
	sortExt		= 2		' ...total
	ascend		= -1		' no, descend
	basis		= ACTIVE_SITES	' just active sites
	
	' --------------------
	' Get cmdline options
	' --------------------
	
	options$ = "abchnprsxt"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" then ascend = 1
		if optchar$ = "b" then sortBy = BRECV
		if optchar$ = "c" then sortBy = CPSRECV
		if optchar$ = "h" then sortBy = SECSRECV
		if optchar$ = "n" then sortBy = NRECV
		if optchar$ = "p" then basis = POLL_TYPES
		if optchar$ = "r" then sortExt = 0
		if optchar$ = "s" then basis = BAUD_RATES
		if optchar$ = "x" then sortExt = 1
		if optchar$ = "t" then sortExt = 2
		if optchar$ = "?" then
			print USAGE
			goto Exit
		endif
	until optchar$ = ""

	if nargc > 1 then
		if mid$(nargv$[nargc-1],1,1) = ">" then
			stdout$ = mid$(nargv$[nargc-1],2)
			nargc = nargc - 1
			AccFile$ = stdout$
			& getinfo stdout$, i$
			errCode = ERR
			if i$ > "" then
				AccMode = accWrite + accDestroy
			else
				AccMode = accWrite
				if errCode = 7 then errCode = 0
			endif		
			gosub CheckAccess
			if not AccOK or errCode then
				print argv$[0]": can't write to " stdout$
				goto Exit
			endif
			if i$ > "" then fDelete stdout$
		endif

	endif

	if nargc > 1 then
		log$ = nargv$[1]
	else
		log$ = SPOOL_LOGS_PATH + "mdsslog"
	endif

	& getinfo log$, i$
	if i$ = "" then
		print argv$[0]": " log$ " not found"
		goto Exit
	endif

	gosub GatherData
	if siteCount then
		& print argv$[0]": calculating...";
		gosub AddTotals
		gosub SortByKey
		& print
		if stdout$ > "" then
			& print argv$[0]": writing report...";
			fAppend stdout$
		else
			& print
		endif
		gosub ShowResults
		fClose
		print
	else
		print argv$[0]": no traffic to report"
	endif
goto Exit

ShowResults:
	basis$[0] = "Active Sites"
	basis$[1] = "Poll Types"
	basis$[2] = "Baud Rates"
	& time (t$)
	print "System:  " SITE_NAME
	print "Period:  " firstTime$ " to " lastTime$
	print "Entries: " siteCount " ("basis$[basis] ")"
	print "Order:   " label$[sortBy]", " \
		mid$("dea", ascend + 2,2) "scending"
	print
	print header$
	print separator$
	for i = 1 to siteCount
		gosub ShowEntry
	next

	print separator$
	i = 0
	site$[i] = "Totals:"
	gosub CalcSiteCPS
	gosub ShowEntry

	print spc(44) sep2$
	print spc(44)

	intwidth = 10
	decwidth = 2
	n = n[0,SECSTOTAL] / col%[SECSTOTAL,DIVUNIT]
	gosub getOutputNum
	print n$ " ";

	intwidth = 11
	decwidth = 0
	n = n[0,CPSTOTAL]
	gosub getOutputNum
	print n$ " ";

	intwidth = 9
	n = n[0,NTOTAL]
	gosub getOutputNum
	print n$
return

ShowEntry:
	site$ = left$(site$[key[i]],13)
	print site$ spc(14-len(site$))
	for j = 0 to NTOTAL
		if col%[j,SHOW_IT] then
			n = n[key[i],j] / col%[j,DIVUNIT]
			intwidth = col%[j,INTPLACES]
			decwidth = col%[j,DECPLACES]
			gosub getOutputNum
			if j then print " ";
			print n$;
		endif
	next
	print
return

getOutputNum:
	if decwidth then
		s = 10 ^ decwidth
		r = int(n * s + .5)
		n = int(r / s)
		r = int(r - n * s + .5)
		& right$(str$(r),decwidth,48),i$
		i$ = "." + left$(i$,decwidth)
	else
		i$ = ""
	endif
	& right$(str$(int(n+.5)), intwidth),n$
	n$ = n$ + i$
return


SortByKey:
	dim key[siteCount]
	for i = 1 to siteCount
		key[i] = i
	next
	if siteCount < 2 then return
	sortBy = sortBy + sortExt
	passnum = 1
	repeat
		sorted = TRUE
		for j = 1 to siteCount - passnum
			if ascend * n[key[j],sortBy] > \
				ascend * n[key[j+1],sortBy] then
				& swap (key[j], key[j+1])
				sorted = FALSE
			endif
		next
		passnum = passnum + 1
	until sorted
return

AddTotals:
	for i = 0 to NTOTAL
		read label$[i]
		for j = SHOW_IT to DIVUNIT
			read col%[i,j]
		next
	next

	for i = 1 to siteCount
		n[i,BTOTAL] = n[i,BRECV] + n[i,BSENT]
		n[i,SECSTOTAL] = n[i,SECSRECV] + n[i,SECSSENT]
		gosub CalcSiteCPS
		n[i,NTOTAL] = n[i,NRECV] + n[i,NSENT]
		for j = 0 to NTOTAL
			n[0,j] = n[0,j] + n[i,j]
		next
	next
return

CalcSiteCPS:
	if n[i,SECSRECV] then n[i,CPSRECV] = n[i,BRECV] / n[i,SECSRECV]
	if n[i,SECSSENT] then n[i,CPSSENT] = n[i,BSENT] / n[i,SECSSENT]
	if n[i,SECSTOTAL] then n[i,CPSTOTAL] = n[i,BTOTAL] / n[i,SECSTOTAL]
return


GatherData:
	& print argv$[0]": processed ";
	fOpen log$
	logRefNum = peek(_OREFNUM)
	poke _SREFNUM, logRefNum
	&MLI (_GET_EOF, _SGETEOF), errCode
	logSize = peek24(_SEOF)
	lastPercent = 0
	fRead log$
	onerr goto logEOF
	do
		repeat				' get first header entry
			& get a$
		until a$ > " "
		repeat
			entryResult = 0
			& pos (a$, "<"), p	' see if it was an error
			if not p then
				&MLI (_GET_MARK, _SGETMRK), errCode
				j = peek24(_SMARK)
				i = percent(0,logSize,j)
				if i > lastPercent then
					& print i "%";
					& hlin len(str$(i))+1, 8
					lastPercent = i
				endif
				gosub ProcessEntry
			endif
		until entryResult > -1
	loop
	logEOF:
	& onerr errCode, errLine
	onerr goto HandleError
	fClose
	& print "100%"
	if errCode <> 5 then
		print argv$[0]": error " errCode " @ " errLine
 		goto Exit
	endif
return
	
ProcessEntry:
	if basis = POLL_TYPES and left$(a$,4) <> "POLL" then return
	& pos (a$," "),q
	& pos (q+1,a$," "),p		' skip to second space
	startTime$ = mid$(a$,q + 1, p - q - 1)
	if firstTime$ = "" then firstTime$ = startTime$
	if basis = POLL_TYPES then
		& pos right$ (a$, " "), p
		site$ = mid$(a$, p + 1)
	else
		& pos (p+1,a$," "),q		' get third space
		if basis = BAUD_RATES then	' skip to bps
			p = q
			& pos (p+1,a$+" "," "),q
		endif
		site$ = mid$(a$,p + 1, q - p - 1)
	endif
	
	found = FALSE
	for i = 1 to siteCount
		if site$[i] = site$ then
			curSite = i
			i = siteCount
			found = TRUE
		endif
	next
	if not found then
		siteCount = siteCount + 1
		curSite = siteCount
		site$[curSite] = site$
	endif

	entryResult = 1
	repeat
		& get a$
		if a$ > " " then
			entryResult = -1
		else
			& pos (a$,"S#"),p
			if p then
				if asc(a$) = 32 then
					q = 9
				else
					q = 2
				endif
				& pos (q, a$, " "), p
				lastTime$ = mid$(a$,q, p - q)
				gosub getStats
				n[curSite,NSENT] = n[curSite,NSENT] + jobCount
				n[curSite,BSENT] = n[curSite,BSENT] + byteCount
				n[curSite,SECSSENT] = n[curSite,SECSSENT] + seconds
				gosub getStats
				n[curSite,NRECV] = n[curSite,NRECV] + jobCount
				n[curSite,BRECV] = n[curSite,BRECV] + byteCount
				n[curSite,SECSRECV] = n[curSite,SECSRECV] + seconds
				entryResult = 0
			endif
		endif
	until entryResult < 1
return

getStats:
	& pos (p + 1, a$, "#"),p
	jobCount = val(mid$(a$,p + 1))
	& pos(p + 1, a$, ","),p
	byteCount = val(mid$(a$,p + 1))
	&pos (p + 1, a$, ","),p
	seconds = val(mid$(a$,p + 1))
return


#if 0
commaFix:
	& pos (n$,"."),p
	if p then
		i$ = mid$(n$,p)
	else
		i$ = ""
		p = len(n$) + 1
	endif
	again:
	  q = p
	  p = p - 3
	  if p > 1 then
		i$ = "," + mid$(n$,p,3) + i$
		goto again
	  endif
	if p < 4 then i$ = left$(n$,q - 1) + i$
	n$ = i$
return
#endif


#include <proline/getopt.lib>
#include <proline/proline.lib>
#include <proline/access.lib>
