' ************************************************************
' *
' *  unbatch.b	News unbatcher for ProLine
' *		(C)opyright 1994 Morgan Davis
' *
' * When    Who Ver	What
' * ======  === ======= ======================================
' * 17nov89 mwd 1.0	Creation
' * 20feb90 mwd	1.1	Fixed counter reporting bug
' * 14apr90 mwd	1.2	Fixed field position assumption bug	
' * 18feb91 mwd 1.3	Flushes article after last line written
' * 02aug91 mwd	1.4	Increased MAX_GROUPS from 256 to 512
' *			Added tracker mechanism to detect bad terminations
' *			to avoid double processing of the rnews mailbox.
' *			Reformatted logfile entries to be more consistent.
' * 13aug91 mwd		Added unbatch log entry before postnews abort alert
' * 26aug91 mwd		Put tracking test before rnews mailbox test
' * 25jul93 mwd 1.5	Fixed string too long error on long newsgroups fields
' * 04sep93 mwd 1.5.1	Minor tweaks
' * 15sep93 mwd 1.6	Optimized lookup w/ binary search, more improvements
' * 07dec93 mwd		Fixed bug in Newsgroups line ending with a comma
' * 16jan94 mwd 3.0	IDENT/Launch update
' * 15mar94 mwd		Strips ^D off lines written out
' * 22apr94 mwd		Added dimension check on hdr$[MAX_HDR_LINES] loading
' *
' ************************************************************

#define	IDENT_PROG "unbatch"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "21may94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	FASTER		1		' Faster (expense of RAM)

#define	TRACK_UNBATCH	0		' 0 for unbatch
#define	TRACK_POSTNEWS	3		' 3 for postnews

#define	POUND_SIGN	35
#define	MAX_GROUPS	512
#define	MAX_GROUP_LEN	200		' length of longest group name
#define	MAX_HDR_LINES	48		' header cache

	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't run"
		goto Exit
	endif

' ==============================
' Pathnames
' ==============================
	
	newsLogFile$	= SPOOL_LOGS_PATH + "newslog"
	newsysFile$	= ETC_PATH + "newsys"
	newspoolDir$	= SPOOL_NEWS_PATH
	rnewsFile$	= MAIL_PATH + "rnews"
	trackerFile$	= SysInfo$[plTempDir] + "newstracker"
	
	newsgroupFile$	= ""

' ==============================
' Header Markers
' ==============================
	
	rnewsMarker$	= "#! rnews "
	rnewsMarkLen	= 9
	fromMarker$	= "From "
	fromMarkLen	= 5
	Newsgroups$	= "Newsgroups:"

' ==============================
' Find system files
' ==============================

	&GETINFO newsysFile$, info$
	if info$ = "" then
		print argv$[0]": "newsysFile$" not found"
		goto Exit
	endif

	&GETINFO trackerFile$, info$
	if info$ > "" then
		i = asc(mid$(info$, 5))
		if i = TRACK_POSTNEWS then
			entry$ = "UNBATCH ~ (0 bytes)"
			gosub UpdateLog
			entry$ = "^I~ <ALERT: detected previous postnews abort>"
			gosub UpdateLog
			goto unbatchExit
		endif
		purgeGroups = i = TRACK_UNBATCH
	else
		fCreate trackerFile$ ",T" TRACK_UNBATCH
	endif

	&GETINFO rnewsFile$, info$
	if info$ = "" then
		print argv$[0]": nothing in "rnewsFile$
		fDelete trackerFile$
		goto Exit
	endif

	&fn fnCarrier, initialDCD	' Save carrier state
	&chk stop			' then turn carrier loss checking off
	& page def initialPage		' Save paging state
	& page stop			' then turn it off

	dim hdr$[MAX_HDR_LINES]

	fOpen rnewsFile$
	rnewsRefNum = peek(_OREFNUM)
	poke _SREFNUM, rnewsRefNum
	&MLI (_GET_EOF, _SGETEOF), errCode
	rnewsSize = peek24(_SEOF)
	
	entry$ = "UNBATCH ~ (" + str$(rnewsSize) + " bytes)"
	gosub UpdateLog
	gosub load_aliases

	onerr goto rnews_EOF

new_message:
	' Scan through file until #! rnews line is reached
	gosub find_rnews_marker

next_message:
	' Save the current file position
	poke _SREFNUM, rnewsRefNum
	&MLI (_GET_MARK, _SGETMRK), errCode
	filePos = peek24(_SMARK)

	' Now determine the primary newsgroup for this article
	' by searching the header for the Newsgroups: field
	fRead rnewsFile$
	groupPtr = 0
	repeat
		&get a$
		if left$(a$, 11) = Newsgroups$ then
			&spc(mid$(a$, 13), 36), groupLine$
			groupPtr = 1
		endif
	until a$ = "" or groupPtr

	' If a Newsgroups field wasn't found, we can't do anything
	if not groupPtr then goto new_message
		
	copies = 0
	
	repeat
		&pos (groupPtr, groupLine$ + ",", ","), p
		realGroup$ = mid$(groupLine$, groupPtr, p - groupPtr)
		&spc (realGroup$), realGroup$
		groupPtr = p + 1
		gosub get_group_alias
		if found then
			group$ = newspoolDir$ + group$
			if not articles%[found] and purgeGroups then
				&GETINFO group$, info$
				if info$ > "" then fDelete group$
			endif
			articles%[found] = articles%[found] + 1
			entry$ = str$(percent(0,rnewsSize,filePos)) + \
				"%^I~ " + realGroup$
			gosub PrintLogEntry
			& ioctl(ioUp)
			gosub copy_article
			copies = copies + 1
		endif
	until groupPtr > len(groupLine$)
	if not copies then
		entry$ = "^I~ <ALERT: ignored article for '" + \
			mid$(groupLine$, 1, MAX_GROUP_LEN) + "'>"
		gosub UpdateLog
	endif
	rnewsField$ = nextRnewsField$
goto next_message


copy_article:
	' ========================================
	' Set file position just below the #! rnews line
	' ========================================

	i% = filePos / 65536
	&poke _SREFNUM, rnewsRefNum, \
			filePos - int(filePos / 256) * 256, \
			int(filePos - i% * 65536) / 256, i%
	&MLI (_SET_MARK, _SSETMRK), errCode

	' ========================================
	' Cache the header, watching for Lines: & Newsgroups:
	' ========================================

	articleSize	= val(mid$(rnewsField$, 10))
	hdrLines	= 0
	lineCount	= 0	' assume unknown
	
	fRead rnewsFile$
	repeat
		&get line$
		& spc(line$, 4), line$
		if line$ > "" then
			& pos(line$, ":"), p
			if p then
				a$ = mid$(line$, 1, p)
				if a$ = "Path:" then
					i$ = SysInfo$[plNode] + "!"
					i = len(i$)
					if mid$(line$, p + 2, i) <> i$ then
						articleSize = articleSize - len(line$)
						line$ = a$ + " " + i$ + mid$(line$, p + 2, 245 - i)
						articleSize = articleSize + len(line$)
					endif
				else
					if a$ = "Lines:" then
						lineCount = val(mid$(line$, 8))
					else
						' ----------------------------------
						' This hack fixes crossposting dupes
						' ----------------------------------
						if a$ = Newsgroups$ then
							p = len(line$)
							line$ = Newsgroups$ + " " + realGroup$
							articleSize = articleSize - (p - len(line$))
						endif
					endif
				endif
			endif
		endif
		if hdrLines < MAX_HDR_LINES then
			hdrLines = hdrLines + 1
			hdr$[hdrLines] = line$
		else
			line$ = ""
		endif
	until line$ = ""

	fFre
	if group$ <> newsgroupFile$ then
		if newsgroupFile$ > "" then fClose newsgroupFile$
		newsgroupFile$ = group$
		fAppend newsgroupFile$
	else
		fWrite newsgroupFile$
	endif

	print "#! rnews " articleSize
	for i = 1 to hdrLines
		print hdr$[i]
		hdr$[i] = ""
	next

	checkMore = not lineCount
	if checkMore then lineCount = -1
	
	while lineCount
		fRead rnewsFile$
		& get line$
		& spc(line$, 4), line$
		if mid$(line$, 1, rnewsMarkLen) = rnewsMarker$ then
			fFlush newsgroupFile$
			nextRnewsField$ = line$
			return
		endif
		if checkMore then
			if mid$(line$, 1, fromMarkLen) = fromMarker$ then goto endArticle
		endif
		fWrite newsgroupFile$
		print line$
		lineCount = lineCount - 1
	wend
	goto endArticle

rnews_EOF:
	&onerr errCode, lineNum
	&pop
	gosub test_for_eof

	fDelete rnewsFile$
	fDelete trackerFile$

	gosub show_summary
	fClose

unbatchExit:
	&fn fnCarrier, currentDCD	' Check for DCD loss
	&chk on

	if initialDCD and not currentDCD then
		&restore ProgStack_Cell to a$
		& pos right$(a$, ":"), p
		ReturnPath$ = mid$(a$, p + 1)
		&store "" to ProgStack_Cell
	else
		ReturnPath$ = ""
	endif

	if initialPage then &page on
Launch("rnews", "", FALSE)

endArticle:
	fFlush newsgroupFile$
	gosub find_rnews_marker
	nextRnewsField$ = rnewsField$
return

' ==============================
' Subroutines
' ==============================

load_aliases:
	dim groups$[MAX_GROUPS]
	groupCount = 0

	entry$ = "^I~ scanning newsys..."
	gosub PrintLogEntry

	onerr goto newsys_EOF
	fOpen newsysFile$
	fRead newsysFile$

	load_loop:
		&get line$
		&spc(line$), line$
		if line$ = "" then goto load_loop
		if asc(line$) = POUND_SIGN then goto load_loop
		groupCount = groupCount + 1
		groups$[groupCount] = line$
		repeat
			&get line$
			& spc(line$), line$
		until line$ = ""
	goto load_loop

	newsys_EOF:
	&onerr errCode, lineNum
	gosub test_for_eof2
	fClose newsysFile$
	& sort (groups$, groupCount)
#if FASTER
	dim aliases$[groupCount]
	for i = 1 to groupCount
		line$ = groups$[i]
		& pos(line$,"="), p
		if not p then p = 254
		groups$[i] = left$(line$, p - 1)
		aliases$[i] = mid$(line$, p + 1)
	next
#endif
	fFre
	dim articles%[groupCount]
	& ioctl(ioUp)
return


test_for_eof:
	fClose
test_for_eof2:
	onerr goto HandleError
	if errCode <> 5 then
		fClose
		entry$ = "^I~ <ERROR: " + str$(errCode) + " at " + \
			str$(lineNum) + ">"
		gosub UpdateLog
		goto Exit
	endif
return


find_rnews_marker:
	fRead rnewsFile$
	repeat
		&get rnewsField$
	until left$(rnewsField$, rnewsMarkLen) = rnewsMarker$
return


get_group_alias:
	low = 1
	high = groupCount
#if FASTER
	while low <= high
		mid = int((low + high) / 2)
		group$ = groups$[mid]
		if realGroup$ = group$ then
			if aliases$[mid] > "" then group$ = aliases$[mid]
			found = mid
			return
		endif
		if realGroup$ < group$ then
			high = mid - 1
		else
			low = mid + 1
		endif
	wend
#else
	while low < high
		mid = int((low + high) / 2)
		line$ = groups$[mid]
		& pos(line$,"="), p
		if not p then p = 256
		&spc(left$(line$, p - 1)), group$
		if realGroup$ = group$ then
			if p < 256 then group$ = mid$(line$, p + 1)
			found = mid
			return
		endif
		if realGroup$ < group$ then
			high = mid - 1
		else
			low = mid + 1
		endif
	wend
#endif

	found = FALSE

' ------debug
	for mid = 1 to groupCount
#if FASTER
		group$ = groups$[mid]
#else
		line$ = groups$[mid]
		& pos(line$,"="), p
		if not p then p = 256
		&spc(left$(line$, p - 1)), group$
#endif
		if realGroup$ = group$ then
#if FASTER
			if aliases$[mid] > "" then group$ = aliases$[mid]
#else
			if p < 256 then group$ = mid$(line$, p + 1)
#endif
			found = mid
			mid = groupCount
'			if not beenHereB4 then
'#if FASTER
'				entry$ = "^I~ <ERROR: L='" + groups$[mid] + "' MID=" + str$(mid) + " G='" + group$ + "'>"
'#else
'				entry$ = "^I~ <ERROR: L='" + line$ + "' MID=" + str$(mid) + " G='" + group$ + "'>"
'#endif
'				gosub UpdateLog
'				beenHereB4 = TRUE
'			endif
		endif
	next
' ------debug
return

show_summary:
	fAppend newsLogFile$
	for i = 1 to groupCount
		if articles%[i] then
		    group$ = groups$[i]
		    & pos(group$, "="), p
		    if p then group$ = left$(group$, p - 1)
		    entry$ = "^I~ unbatched " + str$(articles%[i]) +" "+ group$
		    gosub PrintLogEntry
		    print entry$
		endif
	next
	fClose
return

time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

UpdateLog:
	gosub SetEntry
	fAppend newsLogFile$
	print entry$
	fClose newsLogFile$

PrintLogEntry:
	gosub SetEntry
	& ioctl (ioClearEOL)
	& print entry$
return

SetEntry:
	&pos (entry$, "~"),p
	if p then
		gosub small_time
		entry$ = mid$(entry$, 1, p - 1) + time$ + mid$(entry$, p + 1)
	endif
return

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
#include <proline/proline.lib>
