' **********************************************************************
' ***
' *** 	scan.b		Outgoing Mail Scanner
' ***			ProLine System Software (C) 1991 Morgan Davis Group
' ***
#define	USAGE "Usage: " argv$[0] " " \
	"[-ailx] [-f file] [-o flags] [-p file] [site...]"
' ***
' *** Options:
' ***
' ***	-a		Force a poll to all sites
' ***   -i		Include invisible site directories
' ***	-f file		Sites that have "file" in their area
' ***	-l		Lists work
' ***	-o flags	Option flags to pass on to exec'd app
' ***	-p file		Specifies "file" to execute (default is "poll")
' ***	-x		Scan, but do not execute anything
' ***
' *** History:
' ***
' *** 22may90 mwd 1.1	Conversion to MD-BASIC
' *** 			Added ability to scan one site.
' *** 03aug91 mwd 2.0b	Rewritten entirely.  Now scans directories
' ***			in one pass and builds a C-Shell script of
' ***			commands.  This makes it independent of
' ***			relying on possibly volatile memory locations.
' *** 16jan94 mwd 3.0	IDENT/Launch update

#define	IDENT_PROG "scan"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	MAX_SITES	255

	gosub AppInit
	if not SuperUser then
		print argv$[0]": cannot execute"
		goto Exit
	endif

	' --------------------
	' Initialize defaults
	' --------------------
	
	execFile$	= "poll"
	invisCode	= VISIBLE_ONLY

	' --------------------
	' Get cmdline options
	' --------------------
	
	options$ = "af:ilo:p:x?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" then allSites = TRUE
		if optchar$ = "f" then findFile$ = optarg$
		if optchar$ = "i" then invisCode = VIS_AND_INVIS
		if optchar$ = "l" then listFlag = TRUE
		if optchar$ = "o" then execFlags$ = optarg$
		if optchar$ = "p" then execFile$ = optarg$
		if optchar$ = "x" then noExecFlag = TRUE
		if optchar$ = "?" then
			print USAGE
			goto Exit
		endif
	until optchar$ = ""

	' --------------------
	' Init Variables
	' --------------------
	
	dim f$[1]
	mdssDir$ = MDSS_PATH
	scanxFile$ = TEMP_PATH + "scan.x"

	& page def paging
	& page stop

	nargc = nargc - 1			' ignore 0 argument
	if not nargc then			' no site arguments
		& erase (nargv$)		' erase array
		dim nargv$[MAX_SITES]
		& files(mdssDir$,nargv$,15,invisCode),nargc
		if not nargc then
			& print argv$[0]": no sites to scan"
			goto Exit
		endif
	endif

	for site = 1 to nargc
		site$ = nargv$[site]
		gosub ScanSite
		nargv$[site] = site$
	next

	if sitesWithJobs and not noExecFlag then
		& getinfo scanxFile$, i$
		if i$ > "" then fDelete scanxFile$
		if execFlags$ > "" then execFlags$ = " " + execFlags$
		fAppend scanxFile$
		for site = 1 to nargc
			if nargv$[site] > "" then
				print execFile$ execFlags$ " " nargv$[site]
			endif
		next
		fClose
		Launch("csh source " + scanxFile$, "", FALSE)
	endif

	if paging then & page on
goto Exit

	
ScanSite:
	& lcase(site$)
	siteFile$ = site$
	repeat
		& pos (siteFile$, "-"),p
		if p then & mid$(siteFile$, p) = "."
	until not p
	if mid$(site$,4,1) = "." then &mid$(site$,4) = "-"
	if findFile$ > "" then
		& getinfo mdssDir$ + siteFile$ + "/" + findFile$, i$
		if i$ = "" then
			site$ = ""
			return
		endif
	endif
	& files(mdssDir$ + siteFile$,f$),j,fc
	if fc or allSites then
		sitesWithJobs = sitesWithJobs + 1
		if listFlag then
			n = len (site$)
			print argv$[0]":^I" site$;
			& str$ ((n < 8) + (n < 16),9)
			if fc then
				& right$(str$(fc), 4), i$
				print i$ " job";
				if fc <> 1 then print "s";
			endif
			print
		endif
	else
		site$ = ""
	endif
return

#include <proline/proline.lib>
#include <proline/getopt.lib>

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
