' ************************************************************
' *
' *  rnews.b 	News distributor for ProLine
' *		(C)opyright 1994 Morgan Davis
' *
' * History:
' *
' * 22nov89 mwd	1.0	Creation
' * 18feb90 mwd	1.1	Removed (direct batch) reporting in logs
' * 19feb90 mwd	1.2	Fixed double-space bug in address parser
' * 27jan91 mwd	1.3	Added "rnews.batch" file support for MDSS sites
' * 31jan91 mwd		Fixed GetLocalSite bug.  Fixed ForwardBatch so
' *			that it will choose a new batch name (rnews.nnn)
' *			when the last existing one is > MAX_BLOCKS in size.
' * 13feb91 mwd		Reduced log file entries by posting only a summary
' *			of sent groups while maintaining progress info
' * 18feb91 mwd	1.3.1	Fixed header bug in articles.
' * 02aug91 mwd	1.4	Implemented newstracker checking
' * 26sep91 mwd 1.5	Fixed batch mailing address bug in GetLocalSite
' * 17jul92 mwd 1.6	Fixed get_unique_name with "same second" logic
' * 04sep93 mwd 1.6.1	Minor tweaks, changed GetLocalSite to keep path$
' * 16jan94 mwd 3.0	Launch/IDENT update
' *
' ************************************************************

#define	IDENT_PROG "rnews"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"

#define	RNEWS_VER	"(" IDENT_PROG " " IDENT_VERS ")"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	POUND_SIGN	35
#define	TILDE		126

#define	MAX_ADDRS	128
#define	MAX_BLOCKS	128

#define	TRACK_POSTNEWS	3

	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't run"
		goto Exit
	endif

' ==============================
' Pathnames
' ==============================
	
	newsLogFile$	= SPOOL_LOGS_PATH + "newslog"
	newsysFile$	= ETC_PATH + "newsys"
	newspoolDir$	= SPOOL_NEWS_PATH
	mailspoolDir$	= SPOOL_MAIL_PATH
	mdssDir$	= MDSS_PATH
	trackerFile$	= SysInfo$[plTempDir] + "newstracker"
	
	isPlural$[TRUE]	= "s"
	
	rnewsMarker$	= "#! rnews "
	rnewsMarkLen	= 9

' ==============================
' Find system files
' ==============================

	&GETINFO newsysFile$, info$
	if info$ = "" then
		print argv$[0]": "newsysFile$" not found"
		goto Exit
	endif
	
	
	&fn fnCarrier, initialDCD	' Save carrier state
	&chk stop			' then turn carrier loss checking off
	& page def initialPage		' Save paging state
	& page stop			' then turn it off
	
	dim to$[MAX_ADDRS], dirEntries$[1]

	&files (newspoolDir$, dirEntries$, 4), i, i
	entry$ = "RNEWS ~ (" + str$(i) + " group" + isPlural$[i <> 1] + ")"
	gosub UpdateLog
	
	& GETINFO trackerFile$, i$
	if i$ > "" then
		if asc(mid$(i$,5)) = TRACK_POSTNEWS then
			entry$ = "^I~ <ALERT: detected previous postnews abort>"
			gosub UpdateLog
			postNews = TRUE
			goto rnewsExit
		endif
	endif
	
	fOpen newsysFile$
	postNews = FALSE

next_entry:
	onerr goto newsysEOF
	gosub GetNextEntry

	&GETINFO newspoolDir$ + alias$, info$
	if info$ = "" then goto next_entry

	if toCount then
		sitesMailed = 0
		for m = 1 to toCount
			if asc(to$[m]) <> 60 then	' "<"
				gosub SendToSite
			endif
		next
		if localPostInfo$ = "" then fDelete newspoolDir$ alias$

		entry$ = "^I~ sent "+group$+" to "+str$(toCount)+" recipient"
		if toCount > 1 then entry$ = entry$ + "s"
		if sitesMailed then
			entry$ = entry$ + " (" + str$(sitesMailed) + \
				" via mail)"
		endif
		gosub UpdateLog
	endif

	if localPostInfo$ > "" then
		postNews = TRUE
	else
		if not toCount then
			entry$ = "^I~ <ALERT: " + newspoolDir$ + alias$ +\
				 " accumulating>"
			gosub UpdateLog
		endif
	endif
goto next_entry

newsysEOF:
	&onerr errCode, lineNum
	onerr goto HandleError
	&pop
	fClose
	gosub CheckCloseErr

rnewsExit:
	&fn fnCarrier, currentDCD	' Check for DCD loss
	&chk on

	if initialDCD and not currentDCD then
		&restore ProgStack_Cell to a$
		& pos right$(a$, ":"), p
		ReturnPath$ = mid$(a$, p + 1)
		&store "" to ProgStack_Cell
	endif

	if initialPage then & page on

	if not postNews then goto Exit
Launch("postnews", "", FALSE)


' ==============================
' Subroutines
' ==============================

SendToSite:
	splitNews = asc(to$[m]) = TILDE
	&spc (to$[m], TILDE), to$
	gosub GetLocalSite
	siteInfo$ = ""
	how$ = ""
	what$ = ""

	if path$ = (site$ + "!") then
		spool$ = mdssDir$ + site$ + "/"
		repeat
			& pos (spool$,"-"),p
			if p then &mid$(spool$,p) = "."
		until not p
		&GETINFO spool$, siteInfo$
	endif

	if siteInfo$ = "" then
		spool$ = mailspoolDir$
		how$ = "mailed"
		sitesMailed = sitesMailed + 1
	endif

	if splitNews then
		gosub SendArticles
		what$ = "articles"
	else
		gosub ForwardBatch
		if how$ = "mailed" then what$ = "batch"
	endif
	
	& spc (how$ + " " + what$), how$
	if how$ > "" then
		how$ = " (" + how$ + ")"
	else
		how$ = " to"
	endif

	entry$ = "^I~ sent " + group$ + how$ + " " + to$
	gosub PrintLogEntry
	& ioctl(ioUp)
return


ForwardBatch:
	if siteInfo$ = "" then
		gosub get_unique_filename
		targetFile$ = spool$ + file$
		fwdBatch = TRUE
		gosub WriteMailHeader
	else
		batchNum = 0
		repeat
			& right$ (str$(batchNum), 3, 48), i$
			targetFile$ = spool$ + "rnews." + i$
			& getinfo targetFile$, i$
			if i$ = "" then
				fwdBatch = TRUE
				gosub WriteMailHeader
			else
				if asc(mid$(i$, 9)) + asc(mid$(i$,10)) * 256 \
					< MAX_BLOCKS then
					i$ = ""
				else
					batchNum = batchNum + 1
				endif
			endif
		until i$ = ""
	endif
	fClose targetFile$
	fFre
	&add (newspoolDir$ + alias$ to targetFile$)
return

WriteMailHeader:
	gosub header_time
	fAppend targetFile$
	if siteInfo$ > "" then
		from$ = SysInfo$[plNode] + "!"
	else
		from$ = ""
	endif
	print "From " from$ "mdss " htime$ SysInfo$[plZone]
	if siteInfo$ > "" then
		print "Received: by " SITE_NAME " " RNEWS_VER
		print "Ppath: "to$
		from$ = "@" + SITE_NAME
	else
		from$ = ""
	endif
	if fwdBatch then
		print "Date: " time$ " " SysInfo$[plZone]
		print "From: mdss" from$ " (Mail Delivery SubSystem)"
		print "To: " to$
		print "Subject: rnews batch"
		print
	else
		print "To: " to$
	endif
return

SendArticles:
	onerr goto saEOF
	sourceFile$ = newspoolDir$ + alias$
	fOpen sourceFile$
	fRead sourceFile$
	&get				' skip first rnews field

    next_Article:
	gosub get_unique_filename
	targetFile$ = spool$ + file$

	fwdBatch = FALSE
	gosub WriteMailHeader
	
    copy_article:
    	fRead sourceFile$
    	&get a$
	if left$(a$, rnewsMarkLen) = rnewsMarker$
		fClose targetFile$
		goto next_article
	else
		fWrite targetFile$
		print a$
		goto copy_article
	endif

    saEOF:
	&onerr errCode, lineNum
	onerr goto newsysEOF
	fClose sourceFile$
	fClose targetFile$
'''
CheckCloseErr:
	if errCode <> 5 then
		print "Error #"errCode " at " lineNum
		entry$ = "^I~ <ERROR: #" + str$(errCode) + " at " + \
			str$(lineNum) + ">"
		gosub UpdateLog
		goto Exit
	endif
return
    
' ==============================
  GetLocalSite:
'
' On entry:	to$ = e-mail address
'
' Returns:	site$ = name of target site for batch
'		path$ = path (plus "!") to user
'		user$ = recipient
'		to$ = full bang-style path to recipient
' ==============================
	site$ = ""

	' Replace all %'s with @'s

	repeat
		& pos (to$, "%"), p
		if p then & mid$(to$,p) = "@"
	until not p

	' Check for an @ address format.  If found, convert to bang.
	' Reverse build the path if there are multiple @'s.

	path$ = ""
	repeat
		& pos right$ (to$,"@"), p
		if p then
			path$ = path$ + mid$ (to$, p + 1) + "!"
			to$ = left$(to$, p - 1)
		endif
	until not p
	to$ = path$ + to$
	
	' Now determine if path contains any addresses at all!
	
	& pos right$ (to$, "!"), p
	if not p then return	' return with site$ = ""

	' Break path down to user, site and domain components

	user$ = mid$(to$, p + 1)	
	path$ = left$(to$, p)
	& pos right$ (p - 1, path$, "!"), q
	site$ = mid$(path$, q + 1, p - q - 1)

	& pos (2, site$, "."), p
	if p then
		domain$ = mid$ (site$, p)
		site$ = left$ (site$, p - 1)
		if domain$ = SysInfo$[plDomain] then
			domain$ = ""
' 			path$ = ""	' rnews needs the path
		endif
	else
		domain$ = ""
	endif

	if site$ = SysInfo$[plNode] then site$ = ""

	if domain$ > "" then
		to$ = site$ + domain$ + "!" + user$
	else
		to$ = path$ + user$
	endif
return		


GetNextEntry:
	fRead newsysFile$
	&get group$
	if group$ = "" then goto GetNextEntry

	&pos (group$, "="),p
	if p then
		alias$ = mid$(group$, p + 1)
		group$ = left$(group$, p - 1)
	else
		alias$ = group$
	endif
	if len (alias$) > 15 then
		alias$ = right$(alias$, 15)
	endif
	&spc (group$), group$
	&spc (alias$), alias$

	localPostInfo$ = ""
	toCount = 0

	onerr goto gneEOF

    next_address:
	&get a$
	&spc (a$),a$		' Strip spaces
	&spc (a$,9),a$		' Strip tabs
	if a$ = "" then goto noErr

	if asc(a$) = POUND_SIGN then
		if mid$(a$, 2, 1) = "L" then
			localPostInfo$ = mid$(a$, 4)
		endif
	else
		repeat
			gosub stripwhite
			& pos (a$ + " "," "),p
			& pos (a$ + ",",","),q
			if q and (q < p) then p = q
			if p then
				toCount = toCount + 1
				to$[toCount] = left$ (a$,p - 1)
				a$ = mid$(a$, p + 1)
			endif
		until a$ = ""
	endif
	goto next_address

    gneEOF:
    	&onerr
    noErr:
	onerr goto newsysEOF
return

stripwhite:
	&spc (a$), a$
	if a$ > "" then
		pp = 1
		repeat
			qq = pp
			if mid$(a$, pp, 1) < "0" then pp = pp + 1
		until qq = pp or pp > len(a$)
		a$ = mid$(a$, pp)
	endif
return


get_unique_filename:
	gosub time_index
	j = val (mid$ (time$,6))
	& right$ (str$(val(mid$(time$,16)) * 3600 + \
		val(mid$(time$,19)) * 60 + val(right$(time$,2))), 5, 48), a$
	file$ = chr$(64 + index) + chr$(48 + j + 7 * (j > 9)) + a$ + "n"
	& lcase (file$)
	if file$ = lastFile$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastFile$ = file$
	file$ = file$ + seq$
return

time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

header_time:
	& time(time$)
	htime$ = left$ (time$, 3) + mid$ (time$, 8, 5) + \
		mid$ (time$, 6, 3) + right$ (time$, 8) + \
		" 19" + mid$ (time$, 13, 3)
return


small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

UpdateLog:
	gosub SetEntry
	fAppend newsLogFile$
	print entry$
	fClose newsLogFile$

PrintLogEntry:
	gosub SetEntry
	& ioctl (ioClearEOL)
	& print entry$
return

SetEntry:
	&pos (entry$, "~"),p
	if p then
		gosub small_time
		entry$ = mid$(entry$, 1, p - 1) + time$ + mid$(entry$, p + 1)
	endif
return

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
#include <proline/proline.lib>
