' ************************************************************************
' **									**
' **  rmail.b 		Converts UUCP >From lines into one From line	**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' **  4nov90 mwd 1.0	Creation.					**
' ** 22feb91 mwd 1.4	Self-contained (doesn't require mail.o), better **
' **			use of RAM, faster disk I/O. Reports skipped    **
' **			files with "." and processed files with "!".	**
' ** 06mar91 mwd 1.5	Removed root user check which caused rmail to   **
' **			to avoid processing after an (p)MDSS login.	**
' **									**
' ************************************************************************

#define	IDENT_PROG "rmail"
#define	IDENT_VERS "1.5"
#define	IDENT_DATE "6feb91"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	IOBUF_SIZE	$2000
#define	IOBUFL		$00
#define	IOBUFH		$20

	gosub AppInit

	From$ = "From "

	SpoolMail$ = SPOOL_MAIL_PATH

	dim IOBuf%[IOBUF_SIZE / 2]

	fFre
	freeMem = fre(0) - $1000
	dim f$[freeMem / 15]

	& files (SpoolMail$,f$),NumFiles
	if not NumFiles then goto Exit

	print "rmail ["NumFiles"] ";

	for msgNum = 1 to NumFiles
		f$ = SpoolMail$ + f$[msgNum]
		rp$ = ""
		mr$ = ""
		of$ = ""
		n = 0
		& time(t$)
		t$ = left$ (t$,3) + mid$ (t$,8,5) + mid$ (t$,6,3) + \
			right$ (t$,8) + " 19" + mid$ (t$,13,2)
		& getinfo f$,info$
		fOpen f$ ",T" asc ( mid$ (info$,5))
		src = peek (_OREFNUM)
		fRead f$

		repeat
			& get a$
			k = len (rp$)
			& pos (a$,From$),i
			if i and (i < 3) then
				i = i + 5
				& pos (i,a$," "),j
				mr$ = mid$ (a$,i,j - i)
			endif
			& pos (a$," remote from "),i
			if i then
				& spc (mid$(a$,i + 13)), i$
				rp$ = rp$ + i$ + "!"
				n = 1
			endif
		until len (rp$) <= k

		if n then
			of$ = f$ + "."
			fAppend of$
			trg = peek(_OREFNUM)
			print From$ rp$ mr$ " " t$
			print a$
			fFlush of$
			gosub FileCopy
			fClose
			fDelete f$
			fRename of$ "," f$
			of$ = ""
			& setinfo f$, info$
		endif
		fClose
		print chr$(46 - (13 * n));
		f$[msgNum] = ""
		fFre
	next msgNum
	print 

	& restore ProgStack_Cell to a$
	& store BIN_PATH + "sendmail:" + a$ to ProgStack_Cell
goto Exit

' ====================
  FileCopy:
' ====================

	& poke _NEWLREF, src, 0
	& MLI (_NEWLINE, _SNEWLIN), errCode

	' Find address of IOBuf%[0] for file I/O buffer space
		
	a1 = 0
	a2 = 0
	IOBuf%[0] = 0
	& poke 0, peek(131), peek(132)
	a1 = peek(0)
	a2 = peek(1)

	repeat
		& poke _RWREFNUM, src, a1, a2, IOBUFL, IOBUFH
		& MLI (_READ, _SREAD), errCode
		if not errCode then
			& poke _RWREFNUM, trg, a1, a2, \
				peek(_RWTRANS), peek(_RWTRANS+1)
			& MLI (_WRITE, _SWRITE), errCode
		endif
	until errCode

	poke _CFREFNUM, trg
	& MLI (_FLUSH, _SFLUSH), errCode
return

#include <proline/proline.lib>
