'=========================================================================
'                                 P A T H
'
'                             by Dean K. Fick
'=========================================================================
'
' History:
'
' When    Who Ver   What
' ======= === ===== ======================================================
' 24oct91 dkf 1.0   Creation
' 30oct91 dkf       Added code to handle when the argument is the site
'                   where path is currently running
' 01nov91 dkf       Added code to reject arguments containing evidence
'                   of a full address (those containing the characters
'                   !@%).
'=========================================================================

#define	IDENT_PROG "path"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "1nov91"
#define	IDENT_NAME "Dean_Fick"

#include <proline/proline.h>

#define EndofData             5
#define MaxSites              100
#define SubDirType            15


     gosub AppInit
     gosub ShowPath
     goto Exit


' ****************************************************************
' **
' **  Show the path to a given site.
' **
' **

ShowPath:

     if not (argc =  2)  then goto ArgAbort

     & lcase (argv$[1])

     dim SiteName$[MaxSites], BadChar$[3]

     BadChar$[1] = "!"
     BadChar$[2] = "@"
     BadChar$[3] = "%"

     for Counter = 1 to 3
          & pos (argv$[1], BadChar$[Counter]), p
          if p then Counter = 3
     next

     if p then goto ArgAbort

     & pos (argv$[1], ".cts.com"), p
     if p then argv$[1] = left$ (argv$[1], len (argv$[1]) - 8)

     if argv$[1] = SysInfo$[plNode] then
          print "^Myou are now connected to " SysInfo$[plNode] "^M"
          & pop
          goto Exit
     endif

     & files (MDSS_PATH, SiteName$, SubDirType), CountofSites,\
     ActualFiles

     & sort (SiteName$, CountofSites)

     if mid$ (argv$[1], 4, 1) = "." then
          & pos ("prognhrti", left$(argv$[1], 3)), p
          if p then
               & mid$ (argv$[1], 4) = "-"
          endif
     endif

     if mid$ (argv$[1], 4, 1) = "-" then
          LegalSiteName$ = argv$[1]
          & mid$ (LegalSiteName$, 4) = "."
     endif

     for Counter = 1 to CountofSites

          & lcase (SiteName$[Counter])

          if (SiteName$[Counter] = argv$[1]) or\
            (SiteName$[Counter] = LegalSiteName$) then
               print "^M" argv$[1] " is directly connected to "\
               SysInfo$[plNode] "^M"
               Counter = CountofSites
               Found = True
          endif

     next

     if Found then
          & pop
          goto Exit
     endif

     PathsFile$ = ETC_PATH + "paths"

     & getinfo PathsFile$, FileInfo$

     if FileInfo$ = "" then
          print argv$[0] ": $/etc/paths not found"
          & pop
          goto Exit
     endif

     fOpen PathsFile$
     fRead PathsFile$

     onerr goto TrapEOF

     repeat

          & get PathsFileLine$

     until left$(PathsFileLine$, len (argv$[1])) = argv$[1]

     fClose

     onerr goto HandleError

     print "^M" PathsFileLine$ "^M"
     return

ArgAbort:
     print "Usage: path sitename.  See 'man path' for help."
     goto Exit

TrapEOF:
     & onerr errCode, errLine
     fClose
     if errCode = EndOfData then
          smRsrcFile$ = RSRC_PATH + "sendmail.rsrc"
          & getinfo smRsrcFile$, FileInfo$
          if FileInfo$ = "" then
               print "^Mno known path to " argv$[1]
               print "mail to "argv$[1]" will be sent to Crash TimeSharing"\
               " for resolution^M"
               & pop
               goto Exit
          else
               fOpen smRsrcFile$
               fRead smRsrcFile$
               & get SmartHost$
               fClose smRsrcFile$
               print "^Mno known path to " argv$[1]
               print "mail to "argv$[1]" will be sent to " SmartHost$\
               " for resolution^M"
               & pop
               goto Exit
          endif
     else
          print argv$[0] ": err " errCode"@"errLine
          & pop
          goto Exit
     endif


' ****************************************************************
' **
' ** Standard ProLine library routines
' **
' **

#include <proline/proline.lib>
