' ****************************************************************************
' **
' **   netauth - a program for maintaining mailstop files on proline.
' **
' **   Synopsis:
' **
' **     netauth *              : reports net access status for all users
' **     netauth ?              : tell about netauth
' **     netauth username       : reports net access status for username
' **     netauth -a username    : restores net access  for username
' **     netauth -r username    : removes net access for username
' **     netauth -t username    : removed net access, but allwes auto aging
' **     netauth -d             : eats all mailstop files > 30 days old
' **     netauth -d nn          : eats all mailstop files > nn days old
' **
' **
' ** When    Who Ver                What
' ** ======= === ====   ================================================
' ** 02dec90 dzd 1.0    Inital version, -d not implemented, But the rest
' **                    of the program worked.
' **
' ** 18dec90 dzd        -t flag added, bare bones but working verison of
' **                    the -d option added, MkAccess, RmAccess, and
' **                    RmFile fixed to properly suport FORCE/NOTFORCE and
' **                    LOCK/NOLOCK parameters needed for -d option.
' **
' ** 20dec90 dzd        Output from auto expiration cleaned up, and a copy 
' **                    of the netauth.log is mailed to the root alias.
' **                    Introduced Bug that breaks the -d option altogether
' **
' ** 22dec90 dzd        multiple names can now be specified for all options
' **                    except '-d' and '*' where it would make no sense.
' **                    '?' option added.
' **
' ** 23dec90 dzd        '-d' and '*' options now read the $/etc/passwd file
' **                    for a list of names, and test for them as directories
' **                    in the $/adm directory.  '-d' option fixed.
' **
' ****************************************************************************

#define	IDENT_PROG "netauth"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "23dec90"
#define	IDENT_NAME "Daniel_Z._Davidson"

#include <basic.h>
#include <prodos.h>
#include <appleio.h>
#include <proline/proline.h>

        #define RmFile(path,f)  Path$ = path : forced = f : gosub _RmFile
        #define MkFile(path)    Path$ = path :  gosub _MkFile
        #define PostMsg(str)    msg$  = str  : gosub _PostMsg
        #define Auto(d)         Days  = d    : gosub _Auto
        #define MkAccess(str,f) User$ = str  : forced = f : gosub _MkAccess
        #define RmAccess(str,f) User$ = str  : forced = f : gosub _RmAccess
        #define CkStatus(str)   User$ = str  : gosub _CkStatus
        #define Report          gosub _Report
        #define EatHeader       for x=1 to 3: &get User$ : next
        #define ArgError        PostMsg("Usage: netauth [ [-rat]  username ]  [-d xx] [?*]")
        #define IsLeapYear(y)   not mod(y,4) and mod(y,100) or not mod(y,400)
        #define MonthDays(m)    val(mid$(DaysInMonth$, m * 2, 2))
        #define GetJDate(m,d,y) val(mid$(Julian$,m*3,3))+d+(m>2 and IsLeapYear(y))
        #define SendLog         gosub _SendLog


        Julian$         = "??000031059090120151181212243273304334"
        DaysInMonth$    = "?312831303130313130313031"
        Months$         = "???JanFebMarAprMayJunJulAugSepOctNovDec"

        #define MAX_ARGS        3
        #define DEFAULT         30
        #define LOCKED          "!"
        #define FORCE           1
        #define NOFORCE         0
        #define LOCK            1
        #define NOLOCK          0
        #define EPOC            1970
        #define MAX_CHANGE      100


        gosub AppInit                  'ProLine Application Init
        if not SuperUser then
                PostMsg ("Access Denied.")
                goto Exit
        endif

        if (argc = 1)  then
                ArgError
                goto Exit
        endif

        if (argc > 2) then
                gosub Three
                goto Exit
        endif

        on argc gosub One, Two
        goto Exit

One:
        ArgError
        return

Two:
        if argv$(1) = "*" then
                Report
                return
        endif

        if argv$(1) = "?" then
                FilePath$= SysInfo$(plDir)+"etc/help/netauth.help"
                &/ FilePath$, info$
                if (info$<> "") then
                        print "About netauth :"
                        &list FilePath$
                else
                        PostMsg ("Information file not avalible.")
                endif

                return
        endif

        if argv$(1) = "-d" then
                Auto(DEFAULT)
                return
        endif

        CkStatus(argv$(1))
        return

Three:
        if argv$(1) ="-d" then

                if argc > 3 then
                        ArgErr
                        return
                endif

                Auto(val(argv$(2)))
                return

        endif

        if argv$(1) ="-r" then
                for x = 2 to argc - 1
                RmAccess(argv$(x),LOCK)
                next x
                return
        endif

        if argv$(1) ="-a" then
                for x = 2 to argc - 1
                MkAccess(argv$(x),FORCE)
                next x
                return
        endif

        if argv$(1) ="-t" then
                for x = 2 to argc - 1
                RmAccess(argv$(x),NOLOCK)
                next x
                return
        endif

        for x = 1 to argc - 1
        CkStatus(argv$(x))
        next x
        return



' ************************************************************************
' **
' **  The Subrutines that get called are all in after this line. Most
' **  are very simple and require no explination.
' **
' ************************************************************************

_CkStatus:

        'Check for a "/" in the username. if there is one,
        'then refuse to cope with it, and print an error.

        &pos (User$,"/"),info
        if (info) or not(len(User$))  then
                PostMsg("Illegal username.")
                return
        endif

        Path$=SysInfo$(plDir) + "adm/" + User$
        &/ Path$, Info$
        if Info$ = "" then
                PostMsg("No such user '" + User$ + "'.")
        else
                Path$ = Path$ + "/mailstop"
                &/ Path$, Info$
                User$="'"+User$+"'"
                &left$(User$,16),User$
                If Info$ = "" then
                                print User$;"has net access."
                        else
                                print User$;"has No net access"
                        endif
        endif

        return

' ************************************************************************

_RmFile:
        &/ Path$, Info$

        If (Info$ = "") then     'If the File does not exist, don't
                return           'bother trying to remove it, just
        endif                    'act like you did.


        if (mid$(Info$,4,1) = LOCKED) and not(forced) then
                   return
        else
                   fUnlock Path$
                   fDelete Path$
                   return
        endif

' ************************************************************************


_MkFile:
        fOpen   Path$               'create an empty file
        fClose  Path$               'close it
        return

' ************************************************************************

_PostMsg:
        if msgFile$ > "" then
                fAppend msgFile$
                print  msg$
                fClose msgFile$
                print msg$
        else
                print argv$[0] ": " msg$
        endif

return

' ************************************************************************

_Auto:

        if (Days <= 0) then
                ArgError
                return
        endif

        '*********************************************************
        '*
        '*      Get the current Date info for later comparison
        '*


        &time (Time$)
        CDay$   = mid$(Time$,6, 2)
        CMonth$ = mid$(Time$,9, 3)
        CYear$  = mid$(Time$,12,3)

        &spc (CDay$), CDay$
        CDay  = val (CDay$)
        CYear = val (CYear$)
        &pos (Months$, CMonth$), CMonth
        CMonth = int (CMonth / 3)

        '*********************************************************
        '*
        '*      Open the adm directory, and use it as a list of
        '*      users for testing to see if they can get netaccess
        '*


        FilePath$ = SysInfo$(plDir) + "etc/passwd"

        TempPath$ = SysInfo$(plTempDir)+"netauth.log"
        &/ TempPath$,info$
        if (info$<>"")  then
                fDelete TempPath$
        endif

        msgFile$=TempPath$

        DIM CUser$(MAX_CHANGE), CDelta$(MAX_CHANGE)


        fOpen FilePath$
        Changed = 0
        onerr goto AutoEOF
        print "Working ";

AutoRepeat:

        fRead FilePath$
        &get User$
        &pos (User$,":"), user
        User$ = left$ (User$,user - 1)
        &spc (User$), User$
        &lcase (User$)

        TestPath$ = SysInfo$(plDir)+"adm/"+User$
        &/ TestPath$,info$

        if (info$ <> "") then

                print ".";

                'make sure there is a mailstop file, and that it is not
                'locked. becasue if there isn't one, or it is locked
                'there is no need to try and get info from it.

                File$=TestPath$ + "/mailstop"
                &/ File$, info$

                if (info$ <> "") and (mid$ (info$, 4,1) <> LOCKED) then

                        ' Pull the info we want from info$
                        CDateL = asc(mid$(info$,15,1))
                        CDateH = asc(mid$(info$,16,1))

                        'Now convert it from bit fields to some usable numbers

                        FDay   = CDateL - int(CDateL / 32) *32
                        FYear  = int( CDateH /2)
                        FMonth = (CDateH - FYear *2)  * 8 + int( CDateL / 32)

                        'compare file creation date with current date

                        date1 = GetJDate(CMonth, CDay, CYear) \
                                + int((CYear - Epoc) *365.25)
                        date2 = GetJDate(FMonth, FDay, FYear) \
                                + int((FYear - Epoc) *365.25)
                        delta = abs(date1-date2)

                        'If the file is too old, then delete it.

                        if (delta >= Days) and (Changed < MAX_CHANGE) then
                                Changed = Changed + 1
                                CUser$(Changed)  = User$
                                CDelta$(Changed) = str$(delta)
                        endif
                endif

        endif

        goto AutoRepeat

AutoEOF:
        &onerr  Code, Line

        If (Code = 5) then
                onerr goto HandleError
                fClose FilePath$
        else
                fClose
                print "Err ";Code;" @ ";Line
                goto Exit
        endif

        print

        if Changed then

                print "Building 'netauth.log' and granting access."
                PostMsg ("Netuath has restored access for the Following accounts:");
                PostMsg (" ")
                for x= 1 to Changed
                        MkAccess (CUser$(x), NOFORCE)
                        &left$ (CUser$(x),17), User$
                        note$ = User$+ "has not had access for " + \
                                CDelta$(x) + " days. (Max= " + \
                                str$(Days) +" days)."
                        PostMsg(note$)
                next x

                PostMsg(" ")
                note$= "Access added for "+str$(Changed)+" Accounts"
                PostMsg(note$)

                if (Changed = MAX_CHANGED)
                        PostMsg ("Warning: More than 100 accounts needed to have access,")
                        PostMsg ("         It may be nescesary to run netauth again.")
                endif

                SendLog(TempPath$)
        else
                print
                print "No Accounts have had access added."
                &/ TempPath$,info$
                if (info$<>"")  then
                        fDelete TempPath$
                endif
        endif

        return



' ************************************************************************

_RmAccess:
        &pos (User$,"/"),info
        if (info) or not(len(User$))  then
                PostMsg("Illegal username.")
                return
        endif

        Path$=SysInfo$(plDir) + "adm/" + User$
        &/ Path$, Info$
        if Info$ = "" then
                PostMsg("No such user '" + User$ + "'.")
        else
                Path$ = Path$ + "/mailstop"
                Mkfile(Path$)
                if (forced) then fLock Path$
                print "Network access removed for ";User$
        endif
        return

' ************************************************************************

_MkAccess:
        &pos (User$,"/"),info
        if (info) or not(len(User$))  then
                PostMsg("Illegal username.")
                return
        endif

        Path$=SysInfo$(plDir) + "adm/" + User$
        &/ Path$, Info$
        if Info$ = "" then
                PostMsg("No such user '" + User$+ "'.")
        else
                Path$ = Path$ + "/mailstop"
                RmFile(Path$,forced)
                if (forced) then print "Network access added for ";User$
        endif
        return

' ************************************************************************

_Report:
        FilePath$ = SysInfo$(plDir) + "etc/passwd"
        fOpen FilePath$
        fRead FilePath$

        Onerr goto ReportDone

NextReport:

        &get User$
        &pos (User$,":"), user
        User$ = left$ (User$,user - 1)
        &spc (User$), User$
        &lcase (User$)

        TestPath$ = SysInfo$(plDir)+"adm/"+User$
        &/ TestPath$,info$

        if (info$ <>"") then
                CkStatus(User$)
        endif

        goto NextReport

ReportDone:

        &onerr
        onerr goto HandleError
        fClose
        return

' ***************************************************
' **
' ** SendMsgFile - Create mailbox header and send log
' **
' ** The letter is addressed to "root" so that it is
' ** sent to the root alias (which could be many users).
' **

_SendLog:
        gosub MakeUniqueName
        spoolDir$ = SysInfo$(plDir)+"spool/mail/"
        fAppend spoolDir$ theFile$
        print "From " ID$[uName] " " left$(theTime$,3) mid$(theTime$,8,5) \
              mid$(theTime$,6,3) right$(theTime$,8) " 19" mid$(theTime$,13,3)
        print "Date: " left$(theTime$,5) val(mid$(theTime$,6)) \
              mid$(theTime$,8) " " SysInfo$[plZone]
        print "From: " ID$[uName] " (" ID$[uFullName] ")"
        print "To: root"
        print "Subject: " argv$[0] " log"
        print 
        fClose
        &add (TempPath$ to spoolDir$ + theFile$)
        fDelete msgFile$
        return


' *****************************************************************
' **
' ** Build a filename (theFile$) from theTime$ in the format:
' **
' **    ddSSSSS
' **
' ** Where dd is an alphabetic variant of the combined month and date
' ** values, and SSSSS are the number of seconds that have elapsed since
' ** midnight.

MakeUniqueName:
        &time (theTime$)
        &pos ("?anebarprayunulugepctovec", mid$(theTime$, 10, 2)), i
        i = i / 2
        d = val (mid$ (theTime$,6))
        &right$ (str$(val(mid$(theTime$,16)) * 3600 + \
                val(mid$(theTime$, 19)) * 60 + \
                val(right$(theTime$, 2))), 5, 48), theFile$
        theFile$ = chr$(64 + i) + chr$(48 + d + 7 * (d > 9)) + theFile$
return

#include <proline/proline.lib>
