' ****************************************************************
' **
' ** mdss.b	Mail Delivery SubSystem
' **		(C)opyright 1994 Morgan Davis Group
' **
' ** History:
' ** 07mar90 mwd	Conversion to MD-BASIC format
' **			Added job countdown during receives
' ** 18apr90 mwd	Fixed job count of 1 when there's none
' ** 22apr90 mwd	Variable cans used instead of cancels
' **			in line noise cancel test.  Fixed.
' **			Replaced null print for DCD check with
' **			explicit &FN fnCarrier function call.
' ** 26apr90 mwd	Constant ENQ_SECONDS used instead of
' **			ENQ_SECOND -- the define is renamed to
' **			be ENQ_SECONDS as is more descriptive.
' ** 21may90 mwd 1.7	Fixed bug in catching no command line
' **			arguments via a poll invocation.  Added
' **			-p flag to turn on pmdss mode.  Turned
' **			off paging (in case it was on).
' **			Reports seconds in mdss log.
' ** 16nov90 mwd 1.8	Added UnixMDSS -u flag and delay
' ** 13feb91 jj  1.9	Added total byte reporting.
' **         mwd	Prefixes job number with site name.
' **			ENQ sends every two seconds now.
' **			Fixed UnixMDSS delay (was mislocated)
' ** 14feb91 mwd	Erases (reuses) protocol status line.
' ** 30jul91 mwd 1.9.1	Added JOBINFO_SECS and increased time
' **			allowed for "Jobs:" handshake.  Fixed
' **			log format to conform with system.
' ** 22aug91 mwd 2.0	Does exact time logging of transfers
' **			adding S# and R# stats in H log entry.
' ** 18nov91 mwd 2.1	Removed "bytes to" in log entries.
' ** 25nov91 mwd 2.2	Added same-second sequencer.
' **  7Jul92 mwd 2.3	Added MW 3 protocols, batch modes, etc.
' ** 25Feb93 mwd 2.3.1	Fixed batchFlag% / Refresh_Queue bug
' ** 16jan94 mwd 3.0	Launch/IDENT update
' **
' ****************************************************************

#define	IDENT_PROG "mdss"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"


#include <appleio.h>
#include <basic.h>
#include <romcall.h>
#include <prodos.h>
#include <proline/proline.h>

#define	SEND_CMD	"S"		' MDSS command letters
#define	RECV_CMD	"R"
#define	RECV_BIN_CMD	"B"
#define	HANGUP_CMD	"H"
#define	COMMAND_LIST	"SRBH"		' all of them

#define	SEND_MODE	1
#define	RECV_MODE	2

#define	QUEUE_SIZE	16		' Filename queue size
#define	MAX_CANS	4		' Consecutive cancels before dying
#define	MAX_SECONDS	30		' Seconds before inactivity timeout
#define	MAX_FAILS	3		' Consecutive file xfer failures
#define	ENQ_PERIODS	3		' # times to process ENQ handshakes
#define	ENQ_SECONDS	-10		' Seconds per ENQ handshake (no echo)
#define	JOBINFO_SECS	-10		' Seconds for 'Jobs:' handshake


' ************************************************************
' **
' ** Main
' **
' ** Sets up environment, and if all is well, selects the proper
' ** function to call based on arguments passed on the command
' ** line.  This provides arbitration for who choosing slave
' ** and master without flipping any coins.
' **
' ** We check argv$[1] for flags and set up unixmdss or pmdss as
' ** needed.

	gosub AppInit			' Init ProLine environment

	xferFlags$	= ""		' ProLine ProDOS XMODEM
	pmdss		= FALSE		' P-Net MDSS mode
	xferType$	= "X"		' XMODEM default
	batchMode%	= FALSE		' Not a batch-style transfer
	delaySeconds%	= 0		' No delays after ENQ's recvd
	runSendmail	= FALSE		' Run sendmail after receiving
	
	options$ = "d:upsx:zy"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "d" then delaySeconds% = val(optarg$)
		if optchar$ = "p" or optchar$ = "u" then
			pmdss = TRUE
			xferFlags$ = xferFlags$ + "XT"
		endif
		if optchar$ = "s" then runSendmail = TRUE
		if optchar$ = "x" then xferFlags$ = xferFlags$ + optarg$
		if optchar$ = "z" then
			xferType$ = "Z"
			batchMode% = TRUE
			xferFlags$ = xferFlags$ + "D"
		endif
		if optchar$ = "y" then
			xferType$ = "XY"
			batchMode% = TRUE
			xferFlags$ = xferFlags$ + "Y"
		endif
		if optchar$ = "?" then
			print "Usage: " argv$[0] " [-d delay] [-uyz] [-x flags] [site]"
			goto ExitError
		endif
	until optchar$ = ""

	if not SuperUser and ID$[uGID] <> "2" then 
		print argv$[0]": not a user function"
		goto ExitError
	endif

	& pr ioConsole
	& page stop

	mdssLogFile$	= SPOOL_LOGS_PATH + "mdsslog"
	spoolMailDir$	= SPOOL_MAIL_PATH
	idFile$		= SysInfo$[plDir] + "etc/idfile"

	ENQ$		= chr$(5)
	CAN$		= chr$(24)

	gosub GetConnectSpeed
	topcps = connectSpeed / 10

	& int stop 
	if nargc < 2 then goto Get_MDSS_ID


' ************************************************************
' **
' ** If we were called via a poll, we must have passed the name
' ** of the site we're polling as an argument.

	site$ = nargv$[1]
	& ioctl(ioEraseLine)		' ...to hide the id;password
	gosub DrawStatusBox
	& on hangup goto MDSS_Carrier_Lost

' ************************************************************
' **
' ** Since we've successfully logged in and identified ourselves
' ** with the other site at this point, we can start sending
' ** files, if there are any to send.  If there aren't, we
' ** give up master mode and let the other end take over.

SendFiles:
	& load fre ReceiveTool_ID	' Dump any receive tool
	queue$[0] = ""
	& erase(queue$)
	dim queue$[QUEUE_SIZE]
	& hlin 20, 45
	& print 

	info$ = site$
	if mid$(info$, 4, 1) = "-" then & mid$(info$, 4) = "."
	siteDir$ = SysInfo$[plDir] + "mdss/" + info$
	modePrompt$ = SEND_CMD
	& GETINFO siteDir$, info$
	
	printJob = TRUE
	currentMode = SEND_MODE
	gosub InitStatus
	batchStarted% = FALSE

Refresh_Queue:
	filesInQ = 0
	filesInDir = 0

	if info$ > "" then & files (siteDir$, queue$, -15), filesInQ, filesInDir
	if not jobsTotal then jobsTotal = filesInDir
	if printJob then 
		printJob = FALSE
		if filesInDir then gosub GetBytesTotal
		gosub NewStatus
		if not pmdss then
			& put ("Bytes: " + str$(bytesTotal) + "^M^J")
			& put ("Jobs: " + str$(filesInDir) + "^M^J")
		endif
	endif

	& clear 
	if filesInQ then
		& load peek ommInfo, SendTool_ID, i$
		if i$ = "" then
			& load get SysInfo$[plModulesDir] + "S" + left$(xferType$, 1)
			onerr goto MDSS_Error
		endif
		& srt (queue$, filesInQ)
		for k = 1 to filesInQ
			theFile$ = siteDir$ + "/" + queue$[k]
			a$ = RECV_CMD

' The conditionals in here for the "Z" mode and binary files are to make
' up for the fact that RZ/SZ currently don't support Binary II wrapping.
' Once they do, all this junk can be deleted.

			binaryFlag% = FALSE
			if xferType$ = "Z" then
				& getinfo theFile$, i$
				binaryFlag% = asc(mid$(i$, 5)) = 6
				if binaryFlag% then
					a$ = RECV_BIN_CMD
					if batchStarted% then
						& snd ("", xferFlags$), xResult
						batchStarted% = FALSE
					endif
				endif
			endif
			if not batchStarted% then
				gosub Wait_For_ENQ
				& put (a$)
				batchStarted% = batchMode%
			endif
			fFre				' Free RAM
			gosub MiniTime
			logTime$ = a$
			gosub GetTimeMark
			startTimeMark = curTimeMark
			print "Send (" xferType$ ") ";
			& snd (theFile$, xferFlags$), xResult
			gosub GetEndMark
			endTimeMark = curTimeMark
			if not xResult then
				gosub UpdateStatusInfo
				fDelete theFile$
				queue$[k] = ""		' Save RAM as we go
				if xferType$ = "Z" and binaryFlag% then
					batchStarted% = FALSE
					& snd ("", xferFlags$), xResult
				endif
			else
				gosub FileFailure
				k = k - 1		' Retry same file again
				batchStarted% = FALSE
			endif
		next
		if filesInQ < filesInDir then goto Refresh_Queue
	endif

	if batchMode% and batchStarted% then & snd ("", xferFlags$), xResult

	gosub Wait_For_ENQ
	if nargc > 1 then 
		& put (SEND_CMD)
		goto Receive_Commands
	endif

	& put(HANGUP_CMD)
	& chk stop
	& wait 3
goto LogHangUp


' ************************************************************
' **
' ** Prompt calling site for its ID and password.  Look them up
' ** in the idfile.  Handle accordingly.  If successful login,
' ** fall into Receive_Commands.

Get_MDSS_ID:
	& put ("id: ")
	& pr ioNone
	& read id$
	& pr ioConsole

	gosub MiniTime
	LogEntry$ = "MDSS " + a$ + " "

	& pos (id$,";"), p
	if not p then & pos (id$," "), p
	if not p then
		site$ = id$
		i$ = "bad format"
		goto ID_Failed
	endif

	site$ = mid$ (id$, 1, p - 1)
	password$ = mid$ (id$, p + 1)

	onerr goto idFileEOF
	fOpen idFile$
	fRead idFile$
	do
		& get i$
		& pos (i$, "#"), p
		if p then & spc(mid$(i$, 1, p - 1)), i$
		& pos (i$, ";"), p
		if not p then & pos (i$, " "), p
		if not p then
			fClose
			LogEntry$ = LogEntry$ + "<ERROR: BAD IDFILE ENTRY '" + i$ + "'>"
			gosub UpdateLog
			goto MDSS_Logout
		endif
		if site$ = left$ (i$, p - 1) then goto Got_Site
	loop

idFileEOF:
	& onerr
	i$ = "SITE UNKNOWN"

ID_Failed:
	onerr goto HandleError
	fClose
	LogEntry$ = LogEntry$ + site$ + " <ALERT: " + i$ + ">"
	gosub UpdateLog
	goto MDSS_Logout

Got_Site:
	onerr goto HandleError
	fClose
	if mid$ (i$,p + 1) < > password$ then 
		i$ = "BOGUS PASSWORD '" + password$ + "'"
		goto ID_Failed
	endif

	gosub GetConnectSpeed
	LogEntry$ = LogEntry$ + site$ + " " + str$(connectSpeed)
	gosub UpdateLog

	gosub DrawStatusBox
	& on hangup goto MDSS_Carrier_Lost


' ************************************************************
' **
' ** This routine is responsible for determining the number of jobs
' ** the other end has queued for transmission -- but only if the
' ** session is MDSS (not PMDSS).  If MDSS, the job count decrements
' ** as files are received.  If PMDSS, the job count just increments.
' ** This function sends ENQ to the other end, and then handles the
' ** MDSS commands it receives in return.

Receive_Commands:
	& load fre SendTool_ID		' Dump any sending tool
	& hlin 20, 45
	& print
	currentMode = RECV_MODE
	gosub InitStatus

	if not pmdss then
		& in ioBoth
		a$ = "s: "
		& wait JOBINFO_SECS for a$, i
		if i then
			& get (8), i$
			bytesTotal = val(i$)
		endif
		& wait JOBINFO_SECS for a$, i
		if i then
			& get (3), i$
			jobsTotal = val(i$)
		endif
		& in ioConsole
	endif
	gosub NewStatus

	modePrompt$ = RECV_CMD

	repeat
		cancels = 0
		repeat
			& clear
			seconds = 0
			sendInterval = FALSE
			repeat
				sendInterval = not sendInterval
				if sendInterval then & put (ENQ$)
				& time (i$)
				& rept
					& fn fnPortInput, ch
					& time (theTime$)
				& until ((ch > 127) or (theTime$ <> i$))
				& fn fnModemType, dcd
				if dcd = noModem then
					& fn fnPortDCD, dcd
				else
					& fn fnOnline, dcd
				endif
				if not dcd then goto MDSS_Carrier_Lost
				if ch < 128 then 
					seconds = seconds + 1
					if seconds > MAX_SECONDS then
						failMsg$ = "COMMAND TIMEOUT"
						goto MDSS_Fail
					endif
				endif
			until ch > 127

			ch$ = chr$(ch - 128)
			& pos (COMMAND_LIST, ch$), p
			if not p then
				cancels = cancels + 1
				& put (CAN$)
				& wait 1
				if cancels > MAX_CANS then
					failMsg$ = "TOO MUCH LINE NOISE"
					goto MDSS_Fail
				endif
			endif
		until p
		if ch$ = SEND_CMD then goto SendFiles
		if ch$ <> HANGUP_CMD then
			binaryFlag% = ch$ = RECV_BIN_CMD
			gosub ReceiveFile
		endif
	until ch$ = HANGUP_CMD
goto LogHangUp


' **************************************************
' **
' ** Get a unique filename based on the date, show the
' ** job count, and then get the file.  After the file
' ** is received without errors, update the log file.

ReceiveFile:
	& load peek ommInfo, ReceiveTool_ID, i$
	if i$ = "" then
		& load get SysInfo$[plModulesDir] + "R" + left$(xferType$, 1)
		onerr goto MDSS_Error
	endif
	gosub MakeUniqueName
	gosub MiniTime
	logTime$ = a$
	gosub GetTimeMark
	startTimeMark = curTimeMark
	print "Receive (" xferType$ ") ";
	& rcv (theFile$, "B" + xferFlags$), xResult, newName$
	gosub GetEndMark
	endTimeMark = curTimeMark
	if batchMode% and newName$ = "" then return
	if not xResult then
		gosub UpdateStatusInfo
		if batchMode% then goto ReceiveFile
	else
		gosub FileFailure
	endif
return


' ****************************************
' **
' ** Transfer failed, see if too many

FileFailure:
	consecFailures = consecFailures + 1
	if consecFailures = MAX_FAILS then
		failMsg$ = "TOO MANY FAILURES"
		goto MDSS_Fail
	endif
return


' ******************************************************
' **
' ** If carrier is lost after logging in, report it

MDSS_Carrier_Lost:
	& chk stop
	failMsg$ = "LOST CARRIER"

' ******************************************************
' **
' ** Update log with the MDSS failure message, then exit

MDSS_Fail:
	gosub MiniTime
	LogEntry$ = "^I" + a$ + " <ALERT: " + site$ + "; " + failMsg$ + ">"
	gosub UpdateLog
	goto LogHangUp

MDSS_Error:
	& onerr e, l
	print argv$[0]": error "e" at "l

LogHangUp:
	onerr goto HandleError
	& load fre SendTool_ID		' Dump any lingering tools
	& load fre ReceiveTool_ID

	gosub MiniTime
	i$ =	"S#" + str$(jobsDone[SEND_MODE]) + "," + \
			str$(bytesDone[SEND_MODE]) + "," + \
			str$(timeElapsed[SEND_MODE]) + " " + \
		"R#" + str$(jobsDone[RECV_MODE]) + "," + \
			str$(bytesDone[RECV_MODE]) + "," + \
			str$(timeElapsed[RECV_MODE])

	LogEntry$ = "^I" + a$ + " " + HANGUP_CMD + " " + site$ + " " + i$
	gosub UpdateLog

MDSS_Logout:
	& hangup
	& pr ioConsole
	& int on
	& chk on
	poke _WNDBOT, 24
	& goto 0, statusLine% + 5
	print
	if runSendmail and jobsDone[RECV_MODE] then
		Launch("sendmail", "", FALSE)
	endif
goto Exit


' ************************************************************
' **
' ** Time routines:
' **
' ** MiniTime: Return a time string in a$ in this format:  mm/dd-hh:mm
' **
' ** GetMonthNum: Returns in i the current month number

MiniTime:
	& time (theTime$)
	gosub GetMonthNum
	a$ = str$ (i) + "/" + str$ (val (mid$ (theTime$,6))) + \
		 "-" + mid$ (theTime$,16,8)
return 

GetMonthNum:
	& pos ("?anebarprayunulugepctovec", mid$ (theTime$, 10, 2)), i
	i = i / 2
return 

ElapsedTime:
	if endTimeMark <  startTimeMark then
		seconds = 86400 - startTimeMark + endTimeMark
	else
		seconds = endTimeMark - startTimeMark
	endif
return

GetEndMark:
	& ioctl(ioCR)
	& ioctl(ioClearEOL)
	
GetTimeMark:
	&time(t$)
	curTimeMark = val(mid$(t$,16,2)) * 3600 + \
		val(mid$(t$,19,2)) * 60 + \
		val(mid$(t$,22,2))
return


' *****************************************************************
' **
' ** Build a filename (theFile$) from theTime$ in the format:
' **
' **	ddSSSSS
' **
' ** Where dd is an alphabetic variant of the combined month and date
' ** values, and SSSSS are the number of seconds that have elapsed since
' ** midnight.

MakeUniqueName:
	& time (theTime$)
	gosub GetMonthNum
	d = val (mid$ (theTime$,6))
	& right$ (str$(val(mid$(theTime$,16)) * 3600 + \
		val(mid$ (theTime$, 19)) * 60 + \
		val(right$ (theTime$, 2))), 5, 48), theFile$
	theFile$ = spoolMailDir$ + \
		chr$ (64 + i) + chr$ (48 + d + 7 * (d > 9)) + theFile$
	if theFile$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = theFile$
	theFile$ = theFile$ + seq$
return


' ****************************************************************
' **
' ** Search through received message to locate the Ppath field.
' ** Once found, build an entry for the logfile giving the name
' ** of the intended recipient.  If the address could not be
' ** resolved, return "?".

Find_Ppath:
	& getinfo theFile$, i$			' Get file info (type)
	if binaryFlag% then
		& mid$(i$, 5) = chr$(6)
		& setinfo theFile$, i$
	endif

	fOpen theFile$ ",T" asc(mid$(i$,5))	' Open any filetype
	fRead theFile$

	poke _SREFNUM, peek(_OREFNUM)		' Get number of bytes in file
	& MLI (_GET_EOF, _SGETEOF), r
	bytes = peek24(_SEOF)
	
	LogEntry$ = "^I" + logTime$ + " " + modePrompt$ + " " + \
		str$(bytes) + " "

	address$ = "?"
	onerr goto Ppath_EOF
	repeat
		& get i$
	until left$(i$, 7) = "Ppath: " or i$ = ""

	if i$ > "" then
		address$ = mid$ (i$,8)
		if modePrompt$ = "R" then
			strip$ = SysInfo$[plNode]
		else
			strip$ = site$
		endif
		& pos (address$, strip$ + "!"),p
		if p then address$ = mid$ (address$, p + len(strip$) + 1)
	endif
	goto PpathClose

Ppath_EOF:
	& onerr

PpathClose:
	fClose
	onerr goto HandleError

	LogEntry$ = LogEntry$ + address$

	'fall into UpdateLog


' ************************************************************
' **
' ** Write the variable LogEntry string into the mdss log file.

UpdateLog:
	fAppend mdssLogFile$
	print LogEntry$
	fClose mdssLogFile$
	& print LogEntry$
return 


' ************************************************
' **
' ** Wait for an ENQ based on handshake tolerances

Wait_For_ENQ:
	timeout = 0
	repeat
		& wait ENQ_SECONDS for ENQ$, r
		if not r then 
			timeout = timeout + 1
			print "ENQ timeout #" timeout
		endif
	until r or (timeout = ENQ_PERIODS)
	if not r then
		failMsg$ = "ENQ TIMEOUT"
		goto MDSS_Fail
	else
		if delaySeconds% then & wait(delaySeconds%)
	endif
return 


GetBytesTotal:
	fOpen siteDir$",T15"
	fRead siteDir$
	& get
	& get
	& get
	repeat
		& get a$
		bytesTotal = bytesTotal + val(mid$(a$,65,8))
	until a$ = ""
	fClose siteDir$
return


UpdateStatusInfo:
	gosub ElapsedTime
	timeElapsed[currentMode] = timeElapsed[currentMode] + seconds
	jobsDone[currentMode] = jobsDone[currentMode] + 1
	gosub Find_Ppath
	bytesDone[currentMode] = bytesDone[currentMode] + bytes
	consecFailures = 0

	poke _WNDBOT, 24

UpdateStatus:
	x = 31
	& goto x, statusLine% + currentMode

	poke _CH80, x
	& right$(str$(jobsDone[currentMode]), 3), i$
	& print i$;

	poke _CH80, x + 7
	bytes = bytesDone[currentMode]
	if pmdss and currentMode = RECV_MODE then
		i$ = "  ?"
		a$ = "  ?"
	else
		& right$(str$(jobsTotal), 3), i$
		if bytesTotal then
			& right$(str$(percent(0, bytesTotal, bytes)), 3), a$
		else
			a$ = "  0"
		endif
	endif
	& print i$;

	poke _CH80, x + 13
	& right$(str$(bytes), 8), i$
	& print i$ " " a$;
	
	seconds = timeElapsed[currentMode]
	poke _CH80, x + 29
	& right$(str$(seconds), 5), i$
	& print i$;

	if seconds then
		poke _CH80, x + 37
		cps = int(bytesDone[currentMode] / seconds)
		& right$(str$(cps), 4), i$
		& print i$;
		poke _CH80, x + 42
		& right$(str$(percent(0, topcps, cps)), 3), i$
		& print i$;
	endif
goto SetWindow


DrawStatusBox:
	& hlin 4 + (peek(_CH80) > 0), 13
	statusLine% = peek(37) - 3
	& goto 0, statusLine%
	i$ = ": --- of --- | -------- ---% | ----- | ---- ---%"
	& scrn (stdAppleIO)
	print "^O" tab(10) "Info" tab(32) "Jobs" tab(48) \
		"Bytes Done  Seconds   Avg CPS" tab (81);
	print "^[_^N" tab(22) "|   Sent" i$ "  ^OZ_^N" \
		" " site$ tab(22) "|   Rcvd" i$ "  ^OZ";
	& hlin 79, $4C
	poke _VIDLAST, $4C
	& ioctl (ioMTextOff)
	& scrn (stdMWIO)
SetWindow:
	& goto 0, statusLine% - 1
	poke _WNDBOT, statusLine%
return

InitStatus:
	bytesTotal	= 0
	jobsTotal	= 0
	consecFailures	= 0
	binaryFlag%	= 0
return

NewStatus:	
	poke _WNDBOT, 24
	& goto 2, statusLine% + 1
	& print str$(bytesTotal) " bytes " \
		mid$("fromto", 1 + ((currentMode = SEND_MODE) * 4), 4) \
		tab(22)
	x = 23
	& goto x, statusLine% + currentMode
	& print ">";	
	& goto x, statusLine% + RECV_MODE - (currentMode = RECV_MODE)
	& print " ";
goto UpdateStatus



' ==============================
  GetConnectSpeed:
' ==============================
	& fn fnModemType, connectSpeed
	if connectSpeed then
		& fn fnConnectSpeed, i$
	else
		& fn fnPortSpeed, connectSpeed
		connectSpeed = connectSpeed - ((connectSpeed > 5) * 6)
		i$ = mid$("  3  6 12 18 24 36 48 72 96192384576", \
			connectSpeed * 3 + 1, 3) + "00"
	endif
	connectSpeed = val(i$)
return



' ********************************************************
' **
' ** Standard ProLine Library routines

#include <proline/proline.lib>
#include <proline/getopt.lib>
#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
