' **********************************************************************
' ***
' ***	Launcher.b	Applesoft program launcher
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define VERSION	"Version 3.0"

#include <amperworks.h>
#include <appleio.h>
#include <basic.h>
#include <ctype.h>
#include <fileio.h>
#include <modemworks.h>
#include <omm.h>
#include <prodos.h>
#include <romcall.h>

#define	MAX_FILES	400

#define	diskInUse	1065
#define	diskFree	160
#define	diskBusy	67

#define	listCells	7

#define	diagX		15
#define	diagY		4
#define	diagHeight	15
#define	diagWidth	49

	data	"Disk:  Tab", \
		"Open:   ^OM^N ", \
		"Close: Esc", \
		"Quit:   ^OA^N."

	text 
	speed 255
	normal 
	if peek (-1101) < > 6 then 
		print "FOR APPLE IIE OR NEWER"
		new 
	endif

	onerr goto noAW
	& load peek ommInfo, AmperWorks_ID, i$
	if i$ > "" then goto main

noAW:
	print "Requires OMM/AmperWorks"
	new

main:
	onerr goto LauncherError
	if peek(_WNDWID) < 80 then fOutport 3
	& load peek ommInfo, ModemWorks_ID, i$
	mwActive = i$ > ""
	if mwActive then & scrn(stdAppleIO)
	print 
	home 

	deviceNum = peek(_DEVNUM)
	driveNum = 1
	if deviceNum > 128 then 
		driveNum = 2
		deviceNum = deviceNum - 128
	endif

	curSlot = deviceNum / 16

	icon$[0] = "Z^~"
	icon$[1] = "XY"

	title$ = "Applesoft Program Launcher"
	gosub CenterTitle

	e$ = chr$(cMTextOn)
	o$ = chr$(cInverse)
	n$ = chr$(cNormal)
	x$ = chr$(cMTextOff)

	for i = 1 to 4
		read button$[i]
	next 

	dim a$[MAX_FILES]
	fPrefix
	& get b$
	g$ = b$

	gosub DrawDialog

	
ReadDirectory:
	poke diskInUse, diskBusy
	vtab diagY + diagHeight + 2
	fPrefix
	& get b$
	
	fOpen b$ ",TDIR"
	fRead b$
	f = 0
	& get
	& get
	& get
	onerr goto dirErr

	repeat
		input a$
		if a$ > "" then
			t$ = mid$(a$, 18, 3)
			& pos ("TXTDIRBASYS16", t$), p
			if p then 
				f = f + 1
				a$[f] = mid$(a$, 2, 19)
			endif
		endif
	until a$ = ""

	dirErr:
	onerr goto LauncherError
	fClose
	& sort(a$,f)
	if not f then 
		a$[1] = "< Nothing to Open! >"
		f = 1
	endif

	gosub _86_

	on (f > listCells) + 1 gosub EmptyScrollBar,FillScrollBar

	gosub SetPort
	home 
	for i = 1 to listCells - ((listCells - f) * (f < listCells))
		print a$[i];
		if i < > listCells then print 
	next 
	poke diskInUse, diskFree
	v = 1
	g = 1
goto _45_


_33_:
	vtab diagY + 5 + v
_34_:
	poke _CH80, 0
_35_:
	gosub getKey

	on j = cReturn	goto showTextFile
	on j = cTab	goto doDisk
	on j = cEscape	goto doClose
	on j = 46	goto doQuit

	if j < > cDownArrow and j < > cUpArrow then goto _35_
	g = g + (j = cDownArrow) - (j = cUpArrow)
	if not g then 
		g = 1
		goto _35_
	endif

	if g > f then 
		g = f
		goto _35_
	endif

	print a$(p);
	v = v + (j = cDownArrow) - (j = cUpArrow)

	if v > listCells then 
		print chr$(cScrollUp);
		v = listCells
	endif

	if not v then 
		print chr$(cScrollDown);
		v = 1
	endif

_45_:
	vtab diagY + 5 + v
	poke _CH80, 0
	inverse 
	print a$[g];
	normal 
	p = g
goto _34_


showTextFile:
	i = 2
	gosub FlashButton
	t$ = right$ (a$[g], 3)
	i$ = left$ (a$[g], 15)
	if asc(i$) = 60 then goto doClose
	on t$ <> "TXT" goto doOpen
	title$ = i$
	gosub StripCenter
	ln = 0
	fOpen i$
	fRead i$
	onerr goto txtEOF

	repeat
		& get tm$
		print tm$
		ln = ln + 1
		if ln > 20 then
			ln = 0
			print o$ "--More--" n$;
			gosub getKey
			poke _CH80, 0
			call _CLREOL
		endif
	until j = cEscape

	txtEOF:
	fClose
	print 
	print o$ "--End--" n$;
	gosub getKey
	home 
run 

doOpen:
	if t$ <> "DIR" then 
		title$ = i$
		gosub StripCenter
		poke diskInUse, diskBusy
		poke 34,0
		gosub RestoreMWIO
		fLaunch i$
		end 
	endif

doOpen2:
	poke diskInUse, diskBusy
	gosub FullWindow
	fPrefix i$
goto ReadDirectory


doClose:
	i = 3
	gosub FlashButton
	a$ = b$

	repeat
		a$ = left$ (a$, len(a$) - 1)
	until right$ (a$,1) = "/"

	on a$ = "/" goto _33_
	i$ = a$
goto doOpen2


StripCenter:
	& spc(title$), title$
	gosub FullWindow
	gosub CenterTitle
	poke _WNDTOP, 2
	vtab 2
	home 
return 


FlashButton:
	poke _WNDWID, 50
	vtab diagY + 4 + i * 2
	poke _CH80, 28
	print o$ spc(12) n$;
	for j = 1 to 100 : next 
	poke _CH80, 28
	print " " e$ button$[i] x$ " ";
	poke _WNDWID, 20
return 


doQuit:
	i = 4
	gosub FlashButton
	title$ = "BASIC"
	gosub StripCenter
	gosub FullWindow
	print "Quit to ProDOS? (y/n) ";
	get a$
	if a$ = "Y" or a$ = "y" then
		home
		print "Unloading . . .^M"
		& load trace
		& load fre
		fBye
	endif
	home
	print "ProDOS BASIC"
	print "Copyright Apple Computer"
	print peek(115) + peek(116) * 256 - 2052 " bytes free."
	gosub RestoreMWIO
new 


DrawDialog:
	vtab diagY
	htab diagX + 1
	& hlin 49, 95
	print e$ o$
	htab diagX
	& vlin diagHeight, 90
	vtab diagY + 1
	poke _CH80, diagX + diagWidth
	& vlin diagHeight, 95
	print 
	htab diagX + 1
	& hlin 49, 76
	vtab diagY + 2
	htab diagX + 3
	print n$ "Select the file you want to open:"
	vtab diagY + 5
	htab diagX + 3
	& hlin 23, 95
	& hlin 5, 32
	& hlin 14, 95
	print 
	htab diagX + 2
	print e$ o$;
	& vlin listCells, 90
	vtab diagY + 6
	htab diagX + 24
	& vlin listCells, 90
	vtab diagY + 6
	htab diagX + 25
	& vlin listCells, 90
	vtab diagY + 6
	for i = 1 to 4
		htab diagX + 30
		print o$ "Z " n$ " " button$[i] " " o$ " _"
		if i <> 4 then
			htab diagX + 30
			print n$ " " o$;
			& hlin 14, 92
			print
		endif
	next 
	htab diagX + 3
	& hlin 23, 76
	print n$ spc(5) o$;
	& hlin 14, 76
	print 
	htab diagX + 3
	print n$ VERSION
return 


_80_:
	vtab diagY + 5 + listCells
	htab diagX + 25
	print o$ "Q"
	vtab diagY + 6
	htab diagX + 25
	print "R" n$
return 


FillScrollBar:
	ch$ = "V"
	goto DrawScrollbar
EmptyScrollBar:
	ch$ = "Z"
DrawScrollbar:
	print e$ o$
	vtab diagY + 7
	htab diagX + 25
	& vlin listCells - 2, asc(ch$)
	gosub _80_
	poke _WNDWID, 20
	print n$ x$;
return 

_86_:
	vtab diagY + 3
	print 
	poke _CH80, diagX + 2
	print e$ o$ icon$(b$ > g$) n$ x$ " " b$ spc(diagWidth - len (b$) - 7)
return 

getKey:
	wait _KBD, 128
	j = peek (_KBD) - 128
	poke _KBDSTRB, 0
return 


SetPort:
	print 
	vtab diagY + 7
	htab diagX + 3
	poke _WNDTOP, diagY + 5
	poke _WNDLFT, diagX + 3
	poke _WNDWID, 20
	poke _WNDBOT, diagY + 5 + listCells
return 

FullWindow:
	poke _WNDWID, 80
	poke _WNDLFT, 0
	poke _WNDTOP, 0
	poke _WNDBOT, 24
return 

doDisk:
	i = 1
	gosub FlashButton
	home 
	poke diskInUse, diskBusy
	gosub FullWindow
	vtab diagY + diagHeight + 2
	b$ = ""
	onerr goto driveErr

	fPrefix ",S" curSlot ",D" driveNum
	fPrefix
	& get a$
	if a$ < > mid$ (g$, 1, len(a$)) then 
		b$ = a$
		goto driveErr
	endif

_96_:
	driveNum = driveNum + 1
	if driveNum = 3 then 
		driveNum = 1
		curSlot = curSlot + 1
		if curSlot = 8 then curSlot = 1
	endif
	fPrefix ",S" curSlot ",D" driveNum
	fPrefix
	& get b$

	driveErr:
	on b$ = "" goto _96_
	g$ = b$
	gosub FullWindow
goto ReadDirectory


CenterTitle:
	vtab 1
	poke _CH80, 0
	inverse 
	call _CLREOL
	poke _CH80, 39 - len(title$) / 2
	print title$
	normal 
return 

RestoreMWIO:
	if mwActive then & scrn(stdMWIO)
return


LauncherError:
	e = ERR
	l = ERL
	poke _ERRFLG, 0
	fClose
	gosub FullWindow
	vtab diagY
	htab diagX + 1
	& hlin 49, 95
	print 
	htab diagX
	print e$ o$ "Z";
	& hlin 49,76
	print "_"
	for i = 1 to 3
		htab diagX
		print "Z" n$ spc(diagWidth) o$ "_"
	next 
	htab diagX
	print "Z" n$;
	& hlin 49,95
	print o$"_"
	htab diagX + 1
	& hlin 49,76
	vtab diagY + 1
	htab diagX + 3
	& hlin 7,92
	print 
	htab diagX + 2
	print o$ "Z_ZGGG_Z_"
	htab diagX + 2
	print "Z_" n$ "  o  " o$ "Z_"
	htab diagX + 2
	print "Z_" n$ "  O  " o$ "Z_"
	htab diagX + 3
	print "\\\\\\\" n$
	vtab diagY + 2
	htab diagX + 13
	print "An error occurred at line "l
	print 
	htab diagX + 13
	print "ID=" e; n$ x$
	vtab 23
end 
