' **********************************************************************
' **
' **	blackjack.b	ProLine Blackjack (Twenty-One)
' **			(C)opyright 1994 Morgan Davis Group
' **
' **  06nov93 mwd 1.0	Creation (ref "Hoyles Rules of Games",
' **			Morehead/Mott-Smith, 1963, New American Library)
' **

#define	IDENT_PROG "blackjack"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "26feb94"
#define	IDENT_NAME "Morgan_Davis"

#define	YEAR	"1994"

#define	USER_ACCT_FILE	ADM_PATH + ID$[uName] + "/bank.account"
#define	GAME_ACCT_FILE	GamesLib$ + IDENT_PROG ".acct"
#define	HIGH_SCORE_FILE	GamesLib$ + IDENT_PROG ".top10"

#define	MAX_DECK	52	' Number of cards in deck
#define	DECKS_IN_USE	2	' Number of decks shuffled together
#define	TOTAL_CARDS	104	' MAX_DECK * DECKS_IN_USE
#define	MAX_HAND	13	' Number of cards per player's hand
#define	HS_ENTRIES	10	' Number of entries in high score list

#define	MIN_BET		5	' Smallest bet
#define MAX_BET		1000	' Largest bet

#define	DEALER		0	' Dealer ID
#define	PLAYER		1	' Player ID
#define	PLAYER_SPLIT	2	' Player ID with split hand

#define	PLAYER_X	10	' Column positions
#define	PLAYER_SPLIT_X	25
#define	PLAYER_Y	6
#define	PLAYER_SPLIT_Y	6
#define	DEALER_X	45
#define	DEALER_SPLIT_X	50
#define	DEALER_Y	PLAYER_Y
#define	STAT_X		0
#define	STAT_Y		22
#define	HS_X		5
#define	HS_Y		7

#define	isBlackJack	(playersBest = 21 and holding = 2)

#define	formatNum(num, w1, w2)		_fpNum$ = num : \
					_fpNumWidth = w1 : \
					_fpFracWidth = w2 : \
					gosub _formatNum

#define	printDollar(num)		_dollarAmt = num : \
					gosub _printDollar

#include <proline/proline.h>

	gosub AppInit
	gosub Setup
	& int stop
	repeat
		gosub PlaceBet
		if not quit then
			gosub InitialDeal
			gosub PlayersTurn
			gosub DecideWinner
			gosub ResetPlayers
			& ioctl(ioGotoXY, 0, PLAYER_Y + 1)
			& ioctl(ioClearEOS)
		endif
	until quit
	gosub HighScore
	& ioctl(ioGotoXY, STAT_X, STAT_Y)
	print "After " handsPlayed " hand";
	if handsPlayed <> 1 then print "s";
	print " (" playerWins "-" ties "-" dealerWins "), " \
		"you have ";
	printDollar(playersBalance)
	print " (";
	j = playersBalance - playersOld
	printDollar(abs(j))
	if j < 0 then
		print " lost)"
	else
		print " won)"
	endif
	& int on
	if playersOld <> playersBalance then
		Launch("bank -qc " + str$(playersBalance) + \
			" -w -g " IDENT_PROG " -c " + str$(dealersBalance), \
			"", TRUE)
	endif
goto Exit

HighScore:
	' Format of high score file:
	'	Line 1:  count of players following
	'	Line 2:  first player entry...etc.

	& ioctl(ioGotoXY, PLAYER_X, PLAYER_Y)
	& ioctl(ioClearEOL)
	& ioctl(ioGotoXY, HS_X, HS_Y)
	print "  $ Winnings  Plr-Tie-Dlr   Recorded  Name"
	scoreFile$	= HIGH_SCORE_FILE
	dim entry$[HS_ENTRIES + 1]

	& getinfo scoreFile$, scoreInfo$
	if scoreInfo$ > "" then
		fOpen scoreFile$
		fRead scoreFile$
		input count
		for i = 1 to count
			& get entry$[i]
		next
		fClose
	else
		count = 0
	endif

	update% = FALSE
	j = playersBalance - playersOld
	if j > 0 then
		formatNum(str$(j), 9, 2)
		& right$(str$(playerWins), 3), a$
		& right$(str$(ties), 3), b$
		& right$(str$(dealerWins), 3), c$
		& time(i$)
		i$ = mid$(i$, 6, 9)
		& mid$(i$, 3) = "-"
		& mid$(i$, 7) = "-"
		entry$ = _fpNum$ + "  " + a$ + " " + b$ + " " + c$ + \
			+ "  " + i$ + "  " + \
			ID$[uName] + " (" + ID$[uFullName] + ")"	
		if count < HS_ENTRIES then
			count = count + 1
			entry$[count] = entry$
			update% = TRUE
		else
			for i = 1 to count
				if val(entry$) >= val(entry$[i]) then
					entry$[HS_ENTRIES] = Fame$[i]
					entry$[i] = entry$
					update% = TRUE
					i = count
				endif
			next
		endif
	endif
	if count then
		& sort(entry$, count)
		y = HS_Y + 2
		for i = count to 1 step -1
			& ioctl(ioGotoXY, HS_X, y)
			y = y + 1
			print entry$[i]
		next
		if update% then
			if scoreInfo$ > "" then fDelete scoreFile$
			fAppend scoreFile$
			print count
			for i = count to 1 step -1
				print entry$[i]
			next
			fClose
		endif
	endif	
return

Setup:
	& ioctl(ioGotoXY), i
	& ioctl(ioClearEOL), j
	if not i or not j then
		print argv$[0] ": requires terminal emulation"
		goto Exit
	endif

	& prevdir AppPath$, AppHome$
	GamesLib$	= AppHome$ + "/lib/"

	gosub GetDealersBalance
	gosub GetPlayersBalance
	
	dim	deck[TOTAL_CARDS], hand[PLAYER_SPLIT, MAX_HAND], \
		card$[MAX_DECK], cardval[MAX_DECK], xpos[PLAYER_SPLIT], \
		ypos[PLAYER_SPLIT]

	gosub ResetPlayers		
	gosub DrawTable
	gosub CreateDeck
	gosub ShuffleDeck

	quit		= FALSE
	handsPlayed	= 0
	ties		= 0
	playerWins	= 0
	dealerWins	= 0
return

GetDealersBalance:
	bankAccount$	= GAME_ACCT_FILE
	gosub GetAcctBalance
	if not balance then
		print "The " IDENT_PROG " dealer does not have any cash."
		print "You cannot play " IDENT_PROG " at this time."
		goto Exit
	endif
	dealersBalance = balance
return	

GetPlayersBalance:
	bankAccount$	= USER_ACCT_FILE
	gosub GetAcctBalance
	if balance < MIN_BET then
		print "You do not have enough cash to play " IDENT_PROG "."
		& read "Would you like to visit the bank? (Y/N) ", a$
		if a$ = "y" or a$ = "Y" then
			System("bank")
		endif
		goto Exit
	endif
	playersOld	= balance
	playersBalance	= balance
return

GetAcctBalance:
	& getinfo bankAccount$, i$
	if i$ > "" then
		fOpen bankAccount$
		fRead bankAccount$ ",F1"
		& get a$
		fClose
		balance = val(a$)
	else
		balance = 0
	endif
return

	
DecideWinner:
	gosub DealersTurn
	& ioctl(ioGotoXY, STAT_X, STAT_Y)
	if (playersBest < 22 and playersBest > dealersBest) or dealersBest > 21 then
		gosub CheckForBonus
		if bet > dealersBalance then bet = dealersBalance
		playersBalance = playersBalance + bet
		dealersBalance = dealersBalance - bet
		playerWins = playerWins + 1
	else
		if dealersBest = playersBest then
			print "It's a stand-off at " playersBest;
			ties = ties + 1
		else
			print dealersBest " to " playersBest ", dealer wins ";
			printDollar(bet)
			playersBalance = playersBalance - bet
			dealersBalance = dealersBalance + bet
			dealerWins = dealerWins + 1
		endif
	endif
	if playersBalance < MIN_BET then
		print ", and now you're low on cash";
		quit = TRUE
	endif
	if dealersBalance < 1 then
		print ", and the dealer is broke";
		quit = TRUE
	endif
	& get (1), " "
	handsPlayed = handsPlayed + 1
return


CheckForBonus:
	holding = hand[playersHand, 0]
	bonus$ = ""
	if isBlackJack then
		bet = bet * 1.5	
		bonus$ = "blackjack"
	else
		if holding = 6 then
			bet = bet * 3
			bonus$ = "six cards"
		endif
		if holding = 5 then
			bet = bet * 2
			bonus$ = "five cards"
		endif
		if holding = 3 then
			x[0] = 0
			& erase (x)
			dim x[3]
			for i = 1 to 3
				x[i] = cardval[hand[playersHand, i]]
			next
			& sort (x, 3)
			if x[1] = 7 and x[2] = 7 and x[3] = 7 then
				bet = bet * 3
				bonus$ = "three sevens"
			endif
			if x[1] = 6 and x[2] = 7 and x[3] = 8 then
				bet = bet * 2
				bonus$ = "6-7-8"
			endif
		endif
	endif
	print playersBest " to " dealersBest ", you win ";
	printDollar(bet)
	if bonus$ > "" then print " for " bonus$;
return


doHelp:
	& ioctl(ioClearScreen)
	& list GamesLib$ + "help/" IDENT_PROG ".help"
	& page
goto DrawTable


PlaceBet:
	& ioctl(ioGotoXY, STAT_X, STAT_Y)
	print "You have ";
	printDollar(playersBalance)
	if val(lastBet$) > playersBalance then lastBet$ = ""
	& read (-12, lastBet$), ".  Enter bet, <H>elp or <Q>uit: ", a$
	gosub clearStatus
	& lcase(a$)
	if a$ = "h" then
		gosub doHelp
		goto PlaceBet
	endif
	if a$ = "q" then
		quit = TRUE
	else
		bet = val(a$)
		if bet < MIN_BET or bet > playersBalance or bet > MAX_BET then
			&ioctl(ioBeep)
			goto PlaceBet
		endif
		lastBet$ = str$(bet)
	endif
return


DealersTurn:
	gosub DrawDealerHand
	gosub getBestTotal
	if playersBest < 22 then
		repeat
			if total < 17 then gosub doHit
			gosub getBestTotal
		until total > 16
	endif
	dealersBest = total
return

PlayersTurn:
	done = FALSE
	repeat
		thePlayer = PLAYER + (splitMode > 1)
		gosub getBestTotal
		gosub clearStatus
		if splitMode then
			if splitMode = 1 then
				print "First";
			else
				print "Second";
			endif
			print " hand has";
		else
			print "You're holding";
		endif
		print " " total ": ";
		if total < 21 then
			cmd$ = "hs?/"
			if holding = 2 then
				cmd$ = cmd$ + "d"
				print "<D>ouble, ";
				if not splitMode then
					i = cardval[hand[PLAYER, 1]]
					j = cardval[hand[PLAYER, 2]]
					if i = j and i <> 11 then
						cmd$ = cmd$ + "t"
						print "Spli<T>, ";
					endif
				endif
			endif	
			print "<H>it or <S>tand?  ^H";
			repeat
				get a$
				& lcase(a$)
				& pos (cmd$, a$), p
			until p
			print a$;
			on p gosub doHit, pStand, doHelp, doHelp, doDouble, doSplit
		else
			if total = 21 and holding = 2 then
				print "BLACKJACK!";
			else
				if total > 21 then print "bust.";
			endif
			if splitMode and total <> 21 then
				if splitMode < 2 then
					& get (1), "  Next hand "
				endif
			else
				& get(1), "  Dealer's turn "
			endif
			done = TRUE
		endif
	until done
	playersBest = total
	if splitMode and playersBest <> 21 then
		if splitMode = 1 then
			firstHand = playersBest
			splitMode = splitMode + 1
			doubleSave = doubleBet
			doubleBet = FALSE
			goto PlayersTurn
		else
			if (playersBest < firstHand and firstHand < 22) \
				or (playersBest > 21) then
				& swap (playersBest, firstHand)
				& swap (doubleBet, doubleSave)
			else
				playersHand = PLAYER_SPLIT
			endif
			if playersBest > 21 then
				print "  Both hands went over 21";
			else
				if total > 21 then print "  ";
				print "Best hand was " playersBest;
			endif
			& get (1), ".  Dealer's turn "
		endif
	endif
	if doubleBet then bet = bet * 2

clearStatus:
	& ioctl(ioGotoXY, STAT_X, STAT_Y)
	& ioctl(ioClearEOL)
return


doSplit:
	splitMode = 1
	hand[PLAYER, 0] = 1
	hand[PLAYER_SPLIT, 0] = 1
	hand[PLAYER_SPLIT, 1] = hand[PLAYER, 2]
	xpos[PLAYER] = 0
	xpos[DEALER] = DEALER_SPLIT_X
goto DrawTable
		

doDouble:
	if bet * 2 < playersBalance then
		gosub doHit
		done = TRUE
		doubleBet = TRUE
	else
		& ioctl(ioBeep)
	endif
return


doHit:
	if hand[thePlayer, 0] < MAX_HAND then
		gosub DrawTopCard
		holding = hand[thePlayer, 0] 
		x = xpos[thePlayer] + (holding - 1) * 3
		y = ypos[thePlayer] + holding
		gosub ShowCard
	else
		& ioctl(ioBeep)
	endif
	gosub getBestTotal
return

pStand:
	if splitMode = 2 then gosub clearStatus
	done = TRUE
return

getBestTotal:
	total = 0
	holding = hand[thePlayer, 0]
	if holding then
		aceCount = 0
		for i = 1 to holding
			q = cardval[hand[thePlayer, i]]
			total = total + q
			aceCount = aceCount + (q = 11)
		next
		while total > 21 and aceCount
			total = total - 10
			aceCount = aceCount - 1
		wend
	endif
return


ResetPlayers:
	hand[DEALER, 0] = 0
	hand[PLAYER, 0] = 0
	hand[PLAYER_SPLIT, 0] = 0
	xpos[DEALER] = DEALER_X
	xpos[PLAYER] = PLAYER_X
	ypos[DEALER] = DEALER_Y
	ypos[PLAYER] = PLAYER_Y
	xpos[PLAYER_SPLIT] = PLAYER_SPLIT_X
	ypos[PLAYER_SPLIT] = PLAYER_SPLIT_Y
	if splitMode then
		& ioctl(ioGotoXY, 0, PLAYER_Y)
		& ioctl(ioClearEOL)
		splitMode = 0
		gosub DrawNames
	endif
	playersHand = PLAYER
	doubleBet = FALSE
return
	
InitialDeal:
	for deal = 1 to 2
		for thePlayer = DEALER to PLAYER
			faceDown = (deal = 1) and (thePlayer = DEALER)
			gosub doHit
		next
	next
return

DrawTopCard:
	if deckIndex > TOTAL_CARDS then gosub ShuffleDeck
	theCard = deck[deckIndex]
	deckIndex = deckIndex + 1
	holding = hand[thePlayer, 0] + 1
	hand[thePlayer, 0] = holding
	hand[thePlayer, holding] = theCard
return

DrawNames:
	& ioctl(ioGotoXY, xpos[PLAYER], ypos[PLAYER])
	print ID$[uFullName]":";
	if splitMode then
		& ioctl(ioGotoXY, xpos[PLAYER_SPLIT], ypos[PLAYER_SPLIT])
		print "Second Hand:";
	endif
	& ioctl(ioGotoXY, xpos[DEALER], ypos[DEALER])
	print "Dealer:";
return

DrawTable:
	& ioctl(ioClearScreen)
	& hlin 79, 95
	print
	print
	print "		$$$  ProLine Professional Blackjack " IDENT_VERS "  $$$"
	& hlin 79, 95

	gosub DrawNames

	thePlayer = PLAYER
	gosub DrawHand
	if splitMode then
		thePlayer = PLAYER_SPLIT
		gosub DrawHand
	endif
	dontShowFirst = TRUE
DrawDealerHand:
	thePlayer = DEALER
	gosub DrawHand
	dontShowFirst = FALSE
return


DrawHand:
	holding = hand[thePlayer, 0]
	x = xpos[thePlayer]
	y = ypos[thePlayer] + 1
	if holding then
		for i = 1 to holding
			theCard = hand[thePlayer, i]
			faceDown = i = 1 and dontShowFirst
			gosub ShowCard
			x = x + 3
			y = y + 1
		next
	endif
return


CreateDeck:
	suits$   = "CDHS"
	data	"|    _    |","|    /\   |","|   _ _   |","|   /~\   |",\
		"|   ( )   |","|   <  >  |","|  ( ' )  |","|  (_,_)  |",\
		"|  (_,_)  |","|    \/   |","|   \./   |","|    ^~    |"

	dim suitRow$[4, 3]

	for y = 1 to 3
		for x = 1 to 4
			read suitRow$[x, y]
		next
	next

	& ioctl(ioGotoXY, STAT_X, STAT_Y)
	print "(C)opyright " YEAR " by Morgan Davis ";
	k = 1
	for i = 1 to MAX_DECK / 4
		i$ = mid$("? 2 3 4 5 6 7 8 910 J Q K A", i * 2, 2)
		p = val(mid$("? 2 3 4 5 6 7 8 91010101011", i * 2, 2))
		for j = 1 to 4
			card$[k] = i$ + mid$(suits$, j, 1)
			cardval[k] = p
			k = k + 1
		next
	next

	' Build shoe from packs of cards

	k = 1
	for i = 1 to DECKS_IN_USE
		for j = 1 to MAX_DECK
			deck[k] = j
			k = k + 1
		next
	next
goto clearStatus


ShuffleDeck:
	gosub clearStatus
	if alreadyShuffled% then
		print "Bottom of deck reached.  Reshuffling...";
	else
		print "Shuffling...";
		alreadyShuffled% = TRUE
	endif
	for i = 1 to 3
		for j = 1 to TOTAL_CARDS
			& swap(deck[j], deck[int(rnd(1) * TOTAL_CARDS) + 1])
		next
	next
	deckIndex = 1
	& ioctl(ioCR)
	& ioctl(ioClearEOL)
return

ShowCard:
	a$ =  "|         |"
	top$ = mid$(a$, 1)
	bot$ = mid$(a$, 1)
	i$ = left$(card$[theCard], 2)
	& mid$(bot$, 9) = i$
	& spc(i$), i$
	& mid$(top$, 2) = i$
	j$ = right$(card$[theCard], 1)
	& pos (suits$, j$), suitIndex
	& ioctl(ioGotoXY, x, y)
	if y = ypos[PLAYER] + 1 then
		print " _________";
	else
		print " ______|__";
	endif
	& ioctl(ioGotoXY, x, y + 1)
	print a$;
	if faceDown then
		for q = 1 to 5
			& ioctl(ioGotoXY, x, y + q + 1)
			print a$;
		next
		faceDown = FALSE
	else
		& ioctl(ioGotoXY, x, y + 2)
		print top$;
		for q = 1 to 3
			& ioctl(ioGotoXY, x, y + q + 2)
			print suitRow$[suitIndex, q];
		next
		& ioctl(ioGotoXY, x, y + 6)
		print bot$;
	endif
	& ioctl(ioGotoXY, x, y + 7)
	print "|_________|";
return

_formatNum:
	& pos (_fpNum$, "."), p
	if p then
		_fpFrac$ = mid$(_fpNum$, p + 1)
		if p > 1 then
			_fpNum$ = left$(_fpNum$, p - 1)
		else
			_fpNum$ = ""
		endif
	else
		_fpFrac$ = ""
	endif
	& right$(str$(val(_fpNum$)), _fpNumWidth), _fpNum$
	if _fpFracWidth then
		& left$(_fpFrac$, _fpFracWidth, 48), _fpFrac$
		_fpNum$ = _fpNum$ + "." + _fpFrac$
	endif
return

_printDollar:
	formatNum(str$(_dollarAmt), 9, 2)
	& spc(_fpNum$), _fpNum$
	print "$" _fpNum$;
return

#include <proline/proline.lib>

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
