' **********************************************************************
' **
' **	bank.b		ProLine gaming bank
' **			(C)opyright 1994 Morgan Davis Group
' **
' **  09nov93 mwd 1.0	Created to support new blackjack game (and others)
' **

#define	IDENT_PROG "bank"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "4mar94"
#define	IDENT_NAME "Morgan_Davis"

#define	SMALLEST_LOAN	25
#define	USER_ACCT_FILE	ADM_PATH + user$ + "/bank.account"
#define	GAME_ACCT_FILE	GamesLib$ + user$ + ".acct"
#define	TREASURY_FILE	GamesLib$ + "bank.data"
#define	MAX_MILLIONS	999999999.99


	' Format of bank.data file

#define	lineCount	0
#define	treasuryBalance	1
#define	inCirculation	2
#define	lendingRate	3
#define	loanHours	4
#define	penaltyRate1	5
#define	penaltyRate2	6
#define	penaltyRate3	7
#define	newAcctBalance	8
#define	savingsRate	9
#define	transferMax	10
#define	transferHours	11

#define	DATA_FIELDS	transferHours

#define	initialLendingRate	.08
#define	cashForNewAcct		100

	' Format of bank.account file

'define	lineCount	0
#define	cashOnHand	1
#define	savingsBalance	2
#define	loanBalance	3
#define	owner		4
#define	acctOpenDate	5
#define	statementDate	6
#define	loanDate	7
#define	paymentDate	8
#define	payment		9
#define	largestLoan	10
#define	loansTaken	11
#define	loansRepaid	12
#define	transferDate	13
#define	transferBalance	14

#define	ACCT_FIELDS	transferBalance

#define	formatNum(num, w1, w2)		_fpNum$ = num : \
					_fpNumWidth = w1 : \
					_fpFracWidth = w2 : \
					gosub _formatNum

#define	formatPrint(title, num, w1, w2)	formatNum(num, w1, w2) : \
					print title _fpNum$;

#define	round(n,w,v)			_rn = n : _rw = w : gosub _round : \
					v = _rn

#define	MAIN_MENU	0
#define	LOAN_MENU	1
					
#include <proline/proline.h>

	gosub AppInit

	user$	  	= ID$[uName]
	bankAccount$	= USER_ACCT_FILE
	& prevdir AppPath$, AppHome$
	GamesLib$	= AppHome$ + "/lib/"
	
	interact% = argc = 1

	& int stop	
	options$ = "?ac:g:isu:qw"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage% = TRUE
		if optchar$ = "a" then gosub addCash
		if optchar$ = "c" then gosub changeCash
		if optchar$ = "g" then gosub setGameUser
		if optchar$ = "i" then interact% = TRUE
		if optchar$ = "s" then gosub subtractCash
		if optchar$ = "u" then gosub setUser
		if optchar$ = "q" then quietMode% = TRUE
		if optchar$ = "w" then gosub reportNetWorth
	until optchar$ = ""
	& int on

	if showUsage% then
		print "Usage: "argv$[0] " [ options ]"
	else
		if interact% then
			gosub GetAcctInfo
			gosub Interactive
		endif
	endif
	gosub UpdateAccount
goto Exit

header:
	& ioctl(ioClearScreen)
	a$ = SysInfo$[plNode] + " branch office"
	print spc(22) "P r o L i n e   U s e r s   B a n k"
	print spc(40 - len(a$) / 2) a$
	& hlin 79, 95 : print
	gosub calcNetWorth
	print
	print   "Account:            " user$ \
		"			Opened: " \
		mid$(acct$[acctOpenDate], 6, 9)
	& hlin 79, 95 : print
	print
	formatPrint("Cash on hand:       $", acct$[cashOnHand], 9, 2)		: print
	formatPrint("Savings balance:    $", acct$[savingsBalance], 9, 2)	: print
	round(val(acct$[loanBalance]), 2, i)
	if menu = LOAN_MENU or i then
		formatPrint("Loan balance due:   $", str$(i), 9, 2)		: print
	endif
	if menu = LOAN_MENU then
		if i then
			formatPrint("Last payment:       $", acct$[payment], 9, 2)	: print
			print "Last payment date:  " acct$[paymentDate]
		endif
	else
		formatPrint("Current net worth:  $", str$(netWorth), 9, 2)		: print
	endif
	& hlin 79, 95 : print
	print
return

Interactive:
	menu = MAIN_MENU
	gosub header
	if firstTime then
		print "		*** Welcome!  Your account has been opened! *** "
		& hlin 79, 95 : print
		firstTime = FALSE
		print
	endif
	print  "<W>ithdraw, <D>eposit, <T>ransfer, <L>oan menu, <H>elp or <Q>uit: ";
	repeat
		get a$
		& lcase(a$)
		& pos("wdtlhq", a$), p
	until p
	print a$
	print
	on p gosub doWithdraw, doDeposit, doTransfer, doLoanMenu, doHelp, doQuit
goto Interactive

doLoanMenu:
	menu = LOAN_MENU
	gosub header
	print  "<N>ew loan, <M>ake payment, <H>elp or <Q>uit to main menu: ";
	repeat
		get a$
		& lcase(a$)
		& pos("nmhq", a$), p
	until p
	print a$
	print
	on p gosub doNewLoan, doMakePayment, doHelp, doQuit
goto doLoanMenu


doHelp:
	& page clear
	& ioctl(ioClearScreen)
	& list GamesLib$ + "help/" IDENT_PROG ".help"
	& page
return

doQuit:
	pop
return

doWithdraw:
	round(val(acct$[savingsBalance]), 2, balance)
	if not balance then
		& get (1), "Nothing in savings.  Press a key "
		return
	endif
	& read "Enter amount to withdraw: $", a$
	if a$ > "" then
		amount = val(a$)
		if amount < 0 or amount > balance then
			& get (1), "Invalid amount.  Press a key "
		else
			round(balance - amount, 2, j)
			acct$[savingsBalance] = str$(j)
			gosub addCashAmount
			update = TRUE
		endif
	endif
return
		
doDeposit:
	round(val(acct$[cashOnHand]), 2, balance)
	if not balance then
		& get (1), "No cash on hand.  Press a key "
		return
	endif
	& read "Enter amount to deposit: $", a$
	if a$ > "" then
		amount = val(a$)
		if amount < 0 or amount > balance then
			& get (1), "Invalid amount.  Press a key "
		else
			gosub subCashAmount
			round(val(acct$[savingsBalance]) + amount, 2, j)
			acct$[savingsBalance] = str$(j)
			update = TRUE
		endif
	endif
return
		
doTransfer:
	& get (1), "Transfers not available yet.  Press a key "
return

doNewLoan:
	if SuperUser then
		print "<N>ormal loan evaluation, or <O>verride limits? ";
		repeat
			get a$
			& lcase(a$)
		until a$ = "n" or a$ = "o"
		print a$
		if a$ = "n" then
			gosub calcLoanLimits
		else
			& read "Enter desired interest rate: %", a$
			interestRate = val(a$) / 100
			amount = MAX_MILLIONS
		endif
	else
		gosub calcLoanLimits
	endif

	& read "Enter the desired loan amount: $", a$
	if a$ > "" then
		i = val(a$)
		if i < 0 or i > amount then
			& ioctl(ioBeep)
			return
		endif
		round(i, 2, amount)
		round(amount + amount * interestRate, 2, j)
		formatNum(str$(amount), 9, 2)
		& spc(_fpNum$), i$
		formatNum(str$(j), 9, 2)
		& spc(_fpNum$), _fpNum$
		print "You receive $" i$ " in cash, securing a loan plus interest for $" _fpNum$ "."
		print "Please make regular payments to decrease your debt."
		gosub addCashAmount
		acct$[loanBalance] = str$(balance + j)
		if amount > largest then acct$[largestLoan] = str$(amount)
		&time(acct$[loanDate])
		acct$[loansTaken] = str$(taken + 1)
		update = TRUE
	endif
return


calcLoanLimits:
	interestRate = initialLendingRate
	if acct$[loanDate] = "" then
		amount = SMALLEST_LOAN
		balance = 0
		largest = 0
		taken = 0
		interestRate = interestRate + .05
		print "No credit history.  Minimal financing available."
	else
		gosub calcNetWorth
		balance = val(acct$[loanBalance])
		largest = val(acct$[largestLoan])
		taken = val(acct$[loansTaken])
		defaults = taken - val(acct$[loansRepaid])
		if balance then
			print "You have an unpaid loan balance.  " \
				"Accepting a new loan is bad for your credit."
			interestRate = interestRate + .05
		endif
		if defaults and not balance or defaults > 1 then
			print "You have defaulted on " defaults " loan(s) in the past."
			interestRate = interestRate + .10
		endif
		if netWorth < 0 then
			print "You have a negative net worth."
			interestRate = interestRate + .05
			amount = SMALLEST_LOAN
		else
			amount = netWorth
			if defaults = 0 then amount = amount + largest / 2
			if amount < SMALLEST_LOAN then amount = SMALLEST_LOAN
		endif
	endif

	round(amount, 2, amount)
	formatNum(str$(amount), 9, 2)
	& spc(_fpNum$), i$
	formatNum(str$(interestRate * 100), 3, 1)
	& spc(_fpNum$), _fpNum$
	print "The largest loan amount you qualify for is $" i$ " at " _fpNum$ "%"
	print
return


addCashAmount:
	acct$[cashOnHand] = str$(val(acct$[cashOnHand]) + amount)		
return

subCashAmount:
	acct$[cashOnHand] = str$(val(acct$[cashOnHand]) - amount)		
return

doMakePayment:
	round(val(acct$[loanBalance]), 2, balance)
	if not balance then
		& get (1), "No loan to pay.  Press a key "
		return
	endif
	print "Make payment from <C>ash or <S>avings? ";
	repeat
		get a$
		& lcase(a$)
		& pos("cs", a$), p
	until p
	print a$
	if p = 1 then
		p = cashOnHand
	else
		p = savingsBalance
	endif
	& read "Enter amount you wish to pay: $", a$
	if a$ > "" then
		round(val(a$), 2, amount)
		round(val(acct$[p]), 2, j)
		if amount > balance or amount < 0 or amount > j then
			& get (1), "Invalid amount.  Press a key "
		else
			acct$[payment] = str$(amount)
			acct$[p] = str$(j - amount)
			balance = balance - amount
			acct$[loanBalance] = str$(balance)
			if not balance then
				acct$[loansRepaid] = str$(val(acct$[loansRepaid]) + 1)
			endif
			&time(acct$[paymentDate])
			update = TRUE
		endif
	endif
return

_round:
	_rn = abs(_rn)		' Fix negative amounts
	_rn = int(_rn) + \
		int((_rn - int(_rn) + (5 / 10 ^ (_rw + 1))) * 10 ^ _rw) \
		/ 10 ^ _rw
return

_formatNum:
	& pos (_fpNum$, "."), p
	if p then
		_fpFrac$ = mid$(_fpNum$, p + 1)
		if p > 1 then
			_fpNum$ = left$(_fpNum$, p - 1)
		else
			_fpNum$ = ""
		endif
	else
		_fpFrac$ = ""
	endif
	& right$(str$(val(_fpNum$)), _fpNumWidth), _fpNum$
	if _fpFracWidth then
		& left$(_fpFrac$, _fpFracWidth, 48), _fpFrac$
		_fpNum$ = _fpNum$ + "." + _fpFrac$
	endif
return

GetAcctInfo:
	if not hasInfo then
		acct$[0] = ""
		& erase(acct$)
		dim acct$[ACCT_FIELDS]
		& getinfo bankAccount$, i$
		if i$ > "" then
			fOpen bankAccount$
			fRead bankAccount$
			& get a$
			for i = 1 to val(a$)
				& get acct$[i]
			next
			fClose bankAccount$
			update = FALSE
		else
			firstTime = TRUE
			acct$[owner] = user$
			&time(acct$[acctOpenDate])
			amount = cashForNewAcct
			gosub addCashAmount
			update = TRUE
		endif
		hasInfo = TRUE
	endif
return

validateSUOption:
	if not SuperUser then
		print argv$[0] ": permission denied"
		goto ExitError
	endif
return

addCash:
	gosub validateSUOption
	gosub GetAcctInfo
	amount = val(optarg$)
	gosub addCashAmount
goto cashUpdate

subtractCash:
	gosub validateSUOption
	gosub GetAcctInfo
	amount = val(optarg$)
	gosub subCashAmount
goto cashUpdate

changeCash:
	gosub validateSUOption
	gosub GetAcctInfo
	acct$[cashOnHand] = optarg$
cashUpdate:
	update = TRUE
	formatNum(acct$[cashOnHand], 9, 2)
	& spc(_fpNum$), _fpNum$
	if not quietMode% then
		print argv$[0] ": " user$ " has $" _fpNum$ " in cash"
	endif
return

newuser:
	gosub UpdateAccount
	gosub validateSUOption
	user$ = optarg$
	hasInfo = FALSE
	if not quietMode% then
		print argv$[0] ": current account set to " user$
	endif
return

setUser:
	gosub newuser
	bankAccount$ = USER_ACCT_FILE
return

setGameUser:
	gosub newuser
	bankAccount$ = GAME_ACCT_FILE
return

calcNetWorth:
	netWorth =	val(acct$[cashOnHand]) + \
			val(acct$[savingsBalance]) - \
			val(acct$[loanBalance])
return

reportNetWorth:
	gosub GetAcctInfo
	gosub calcNetWorth
	formatNum(str$(netWorth), 9, 2)
	& spc(_fpNum$), _fpNum$
	if not quietMode% then
		print argv$[0] ": " user$ " has a net worth of $" _fpNum$
	endif
return

UpdateAccount:
	if update then
		& getinfo bankAccount$, i$
		if i$ > "" then fDelete bankAccount$
		fAppend bankAccount$
		print ACCT_FIELDS
		for i = 1 to ACCT_FIELDS
			print acct$[i]
		next
		fClose bankAccount$
		update = FALSE
	endif
return
	
#include <proline/proline.lib>
#include <proline/getopt.lib>
