' ************************************************************************
' **									**
' **  unmount.b 	Unmount a device from the filesystem		**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 26may91 mwd 1.0	Created.					**
' **									**
' ************************************************************************

#define	IDENT_PROG "unmount"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "26may91"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	NODEV	$BF20

#define	DRV1LST	$BF10
#define	DRV2LST	$BF20

#define	DBFILE	RSRC_PATH + "mount.rsrc"

' ====================
' UnMount
' ====================

	gosub AppInit
	if not SuperUser then
		print argv$[0] ": cannot execute"
		goto Exit
	endif

	if argc < 2 then
		print "Usage: " argv$[0] " device..."
		goto Exit
	endif

	deviceDB$ = DBFILE
	
	currentDevice = peek(_DEVNUM)

	& getinfo SysInfo$[plTempDir], i$
	tempDevice = peek(_DEVNUM)

	& getinfo deviceDB$, i$
	prolineDevice = peek(_DEVNUM)

	if i$ > "" then
		fOpen deviceDB$
		fRead deviceDB$
		for i = 1 to 7
			& get volnam$[i]
			& get dentry$[i]
		next
		fClose
		updateRsrc = FALSE
	else
		for i = 1 to 7
			volnam$[i] = ","
			dentry$[i] = "000,00000,000,00000"
		next
		updateRsrc = TRUE
	endif		

	noDevAddr = peek16(NODEV)
	for optind = 1 to argc - 1
		a$ = argv$[optind]
		gosub unmount
	next

	if updateRsrc then
		fOpen deviceDB$
		fWrite deviceDB$
		for i = 1 to 7
			print volnam$[i]
			print dentry$[i]
		next
		fFlush deviceDB$
		poke _SREFNUM, peek(_OREFNUM)
		& MLI (_GET_MARK, _SGETMRK), errCode
		& MLI (_SET_EOF, _SSETEOF), errCode
		fClose deviceDB$
	endif
goto Exit

unmount:
	if left$(a$,1) = "/" then
		& pos (2,a$,"/"),p
		if p then a$ = left$(a$,p - 1)
		& getinfo a$ + "/foo", i$
		if ERR = 6 then
			print argv$[0]": " a$ " not online"
			return
		endif
		i = peek(_DEVNUM)
		if i > 128 then
			drive = 2
			i = i - 128
		else
			drive = 1
		endif
		slot = i / 16
	else
		slot = val(left$(a$,1))
		drive = 0
		if len(a$) > 1 then drive = val(right$(a$,1))
	endif

	if slot < 1 or slot > 7 then
		print argv$[0] ": invalid slot #" slot
		return
	endif

	if drive > 2 then
		print argv$[0] ": invalid drive #" drive
		return
	endif

	if not drive then
		drive = 1
		gosub rmunit
		drive = 2
	endif
	gosub rmunit
return

rmunit:
	gosub getDevInfo
	if unit = currentDevice or \
		unit = prolineDevice or \
		unit = tempDevice then
		print argv$[0]": cannot unmount active device " \
			slot "." drive
		return
	endif
	if devbyte > 0 then
		fClose
		i$ = mid$(dentry$[slot],1)
		j$ = volnam$[slot]
		&pos (j$, ","), p
		if drive = 2 then
			j = 11
			j$ = left$(j$, p) + volName$
		else
			j = 1
			j$ = volName$ + mid$(j$, p)
		endif
		& mid$(i$, j) = devInfo$
		dentry$[slot] = i$
		volnam$[slot] = j$
		updateRsrc = TRUE
		if dindex < devices then
			for j = dindex + 1 to devices
				poke (j + _DEVLST - 1), peek(j + _DEVLST)
			next
		endif
		devices = devices - 1
		poke _DEVCNT, devices
		poke _DEVNUM, prolineDevice
		poke16(tblAddr, noDevAddr)
		print argv$[0] ": "volName$ " ("slot "." drive ") unmounted"
	else
		print argv$[0] ": no volume mounted on " slot "." drive
	endif
return

getDevInfo:
	unit = slot * 16 + (128 * (drive = 2))
	devices = peek(_DEVCNT)
	devbyte = -1
	for j = 0 to devices
		i = peek(_DEVLST + j)
		& poke $300,$A9,i,$29,$F0,$85,$00,$60
		call $300
		devnum = peek(0)
		if unit = devnum then
			devbyte = i
			devindex = j
			dindex = j
		endif
	next	
	if drive = 2 then
		i = DRV2LST
	else
		i = DRV1LST
	endif
	tblAddr = i + slot * 2
	devaddr = peek16(tblAddr)
	& right$ (str$(devbyte),3,48), i$
	& right$ (str$(devaddr),5,48), a$
	devInfo$ = i$ + "," + a$
	& poke _SUNITNUM, unit, $80, $02
	& MLI (_ONLINE, _SONLINE), errCode
	volName$ = "?"
	if not errCode then
		volName$ = "/"
		& poke $300,$A9,peek($280),$29,$0F,$85,$00,$60
		call $300
		for v = 1 to peek(0)
			volName$ = volName$ + chr$(peek($280 + v))
		next
		& lcase (volName$)
	endif
return

#include <proline/proline.lib>
