' ************************************************************************
' **									**
' **  startup.b 	ProLine Startup					**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 19sep90 mwd 1.6	Converted to MD-BASIC.				**
' ** 22oct90 mwd	Optional UNIXNAMES feature added		**
' ** 06nov90 mwd 1.7	Ramlist resource supported.			**
' ** 18jan91 mwd	Adds support for new printer config variable    **
' ** 14aug91 mwd 1.8	Changed logo and copyright notice.		**
' **			Added support for $/etc/rc script.		**
' ** 18feb92 mwd 2.0    wow!  2.0?					**
' ** 17jul92		Official 2.0 Release				**
' ** 02nov93 mwd 3.0	3.0 Release					**
' **									**
' ************************************************************************

#define	IDENT_PROG "startup"
#define	IDENT_VERS "3.0b4"		' ProLine System Version
#define	IDENT_DATE "26feb94"
#define	IDENT_NAME "Morgan_Davis"

#include <appleio.h>
#include <basic.h>
#include <ctype.h>
#include <romcall.h>
#include <proline/proline.h>

#define	APPATH		$280	' Pascal string holding last used pathname
#define	ASM_STUFF	$300	' Temp area for misc work (about 200 bytes)
#define	STACKINIT	$D683	' Applesoft stack initializer

#define	OMM_LOADER	"sys/OMM.Loader"
#define	MODULES		"sys/modules/"
#define	RC_FILE		"etc/rc"
#define	SHELL		"csh"

#define	MAX_MODULES	24

#define	IVERSION	$BFFD	' ProDOS loaded interpreter version (BI)
#define	MIN_BI_VER	3	' At least BASIC.System 1.3 or newer

#define	APPLE_ERR	234	' Error: Type of Apple not compatible
#define	BIVER_ERR	235	' Error: old BI loaded
#define QUIT_ERR	236	' Error: just quit without error message
#define CONFIG_ERR	237	' Error: Bad or no configuration
#define	DIR_ERR		238	' Error: Can't create directory
#define	LAST_ERR	238


data	"REQUIRES APPLE IIE OR NEWER"
data	"Old (buggy) BASIC.System"
data	"Cancelled"
data	"Improperly Configured"
data	"Can't Create Directory:"


' ****************************************
' **
' ** main
' **

	text : normal : speed 255 : home
	onerr goto begin
	poke _INBUF,0			' Fixes ampersand/BI bug
	& load notrace			' Be quiet about it...
	& load fre			' Remove anything and everything
begin:
	call STACKINIT			' Initialize stack after error
	onerr goto HandleError

	if peek(-1101) <> 6 then	' Toss out Apple II+
		error(APPLE_ERR)
	endif
	
	if peek(IVERSION) < MIN_BI_VER then 
		error(BIVER_ERR)
	endif

	gosub SetUpEnv		' set up the environment first
	gosub GetConfig		' get system configuration variables
	gosub InitModem		' Initialize communications devices
goto DoLaunch			' Launch next application

	
' ****************************************
' **
' ** SetUpEnv
' **
' ** Find out where we are, and
' ** get the whole environment set up.
' **

SetUpEnv:
	Ver$ = IDENT_VERS
	l = peek (APPATH)				' Get length byte
	a$ = ""
	pfx$ = ""
	if l and (l < 65) then				' If valid...
		for i = APPATH + 1 to APPATH + 1 + l
			a$ = a$ + chr$ (peek(i))	' ...build path
		next
		i = l
		repeat					' search back for /
			i = i - 1
			if i then
				if mid$(a$,i,1) = "/" then
					pfx$ = mid$(a$,1, i)
				endif
			endif
		until (not i) or pfx$ > ""
	endif

	if pfx$ = "" then	' Couldn't peek out a prefix
		fPrefix		' ...so ask the OS for the current one
		input pfx$
	endif
	fPrefix pfx$		' Then set it

	fOutPort 3		' Begin in 80 columns	
	print "ProLine Version " Ver$
	print "(C)opyright 1984-1994"
	print "By Morgan Davis Group"
	print "World Rights Reserved"
	print
	print "Loading modules . . ."
	print
	inverse
	print ommTableHeader
	normal

	fLaunch OMM_LOADER			' Get the loader first
	& load get MODULES "AmperWorks"		' ...then AmperWorks
	& lcase(pfx$)
	&poke ASM_STUFF, $38, $20, $1F, $FE, $66, $00, $60
	call ASM_STUFF
	IIGS = peek($00) < $80
return


' ==============================
  GetConfig:
' ==============================
	ConfigFile$	= "etc/rsrc/startup.rsrc"
	dim module$[MAX_MODULES]

	fOpen ConfigFile$
	fRead ConfigFile$
	onerr goto configEOF

	input moduleCount%
	for i = 1 to moduleCount%
		& get module$[i]
	next

	& get modemcapFile$
	input modemSlot%
	input modemSpeaker%
	& get printerModule$
	input printerSlot%

	SysInfo$[plDir] = pfx$
	& get SysInfo$[plNode]
	& get SysInfo$[plDomain]
	& get SysInfo$[plAdmin]
	& get SysInfo$[plAdminFull]
	& get SysInfo$[plZone]
	& get SysInfo$[plTempDir]
	& get SysInfo$[plSpoolDir]
	error(0)	
	
	configEOF:
	& onerr e,l
	onerr goto HandleError
	fClose
	if e then
		error(CONFIG_ERR)
	endif

	SysInfo$[plModulesDir] = SYS_PATH + "modules"


	for i = 1 to moduleCount%
		a$ = module$[i]
		& pos (a$, "|"), p		' check for "GS" separator
		if p then
			a$ = left$(a$, p - 1)
			& lcase(a$)
			if IIGS then
				if left$(a$, 6) = "serial" then
					& poke $300, $AD, $2D, $C0, $29, 2 ^ modemSlot%, $85, $00, $60
					call $300
					if not peek(0) then a$ = a$ + "GS"
				else
					a$ = a$ + "GS"
				endif
			endif
		endif
		& load get MODULES + a$
	next
	& load notrace
	
	if SysInfo$[plDomain] > "" then
		if asc(SysInfo$[plDomain]) <> $2e then
			SysInfo$[plDomain] = "." + SysInfo$[plDomain]
		endif
	endif
	
	i = plTempDir		: gosub MakePath
	i = plSpoolDir		: gosub MakePath
	i = plModulesDir	: gosub MakePath

	a$ = ADM_PATH		: gosub CreateDir
	a$ = MDSS_PATH		: gosub CreateDir
	a$ = MAIL_PATH		: gosub CreateDir
	a$ = NEWS_PATH		: gosub CreateDir
	a$ = MAPS_PATH		: gosub CreateDir
	a$ = USR_PATH		: gosub CreateDir
	a$ = SPOOL_MAIL_PATH	: gosub CreateDir
	a$ = SPOOL_NEWS_PATH	: gosub CreateDir
	a$ = SPOOL_LOGS_PATH	: gosub CreateDir

	& store SysInfo$[plDir] + ":" \
		+ SysInfo$[plNode] + ":" \
		+ SysInfo$[plAdmin] + ":" \
		+ SysInfo$[plZone] + ":" \
		+ SysInfo$[plTempDir] + ":"\
		+ SysInfo$[plAdminFull] + ":" \
		+ SysInfo$[plSpoolDir] + ":" \
		+ Ver$ + ":" \
		+ SysInfo$[plDomain] + ":" \
		+ SysInfo$[plModulesDir] \
	to SysInfo_Cell
return


' ==============================
' Init Modem
' ==============================

InitModem:
	fBload "sys/modemcaps/" modemcapFile$ ",T0,A" ASM_STUFF
	& mset (ASM_STUFF)
	print
	repeat
		print "Initializing " modemcapFile$ \
			" in slot " modemSlot% " . . . ";
		& slot(modemSlot%, printerSlot%),ok
'		& speed modemSpeed%
		if ok then
			print "OK"
			& usr modemSpeaker%
		else
			print "failed!"
			retry = retry + 1
		endif
	until ok or retry > 1

	if not ok then
		print "(A)bort, (I)gnore, or (R)etry? <";
		inverse : print " "; : normal
		print ">^H^H";
		key = 0
		k = 1
		repeat
			& beep(24,15) : & beep
			& beep(20,20) : & beep
			& beep(15,50) : & beep
			& time(a$)
			repeat
				& time(i$)
				key = peek(_KBD)
			until a$ <> i$ or key > 127
			k = k + 1
		until key > 127 or k = 30
		& beep(stdBeepDur, stdBeepPitch)
		poke _KBDSTRB, 0
		if key < 128 then 
			a$ = "R"
		else
			a$ = chr$ (key - 128)
			& clear 
			& ucase(a$)
			& pos ("AIR",a$),i
			if not i then a$ = "A"
		endif
		print a$
		if a$ = "A" then
			error(QUIT_ERR)
		endif
		if a$ = "R" then
			& hangup
			goto InitModem
		endif
	endif
return

		
' ==============================
' Launch Next App
' ==============================

DoLaunch:
	if SysInfo$[plAdmin] > "" then 
		& time(a$)
		j$ = a$
		& lcase(a$)
		fAppend SPOOL_LOGS_PATH "syslog"
		i$ = mid$ (a$,16,2) + mid$ (a$,19,2)
		print mid$ (a$,6,2) mid$ (a$,9,3) mid$ (a$,13,3) \
			"-----  cron " i$ "-" i$ "=0000 !UPTIME: " j$
		fClose
	endif

	& scrn(_80Columns)
	& list ETC_PATH + "notices/notice"
	
	& getinfo SysInfo$[plTempDir] + "utmp", i$
	if i$ > "" then fDelete SysInfo$[plTempDir] + "utmp"

	ReturnPath$ = LOGIN_PATH
	& getinfo RC_FILE, i$
	if i$ > "" then
		i$ = SysInfo$[plAdmin] + ":0:0:" + SysInfo$[plAdminFull] + \
			SysInfo$[plDir] + "usr/" + SysInfo$[plAdmin] + ":ed"
		& store i$ to UserID_Cell
		SuperUser = TRUE
		CommandLine$ = SHELL " source $/" RC_FILE
		goto _Launch
	endif

fLaunch ReturnPath$

	
' ==============================
  FixPath:
' ==============================
	if right$ (a$,1) <> "/" then a$ = a$ + "/"
	if asc (a$) <> 47 then a$ = pfx$ + a$
return 

' ==============================
  MakePath:
' ==============================
	a$ = SysInfo$[i]
	gosub FixPath
	SysInfo$[i] = a$
CreateDir:
	onerr goto dirError
	fCreate a$
	onerr goto HandleError
	return

dirError:
	& onerr e, l
	onerr goto HandleError
	if e = 19 then return		' Directory exists, not an error
	e = DIR_ERR
goto PrintError

	
' ==============================
' Error Handler
' ==============================

HandleError:
	e = ERR
	l = ERL

PrintError:
	poke _ERRFLG,0
	call _BELL
	normal 
	fOutPort 0
	fInPort 0
	print chr$(cKill80)
	text 
	home 
	vtab 12

	print " * * *  PROLINE STARTUP FAILURE  * * *"
	print 
	print 
	if e >= APPLE_ERR and e <= LAST_ERR then
		restore
		for i = 0 to e - APPLE_ERR
			read i$
		next
		htab 21 - (len(i$) / 2)
		print i$
		if right$(i$, 1) = ":" then
			print
			htab 20 - (len(a$) / 2)
			print a$
		endif
	else
		print "    UNEXPECTED ERROR #" e " IN LINE " l
	endif
	vtab 23
end 

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>

