' ************************************************************************
' **
' **  rmuser.b		Remove user accounts from the system
' **			(C)opyright 1993 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 25sep90 mwd 2.0	Converted old rmuser to MD-BASIC.
' ** 11mar93 mwd 2.1.1	Updated to use *_PATH defines.
' ** 16jan94 mwd 3.0	Allows file list to include # comments
' **
' ************************************************************************

#define	IDENT_PROG "rmuser"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

	' ====================
	' Constants
	' ====================

#define	MAX_FILES	24
#define	MAX_USERS	500


' ****************************************
' **
' ** main
' **
' **
	gosub AppInit
	gosub Setup
	gosub FixPasswdFile
	gosub RemoveUsers
	if pagingState then & page on
goto Exit


' ** Initialize the application and environment.
' ** Exit if not invoked with SuperUser status.

Setup:
	if not SuperUser then
		print argv$[0] ": cannot execute"
		goto Exit
	endif

	options$ = "?pf:"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "p" then progress = TRUE
		if optchar$ = "f" then FileList$ = optarg$
	until optchar$ = ""
	
	if showUsage or (nargc < 2 and FileList$ = "") then
		print "Usage: "argv$[0]" [-p] [-f file] [user...]"
		goto Exit
	endif

	PasswdFile$	= ETC_PATH + "passwd"
	PwTemp$		= PasswdFile$ + ".tmp"

	dim nf$[MAX_FILES], user$[MAX_USERS]

	users = 0
	if FileList$ > "" then
		f$ = FileList$
		& GETINFO f$,i$
		if i$ = "" then 
			print f$": not found"
			goto Exit
		endif

		fOpen f$
		fRead f$
		onerr goto flEOF
		if progress then & print argv$[0]": reading " f$	
		do
			& get a$
			& spc(a$),a$
			& pos (a$, "#"), p
			if p then a$ = mid$(a$, 1, p - 1)
			if a$ > "" then
				& lcase(a$)
				& pos (a$," "),p
				if p then a$ = left$ (a$,p - 1)
				user$[users+1] = a$
				users = users + 1
			endif
		loop
	
		flEOF:
		&onerr
		onerr goto HandleError
		fClose

		if not users then 
			print argv$[0]": nothing read from '" f$ "'"
			goto Exit
		endif
	else
		for i = 1 to nargc - 1
			user$[i] = nargv$[i]
		next
		users = i - 1
	endif
	if progress then & print argv$[0]": " users " user(s) to remove"
	& page def pagingState
	& page stop
return


FixPasswdFile:
	k$ = PwTemp$
	gosub KillFile

	fOpen PasswdFile$
	fOpen PwTemp$
	onerr goto pwEOF
	if progress then & print argv$[0]": rewriting " PasswdFile$
	do
		fRead PasswdFile$
		& get b$
		a$ = b$
		& pos (a$,":"),p
		if p then 
			a$ = left$ (a$,p - 1)
			& lcase(a$)
		endif
		ok = b$ > ""
		for j = 1 to users
			if user$[j] = a$ then 
				ok = FALSE
				j = users
				RemovedPWEntry = TRUE
				if progress then & print argv$[0]": skipping " a$
			endif
		next 
		if ok then 
			fWrite PwTemp$
			print b$
		endif
	loop

	pwEOF:
	&onerr
	fClose
	onerr goto HandleError

	if RemovedPWEntry then 
		if progress then & print argv$[0]": deleting " PasswdFile$
		fDelete PasswdFile$
		if progress then & print argv$[0]": " PwTemp$ " -> " PasswdFile$
		fRename PwTemp$ "," PasswdFile$
	else
		fDelete PwTemp$
	endif
return


RemoveUsers:
	for x = 1 to users
		n$ = user$[x]
		if progress then
			& print argv$[0]": removing files for " n$
		else
			print "Removing " n$ " ";
		endif
		k$ = MAIL_PATH + n$	: gosub KillFile
		f$ = USR_PATH + n$	: gosub KillDirectory
		f$ = ADM_PATH + n$	: gosub KillDirectory
		if not progress then print 
	next
return


KillFile:
	onerr goto kfErr
	killed = FALSE
	fDelete k$
	killed = TRUE
	kfErr:
	onerr goto HandleError
	if not killed then &onerr
	if progress and killed then
		& lcase(k$)
		& print argv$[0]": deleted " k$
	endif
return 


KillDirectory:
	& GETINFO f$, i$
	if i$ = "" then return
	if progress then & print argv$[0]": rmdir " f$
nextDir:
	i$ = f$
rmDir:	
	& files (i$, nf$, , VIS_AND_INVIS), nf, actualFiles
	if not nf then
		on i$ <> f$ goto nextDir
		fUnlock f$
		fDelete f$
		return 
	endif

	i = 1
	repeat
		k$ = i$ + "/" + nf$[i]
		gosub KillFile
		if not killed then
			& GETINFO k$, j$
			if asc(mid$(j$, 4)) < 128 then
				fUnlock k$
				gosub KillFile
			endif
			if not killed then
				if asc (mid$ (j$,5)) = 15 then
					i$ = k$
					goto rmDir
				else
					print argv$[0]": can't delete " k$
					goto Exit
				endif
			endif
		endif
		i = i + 1
	until i > nf
	if nf < actualFiles then goto rmDir
goto nextDir

#include <proline/proline.lib>
#include <proline/getopt.lib>
