' ======================================================================
' 
'	ned.b	Newsys editor for ProLine
'		(C)opyright 1994 Morgan Davis
' 
' History:
'
' 20-Sep-92 mwd 1.0	Creation
' 
' ======================================================================

#define	IDENT_PROG "ned"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "16may94"
#define	IDENT_NAME "Morgan_Davis"

#define	COPR	IDENT_PROG " " IDENT_VERS " (C) 1994 Morgan Davis Group...";

#include <basic.h>
#include <ctype.h>
#include <prodos.h>
#include <proline/proline.h>

#define	POUND_SIGN	35

#define	MAX_ADDRS	128
#define	MAX_GROUPS	1000

#define	TEMP_FILE		newsysFile$ + ".ned"

	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't run"
		goto Exit
	endif


	' ==============================
	' Pathnames
	' ==============================

	if argc > 1 then
		newsysfile$ = argv$[1]
	else
		newsysFile$ = ETC_PATH + "newsys"
	endif
	mailspoolDir$	= SPOOL_MAIL_PATH

	quitFlag%	= FALSE

	& ioctl(ioClearScreen)
	gosub ClrMsgBox
	print COPR;
	gosub ScanNewsys

	& int stop
	gosub MainEvent
	& int on
	fClose
goto Exit


' ==============================
' Subroutines
' ==============================

MainEvent:
	cmd$ = "ACDEFNPUQ"
	selection = 1
	repeat
		if groupCount then
			gosub GetGroupInfo
			gosub ShowGroup2
			i$ = ""
			if deleteCount% then
				if deleted%[selection] then i$ = "un"
			endif
			print "<A>dd <C>opy " i$ "<D>elete <E>dit <F>ind <N>ext <P>rev <U>pdate";
			opt$ = "ACDEFNPUQ"
		else
			& ioctl(ioGotoXY, 32, 10)
			print "No newsgroups.";
			gosub ClrMsgBox
			print "<A>dd";
			opt$ = "AQ"
		endif
		print " <Q>uit: < >^H^H";
		repeat
			get a$
			& ucase(a$)
			& pos (opt$, a$), p
		until p
		& pos (cmd$, a$), p
		print a$;
		on p gosub AddGroup, CopyGroup, DeleteGroup, EditGroup, \
			LocateGroup, NextGroup, PrevGroup, Updater, Quit
	until quitFlag%
	& ioctl (ioUp)
return

NextGroup:
	if i and (selection < groupCount) then
		selection = selection + 1
	endif
return

PrevGroup:
	if i and (selection > 1) then
		selection = selection - 1
	endif
return

Quit:
	quitFlag% = TRUE
	if deleteCount% then
		gosub ClrMsgBox
		print "Updating " newsysFile$ "...";
		gosub UpdateNewsys
	endif
	gosub ClrMsgBox
	print
return

AddGroup:
return


Updater:
	gosub ClrMsgBox
	print "Update (sort and optimize) your newsys file";
	gosub GetYN
	if Yes then
		gosub ClrMsgBox
		gosub NewTmpFile 
		curSel = selection
		for selection = 1 to groupCount
			if deleteCount% then
				skip% = deleted%[selection]
			else
				skip% = FALSE
			endif
			if not skip% then
				gosub GetGroupInfo
				oldAlias$ = alias$
				gosub MakeAlias
				if alias$ > "" and alias$ <> oldAlias$ then
					gosub EditAlias
					gosub ClrMsgBox
				endif
				oldAlias$ = ""
				& ioctl(ioCR)
				& ioctl(ioClearEOL)
				print "Updating " selection "/" groupCount ": " group$;
				fWrite tempFile$
				gosub WriteGroup
			endif
		next
		gosub UseTmpFile
		fClose
		gosub ScanNewsys
		selection = curSel
	endif
return

CopyGroup:
'	if groupCount then
'		selectPrompt$ = "copy"
'		gosub SelectGroup
'		if selection > 0 then
'			gosub GetGroupInfo
'			gosub ShowGroup
			repeat
				gosub ClrMsgBox
				i$ = group$ + ".copy"
				& read (-64, i$),"Copy this group to: ", a$
				if a$ > "" then
					gosub ClrMsgBox
					print "Checking...";
					gosub FindGroup
					if not groupExists% then
						group$ = a$
						gosub CheckAlias
						gosub ClrMsgBox
						print "Copying...";
						fClose
						fAppend newsysFile$
						gosub WriteGroup
						gosub ScanNewsys
						a$ = ""
					else
						gosub ClrMsgBox
						print a$ " exists!" \
						  "  Try new name";
						gosub GetYN
						if not Yes then return
					endif
				endif
			until a$ = ""
'		endif
'	endif
return

MakeAlias:
	alias$ = ""
	if len(group$) > 15 then
		p = 1
		repeat
			alias$ = alias$ + mid$(group$,p,1) + "."
			& pos(p, group$, "."), q
			if q then
				p = q + 1
				& pos(p, group$, "."), q
				if q then
					if (len(alias$) + len(group$) - p) < 15 then q = 0
				endif
			endif
		until not q
		alias$ = left$(alias$ + mid$(group$, p), 15)
	else
		alias$ = group$
	endif
	for p = 1 to len(alias$)
		i = asc(mid$(alias$, p, 1))
		if not isalnum(i) then
			&mid$(alias$, p) = "."
		endif
	next
	if alias$ = group$ then alias$ = ""
return

CheckAlias:
	gosub MakeAlias
	if alias$ = "" then return

EditAlias:
	i$ = alias$
	gosub ClrMsgBox
	print "Alias for " group$;
	& read (-15, i$),": ",alias$
return

	
FindGroup:
	&lcase(a$)
	groupExists% = FALSE
	fRead newsysFile$
	for i = 1 to groupCount
		filePos = group[i]
		poke24 (_SMARK, filePos)
		&MLI (_SET_MARK, _SSETMRK), errCode
		& get i$
		& pos(i$, "="), p
		if p then i$ = left$(i$, p - 1)
		if i$ = a$ then
			groupExists% = TRUE
			i = groupCount
		endif
	next
	fFre
return


DeleteGroup:
#if 0
	if groupCount then
		selectPrompt$ = "delete"
		gosub SelectGroup
		if selection > 0 then
			gosub GetGroupInfo
			gosub ShowGroup2
			print "Delete";
			gosub GetYN
			if Yes then
				gosub ClrMsgBox
				print "Deleting...";
				if selection < groupCount then
					for i = selection to groupCount - 1
						group[i] = group[i + 1]
					next
				endif
				groupCount = groupCount - 1
				gosub UpdateNewsys
			endif
		endif
	endif
#endif
	if deleteCount% then
		if deleted%[selection] then
			deleted%[selection] = FALSE
			deleteCount% = deleteCount% - 1
			if not deleteCount% then &erase(deleted%)
			return
		endif
	endif
	if not deleteCount% then dim deleted%[groupCount]
	deleted%[selection] = TRUE
	deleteCount% = deleteCount% + 1
return

LocateGroup:
	curSelection = selection
	gosub SelectGroup
	if selection <= 0 then & swap (curSelection, selection)
return

EditGroup:
'	if groupCount then
'		selectPrompt$ = "edit"
'		gosub SelectGroup
'		if selection > 0 then
'			gosub GetGroupInfo
			gosub ShowGroup2
			print "Select item to edit: < >^H^H";
			get a$
'		endif
'	endif
return


SelectGroup:
	selectFirst = 1
	selection = 0
	repeat
		gosub GetSelection
	until selection
return

ShowGroup2:
	gosub ShowGroup
ClrMsgBox:
	& ioctl(ioGotoXY, 0, 21)
	& ioctl(ioClearEOS)
	& hlin 79, 45
	print
return

ShowGroup:
	& ioctl(ioClearScreen)
	print
	print "<N>ame:        " group$ " ";
	if deleteCount% then
		if deleted%[selection] then
			& ioctl (ioInverse)
			print "DELETED";
			& ioctl (ioNormal)
		endif
	endif
	print "^M<A>lias:       " alias$
	print "<D>escription: " Description$
	print "<C>onference:  " csInfo$
	print
	print "<R>emarks:"
	if commentCount% then
		for i = 1 to commentCount%
			print "    " comment$[i]
		next
	endif
	print
	print "<S>ubscribers:"
	compactList% = FALSE
goto WriteToList

NewTmpFile:
	tempFile$ = TEMP_FILE
	& getinfo tempFile$, i$
	if i$ > "" then fDelete tempFile$
	fOpen tempFile$
return

UpdateNewsys:
	if groupCount = deleteCount% then
		fClose newsysFile$
		fDelete newsysFile$
		return
	endif

	gosub NewTmpFile
	for i = 1 to groupCount
		if deleteCount% then
			skip% = deleted%[selection]
		else
			skip% = FALSE
		endif
		if not skip% then
			filePos = group[i]
			fWrite tempFile$
			&MLI (_GET_MARK, _SGETMRK), errCode
			group[i] = peek24(_SMARK)
			fRead newsysFile$
			poke24 (_SMARK, filePos)
			&MLI (_SET_MARK, _SSETMRK), errCode
			repeat
				fRead newsysFile$
				& get i$
				fWrite tempFile$
				print i$
			until i$ = ""
		endif
	next
	
UseTmpFile:
	fClose
	fDelete newsysFile$
	fRename tempFile$ "," newsysFile$
	tempFile$ = ""
	fOpen newsysFile$
	fFre
return

WriteGroup:
	print group$;
	if alias$ > "" then		print "=" alias$;
	print
	if Description$ > "" then	print "#D " Description$
	if csInfo$ > "" then		print "#L " csInfo$
	if commentCount% then
		for i = 1 to commentCount%
			print "#R " comment$[i]
		next
	endif
	compactList% = TRUE

WriteToList:
	if toCount% then
		& sort(to$, toCount%)
		j = 0
		for i = 1 to toCount%
			repeat
				if not j and not compactList% then
					print "    ";
					j = 4
				endif
				j = j + len(to$[i]) + 2 - compactList%
				if j > 79 then
					print
					j = 0
				endif
			until j
			print to$[i];
			if i < toCount% then print mid$(", ", 1, 2 - compactList%);
		next
		print
	endif
	print
return


GatherAddresses:
	repeat
		gosub stripwhite
		& pos (a$ + " "," "),p
		& pos (a$ + ",",","),q
		if q and (q < p) then p = q
		if p then
			toCount% = toCount% + 1
			to$[toCount%] = left$ (a$,p - 1)
			a$ = mid$(a$, p + 1)
		endif
	until a$ = ""
return

stripwhite:
	&spc (a$), a$
	if a$ > "" then
		pp = 1
		repeat
			qq = pp
			if mid$(a$, pp, 1) < "0" then pp = pp + 1
		until qq = pp or pp > len(a$)
		a$ = mid$(a$, pp)
	endif
return


GetGroupInfo:
	fRead newsysFile$
	filePos = group[selection]
	poke24 (_SMARK, filePos)
	&MLI (_SET_MARK, _SSETMRK), errCode
	& get group$
	& pos(group$, "="), p
	if p then
		alias$ = mid$(group$, p + 1)
		group$ = left$(group$, P - 1)
	else
		alias$ = ""
	endif
	commentCount% = 0
	toCount% = 0
	to$[0] = ""
	description$ = ""
	csInfo$ = ""
	& erase(to$)
	dim to$[MAX_ADDRS]
	onerr goto groupEOF
	repeat
		& get a$
		if mid$(a$, 1, 1) = "#" then
			i$ = mid$(a$, 2, 1)
			if i$ = "R" then
				commentCount% = commentCount% + 1
				comment$[commentCount] = mid$(a$, 4)
			else
				if i$ = "D" then
					description$ = mid$(a$, 4)
				else
					if i$ = "L" then
						csInfo$ = mid$(a$, 4)
					endif
				endif
			endif
		else
			if a$ > "" then
				gosub GatherAddresses
				a$ = "#"	' to keep looping
			endif
		endif
	until a$ = ""
	error(5)
	groupEOF:
	onerr goto HandleError
	& onerr
	fFre
return


GetSelection:
	& ioctl(ioClearScreen)
	fRead newsysFile$
	selectLast = selectFirst + 15
	if selectLast > groupCount then selectLast = groupCount
	gosub PageScan
	print
	print "Select a group:^I^I^I^I^I^I" \
		 selectFirst " to " selectFirst + j - 1 " of " groupCount
	print
	for i = 1 to j
		a$ = line$[i]
		& pos(a$, " "), p
		j$ = mid$(a$, p, 74 - maxLen)
		& left$(left$(a$, p - 1), maxLen), a$
		print "(" chr$(64 + i) ")  " a$ j$
	next
	& erase(line$)
	fFre
	gosub ClrMsgBox
	print "Enter a letter, < Prev, Next >, or (Q)uit: ";
	repeat
		get a$
		& ucase(a$)
		p = 1
		if a$ = "Q" then
			selection = -1
		else
			& pos ("^M >.^I+", a$), i
			if i and selectLast < groupCount then
				selectFirst = selectLast + 1
			else
				& pos ("^H<,^?-", a$), i
				if i and selectFirst > 1 then
					selectFirst = selectFirst - 16
					if selectFirst < 1 then selectFirst = 1
				else
					if a$ > "@" and a$ < chr$(65 + j) then
						selection = selectFirst + asc(a$) - 65
						print a$
					else
						p = 0
					endif
				endif
			endif
		endif
	until p
return

PageScan:
	line$[0] = ""
	& erase(line$)
	dim line$[16]
	j = 0
	maxLen = 0
	for i = selectFirst to selectLast
		filePos = group[i]
		poke24 (_SMARK, filePos)
		&MLI (_SET_MARK, _SSETMRK), errCode
		& get a$
		& pos(a$, "="), p
		if p then a$ = left$(a$, p - 1)
		if len(a$) > maxLen then maxLen = len(a$)
		& get j$
		if mid$(j$, 1, 1) = "#" then
			j$ = mid$(j$, 4)
		else
			j$ = "?"
		endif
		j = j + 1
		line$[j] = a$ + " " + j$
	next
return
	
ScanNewsys:
	fClose
	group$[0] = ""
	group[0] = 0
	& erase(group$)
	& erase(group)
	dim group$[MAX_GROUPS], group[MAX_GROUPS]

	groupCount = 0
	fOpen newsysFile$
	fRead newsysFile$
	onerr goto newsysEOF
	repeat
		repeat
			&MLI (_GET_MARK, _SGETMRK), errCode
			filePos = peek24(_SMARK)
			&get a$
		until a$ > "" and mid$(a$, 1, 1) <> "#" 
		groupCount = groupCount + 1
		group$[groupCount] = a$ + " " + str$(filePos)
		repeat
			&get a$
		until a$ = ""
	until groupCount = MAX_GROUPS
	error(5)

	newsysEOF:
	&onerr errCode, lineNum
	onerr goto HandleError
	if groupCount then
		& sort(group$, groupCount)
		for i = 1 to groupCount
			& spc(group$[i]), a$
			&pos (a$, " "),p
			group[i] = val(mid$(a$, p))
		next
	endif
	& erase(group$)
	fFre
return
	
GetYN:
	print "? (Y/N) ";
	repeat
		get i$
		& ucase(i$)
	until i$ = "Y" or i$ = "N"
	print i$
	Yes = i$ = "Y"
return

#if 0
' ==============================
  GetLocalSite:
'
' Returns:	site$ = name of target site for batch
'		path$ = path (plus "!") to user
'		user$ = recipient
'		to$ = full bang-style path to recipient
' ==============================
	site$ = ""

	' Replace all %'s with @'s

	repeat
		& pos (to$, "%"), p
		if p then & mid$(to$,p) = "@"
	until not p

	' Check for an @ address format.  If found, convert to bang.
	' Reverse build the path if there are multiple @'s.

	path$ = ""
	repeat
		& pos right$ (to$,"@"), p
		if p then
			path$ = path$ + mid$ (to$, p + 1) + "!"
			to$ = left$(to$, p - 1)
		endif
	until not p
	to$ = path$ + to$
	
	' Now determine if path contains any addresses at all!
	
	& pos right$ (to$, "!"), p
	if not p then return	' return with site$ = ""

	' Break path down to user, site and domain components

	user$ = mid$(to$, p + 1)	
	path$ = left$(to$, p)
	& pos right$ (p - 1, path$, "!"), q
	site$ = mid$(path$, q + 1, p - q - 1)

	& pos (2, site$, "."), p
	if p then
		domain$ = mid$ (site$, p)
		site$ = left$ (site$, p - 1)
		if domain$ = SysInfo$[plDomain] then
			domain$ = ""
 			path$ = ""
		endif
	else
		domain$ = ""
	endif

	if site$ = SysInfo$[plNode] then site$ = ""

	if domain$ > "" then
		to$ = site$ + domain$ + "!" + user$
	else
		to$ = path$ + user$
	endif
return		

get_unique_filename:
	gosub time_index
	j = val (mid$ (time$,6))
	& right$ (str$(val(mid$(time$,16)) * 3600 + \
		val(mid$(time$,19)) * 60 + val(right$(time$,2))), 5, 48), a$
	file$ = chr$(64 + index) + chr$(48 + j + 7 * (j > 9)) + a$ + "n"
	& lcase (file$)
	if file$ = lastFile$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastFile$ = file$
	file$ = file$ + seq$
return

time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

header_time:
	& time(time$)
	htime$ = left$ (time$, 3) + mid$ (time$, 8, 5) + \
		mid$ (time$, 6, 3) + right$ (time$, 8) + \
		" 19" + mid$ (time$, 13, 3)
return


small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return
#endif

#include <proline/proline.lib>
