' ****************************************************************************
' ***
' ***	mc.b	Modemcap Editor for ModemWorks 3.1 modemcaps
' ***		(C)opyright 1994 Morgan Davis Group
' ***
' ***	15apr92	1.0	mwd	Creation
' ***	07jul93	1.1	mwd	No arguments loads configured modemcap
' ***				Support for 57,600 speed added

#define	IDENT_PROG "mc"
#define	IDENT_VERS "1.1"
#define	IDENT_DATE "7jul93"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#ifdef STAND_ALONE
 #define MCAPS	AppPrefix$ + "/Modemcaps/"
#else
 #define MCAPS	SYS_PATH + "modemcaps/"
#endif

#define	oVersion	0	' byte: version
#define	oVarySpeed	1	' byte: variable baud rate flag
#define	oHighSpeed	2	' byte: high speed index
#define	oFlowControl	3	' byte: flow control index
#define	oHasDCD		4	' byte: can report DCD
#define	oHasEC		5	' byte: has error correction
#define	oCanAnswer	6	' byte: modem can answer with ATA
#define	oDTRHangup	7	' byte: use DTR to hangup
#define	oReserved1	8	' byte: reserved
#define	oReserved2	9	' byte: reserved
#define	oDTRDelay	10	' word: ticks to hold DTR low for hangup
#define	oResultDelay	12	' word: ticks to wait for a result code
#define	oEscapeDelay	14	' word: ticks around +++ escapes
#define	oPrefixDelay	16	' word: ticks before AT command sent
#define	oReserved3	18	' word: reserved
#define	oReserved4	20	' byte: reserved
#define	oLenStrings	21	' byte: length of command strings following
#define	oStrings	22	' packed array of C-strings

#define	sEscape		1	' +++
#define	sAttention	2	' AT
#define	sMainInit	3	' Primary initialization sequence
#define	sAuxInit	4	' Secondary initialization sequence
#define	sMNPOn		5	' Turns on error correction mode
#define	sMNPOff		6	' Turns off error correction mode
#define	sMakeBusy	7	' Lifts the phone offhook
#define	sNotBusy	8	' Puts the phone onhook
#define	sDialTone	9	' Dial using Touch Tones (tm)
#define	sDialPulse	10	' Dial using pulses
#define	sHangup		11	' Command to hangup
#define	sPostHangup	12	' Command sent after hanging up
#define	sAnswer		13	' Lifts phone to answer a call
#define	sOriginate	14	' Lifts phone to originate a call
#define	sExitInit	15	' Exit initialization sequence
#define	sSpeakerOff	16	' Turns speaker totally off
#define	sSpkrOnUntilDCD	17	' Turns speaker on until carrier detected
#define	sSpeakerOn	18	' Turns speaker on all the time
#define	sSpkrAnswerOnly	19	' Speaker is on only for answer negotiation
#define	sNextString	20

DefaultStrings:
	data "+++","AT","E0V1Q0X4","S0=0S2=43S3=13S7=255S9=6", \
		"","","H1","H0","DT","DP","H0","","A", \
		"O","Z","M0","M1","M2","M3",""


#define	ModemcapAddr	$300

#define	YesNoMenu	0	' Menu ID's
#define	BaudMenu	1
#define	FlowMenu	2
#define NextMenu	3

MenuItems:
	data YesNoMenu,2,"No","Yes"
	data BaudMenu,18,\
		"Default",50,75,110,135,150,300,600,1200,1800,\
		2400,3600,4800,7200,9600,19200,38400,57600
	data FlowMenu,6,"N/A","None","XON/XOFF","RTS/CTS","RTS","CTS"
	data -1

#define	MAXMENUITEMS	18
	
#define	WORD	1		' Dialog item types
#define	MENU	2
#define	STAT	3
#define	BUTN	4
#define	EDIT	5
#define	DASH	6

#define	TrackDialog(i)	gosub _TrackDialog : i = _itemHit

#define	QuitBtnID	1
#define	NewBtnID	2
#define	SaveBtnID	3
#define	MoreBtnID	4

#define	MAXDITEMS	50

MainDLOG:
	data STAT, 0,  2, "--- Communication Settings ---", ,
	data MENU, 20, 4, "Variable Speed:", oVarySpeed, YesNoMenu
	data MENU, 20, 5, "High Speed:", oHighSpeed, BaudMenu
	data MENU, 20, 6, "Flow Control:", oFlowControl, FlowMenu
	data MENU, 20, 7, "Has Carrier Detect:", oHasDCD, YesNoMenu
	data MENU, 20, 8, "Error Correction:", oHasEC, YesNoMenu
	data MENU, 20, 9, "ATA Answers:", oCanAnswer, YesNoMenu
	data MENU, 20,10, "Use DTR to Hangup:", oDTRHangup, YesNoMenu
	data STAT, 0, 12, "--- Timing (in 1/60 seconds) ---", ,
	data WORD, 20,14, "Hangup Duration:", oDTRDelay,
	data WORD, 20,15, "Result Code Delay:", oResultDelay,
	data WORD, 20,16, "+++ Guard Time:", oEscapeDelay,
	data WORD, 20,17, "Attention Delay:", oPrefixDelay,
	data DASH,  0,18, "_", 80,
	data BUTN,  5,20, "Quit", QuitBtnID,
	data BUTN, 25,20, "New", NewBtnID,
	data BUTN, 45,20, "Save", SaveBtnID,
	data BUTN, 65,20, "More", MoreBtnID,
	data -1

	
StringsDLOG:
	data STAT, 0,  2, "--- Modem Command Strings ---", ,
	data EDIT, 20, 4, "Escape:", sEscape, 3
	data EDIT, 20, 5, "Attention:", sAttention, 10
	data EDIT, 20, 7, "Main Init:", sMainInit, 50
	data EDIT, 20, 8, "Aux Init:", sAuxInit, 50
	data EDIT, 20, 9, "Exit Init:", sExitInit, 50
	data EDIT, 20,11, "MNP On:", sMNPOn, 20
	data EDIT, 55,11, "MNP Off:", sMNPOff, 20
	data EDIT, 20,12, "Make Busy:", sMakeBusy, 20
	data EDIT, 55,12, "Not Busy:", sNotBusy, 20
	data EDIT, 20,13, "Dial Tone:", sDialTone, 20
	data EDIT, 55,13, "Dial Pulse:", sDialPulse, 20
	data EDIT, 20,14, "Hangup:", sHangup, 20
	data EDIT, 55,14, "Post Hangup:", sPostHangup, 20
	data EDIT, 20,15, "Answer:", sAnswer, 20
	data EDIT, 55,15, "Originate:", sOriginate, 20
	data EDIT, 20,17, "Speaker Off:", sSpeakerOff, 20
	data EDIT, 55,17, "Spkr On Until DCD:", sSpkrOnUntilDCD, 20
	data EDIT, 20,18, "Speaker On:", sSpeakerOn, 20
	data EDIT, 55,18, "On In Answer Only:", sSpkrAnswerOnly, 20
	data DASH,  0,19, "_", 80,
	data BUTN,  5,21, "Quit", QuitBtnID,
	data BUTN, 25,21, "New", NewBtnID,
	data BUTN, 45,21, "Save", SaveBtnID,
	data BUTN, 65,21, "More", MoreBtnID,
	data -1


' ________________________________________
'
'	       MODEMCAP EDITOR
' ________________________________________

	gosub AppInit

#ifdef STAND_ALONE
	& < AppPath$, AppPrefix$
	& < AppPrefix$, AppPrefix$
#else
	if not SuperUser then
		print argv$[0] ": can't execute"
		goto Exit
	endif
#endif

	dim diType%[MAXDITEMS], diWhereX%[MAXDITEMS], diWhereY%[MAXDITEMS], \
		diTitle$[MAXDITEMS], diData1[MAXDITEMS], diData2[MAXDITEMS], \
		string$[sNextString]

	Commands$ = "qnsm"
	HArrows$ = "^H^U13"
	VArrows$ = "^K^J52"
	dir[1] = -1 : dir[2] = 1 : dir[3] = -1 : dir[4] = 1

	gosub LoadMenus

	mainSelected = TRUE

#ifdef STAND_ALONE
	gosub xClear
	gosub DrawDialog
#else
	if argc > 1 then
		mcFile$ = argv$[1]
	else
		i$ = RSRC_PATH + "startup.rsrc" 
		fOpen i$
		fRead i$
			input j
			for i = 1 to j
				& get
			next
			& get mcFile$
		fClose
	endif
	gosub xOpen
#endif

	repeat
		TrackDialog(itemHit)
		if itemHit = MoreBtnID then
			mainSelected = not mainSelected
			gosub DrawDialog
		else
			if itemHit = SaveBtnID then
				gosub xWrite
			else
				if itemHit = NewBtnID then gosub xNew
			endif
		endif
	until itemHit = QuitBtnID
	gosub askSave
	& ioctl (ioGotoXY, 0, 21)
	& ioctl (ioClearEOS)
	print
goto Exit


	
getModemcap:
	fBload mcFile$ ",A" ModemcapAddr ",T0"
	y = ModemcapAddr + oStrings
	x = sEscape
	LenStrings = 0
	while x < sNextString
		string$[x] = ""
		while peek(y)
			string$[x] = string$[x] + chr$(peek(y))
			y = y + 1
		wend
		LenStrings = LenStrings + len(string$[x]) + 1
		y = y + 1
		x = x + 1
	wend	
return


putModemcap:
	y = ModemcapAddr + oStrings
	j = 0
	for x = sEscape to sNextString
		j = len(string$[x]) + 1
		if j > 1 then
			for i = 1 to j - 1
				poke y, asc(mid$(string$[x], i))
				y = y + 1
			next
		endif
		poke y, 0
		y = y + 1
	next

	poke ModemcapAddr + oLenStrings, j

	fBsave mcFile$ ",A" ModemcapAddr ",T0,L" y - ModemcapAddr
return


getFileName:
	gosub clearModeLine
	i$ = mcFile$
	& read (-64, i$), "Modemcap file name: ", mcFile$
clearModeLine:
	& ioctl (ioGotoXY, 0, 22)
	& ioctl (ioClearEOL)
return



getFileInfo:
	if mcFile$ > "" then
		& pos (mcFile$, "/"), p
		if not p then mcFile$ = MCAPS + mcFile$
		& getinfo mcFile$, i$
	else
		i$ = ""
	endif
return


xNew:
	gosub askSave
	gosub getFileName
xOpen:
	saved = TRUE
	gosub getFileInfo
	if i$ >"" then
		gosub getModemcap
	else
		msg$ = "New file."
		gosub xClear
	endif
goto DrawDialog

xClear:
	& setdata DefaultStrings

	for i = 1 to sNextString
		read string$[i]
	next

	& poke ModemcapAddr, \
		1, TRUE, 8, 1, \
		$FF, FALSE, $FF, $FF, \
		0, 0, \
		90, 0, 60, 0, 90, 0, 30, 0, \
		0, 0, \
		0, 0

	saved = TRUE
return

xWrite:
	oldName$ = mcFile$
	gosub getFileName
	gosub getFileInfo
	if mcFile$ = "" then
		mcFile$ = oldName$
		msg$ = "Cancelled."
	else
		if oldName$ <> mcFile$ then gosub showFileName
		if i$ = "" then fCreate mcFile$ ",T0"
		gosub putModemcap
		saved = TRUE
		msg$ = "Saved."		
	endif
return


askSave:
	if not saved then
		gosub clearModeLine
		i$ = "y"
		& read (-2, i$),"Save changes? (y/n) ",a$
		&lcase(a$)
		if a$ = "y" then
			gosub xWrite
		else
			msg$ = "Cancelled."
		endif
		& ioctl(ioNormal)
	endif
return

itemWrap:
	while diType%[curItem] = STAT or diType%[curItem] = DASH
		gosub itemMove
	wend
return

itemMove:
	curItem = curItem + dir[p]
	if curItem < 1 then curItem = itemCount
	if curItem > itemCount then curItem = 1
return

_TrackDialog:
	if msg$ > "" then
		gosub clearModeLine
		print msg$;
	endif
	p = 2
	_itemHit = 0
	repeat
		repeat
			gosub itemWrap
			& ioctl (ioGotoXY, diWhereX%[curItem] - 1, \
				diWhereY%[curItem])
			print ">^H";
			get a$
			print " ^H";
			if msg$ > "" then
				gosub clearModeLine
				msg$ = ""
				& ioctl (ioGotoXY, diWhereX%[curItem] - 1, \
					diWhereY%[curItem])
			endif
			&lcase(a$)
			& pos (VArrows$, a$), p
			if p then gosub itemMove
		until not p
		gosub handleKey
	until _itemHit
return

handleKey:
	diType = diType%[curItem]
	if a$ = "^M" then
		if diType = EDIT then
			gosub editItem
		else
			if diType = BUTN then
				_itemHit = diData1[curItem]
			else
				if diType = WORD then gosub editWord
			endif
		endif
	else
		if a$ = "^I" then
			_itemHit = MoreBtnID
		else
			& pos (HArrows$, a$), p
			if p then
				if diType = MENU then
					gosub menuMove
				else
					if diType = WORD then gosub wordMove
				endif
			else
				& pos (Commands$, a$), p
				if p then _itemHit = p
			endif
		endif
	endif
return

menuMove:
	y = peek(ModemcapAddr + diData1[curItem])
	if diData2[curItem] = YesNoMenu then
		y = y > 0
		x = not y
		j = x * $FF
	else
		x = y + dir[p]
		if x < 0 then x = MItems[diData2[curItem]] - 1
		if x = MItems[diData2[curItem]] then x = 0
		j = x
	endif
	poke ModemcapAddr + diData1[curItem], j
	a$ = Menu$[diData2[curItem], x]
	j = len(Menu$[diData2[curItem], y])
	if len(a$) < j then & left$(a$, j), a$
	print " " a$;
	saved = FALSE
return

editWord:
	y = peek16(ModemcapAddr + diData1[curItem])
	a$ = str$(y)
	& read (-5, a$)," ",i$
	x = val(i$)
	poke16(ModemcapAddr + diData1[curItem], x)
	saved = FALSE
return

wordMove:
	y = peek16(ModemcapAddr + diData1[curItem])
	x = y + dir[p]
	if x < 0 then x = $FFFF
	if x > $FFFF then x = 0
	poke16(ModemcapAddr + diData1[curItem], x)
	a$ = str$(x)
	j = len(str$(y))
	if len(a$) < j then & left$(a$, j), a$
	print " " a$;
	saved = FALSE
return	

editItem:
	a$ = string$[diData1[curItem]]
	& read (-diData2[curItem], a$)," ",i$
	& spc(i$),i$
	string$[diData1[curItem]] = i$
	saved = FALSE
return

DrawDialog:
	if mainSelected then
		& setdata MainDLOG
	else
		& setdata StringsDLOG
	endif

	& ioctl (ioClearScreen)
	i = 0
	repeat
		read diType
		if diType > -1 then
			i = i + 1
			diType%[i] = diType
			read diWhereX%[i], diWhereY%[i], diTitle$[i], \
				diData1[i], diData2[i]
			gosub DrawDItem
		endif
	until diType = -1
	itemCount = i
	curItem = 1
showFileName:
	if mcFile$ > "" then
		& pos right$(mcFile$, "/"), q
		a$ = mid$(mcFile$, q + 1)
		& ioctl (ioGotoXY, 0, 23)
		& ioctl (ioInverse)
		& ioctl (ioClearEOL)
		& ioctl (ioGotoXY, 38 - len(a$) / 2, 23)
		print a$;
		& ioctl (ioNormal)
	endif
return
	
DrawDItem:
	& ioctl (ioGotoXY, diWhereX%[i], diWhereY%[i])
	on diType%[i] goto \
		drawWORD, drawMENU, drawSTAT, drawBUTN, drawEDIT, drawLINE

drawWORD:
	print peek16(ModemcapAddr + diData1[i]);
goto drawPrompt

drawMENU:
	x = peek(ModemcapAddr + diData1[i])
	if diData2[i] = YesNoMenu then x = x > 0
	print Menu$[diData2[i], x];
goto drawPrompt

drawBUTN:
	print "[ " diTitle$[i] " ]";
return

drawEDIT:
	print string$[diData1[i]];
drawPrompt:
	& ioctl (ioGotoXY, \
		diWhereX%[i] - len(diTitle$[i]) - 1, diWhereY%[i])
drawSTAT:
	print diTitle$[i];
return

drawLINE:
	& hlin diData1[i], asc(diTitle$[i])
return


LoadMenus:
	dim Menu$[NextMenu, MAXMENUITEMS], MItems[NextMenu]
	& setdata MenuItems
	repeat
		read menuID
		if menuID > -1 then
			MenuWidth[menuID] = 0
			read MItems[menuID]
			for i = 0 to MItems[menuID] - 1
				read Menu$[menuID, i]
			next
		endif
	until menuID = -1
return

#include <proline/proline.lib>
