' ************************************************************************
' **
' **  flip.b		Flag Inactive Persons (for removal)
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 03nov93 mwd 2.0	Converted to MD-BASIC from 1987 1.1 versions
' ** 16jan94 mwd 3.0	-a option includes accounting info in report
' **
' ************************************************************************

#define	IDENT_PROG "flip"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>

#define	MAX_USERS	1500

	gosub AppInit

	if not SuperUser then 
		print argv$[0]": cannot execute"
		goto ExitError
	endif

	options$ = "?ad:"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage% = TRUE
		if optchar$ = "a" then acctInfo% = TRUE
		if optchar$ = "d" then dayOverride = val(optarg$)
	until optchar$ = ""
	
	if showUsage% then
		& print "Usage: " argv$[0] " [ -d days ]"
		goto Exit
	endif


	dim id%[MAX_USERS]
	
	passwdFile$	= ETC_PATH + "passwd"
	admFile$	= ETC_PATH + "adm"
	rmipFile$	= ID$[uHome] + "/rmip"
	bigrmipFile$	= rmipFile$ + ".big"

	& time(t$)
	gosub daysThisCentury
	jc = days

	print argv$[0]": ";
	onerr goto pwEOF
	fOpen passwdFile$
	fRead passwdFile$

	users = 0
	do
		& get a$
		& pos (a$,":"), p
		& pos (p + 15, a$, ":"),q
		gid = val(mid$(a$, q + 1, 1))
		if gid = 1 or gid = 3 then 
			users = users + 1
			id%[users] = val(mid$(a$, p + 15))
		endif
	loop

	pwEOF:
	& onerr e,l
	fClose
	onerr goto HandleError

	if not users then goto Exit
	if e <> 5 then
		print argv$[0]": error " e "@" l
		goto ExitError
	endif

	print "[" users "] ";
	fOpen admFile$ ",L" admRecordLength

	& getinfo rmipFile$,i$
	if i$ > "" then fDelete rmipFile$
	& getinfo bigrmipFile$,i$
	if i$ > "" then fDelete bigrmipFile$

	lastLoginOffset = admLastLogin - admName
	removed = 0
	
	fOpen rmipFile$
	for i = 1 to users
		fRead admFile$ ",R" id%[i]
		& get n$
		fRead admFile$ ",B" lastLoginOffset
		& get t$
		gosub daysThisCentury
		& get i$
		& pos right$(i$, ","), q
		grace = val(mid$(i$, q + 1))
		if grace and dayOverride then
			tmo = dayOverride
		else
			tmo = grace
		endif
		i$ = left$(n$, 1)
		if tmo and (jc - days >= tmo) then 
			fWrite rmipFile$
			gosub reportEntry
			fFre
			removed = removed + 1
			& ucase(i$)
			& ioctl(ioInverse)
			print i$;
			& ioctl(ioNormal)
		else
			print i$;
		endif
	next 
	print 
	fClose
	if removed then 
		& list rmipFile$
		if removed > 9 then fRename rmipFile$ "," bigrmipFile$
	else
		fDelete rmipFile$
	endif
goto Exit


' ===== T$ -> Days from year 00 this century =====

daysThisCentury:
	& pos ("?anebarprayunulugepctovec", mid$(t$,10,2)), moy
	moy = moy / 2
	y = val(mid$ (t$, 13, 2))
	days = 365 * y + \
		val(mid$("??000031059090120151181212243273304334", moy * 3, 3)) + \
		val(mid$(t$,6)) + \
		(moy > 2 and y / 4 = int(y / 4))
return 


' ===== Figure Report Entry =====

reportEntry:
	if jc - days > 6000 then 
		print n$" # never activated"
	else
		print n$" # inactive "jc - days" days (max="tmo")"
	endif
	if acctInfo% then
		fRead admFile$ ",R" id%[i] ",B" admName
		for ia = 1 to 5
			fRead admFile$
			& get a$
			fWrite rmipFile$
			print "# " a$
		next
		print "#"
	endif
return 


#include <proline/proline.lib>
#include <proline/getopt.lib>
