' ************************************************************************
' **									**
' **  eduser.b 		Edit user's account info			**
' **			Copyright (C) 1994 Morgan Davis	Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 24sep90 mwd 1.2	Converted to MD-BASIC.				**
' **									**
' ************************************************************************

#define	IDENT_PROG "eduser"
#define	IDENT_VERS "1.2"
#define	IDENT_DATE "24sep90"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	PROGRAM		IDENT_PROG " " IDENT_VERS
#define	MAX_ACCOUNTS	1500
#define	STAT_LINE	21

' ====================
' Main
' ====================

	gosub AppInit
	if not SuperUser then 
		print argv$[0]": cannot execute"
		goto Exit
	endif

	dim i$[12],a$[12]
	for i = 2 to 9
		read l%(i),x%(i),y%(i)
	next
	u$ = argv$[1]
	& ioctl(ioGotoXY),i
	& ioctl(ioClearScreen),j
	& ioctl(ioClearEOS),k
	& ioctl(ioClearEOL),m
	if (i + j + k + m) < 4 then 
		print argv$[0]": inadequate terminal"
		goto Exit
	endif
	& ioctl(ioInsertChar),ic
	& ioctl(ioDeleteChar),dc

	w = peek (33)
	w2 = int (w / 2)

	dim u$[MAX_ACCOUNTS], id%[MAX_ACCOUNTS]

	pw$ = ETC_PATH + "passwd"
	adm$ = ETC_PATH + "adm"
	v$ = PROGRAM
	ec$ = "^M^J^K^U^H^?^D^A^E"
	sc = (peek (- 1101) = 6) * 2

	x = w2 - (len(v$)/2)
	& ioctl(ioNormal)
	& ioctl(ioClearScreen)
	& ioctl(ioGotoXY, x, 10)
	print v$
	print 
	& ioctl(ioGotoXY,x,12)

	fOpen pw$
	fRead pw$
	u = 0
	ptr = 1
	onerr goto pwEOF

	do
		& get a$
		u = u + 1
		& pos (a$,":"),p
		u$(u) = left$(a$,p - 1)
		id%(u) = val (mid$ (a$,p + 15))
		if u$ = u$(u) then ptr = u
	loop

pwEOF:
	& onerr e,l
	fClose
	fFre
	onerr goto HandleError
	if e <> 5 then
		error (e)
	endif

	& page def paging
	& page stop

	fOpen adm$ ",L256"
	gosub DrawScreen

' ====================
' Draw Screen
' ====================

DrawScreen:
	& ioctl(ioClearScreen)
	& ioctl(ioGotoXY,0,2)
	print "User-ID:^M"
	print "Full name:^MAddress:^MCity, ST:^MZip code:^M^MTelephone:^M"
	print "Minutes per month max:"
	print "Days inactive before removal:"
	print "Cents charged per minute:"
	& ioctl(ioGotoXY, 0, STAT_LINE)
	& ioctl(ioInverse)
	& left$ ("=== " + v$ + " by Morgan Davis ", peek (33), $3D),a$
	print a$
	& ioctl(ioNormal)
	& on int goto ShowRecord

' ====================
' Show Rec
' ====================

ShowRecord:
	& pop 
	& ioctl(ioGotoXY,9,2)
	& ioctl(4)
	print id%(ptr);
	fRead adm$ ",R" id%(ptr)
	for i = 1 to 12
		& get i$(i)
		& spc(i$(i)),a$(i)
	next 
	a$(1) = u$(ptr)
	gosub _63_
	print chr$ (9)"("a$(1)")";
	for i = 2 to 9
		& ioctl(ioGotoXY,x%(i),y%(i))
		& ioctl(ioClearEOL)
		print a$(i);
	next 

	do
		& ioctl(ioGotoXY,0,STAT_LINE + 1)
		print "[" u "] Next, Prev, Find, Edit, Dump, Quit: ";
		& ioctl(ioClearEOS)

		repeat
			get a$
			& ucase(a$)
			& pos ("NPFEDQ^L",a$),p
		until p

		if p > 2 then
			& ioctl(ioCR)
			& ioctl(ioClearEOL)
		endif
		op = ptr
		on p gosub NextRec, PrevRec, FindRec, EditRec, DumpRec, \
			Quit, DrawScreen
		on ptr <> op goto ShowRecord
	loop

' ====================
' Next/Prev
' ====================


NextRec:
	ptr = ptr + (ptr < u)
return 

PrevRec:
	ptr = ptr - (1 < ptr)
return 


' ====================
' Find
' ====================

FindRec:
	& read "Find who? ",a$
	& spc(a$),a$
	& lcase(a$)
	if a$ > "" then
		& ioctl(ioGotoXY,0,STAT_LINE + 1)
		print "Finding "a$"...";
		& ioctl (ioClearEOL)
		for i = 1 to u
			& pos (u$(i),a$),p
			if p = 1 then 
				ptr = i
				i = u
			endif
		next
	endif
return 


' ====================
' Edit
' ====================

EditRec:
	f = 2
	wr = FALSE
	old_f = 0

	do
		if old_f <> f then
			i = 1
			& ioctl(ioGotoXY,x%(f),y%(f))
			i$ = a$(f)
			old_f = f
		endif
		get a$
		& pos (ec$,a$),p
		if p then
			on p gosub _56_,_56_,_57_,_65_,_67_,_67_,_68_,_72_,_72_
		else
			if len (i$) < l%(f) and a$ > = " " then 
				i$ = mid$ (i$,1,i - 1) + a$ + mid$ (i$,i)
				& ioctl(ioInsertChar)
				print a$;
				i = i + 1
				if not ic then gosub _69_
			endif
		endif
	loop

_56_:
	gosub _73_
	f = f + 1
	if f < 10 then return
	goto _58_

_57_:
	gosub _73_
	f = f - 1
	if f > 1 then return

_58_:
	pop
	on not wr goto _64_
	& ioctl(ioGotoXY,0,STAT_LINE + 1)
	print "Writing...";
	n$ = a$(2)
	&spc (i$(2)), oldName$
	& pos (i$(10),","),p
	& left$ (a$(9) + mid$ (i$(10),p),12),a$(10)
	& left$ (left$ (i$(12),pq) + a$(7) + "," + a$(8),36),a$(12)
	for i = 7 to 9
		a$(i) = i$(i)
	next 
	fWrite adm$ ",R" id%(ptr)
	for i = 1 to 12
		& left$ (a$(i), len (i$(i))),i$(i)
		& spc(i$(i)),a$(i)
		print i$(i)
	next 


	' check if full name field changed
	' then rewrite passwd file (ack!)

	if n$ <> oldName$ then
		pw$ = ETC_PATH + "passwd"
		pt$ = pw$ + ".tmp"
		& GETINFO pt$,i$
		if i$ > "" then fDelete pt$

		fOpen pw$
		fOpen pt$
		for i = 1 to u
			fRead pw$
			& get a$
			if i = ptr then
				& pos (a$, ":" + oldName$ + ":"), p
				if p then
					&pos (p + 1, a$, ":"), q
					a$ = left$(a$, p) + n$ + mid$(a$, q)
				endif
			endif
			fWrite pt$
			print a$
		next			
		fClose pt$
		fClose pw$
		fDelete pw$
		fRename pt$ "," pw$
	endif


_63_:
	a$(9) = str$ (val (a$(10)))
	p = 0
	for i = 1 to 6
		q = p
		& pos (p + 1,a$(12),","),p
	next 
	pq = q
	a$(7) = mid$ (a$(12),q + 1,p - q - 1)
	a$(8) = mid$ (a$(12),p + 1)

_64_:
	fFre
return


_65_:
	if i < = len (i$) then 
		print mid$ (i$,i,1);
		i = i + 1
	endif
return

_67_:
	if i = 1 then return
	print chr$ (8);
	i = i - 1
	if p = 5 then return

_68_:
	& ioctl(8)
	i$ = mid$ (i$,1,i - 1) + mid$ (i$,i + 1)
	if dc then return

_69_:
	if i < = len (i$) then & put(mid$ (i$,i))
	if p > 5 then & put(" ")

_71_:
	& ioctl(ioGotoXY,x%(f) + i - 1,y%(f))
return

_72_:
	i = len (i$) * (p = 9) + 1
	goto _71_

_73_:
	wr = wr or (a$(f) < > i$)
	a$(f) = i$
return 


' ====================
' Dump
' ====================

DumpRec:
	& ioctl(ioClearScreen)
	& scrn (PrinterOn)
	print "User-ID: "id%(ptr) chr$ (9)"("a$(1)")"
	print 
	for i = 2 to 6
		print a$(i)
	next 
	& scrn (PrinterOff)
goto DrawScreen


' ====================
' Quit
' ====================

Quit:
	if paging then & page on
	print 
	goto Exit

' ====================
' input data tables
' ====================

	data 22,11,04, 33,11,05, 22,11,06, 10,11,07
	data 12,11,09, 05,30,11, 03,30,12, 05,30,13

#include <proline/proline.lib>
