' ======================================================================
' addconf.b	- Add a conference to CS
' 		  (C)opyright 1993 Morgan Davis
'
' 09sep93 mwd 1.4	Newsgroup interface added
'
' ======================================================================

#define	IDENT_PROG "addconf"
#define	IDENT_VERS "1.4"
#define	IDENT_DATE "9sep93"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	MAX_CONFS	51
#define	MAX_TOPICS	6

	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't execute"
		goto Exit
	endif

	& ioctl (ioClearScreen)
	print argv$[0] " " IDENT_VERS
	print
	
	dim topicName$[MAX_TOPICS], netAddress$[MAX_TOPICS], s%[MAX_TOPICS], \
		sig%[MAX_TOPICS]
	dim listLine$[MAX_CONFS + 20]

	indexFile$	= "/i.."
	y$[FALSE]	= "No"
	y$[TRUE]	= "Yes"

	csRsrcFile$ = RSRC_PATH + "cs.rsrc"
	csListFile$ = SYS_PATH + "pcs/cs.list"
	
	& getinfo csRsrcFile$,i$
	if i$ > "" then
		fOpen csRsrcFile$
		fRead csRsrcFile$
		& get cdDir$
		fClose
		if right$ (cdDir$,1) < > "/" then 
			cdDir$ = cdDir$ + "/"
		endif
		& getinfo cdDir$,i$
	endif

	if i$ = "" then 
		print "CS not installed"
		goto Exit
	endif

	print "NOTE: Conference and topic names must be legal filenames!"
	print "(Start with a letter.  Use '.' for spaces.  15 letters max.)"
	print 

	& read (15),"New conference name:  ",confName$
	& spc(confName$), confName$
	on a$ = "" goto Exit
	& lcase(confName$)

	& getinfo cdDir$ + confName$,i$
	if i$ > "" then 
		print "That conference already exists!"
		goto Exit
	else
		if ERR <> 7 then
			print "That's an illegal filename!"
			goto Exit
		endif
	endif

	print "Make "confName$" an open conference";
	gosub GetYN_Y
	confStatus% = y%

	i$ = ID$[uName]
	& read (-15, i$),"Moderator's username: ",moderator$
	& lcase(moderator$)

	print "Enter description" \
		" (or press RETURN to omit from Conference Listing):"
	print
	& hlin 7, 9
	print "      ]";
	& ioctl (ioCR)
	& read (-61),"[",j$
	hideConf% = (j$ = "")

	print 
	print "Enter no more than "MAX_TOPICS" topic names, RETURN alone when done."
	print "(Remember, topic names must be legal file names!)"
	print 
	nt% = 0
	repeat
		print nt% + 1": ";
		& read (-15),a$
		& lcase(a$)
		& getinfo TEMP_PATH + a$, i$
		if ERR = 16 then
			print "That name is not a legal file name!"
		else
			if a$ = "info" or a$ = "i.." then
				print "Sorry, '"a$"' is reserved and can't be used for topic names."
			else
				topicName$[nt% + 1] = a$
				nt% = nt% + 1
			endif
		endif
	until nt% = MAX_TOPICS or a$ = ""

	nt% = nt% - (a$ = "")
	on not nt% goto Exit

	print 
	for j = 1 to nt%
		& lcase(topicName$[j])
		print "Is " topicName$[j] " read-only";
		gosub GetYN_N
		s%[j] = y%
		print "Is " topicName$[j] " a networked topic";
		gosub GetYN_N
		if y% then 
			& read (-70, host$),"     Posting address: ",a$
			if a$ = "" then goto ExitError
			& read (-70),"      Newsgroup name: ",i$
			host$ = a$
			if i$ > "" then a$ = a$ + ";" + i$
			netAddress$[j] = a$
			print       "   Attach signatures";
			gosub GetYN_Y
			sig%[j] = y%
		endif
		if netAddress$[j] > "" then
			netAddress$[j] = ":" + netAddress$[j] + ":" + \
				str$(sig%[j])
		endif
		print 
	next 

	print "OK to create the '" confName$ "' conference";
	gosub GetYN_Y
	on not y% goto Exit

	print 
	print "Creating "confName$"...";
	fCreate cdDir$ confName$
	for i = 1 to nt%
		topicDir$ = cdDir$ + confName$ + "/" + topicName$[i]
		fCreate topicDir$
	next 

	fOpen cdDir$ confName$ indexFile$
	fWrite cdDir$ confName$ indexFile$
	print moderator$
	print confStatus% "," nt%
	for i = 1 to nt%
		print topicName$[i] netAddress$[i]
		print s%[i] ",0,0"
	next 
	fClose
	print "done"

	print
	if not hideConf% then gosub updateList
goto Exit


updateList:
	print "Sort new conference listing";
	gosub GetYN_Y
	print "Updating conference listing...";
	& left$ (confName$, 16), confName$
	confName$ = confName$ + chr$(42 - confStatus% * 10) + " " + j$
	if y% then
		fOpen csListFile$
		fRead csListFile$
		onerr goto _listEOF
		j = 0
		do
			j = j + 1
			& get listLine$[j]		
		loop
		_listEOF:
		& onerr
		onerr goto HandleError
		fClose
		listLine$[j] = confName$
		& sort (listLine$, j)
		
		fOpen csListFile$
		fWrite csListFile$
		for i = 1 to j
			print listLine$[i]
		next
	else
		fAppend csListFile$
		print confName$
	endif
	fClose
	print "done!"
return

GetYN_N:
	i = FALSE
	goto GetYN

GetYN_Y:
	i = TRUE

GetYN:
	print "? " left$ (y$[i],1)"^H";
	& clear 
	& rept
		get a$
		& ucase(a$)
		& pos ("^M" + "YN",a$),y%
	& until(y%)
	y% = (a$ = "Y")
	if a$ = "^M" then y% = i
	print y$[y%]
return 


#include <proline/proline.lib>
