' **********************************************************************
' ***
' ***	Menu.h		TextToolbox Menu Manager interfaces
' ***			Copyright (C) 1993 Morgan Davis Group
' ***

#pragma once

#define menuCancelEvt	-1	' TrackMenu events
#define menuNullEvt	0

#define vertMenu	0	' Menu types
#define horizMenu	1

#define errBeepFreq	90
#define errBeepDur	20

#define NewMenu(type, x, y, spacing, count, defItem, title) \
		menuType = type : menuX = x : menuY = y : menuItems = count :\
		menuItem = defItem : menuSpacing = spacing : \
		menuTitle$ = title : gosub _NewMenu

#define MenuWidth(count, size) \
		menuItems = count : gosub _MenuWidth : size = menuWidest

#define MenuPrompt(x, y, prompt) \
		mPromptX = x : mPromptY = y : mPromp$ = prompt : \
		gosub _MenuPrompt

#define TrackMenu(result) \
		gosub _TrackMenu : result = menuResult

#define GetMenuItem(item) \
		repeat : gosub _TrackMenu : item = menuResult : until item > 0

#define HiliteItem(item, flag) \
		menuItem = item : hiliteFlag = cNormal+flag : gosub _HiliteItem

#define DisposeMenu \
		gosub _DisposeMenu

#define MenuStartup \
		gosub _MenuStartup

#define MenuShutdown \
		gosub _MenuShutdown
