' ============================================================
'
' romcall.h	- Apple II monitor ROM entry points
'		  Copyright (C) 1993 Morgan Davis Group
'
' ============================================================

#pragma once

	' Applesoft ROM

#define _ERROR		$d412
#define _STKINI 	$d683
#define _NEWSTT 	$d7d2
#define _GOLINE 	$d935
#define _DATA		$d995
#define _ADDISP 	$d998	' adjusts text pointer
#define _LET2		$da63
#define _STROUT 	$db3a	' basic's string printer
#define _FRMNUM 	$dd67
#define _CHKNUM 	$dd6a
#define _CHKSTR 	$dd6c
#define _FRMEVL 	$dd7b
#define _PARCHK 	$deb2
#define _CHKCLS 	$deb8
#define _CHKOPN 	$debb	' misc Applesoft routines...
#define _CHKCOM 	$debe
#define _SYNCHR 	$dec0
#define _PTRGET 	$dfe3
#define _FPINT		$e10c	' FAC->INT ($A0,$A1 = high,low)
#define _BADSUB 	$e196
#define _ILLQUAN	$e199
#define _GIVAYF 	$e2f2	' more misc FP routines
#define _UNDFNC 	$e303
#define _ILLDIR 	$e306	' prints ILLEGAL DIRECT ERROR
#define _STRSPA 	$e3dd
#define _STR2LNG	$e5b2
#define _MOVSTR 	$e5e2
#define _GETBYTE	$e6f8
#define _CONINT 	$e6fb
#define _COMBYTE	$e74c
#define _GETADR 	$e752
#define _MOVFM		$eaf9
#define _MOVMF		$eb2b
#define _FLO2		$eba0	' fac floater
#define _FCOMP		$ebb2
#define _FIN		$ec4a	' eval fp number at txtptr -> FAC
#define _LINPRT 	$ed24	' Print X,A in decimal
#define _FOUT		$ed34
#define _RND		$efae
#define _HGR2		$f3d8
#define _HGR		$f3e2
#define _HCLR		$f3f2	' clear cur hires page to black
#define _BKGND		$f3f6	' clear cur hires page to hcolor1 ($1c)
#define _HPOSN		$f411	' Y in a-reg, XL in x, XH in y
#define _HPLOT0 	$f457	'     " 	"	"
#define _HLIN		$f53a	' Y in y-reg, XL in a, XH in x
#define _HCOLOR 	$f6f0	' color (0-7) in X
#define _GETARY 	$f7d9


	' Monitor ROM
        
#define _CLRSCR 	$f832	' Clear lo-res to black
#define _CLRTOP 	$f836	' Clear top 40 rows of lo-res
#define _NXTCOL 	$f85f	' Add 3 to current lo-res color
#define _PRBLNK 	$f948	' Print 3 spaces
#define _TEXT2COPY	$f962	' Manipulate text page 2 shadowing
#define _BREAK		$fa4c	' Call BRK handler
#define _RESET		$fa62	' Call RESET handler
#define _INIT		$fb2f	' Init text display
#define _SETTXT 	$fb39	' Sane as TEXT
#define _SETGR		$fb40	' Same as GR
#define _SETWND 	$fb4b	' Set text window to current bounds
#define _APPLEII	$fb60	' Display computer's name
#define _SETPWRC	$fb6f	' Set power-up compliment
#define _KBDWAIT	$fb88	' Wait for key, then print it
#define _BASCALC	$fbc1	' Determine cursor's video address
#define _BELL1		$fbdd	' Beep
#define _ADVANCE	$fbf4	' Cursor right
#define _BS		$fc10	' Cursor left
#define _UP		$fc1a	' Cursor up
#define _VTAB		$fc22	' VTAB to row in $25
#define _CLREOP 	$fc42	' Clear to end of page
#define _HOME		$fc58	' Same as HOME
#define _CR		$fc62	' Do a CR/LF
#define _LF		$fc66	' Do LF only
#define _SCROLL 	$fc70	' Scroll screen up
#define _CLREOL 	$fc9c	' Clear to end of line
#define _RDKEY		$fd0c	' Show cursor, get keypress
#define _RDCHAR 	$fd35	' Same as RDKEY, allow ESC movements
#define _GETLNZ 	$fd67	' Do CR/LF, call GETLN
#define _GETLN		$fd6a	' Print char at $33, call GETLN1
#define _GETLN1 	$fd6f	' Get a line of input
#define _CROUT1 	$fd8b	' CLREOL, then CROUT
#define _CROUT		$fd8e	' Print a CR
#define _PRA1		$fd92	' CROUT, print $3C/$3D in hex
#define _SETINV 	$fe80	' INVERSE
#define _SETNORM	$fe84	' NORMAL
#define _SETKBD 	$fe89	' IN#0
#define _SETVID 	$fe93	' PR#0
#define _PRERR		$ff2d	' Print "ERR", then BELL
#define _BELL		$ff3a	' Beep
#define _MON		$ff65	' Enter monitor
