' ======================================================================
'
' parse.h	Command line string parsing tools
'		(C)opyright 1994 Morgan Davis Group
'
' ======================================================================

#pragma once

#reserve PARSE

#define	PARSER_NAME	"Parse"		' Shell utility module
#define PARSER_ID	$2024		' or '$ '

#define	ParseEscapes(ch,op,arg,s1,s2)	& parse, 0, ch, op, arg, s1, s2
#define ParseVarLen(s,n)		& parse, 1, s, n
#define ParseQuotes(ch,s1,s2)		& parse, 2, ch, s1, s2
#define	ParseSpaces(s1,s2)		& parse, 3, s1, s2

#define	ParseBackslashes(s1,s2)		ParseEscapes(92, $05, $80, s1, s2)
#define	ParseControls(s1,s2)		ParseEscapes(94, $25, $1F, s1, s2)
#define	ParseTrim(s1,s2)		& spc(s1), s2
#define	ParseNormalize(s)		& asc(s)
