' **********************************************************************
' ***
' ***	MicroDot.h	BASIC.SYSTEM replacement
' ***			Copyright (C) 1990 J. Eric Bush
' ***

#pragma once

' **************************************************************************
' **
' **  The microdot.h file is for use with MD-BASIC and MicroDot.
' **  It will allow you to use all of the MicroDot &. commands as you would
' **  in a regular Applesoft program or with English equivalents
' **  pre-defined.  MD-BASIC gives you tight Applesoft code - MicroDot
' **  gives you an additional 7K of programming space!
' **
' **  MicroDot is available from:	Kitchen Sink Software Inc.
' **					903 Knebworth Court
' **					Westerville, OH  43081
' **			 or call:	614-891-2111
' **
' **					call or write  for free catalog
' **
' *************************************************************************

' *************************************************************************
' **
' ** Reserves the MicroDot Ampersand Commands as keywords so that
' ** MD-BASIC will not use them or recognize them as variables
' **
' *************************************************************************

#reserve A,BL,BO,BS,BX,C,D,F,G,IG,IS,K,L,M,N,O,PG,PS,Q,R,S,T,V,W,X,Z
#reserve E,HP,HU,JF,JG,JP,JR,JW,UB,US,Y

' *************************************************************************
' **
' ** _MICRODOT_H_ I/O commands to match the MD-BASIC <FILEIO.H> commands.
' ** 
' ** Note: That the following commands are not directly supported.  You
' **	   need to use the MicroDot equivalent listed in the next section.
' **
' **		fCreate 	use	    mMake
' **		fExec		use	    fOpen and fRead
' **		fFre		use	    mGarb (GARB module)
' **		fLock		use	    mGetInfo and mSetInfo    
' **		fMonitor    not available
' **		fPosition	use	    mPosition (RANDOM module)
' **		fPrefix 	use	    mGetPrefix or mSetPrefix
' **		fRestore    not available
' **		fStore	    not available
' **		fUnLock 	use	    mGetInfo and mSetInfo
' **
' *************************************************************************

#define fAppend 	&.A
#define fBLoad		&.BL,
#define fBRun		&.BX,
#define fBSave		&.BS,
#define fBye		&.Q
#define fClose		POKE 46047,0 : POKE 49044,0 : &.C
#define fDelete 	&.D,
#define fInPort 	POKE 56,0 : POKE 57,192+
#define fLaunch 	&.Q,
#define fOpen		&.O,
#define fOutPort	POKE 54,0 : POKE 55,192+
#define fRead		&.R
#define fRename 	&.N,
#define fRun		&.X,
#define fVerify 	&.F,
#define fWrite		&.W

' *************************************************************************
' **
' ** The following commands are features used by MicroDot not available
' ** in the FILEIO.H file for use with BASIC.SYSTEM
' **
' *************************************************************************

#define mOverlay	&.BO,	' Requires Filename, Line# or Address
#define mGetDir 	&.G	' Requires Variables for Name,Type,Aux
#define mGetInfo	&.IG,	' Requires Variables for Name,Type,Aux
#define mSetInfo	&.IS,	' Requires Variables for Name,Type,Aux
#define mKill		&.K	' Kill to end of File
#define mLoad		&.L	' Load file
#define mMake		&.M,	' Requires Variables for Name,Type
#define mGetPrefix	&.PG,	' Requires Variable for Prefix
#define mSetPrefix	&.PS,	' Requires Variable for Prefix
#define mTest		&.T	' Requires Variables for Name,Type
#define mVolume 	&.V	' Requires Variables for Slot,Drive
#define mZap		&.Z	' Zap Read/Write mode

' ************************************************************************
' **
' ** If you are using MicroDot's modules, then the following can be used
' **
' ************************************************************************

' ---===[[[ CAT40 or CAT80 modules ]]]===---

#define fCat		&.E	' Does CAT or CATALOG

' ---===[[[ GARB module ]]]===---

#define mGarb		_GARB_COLLECTOR_ = USR(0)

' ---===[[[ MULTI module ]]]===---

#define mOpen		&.O,	' Requires Variable for Reference Number
#define mSetBuffers	&.UB,	' Requires Variable for Number of Buffers
#define mSelectBuffer	&.US,	' Requires Variable for Reference Number

' ---===[[[ PACK module ]]]===---

#define mPack		&.HP	' Does Hi-Res PACK to Opened File
#define mUnPack 	&.HU	' Does Hi-Res UNPACK from Opened File

' ---===[[[ RANDOM module ]]]===---

#define mSkipFields	&.JF	' Requires Variable for Skip
#define mGetPointer	&.JG,	' Requires Vairable for Pointer
#define mPosition	&.JP,	' Requires Variable for Position
#define mRead		&.JR,	' Requires Variables for Address & Length
#define mWrite		&.JW,	' Requires Variables for Address & Length


' ---===[[[ SYSCALL module ]]]===---

#define mSysCall	&.Y,	' Requires Variables for MLI#,Pointer,Error
