' ============================================================
'
' appleio.h	Apple II I/O & common memory locations
'		Copyright (C) 1993 Morgan Davis Group
'
' ============================================================

#pragma once

#define _PAGE0		$00	' Start of zero page
#define _USRJMP 	$0a	' Applesoft USR jmp instruction
#define _SHAPEL 	$1a	' Shape list pointer
#define _WNDLFT 	$20	' Window edge left (0-79)
#define _WNDWID 	$21	' Window width (1-80)
#define _WNDTOP 	$22	' Window's top row (0-22)
#define _WNDBOT 	$23	' Window's bottom row (1-24)
#define _CH		$24	' Cursor X pos'n (40 col only)
#define _CV		$25	' Cursor Y pos'n
#define _BASL		$28	' Cusror's video RAM loc'n
#define _INVFLG 	$32	' Inverse flag
#define _PROMPT 	$33	' Input prompt
#define _ERRFLG 	$d8	' ONERR active if >$7F
#define _ERRLIN 	$da	' Line where error occured
#define _ERRNUM 	$de	' Error code

#define _STACK		$0100	' Stack

#define _INBUF		$0200	' Input buffer

#define _PAGE3		$0300	' Page 3 (free) space
#define _WARMDOS	$03d0	' Warm DOS restart
#define _BRKV		$03f0	' BRK vector
#define _SOFTEV 	$03f2	' Reset vector
#define _PWREDUP	$03f4	' Power-up compliment byte
#define _AMPERV 	$03f5	' Ampersand vector
#define _USRADR 	$03f8	' Control-Y user vector
#define _NMI		$03fb	' NMI vector
#define _IRQLOC 	$03fe	' IRQ vector

#define _VIDBUF 	$0400	' Start of 40 col video
#define _CH80		$057b	' Cursor X pos'n (80 col only)
#define _VIDLAST	$07f7	' End of 40 col video (last character)

#define _HGRBUF1	$2000	' Start of low HGR buffer

#define _HGRBUF2	$4000	' Start of high HGR buffer

#define _BI_GLOBALS	$be00	' BASIC Interpreter global page

#define _MLI_GLOBALS	$bf00	' ProDOS MLI global page

#define _KBD		$c000	' Keyboard input register
#define _KBDSTRB	$c010	' Keyboard strobe
#define _MONOCOLOR	$c021	' Monochrome/color selector
#define _TBCOLOR	$c022	' Text/background color
#define _MOUSEDATA	$c024	' Mouse X/Y data
#define _KEYMODREG	$c025	' Keyboard modifiers
#define _KMSTATUS	$c027	' Keyboard/mouse status
#define _NEWVIDEO	$c029	' Misc video selector
#define _SLTROMSEL	$c02d	' Int/Ext slot ROM selectors
#define _SPKR		$c030	' Speaker toggle
#define _CLOCKCTL	$c034	' Clock control / border selector
#define _CYAREG 	$c036	' CPU speed / drive motor detect
#define _MMDELTAX	$c044	' Mouse X delta
#define _MMDELTAY	$c045	' Mouse Y delta
#define _TXTCLR 	$c050	' Set graphics
#define _TXTSET 	$c051	' Set text
#define _MIXCLR 	$c052	' Full graphics
#define _MIXSET 	$c053	' Set text/graphics
#define _TXTPAGE1	$c054	' Set page 1
#define _TXTPAGE2	$c055	' Set page 2
#define _LORES		$c056	' Lo-res
#define _HIRES		$c057	' Hi-res
#define _CLRAN0 	$c058	' Clear #0
#define _SETAN0 	$c059	' Set #0
#define _CLRAN1 	$c05a	' Clear #1
#define _SETAN1 	$c05b	' Set #1
#define _CLRAN2 	$c05c	' Clear #2
#define _SETAN2 	$c05d	' Set #2
#define _CLRAN3 	$c05e	' Clear #3
#define _SETAN3 	$c05f	' Set #3
#define _BUTN3		$c060	' Switch #3
#define _BUTN0		$c061	' Switch #0 (Command Key)
#define _BUTN1		$c062	' Switch #1 (Option Key)
#define _BUTN2		$c063	' Switch #2
#define _PADDL0 	$c064	' Paddle #0
#define _PADDL1 	$c065	' Paddle #1
#define _PADDL2 	$c066	' Paddle #2
#define _PADDL3 	$c067	' Paddle #3
#define _PTRIG		$c070	' Paddle trigger timer
