' **********************************************************************
' ***
' ***	manps.b		ProLine manual-to-PostScript generator
' ***			(C)opyright 1994 Morgan Davis
' ***

#define	IDENT_PROG "manps"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "19mar92"
#define	IDENT_NAME "Morgan_Davis"

#define	LINES_PER_PAGE	50
#define	PAGE_WIDTH	92

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit

	options$ = "Ee?w:l:capt:"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" then all = TRUE
		if optchar$ = "c" then includeCover = TRUE
		if optchar$ = "e" then evenUp = TRUE
		if optchar$ = "E" then evenUpAll = TRUE
		if optchar$ = "l" then pageLen = val(optarg$)
		if optchar$ = "p" then progress = TRUE
		if optchar$ = "w" then pageWidth = val(optarg$)
		if optchar$ = "?" then usage = TRUE
		if optchar$ = "t" then CoverTitle$ = optarg$
	until optchar$ = ""

	if (nargc < 2) or usage then goto ShowUsage

	cm$ = "--.TH.DA.LM.RM.PP.CN.SP.RC.BR.AF.UC.NP.IF.IP.SH.TB"
	order$ = MAN_LIST
	if CoverTitle$ > "" then
		header$ = "ProLine " + CoverTitle$
	else
		header$ = "ProLine Reference Manual"
	endif

	psprep$ = ETC_PATH + "psprep"

	if asc(nargv$[nargc-1]) = 62 then
		AccFile$ = mid$(nargv$[nargc-1],2)
		if asc(AccFile$) = 62 then
			& spc(AccFile$, 62), AccFile$
			AccMode = accWrite
		else
			& getinfo AccFile$, i$
			AccMode = accWrite + (accDelete * (i$ > ""))
		endif
		gosub CheckAccess
		if not AccOK then 
			print argv$[0]": cannot open " AccFile$
			goto Exit
		endif
		if AccMode = accWrite + accDelete then fDelete AccFile$
		nargc = nargc - 1
		outputFile$ = AccFile$
	endif

	argBegin = 1
	if nargv$[1] > "_" then
		a$ = RSRC_PATH + "man.rsrc"
		& getinfo a$, i$
		if i$ > "" then
			fOpen a$
			fRead a$
			& get order$
			fClose
		endif
	else
		if nargv$[1] = "*" then
			print argv$[0]": section not specified"
			goto Exit
		endif
		if nargc < 3 then goto ShowUsage
		order$ = nargv$[1]
		if nargv$[2] = "*" then
			& pos (order$, ":"), p
			if p then order$ = left$(order$, p - 1)
			manFile$ = MAN_PATH + "man." + order$
			& files(manFile$, nargv$),i,i
			if not i then goto Exit
			& erase (nargv$)
			nargc = i + 1
			dim nargv$[nargc]
			& files(manFile$, nargv$),i
			& sort(nargv$,i)
			star = TRUE
		else
			argBegin = 2
		endif
	endif
	orderLen = len(order$)

	globalPage = 1
	curArg = argBegin
	repeat
		theTitle$ = nargv$[curArg]
		gosub FindManual
		curArg = curArg + 1
	until curArg = nargc
	if globalPage > 1 then
		if evenUpAll and not mod(globalPage, 2) then
			gosub checkHeader
			gosub doFooter
		endif
		print "%%Pages: " globalPage - 1
	endif
	if openedFile then fClose outputFile$
goto Exit

ShowUsage:
	print "Usage: " argv$[0] " [-aceEp] [-l length] [-w width] [section] title ..."
goto Exit


FindManual:
	found = FALSE
	curDir = 1
	repeat
		& pos (curDir, order$, ":"), p
		if not p then p = orderLen + 1
		tag$ = "." + mid$(order$, curDir, p - curDir)
		curDir = p + 1
		manFile$ = MAN_PATH + "man" + tag$ + "/" + theTitle$
		if not star then manFile$ = manFile$ + tag$
		& getinfo manFile$, i$
		if i$ > "" then
			found = TRUE
			gosub ShowManual
			if not all then return
		endif
	until curDir > orderLen
	if found then return

	manFile$ = MAN_PATH + "index"
	fOpen manFile$
	fRead manFile$
	onerr goto indexEOF
	do
		& get a$
		if a$ > "" then
			& pos (a$, " "), p
			if theTitle$ = left$(a$, p - 1) then
				& spc (mid$(a$, p + 1)), theTitle$
				fClose manFile$
				goto FindManual
			endif
		endif
	loop
	indexEOF:
	& onerr
	fClose manFile$
	print argv$[0]": no entry for " theTitle$
return


ShowManual:
	if progress then
		& lcase(manFile$)
		& print argv$[0]": processing " manFile$
	endif

	if not pageLen then pageLen = LINES_PER_PAGE
	if not pageWidth then pageWidth = PAGE_WIDTH

	autoFill = TRUE
	inited = FALSE
	title$ = "Untitled"
	date$ = "<No Date>"

	if not openedFile and outputFile$ > "" then 
		fAppend outputFile$
		openedFile = TRUE
	endif

	if not prepped then
		ignore = FALSE
		fOpen psprep$
		onerr goto prepEOF
		do
			fRead psprep$
			& get i$
			if i$ = "%%BeginCoverProc" then
				ignore = not includeCover
			endif
			if not ignore then
				if openedFile then fWrite outputFile$
				print i$
			endif
			if i$ = "%%EndCoverProc" then ignore = FALSE
		loop
		prepEOF:
		& onerr
		fClose psprep$
		onerr goto HandleError
		prepped = TRUE
		if includeCover then
			if openedFile then fWrite outputFile$
			print
			print "%%Page: Cover"
			print "(" coverTitle$ ") cover"
			if evenUp or evenUpAll then print "showpage"
		endif
	endif
	
	fFre
	fOpen manFile$
	onerr goto mfEOF

	do
		again:
		fRead manFile$
		repeat
			& get a$
			if autoFill then &spc(a$), a$
		until a$ > ""
		if openedFile then fWrite outputFile$
		if asc(a$) <> 46 then
			gosub printString
			goto again
		endif

		& pos (cm$, left$ (a$,3)),p
		if not p then goto again

		a$ = mid$ (a$,5)
		i = val (a$)
		on p / 3 gosub cmdTH, cmdDA, cmdLM, \
			cmdRM, cmdPP, cmdCN, cmdSP, \
			cmdRC, cmdBR, cmdAF, cmdUC, cmdNP, \
			cmdIF, cmdIP, cmdSH, cmdTB
	loop

	mfEOF:
	onerr goto HandleError
	& onerr e,l
	fClose manFile$
	if e <> 5 then goto HandleError
	
	if openedFile then fWrite outputFile$
	if header then gosub doFooter
	if (evenUp and not mod(pg, 2)) then
		gosub checkHeader
		gosub doFooter
	endif
	print "%%EndDocument"
return

checkHeader:
	if not inited then
		gosub doInit
	else
		if not header then
			print "%%Page: " globalPage
			print "header"
			header = TRUE
			ln = 0
			if not autoFill then print "mono"
		endif
	endif
return

newBreak:
	if not ln then return

doBreak:
	gosub checkHeader
	print "nl"
nextLine:
	ln = ln + 1
	if ln > pageLen then gosub doFooter
updateCP:
	cp = sp + inp
return 


doInit:
	print
	print "%%BeginDocument: " manFile$
	print "%%Page: 1"
	print "(" header$ ")"
	print "(" title$ ")"
	print "(Revised " date$ ")"
	& time(t$)
	print "(Printed" mid$ (t$,5,10) ")"
	print "init"
	header = TRUE
	sp = 5
	uc$ = "_"
	inp = 0
	pg = 1
	ln = 0
	inited = TRUE
return


printString:
	if not autoFill then
		i$ = a$
		gosub quoteChars
		gosub checkHeader
		print "(" i$ ") wl"
		goto nextLine
	endif


	if len(a$) + cp < pageWidth then
		& spc(theLine$ + " " + a$), theLine$
		cp = cp + len(a$) 
	else
		p = 0
		repeat
			q = p + 1
			& pos (q, a$ + " ", " "), p
		until (p + cp) > pageWidth
		if q > 1 then
			& spc(theLine$ + " " + left$(a$, q - 1)), theLine$
		else
			q = 1
		endif
		gosub flushLine
		theLine$ = mid$(a$, q)
		cp = cp + len(theLine$)
	endif
return

flushLine:
	if theLine$ > "" then
		i$ = theLine$
		gosub quoteChars
		c$ = "l"
		gosub DumpIt
		theLine$ = ""
		gosub nextLine
	endif
return		

flushIt:
	if theLine$ > "" then
		i$ = theLine$
		gosub quoteChars
		c$ = "r"
		gosub DumpIt
		theLine$ = ""
	endif
return


' Escape (, ), and \

quoteChars:
	c$ = "\"
	gosub quoteIt
	c$ = "("
	gosub quoteIt
	c$ = ")"
quoteIt:
	qp = 0
	repeat
		qq = qp + 1
		& pos (qq, i$, c$), qp
		if qp then
			i$ = mid$(i$, 1, qp - 1) + "\" + mid$(i$, qp)
			qp = qp + 1
		endif
	until not qp
return

dumpIt:
	gosub checkHeader
	& pos (i$, uc$), qp
	if qp then
		& pos (qp + 1, i$, uc$), qq
		if not qq then qq = len(i$)
		if qp > 1 then print "(" mid$(i$, 1, qp - 1) ") wr"
		print "(" mid$(i$, qp + 1, qq - qp - 1) ") iw"
		i$ = mid$(i$, qq + 1)
		goto dumpIt
	else
		if i$ > "" then
			print "(" i$ ") w" c$
		else
			if c$ = "l" then print "nl"
		endif
	endif
return


	
' --------------------
' dot functions
' --------------------

cmdTH:
	& pos(a$, " "), q
	if not q then
		title$ = a$
	else
		title$ = left$(a$, q - 1) + "(" + mid$(a$, q + 1) + ")"
	endif
return

cmdDA:
	date$ = a$
return 

cmdLM:
	gosub flushLine
	sp = sp + i
	print i " alm"
goto updateCP

cmdRM:
	gosub flushLine
	pageWidth = pageWidth + i
return 

cmdPP:
	gosub flushIF2
	gosub newBreak
	if a$ > "" then
		i$ = a$
		gosub quoteChars
		gosub checkHeader
		print "(" i$ ") pp"
		gosub nextLine
	endif
return

cmdCN:
	gosub flushLine
	i$ = a$
	gosub quoteChars
	gosub checkHeader
	print "(" i$ ") cj"
goto doBreak

cmdSP:
	a$ = "  "
	if not i then i = 1
cmdRC:
	gosub flushIt
	if not i then i = pageWidth
	if cp + i > pageWidth then i = pageWidth - cp
	& pos (a$," "),p
	a$ = mid$ (a$,p + 1)
	gosub checkHeader
	print "tabin " i " { (" a$ ") show } repeat"
	cp = cp + i
return

cmdBR:
	for j = 1 to i
		if theLine$ > "" then
			gosub flushLine
		else
			gosub newBreak
		endif
	next 
return 

cmdAF:
	if a$ = "" then
		autoFill = not autoFill
	else
		autoFill = i
	endif
	gosub flushLine
	gosub checkHeader
	if autoFill then
		print "text"
	else
		print "mono"
	endif
return 

cmdUC:
	uc$ = a$
return 


flushIF2:
	gosub flushLine
	if 2 + ln >= pageLen then goto doFooter
return

cmdIF:
	gosub flushLine
	if i + ln < pageLen then return 
cmdNP:
doFooter:
	gosub flushLine
	print "footer"
	ln = 0
	header = FALSE
	pg = pg + 1
	globalPage = globalPage + 1
return


cmdIP:
	gosub flushIF2
	gosub newBreak
	& pos (a$," "),j
	if j then
		inp = val (left$(a$,j))
		i$ = mid$ (a$, j + 1)
		gosub quoteChars
		gosub checkHeader
		print inp " (" i$ ") ips"
	else
		inp = i
		gosub checkHeader
		print inp " ip"
	endif
goto updateCP


cmdSH:
	gosub flushIF2
	gosub newBreak
	i$ = a$
	gosub quoteChars
	gosub checkHeader
	print "(" i$ ") sh"
goto nextLine


cmdTB:
	gosub flushIt
	gosub checkHeader
	if i + sp > cp then
		print i " tb"
		cp = i + sp
	endif
return 


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
