' ************************************************************************
' **									**
' **  wc.b -		Word count					**
' **			Copyright (C) 1990 Morgan Davis	Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 27sep90 mwd 1.0	Created.					**
' **									**
' ************************************************************************

#define IDENT_PROG "wc"
#define IDENT_VERS "1.0"
#define IDENT_DATE "26sep90"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	wc		$300

#define	FROM_END	1
#define	FROM_START	2


' ====================
' Wc
' ====================

	gosub AppInit
	if argc < 2 then
		print "Usage: " argv$[0] " [ -lwc ] file ..."
		goto Exit
	endif

	showLines = TRUE
	showWords = TRUE
	showChars = TRUE
	argp = 1

	repeat
		repeat
			theFile$ = argv$[argp]
			if asc(theFile$) = 45 then
				i$ = mid$(theFile$, 1)
				& pos (i$, "l"), showLines
				& pos (i$, "w"), showWords
				& pos (i$, "c"), showChars
				argp = argp + 1
				if argp = argc then goto Exit
			endif
		until asc(theFile$) <> 45
		gosub doWordCount
		argp = argp + 1
	until argp => argc
goto Exit

doWordCount:
	& GETINFO theFile$, i$
	if i$ = "" then
		print argv$[0] ": " theFile$ " not found"
		goto Exit
	endif

	AccFile$ = theFile$
	AccMode = accRead
	gosub CheckAccess
	if not AccOK then
		print argv$[0] ": can't access " theFile$
		goto Exit
	endif
	
	fOpen theFile$ ",t" asc(mid$(i$, 5))
	poke _SREFNUM, peek(_OREFNUM)
	& MLI (_GET_EOF, _SGETEOF), i
	bytes = peek24(_SEOF)
	lines = 0
	words = 0

	& poke wc, \
	    $A0,$00,$84,$00,$84,$01,$AE,$DB,$BE,$D0,$01,$60,$B9,$00,$02,$C9,\
	    $0D,$D0,$05,$E6,$00,$4C,$20,$03,$C9,$09,$F0,$04,$C9,$20,$D0,$07,\
	    $A9,$00,$F0,$0C,$EA,$EA,$EA,$AD,$38,$03,$D0,$07,$E6,$01,$A9,$01,\
	    $8D,$38,$03,$C8,$CA,$D0,$D5,$60,$00

	poke _RWREFNUM, peek(_OREFNUM)
	poke16 (_RWDATA, $200)
	poke24 (_RWCOUNT, $FF)
	repeat
		& MLI (_READ, _SREAD), i
		if not i then
			call wc
			lines = lines + peek(0)
			words = words + peek(1)
		endif
	until i

	fClose

	if showLines then
		& right$(str$(lines), 6), i$
		print i$ "  ";
	endif
	if showWords then
		& right$(str$(words), 6), i$
		print i$ "  ";
	endif
	if showChars then
		& right$(str$(bytes), 8), i$
		print i$ "  ";
	endif
	print theFile$
return

#include <proline/proline.lib>
#include <proline/access.lib>
