' **********************************************************************
' ***
' ***	unpar.b		ProLine unArchive utility
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define IDENT_PROG "unpar"
#define IDENT_VERS "3.0"
#define IDENT_DATE "21may94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>


' ====================
' Main:
' ====================

	gosub AppInit
	if argc < 2 then 
		print "Usage: " argv$[0] " [-dlr] file ..."
		goto Exit
	endif

	dirsame = SuperUser
	extract	= TRUE
	replace	= FALSE

	buf	= 768
	typ	= buf + 4
	siz	= buf + 20
	nam	= buf + 23
	lft	= buf + 127

	def fn eof(x) = peek(x) + peek(x+1) * 256 + peek(x+2) * 65536
	ty$ = "^D^F^O" + chr$($2B) + chr$($F0) + chr$($FC) + chr$($FF) + chr$(0)
	ta$ = "--TXTBINDIR8OBCMDBASSYS-?-"

	for file = 1 to argc - 1
		f$ = argv$[file]
		if asc(f$) = 45 then
			if f$ = "-d" then dirsame = FALSE
			if f$ = "-l" then extract = FALSE
			if f$ = "-r" then replace = TRUE
		else
			gosub UnparFile
		endif
	next file
goto Exit


UnparFile:
	sz	= 0
	ba	= 0

	& GETINFO f$, i$
	if i$ = "" then 
		print f$": not found"
		return
	endif

	if extract and not dirsame then gosub GetParentDirInfo
	
	ty% = asc (mid$ (i$,5))
	off = 0
	AccFile$ = f$
	AccMode = accRead
	gosub TellAccess
	if not AccOK then return 

	print "Type  Bytes  Pathname"
	& str$ (40,45)
	print 

	repeat
		fBload f$ ",A" buf ",B" off ",L128,T" ty%
		if peek(buf) + peek(buf+1) + peek(buf+2) + peek(buf+18) <> 159 then 
			print f$ ": not a par file"
			num = 0
		else
			gosub ShowFileInfo
			if extract then gosub ExtractFile
			n = i / 128
			off = off + 128 + 128 * (int (n) + (n > int (n)))
		endif
	until not num
	print
return

ExtractFile:		
	AccMode = accWrite
	AccFile$ = b$
	gosub TellAccess
	if not AccOK then return

	& GETINFO b$,info$
	if info$ > "" then
		if fType = 15 then return		' directory exists
		if not replace then 
			print "^I^I...exists, replace? (y,n,r,q) ";
			& rept
				get info$
				& lcase(info$)
				& pos ("yrnq", info$), p
			& until (p)
			print info$
			if p > 2 then
				if p = 4 then num = 0
				return
			endif
			replace = p = 2
		endif
		AccMode = accDelete
		AccFile$ = b$
		gosub TellAccess
		if not AccOK then return
		fDelete b$
	endif

	tc = 0
	wc = 0
	ptr = off + 128
	info$ = ""
	for p = 0 to 17
		info$ = info$ + chr$(peek(buf + p))
	next 

	if fType = 15 then 
		fCreate b$
		if not dirsame then & mid$(info$, 6) = parentInfo$
	else
		fFre
		sz = fre(0) - 2048
		ba = (peek(109) + peek(110) * 256) + 256
		if sz < 256 then 
			print argv$[0]": out of mem"
			goto Exit
		endif
		& rept
			fBload f$ ",A" ba ",B" ptr ",L" sz ",T" ty%
			wc = sz
			if tc + wc > i then 
				wc = i - tc
			endif
			fBsave b$ ",A" ba ",B" tc ",L" wc
			tc = tc + wc
			ptr = ptr + wc
		& until (tc = i)
	endif

	& SETINFO b$,info$
return


ShowFileInfo:
	b$ = ""
	for i = 1 to peek(nam)
		b$ = b$ + chr$(peek(nam + i))
	next 
	fType = peek(typ)
	if fType = 15 then
		i = 0
	else
		i = fn eof(siz)
	endif
	& right$ (str$ (i),6),j$
	& pos (ty$, chr$ (fType)),p
	if not p then p = len (ty$)
	print mid$(ta$,p * 3,3) "  " j$ "  " b$
	num = peek(lft)
return


TellAccess:
	gosub CheckAccess
	if not AccOK then print "-- access denied"
return


GetParentDirInfo:
	fPrefix
	& get curDir$
	curDir$ = left$(curDir$, len(curDir$) - 1)
	& pos (2, curDir$, "/"), p
	if p then
		& getinfo curDir$, parentInfo$
		parentInfo$ = mid$(parentInfo$, 6, 2)
	else
		parentInfo$ = chr$(0) + chr$(0)
	endif
return


#include <proline/proline.lib>
#include <proline/access.lib>
