' **********************************************************************
' ***
' ***	sx.b	Send XMODEM / YMODEM
' ***		(C)opyright 1994 Morgan Davis Group
' ***

#ifndef ZMODEM

#define	IDENT_PROG "sx"
#define	IDENT_VERS "3.0"
#define IDENT_DATE "20jan94"
#define	IDENT_NAME "Morgan_Davis"

#define	MODULE "SX"

#include <omm.h>
#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

	gosub AppInit

	Result$[xferOK]		= "successful!"
	Result$[xferFail]	= "stopped due to errors"
	Result$[xferCancel]	= "cancelled"

	q$ = chr$(34)
	prodos$ = "X"		' Default is ProDOS *off*
	
	options$ = "pydfbcklt?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then
			showUsage = TRUE
		else
			if optchar$ = "p" then
				prodos$ = ""
			else
				flags$ = flags$ + optchar$
			endif
		endif
	until optchar$ = ""

	flags$ = prodos$ + flags$
	& pos (flags$, "y"), i
	batchFlag = i > 0
	
	if showUsage or nargc < 2 then
		print "Usage: " argv$[0] " [ options ] file..."
		print "	-b	Apple Binary II mode"
		print "	-c	128/CRC"
		print "	-d	Double delay tolerance"
		print "	-f	Send full pathnames"
		print "	-k	1K/CRC"
		print "	-l	4K/CRC"
		print "	-p	Apple ProDOS mode"
		print "	-t	Text mode (converts newlines)"
		print "	-y	YMODEM batch"
		goto Exit
	endif
#endif ZMODEM

	& load get SysInfo$[plModulesDir] + MODULE

	xferType$ = mid$("XYZ", batchFlag + 1, 1)
	
	&ucase (flags$)
	fileIndex = 1
	sentOK = 0
	repeat
		AccFile$ = nargv$[fileIndex]
		gosub SendFile
		fileIndex = fileIndex + 1
	until fileIndex = nargc
	if batchFlag and sentOK then & snd("", flags$), r
goto Exit


SendFile:
	& getinfo AccFile$, i$
	if i$ = "" then
		print argv$[0]": " AccFile$ " not found"
		return
	endif

	t% = asc(mid$(i$, 5))

	AccMode = accRead
	gosub CheckAccess
	if not accOK then
		print argv$[0]": can't send " AccFile$
		return
	endif

	if batchFlag then
		if fileIndex > 1 then goto SendOver
		print IDENT_PROG " " IDENT_VERS " sending " xferType$ "MODEM batch"
	else
		fOpen AccFile$ ",T" t%			' Open any filetype
		poke _SREFNUM, peek(_OREFNUM)		' Get number of bytes in file
		& MLI (_GET_EOF, _SGETEOF), r
		bytes = peek24(_SEOF)
		fClose
	
		print IDENT_PROG " " IDENT_VERS " sending "q$ AccFile$ q$
		print "File info: " bytes " bytes (" \
			int ((bytes + 127) / 128)" XMODEM blocks)"
	endif
	print "Start receiving now, or type several Control-X keys to cancel"

SendOver:
	& fn fnOutputMode, curOutMode
	& pr ioConsole
	print "### Send (" xferType$ ") ";
	& pr curOutMode
	& snd(AccFile$, flags$), r
	& pr ioConsole
	print ", " Result$[r]
	& pr curOutMode
	sentOK = sentOK + not r
return

#define	APP_AT_EXIT DumpTools
DumpTools:
	fClose
	& load fre SendTool_ID
return

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
