' **************************************************************************
' **
' **	setfile.b	Sets file attributes
' **			(C)opyright 1994 Morgan Davis Group
' **	Options:
' **
' **	-a attributes
' **	-at type
' **	-c date
' **	-m date
' **	-t type
' **	-s size
' **

#define IDENT_PROG "setfile"
#define IDENT_VERS "1.0"
#define IDENT_DATE "11apr91"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <ctype.h>
#include <prodos.h>
#include <proline/proline.h>

#define	CREATE_TAG	0
#define	MOD_TAG		1


	gosub AppInit
	if argc < 3 then
		print "Usage: " argv$[0] " [option...] file..."
		goto Exit
	endif

	doAttributes%	= FALSE
	doSize%		= FALSE
	doType%		= FALSE
	doAuxType%	= FALSE
	doModDate%	= FALSE
	doCreateDate%	= FALSE

	hex$  = "0123456789abcdef"
	attr$ = "rwi34bnd"
	flag$ = "1-a;2-at;3-c;4-m;5-t;6-s;"
	type$ = "badtxtbindiradbawpasps16execmdbasvarrelsys"
	tval$ = "$01$04$06$0f$19$1a$1b$b3$b5$f0$fc$fd$fe$ff"

	for optind = 1 to argc - 1
		if asc(argv$[optind]) = 45 then gosub ParseArg
	next

	noFileFlag = TRUE
	for optind = 1 to argc - 1
		if asc(argv$[optind]) = 45 then
			optind = optind + 1
		else
			noFileFlag = FALSE
			AccFile$ = argv$[optind]
			AccMode = accRead + accWrite + accDestroy
			gosub CheckAccess
			& getinfo AccFile$, info$
			if not AccOK or info$ = "" then
				print argv$[0] ": can't access " AccFile$
			else
				gosub SetFile
			endif
		endif
	next
	if noFileFlag then
		print argv$[0] ": no filename"
	endif
goto Exit


SetFile:
	oldType = asc(mid$(info$, 5))
	if oldType = 15 and (doSize% or doType% or doAuxType%) then
		print argv$[0] ": can't change size or type on " AccFile$ \
			" (directory)"
		return
	endif

	if doSize% then
		fOpen AccFile$ ",T" oldType
		poke _SREFNUM, peek(_OREFNUM)
		poke24 (_SEOF, newSize)
		& mli (_SET_EOF, _SSETEOF), errCode
		fClose AccFile$
		if errCode then
			print argv$[0] ": error setting size on " AccFile$
		endif
	endif

	if doType% then
		& mid$ (info$, 5) = chr$(newType)
	endif

	if doAuxType% then
		& mid$ (info$, 6) = chr$(LoByte(newAuxType))
		& mid$ (info$, 7) = chr$(HiByte(newAuxType))
	endif

	if doModDate% then
		tag = MOD_TAG
		gosub setDate
	endif

	if doCreateDate% then
		tag = CREATE_TAG
		gosub setDate
	endif

	if doAttributes% then
		& poke $301, \
			$A9, asc(mid$(info$, 4)), \
			$29, andAttr, \
			$09, orAttr, \
			$8D, $00, $03, \
			$60
		call $301
		& mid$ (info$, 4) = chr$(peek($300))
	endif

	& setinfo AccFile$, info$
return


ParseArg:
	arg$ = argv$[optind]
	& lcase(arg$)
	& pos (flag$, arg$ + ";"), p
	if not p then
		print argv$[0] ": unknown option '" arg$ "'"
		goto Exit
	endif

	optind = optind + 1
	if optind >= argc then
		print argv$[0] ": '" arg$ "' requires argument"
		goto Exit
	endif

	a$ = argv$[optind]
	p = val(mid$(flag$, p - 1))
	on p goto _a, _at, _c, _m, _t, _s

_a:
	andAttr = $FF
	orAttr = $00
	for i = 0 to len(a$) - 1
		c$ = mid$(a$, i + 1, 1)
		set = isupper(asc(c$))
		& lcase(c$)
		&pos (attr$, c$), p
		if not p then
			print argv$[0]": unknown attribute '"c$"'"
			goto Exit
		endif
		bits = 2 ^ (p - 1)
		if set then
			orAttr = orAttr + bits
		else
			andAttr = andAttr - bits
		endif
	next
	doAttributes% = TRUE
return

_at:
	maxNum = $FFFF
	gosub GetNumber
	newAuxType = n
	doAuxType% = TRUE
return

_c:
	tag = CREATE_TAG
	gosub parseDate
	doCreateDate% = TRUE
return

_m:
	tag = MOD_TAG
	gosub parseDate
	doModDate% = TRUE
return

_t:
	& lcase (a$)
	p = asc(a$)
	if (isalpha(p)) then
		& pos (type$, a$), p
		if not p or mid$(tval$, p, 1) <> "$" then
			print argv$[0] ": unknown type '" a$ "'"
			goto Exit
		endif
		a$ = mid$(tval$, p, 3)
	endif
	maxNum = $FF
	gosub GetNumber
	newType = n
	if newType = 15 then
		print argv$[0] ": can't change type to directory"
		goto Exit
	endif
	doType% = TRUE
return

_s:
	maxNum = $FFFFFF
	gosub GetNumber
	newSize = n
	doSize% = TRUE
return

#define	ValidDate(n,vmin,vmax)	_vn = n : _vmin = vmin : _vmax = vmax : \
				gosub _validDate
parseDate:
	&lcase (a$)
	if a$ = "." then
		mo[tag] = 0
		dd[tag] = 0
		yy[tag] = 0
		hh[tag] = 0
		mm[tag] = 0
		return
	endif
		
	mo[tag]	= val(mid$(a$, 1, 2))
	ValidDate (mo[tag], 1, 12)
	dd[tag] = val(mid$(a$, 4, 2))
	ValidDate (dd[tag], 1, 31)
	yy[tag] = val(mid$(a$, 7, 2))
	ValidDate (yy[tag], 0, 99)

	if len(a$) < 13 then
		& time(a$)
		a$ = mid$(a$, 16, 5)
	else
		a$ = mid$(a$, 10)
	endif
	hh[tag] = val(a$)
	if hh[tag] < 12 and mid$(a$, 7, 1) = "p" then
		hh[tag] = hh[tag] + 12
	endif
	if hh[tag] = 12 and mid$(a$, 7, 1) = "a" then
		hh[tag] = 0
	endif
	ValidDate (hh[tag], 0, 23)
	mm[tag] = val(mid$(a$, 4, 2))
	ValidDate (mm[tag], 0, 59)
return

_validDate:
	if _vn < _vmin or _vn > _vmax then
		print argv$[0] ": invalid date"
		goto Exit
	endif
return

setDate:
	if tag = MOD_TAG then
		x = 11
	else
		x = 15
	endif
	monthBit = mo[tag] > 7
	& mid$(info$, x) = chr$(dd[tag] + ((mo[tag] - (monthBit * 8)) * 32))
	& mid$(info$, x + 1) = chr$(yy[tag] * 2 + monthBit)
	& mid$(info$, x + 2) = chr$(mm[tag])
	& mid$(info$, x + 3) = chr$(hh[tag])
return


GetNumber:
	& lcase (a$)
	offset = (left$(a$,1) = "$") + (left$(a$,2) = "0x") * 2
	if offset then
		base = 16
	else
		base = 10
	endif
	i = 0
	n = 0
	while offset < len(a$)
		offset = offset + 1
		& pos (left$(hex$, base), mid$ (a$,offset,1)),p
		if not p then
			print argv$[0] ": bad digit in '" a$ "'"
			goto Exit
		endif
		n = n + (base ^ (len(a$) - offset) * (p - 1))
	wend
	if n > maxNum then
		print argv$[0] ": value > " maxNum
		goto Exit
	endif
return

	
#include <proline/proline.lib>
#include <proline/access.lib>
