' **********************************************************************
' ***
' ***	server.b	ProLine File Server
' ***			(C)opright 1994 Morgan Davis Group
' ***
' ***	History:
' ***
' *** 22may90 mwd 1.0	Creation
' *** 23sep90 mwd 1.1	Reads server path from resource file (if present)
' *** 18jul91 mwd 1.2	Now includes map server
' *** 01aug91 mwd	Sends optional "server.msg" file with all requests
' *** 25aug91 mwd 1.3	Removed Received: and Message-Id: fields now that
' ***			sendmail includes them.
' *** 28mar92 mwd 1.4	New unique filename generator installed.  Updated
' ***			to call rcp with -a instead of sendfile.
' *** 22jan94 mwd 3.0	Improved return path logic (taken from mdssclean)
' ***

#define IDENT_PROG "server"
#define IDENT_VERS "3.0"
#define IDENT_DATE "22jan94"
#define	IDENT_NAME "Morgan_Davis"

#define	SERVER_VER	"(" IDENT_PROG " " IDENT_VERS " " IDENT_DATE ")"

#include <basic.h>
#include <proline/proline.h>

#define	SEND_BINARY	"rcp"
#define	SEND_TEXT	"rcp -a"

#define	HELP_CMD	"help"
#define	INDEX_CMD	"index"
#define	SEND_CMD	"send"
#define	DIR_CMD		"dir"
#define	MAP_CMD		"map"

#define	MAXDIRS		100
#define	FILEQSIZE	300
#define	MAXJOBS		300

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' Mail header fields we care about
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define	STD_FIELDS	"1:Reply-To;2:From;3:Sender;4:Errors-To;5:Subject;"
#define SENDER_COUNT	4
#define	SUBJECT_FIELD	5
#define	FIELD_COUNT	5


' ************************************************************
' **
' **	main
' **
	gosub AppInit
	gosub SetUp
	gosub CollectJobs
	gosub ProcessJobs
	if doRCP then
		CommandLine$ = "csh source " + execFile$
		goto _Launch
	endif
goto Exit


SetUp:
	if not SuperUser then
		print argv$[0] ": can't run"
		goto Exit
	endif

	serverLog$	= SPOOL_LOGS_PATH + "servlog"
	resourceFile$	= RSRC_PATH + "server.rsrc"
	msgFile$	= HELP_PATH + "server.msg"
	helpFile$	= HELP_PATH + "server"
	execFile$	= SysInfo$[plTempDir] + "server.xqt"
	spoolDir$	= SPOOL_MAIL_PATH
	mailboxFile$	= MAIL_PATH + "server"
	validateFile$	= ETC_PATH + "server.req"
	serverDir$	= SysInfo$[plDir] + "pub/"
	mapDir$		= SYS_PATH + "maps/"
	fields$		= STD_FIELDS
	
	dim dir$[MAXDIRS], f$[FILEQSIZE], job$[MAXJOBS], from$[MAXJOBS]
	
	' Check for mail

	&GETINFO mailboxFile$, info$
	if info$ = "" then
		print argv$[0] ": server mailbox empty"
		goto Exit
	endif

	' Purge existing files

	&GETINFO execFile$, info$
	if info$ > "" then fDelete execFile$

	' Get resources, if file exists
	
	&GETINFO resourceFile$, info$
	if info$ > "" then
		fOpen resourceFile$
		fRead resourceFile$
		& get serverDir$
		& get mapDir$
		fClose

		if right$(serverDir$,1) <> "/" then
			serverDir$ = serverDir$ + "/"
		endif
		if right$(mapDir$,1) <> "/" then
			mapDir$ = mapDir$ + "/"
		endif
	endif

	' See if server message file exists

	& GETINFO msgFile$, info$
	msgFileExists = info$ > ""

return


CollectJobs:
	entry$ = "SERVER ~"
	gosub UpdateLog

	jobs = 0
	doRCP = FALSE
	fOpen mailboxFile$
	onerr goto mbEOF
	fRead mailboxFile$

	& get from$		' Snatch the From return path first
	do
		cmd$ = ""
		arg$ = ""
		hdr$[0] = ""
		&erase(hdr$)
		dim hdr$[FIELD_COUNT]

		repeat			' Then loop through header, collecting fields
			& get a$
			& pos (a$, ":"), p
			if p then
				i$ = left$(a$, p - 1)
				&spc(mid$(a$, p + 1)), j$
				&pos(fields$, ":" + i$ + ";"), p
				if p then hdr$[val(mid$(fields$, p - 1, 1))] = j$
			endif
		until a$ = ""
	
		to$ = ""
		for i = 1 to SENDER_COUNT
			if hdr$[i] > "" then
				to$ = hdr$[i]
				i = SENDER_COUNT
			endif
		next
	
		if to$ = "" then
			& pos (7, from$, " "), p
			to$ = mid$(from$, 6, p - 6)
		endif
	
		gosub StripMailAddress
		from$ = to$

		a$ = hdr$[SUBJECT_FIELD]
		if a$ > "" then gosub ParseJob

		if cmd$ = "" then
			repeat
				& get a$
				& spc(a$), a$
			until a$ > ""
			gosub ParseJob
		endif

		while left$(a$, 5) <> "From "			
			& get a$
		wend
		from$ = a$
	loop
	mbEOF:
	&onerr errCode, errLine
	fClose
	fFre
	onerr goto HandleError
	if errCode <> 5 then
		print argv$[0]": error " errCode " at " errLine
		goto Exit
	endif
	fDelete mailboxFile$
return

parseJob:
	&pos (a$ + " ", " "),p
	cmd$ = left$(a$, p - 1)
	&spc (mid$(a$, p + 1)), arg$
	jobs = jobs + 1
	&spc(cmd$ + " " + arg$),job$[jobs]
	&lcase (job$[jobs])
	from$[jobs] = from$
return


ProcessJobs:
	jIndex = 1
	while jIndex <= jobs
		from$ = from$[jIndex]
		cmd$ = job$[jIndex]
		&pos (cmd$, " "), p
		if p then
			larg$ = mid$(cmd$, p + 1)
			cmd$ = left$(cmd$, p - 1)
		else
			larg$ = ""
		endif
		repeat
			&pos(larg$, " "), p
			if p then
				&spc(left$(larg$, p - 1)), arg$
				&spc(mid$(larg$, p + 1)), larg$
			else
				arg$ = larg$
				larg$ = ""
			endif
			&spc(cmd$ + " " + arg$), request$
			entry$ = "^I~ " + request$ + " (" + from$ + ")"
			gosub UpdateLog
			gosub HandleJob
		until larg$ = ""
		from$[jIndex] = ""
		job$[jIndex] = ""
		fFre
		jIndex = jIndex + 1
	wend
return

time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

UpdateLog:
	&pos (entry$, "~"),p
	if p then
		gosub small_time
		entry$ = mid$(entry$, 1, p - 1) + time$ + mid$(entry$, p + 1)
	endif
	fAppend serverLog$
	print entry$
	fClose serverLog$
	print entry$
return



HandleJob:
	file$ = arg$
	
	if cmd$ = HELP_CMD then
		larg$ = ""
		file$ = "HELP"
		jobFile$ = helpFile$
		goto SendJobFile
	endif

	if cmd$ = INDEX_CMD then
	   	jobFile$ = serverDir$ + arg$
	   	goto IndexJob
	endif

	if cmd$ = SEND_CMD then
		jobFile$ = serverDir$ + arg$
		goto SendJobFile
	endif

	if cmd$ = MAP_CMD then
		jobFile$ = mapDir$ + arg$
		goto SendMapFile
	endif
	
	if cmd$ = DIR_CMD then
	   	jobFile$ = serverDir$ + arg$
	   	goto DirJob
	endif

	msg$ = "unknown command.  Use HELP for assistance"
goto SendMsgFile


SendMapFile:
	repeat
		& pos (jobFile$,"-"),p
		if p then & mid$(jobFile$, p) = "."
	until not p
	mapJobFlag = TRUE
	goto doSendJob
		
SendJobFile:
	mapJobFlag = FALSE
doSendJob:
	&GETINFO jobFile$, info$
	if info$ > "" then
		if asc(mid$(info$,5)) = 15 then goto DirJob

		isText = asc(mid$(info$,5)) = 4
		if isText then
			jobType$ = SEND_TEXT
		else
			jobType$ = SEND_BINARY
		endif

		AccFile$ = jobFile$
		AccMode = accRead
		SuperUser = 0
		gosub CheckAccess
		SuperUser = 1
		if AccOK or mapJobFlag then
			if isText
				sub$ = "Server file: " + file$
				gosub DoMsgHeader
				fClose theFile$
				&add (jobFile$ to theFile$)
			else
				fAppend execFile$
				print jobType$ " " jobFile$ " " from$
				fClose execFile$
				doRCP = TRUE
			endif
		else
			fAppend validateFile$
			print jobType$ " " jobFile$ " " from$
			fClose validateFile$
			entry$ = "^I~ <HELD: pending authorization>"
			gosub UpdateLog
		endif
	else
		msg$ = "file not found"
		goto SendMsgFile
	endif
return


DirJob:
	gosub GetJobFileInfo
	if info$ > "" then
		gosub FillQ
		if mapJobFlag then
			sub$ = "Server maps directory"
		else
			sub$ = "Server directory listing"
		endif
		gosub DoMsgHeader
		for i = 0 to fileCount
			theDir$ = startDir$ + dir$[i]
			dir$[i] = ""
			fFre
			fOpen theDir$ ",TDIR"
			fRead theDir$
			input name$
			&get
			&get
			qIndex = 1
			repeat
				input a$
				if a$ > "" then
					f$[qIndex] = mid$(a$,2,20) + mid$(a$,31,10) +\
						 mid$(a$,64,8)
					qIndex = qIndex + 1
				endif
			until qIndex > FILEQSIZE or a$ = ""
			fClose theDir$
			fWrite theFile$
			if i or (arg$ > "") then
				if i then
					print
					print
				endif
				print name$
				print
			endif
			print "Name" spc(11) "Type  Modified    Bytes"
			print "-------------  ----  --------  -------"
			& srt (f$, qIndex - 1)
			for j = 1 to qIndex - 1
				&lcase(f$[j])
				print f$[j]
				f$[j] = ""
			next
		next
		fClose theFile$
		fFre
	endif
return

IndexJob:
	gosub GetJobFileInfo
	if info$ > "" then
		gosub FillQ
		sub$ = "Server index listing"
		gosub DoMsgHeader
		for i = 0 to fileCount
			if i then
				print
				print
			endif
			theIndex$ = startDir$ + dir$[i] + "index"
			&GETINFO theIndex$, info$
			if info$ = "" then
				fWrite theFile$
				print "No index for " dir$[i]
			else
				fClose theFile$
				&add (theIndex$ to theFile$)
				fAppend theFile$
			endif
		next
		fClose theFile$
		fFre
	endif
return


GetJobFileInfo:
	if right$(jobFile$, 1) <> "/" then
		jobFile$ = jobFile$ + "/"
	endif
	&GETINFO jobFile$, info$
	if info$ > "" then
		if asc(mid$(info$,5)) <> 15 then
			info$ = ""
			msg$ = "not a directory"
			goto SendMsgFile
		endif
		startDir$ = jobFile$
	else
		msg$ = "directory not found"
		goto SendMsgFile
	endif
return


FillQ:
        fileCount = 0
        qIndex = 0
        pIndex = 1
        dir$[0] = ""

        repeat
        	theDir$ = startDir$ + dir$[qIndex]
                fOpen theDir$ ",TDIR"
                fRead theDir$
                &get : &get : &get
                repeat
                        input a$
                        if mid$(a$,18,3) = "DIR" then
                                &spc(mid$(a$,2,15)),a$
                                dir$[pIndex] = dir$[qIndex] + a$ + "/"
				fileCount = fileCount + 1
        	                pIndex = pIndex + 1
                        endif
                until a$ = ""
                fClose theDir$
		qIndex = qIndex + 1
        until qIndex >= pIndex
	& srt (dir$, fileCount)
return



' ***************************************************
' **
' ** SendMsgFile - Create mailbox header and send log
' **
' ** The letter is addressed to "root" so that it is
' ** sent to the root alias (which could be many users).
' **

SendMsgFile:
	sub$ = "Server error"
	gosub DoMsgHeader
	print "The server could not process your '" +  request$ + "' request."
	print "Reason: " msg$ "."
	print
	print "Sincerely,"
	print
	print "^Iserver@" SITE_NAME
	fClose theFile$

	entry$ = "^I~ <FAILED: " + msg$ + ">"
goto UpdateLog


DoMsgHeader:
	gosub DoMsgHeader2
	if msgFileExists then
		fClose theFile$
		& add (msgFile$ to theFile$)
		fAppend theFile$
		print
	endif
return

DoMsgHeader2:
	gosub MakeUniqueName
	fAppend theFile$
	print "From root " left$(t$,3) mid$(t$,8,5) \
	      mid$(t$,6,3) right$(t$,8) " 19" mid$(t$,13,2)
	print "Date: " left$(t$,5) val(mid$(t$,6)) \
	      mid$(t$,8) " " SysInfo$[plZone]
	print "From: root (File Server)"
	print "To: " from$
	print "Subject: " sub$
	print 
return

' *****************************************************************
' **
' ** Build a filename (theFile$) in this format:
' **
' **	ddSSSSS
' **
' ** Where dd is an alphabetic variant of the combined month and date
' ** values, and SSSSS are the number of seconds that have elapsed since
' ** midnight.

  MakeUniqueName:
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
	j = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + \
		val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),a$
	msgID$ = chr$ (64 + i / 2) + chr$ (48 + j + 7 * (j > 9)) + a$
	& lcase (msgID$)
	if msgID$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = msgID$
	theFile$ = spoolDir$ + msgID$ + seq$
return




'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' This routine is entered with a field from the header.
' The field in to$ will be in some address notation:
'	...!site!jdoe
'	jdoe@site.domain
'	John Doe <jdoe@site.domain>
'	jdoe@site.domain (John Doe)
' Strip out the address and return in to$.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
StripMailAddress:
	& pos (to$, "<"), p
	if p then
		&pos right$(to$, ">"), q
		&spc(mid$(to$,p + 1, q - p - 1)), to$
	else
		& pos (to$, "("), p
		if p then &spc(left$(to$, p - 1)), to$
	endif
return


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/launch.lib>
