'=========================================================================
'                                 R O T 1 3
'
'                               by Dean Fick
'=========================================================================
'
' History:
'
' When    Who Ver   What
' ======= === ===== ======================================================
' 28aug91 df  1.0   Creation
' 24sep91 mwd 1.1   Wrote 6502 string encoder/decoder function for speed
'                   Used getopt library to handle argument parsing
' 30sep91 mwd       Realizing that rot13 is a reverse-decoding mechanism
'		    exception code for encode/decode modes was removed.
'
'=========================================================================

#define IDENT_PROG "rot13"
#define IDENT_VERS "1.1"
#define IDENT_DATE "30sep91"
#define	IDENT_NAME "Dean_Fick_&_Morgan_Davis"

#include <proline/proline.h>

#define	UsageLine             "Usage: " argv$[0] " [-h] infile [outfile]"
#define EndofData             5

#define Rot13                 $300

#define ChkAccess(string1, string2)  AccFile$ = string1 : AccMode =\
        string2 : gosub CheckAccess


     gosub AppInit
     gosub GetArgs
     gosub CheckArgs
     gosub PokeRot13
     gosub ProcessFile
goto Exit


' ****************************************************************
' **
' ** Get shell arguments via getopt
' **
' **

GetArgs:
     optchar$ = ""
     options$ = "h"
     repeat
          gosub getopt
          if optchar$ = "h" then skipHeader = True
          if optchar$ = "?" then showUsage = True
     until optchar$ = ""

     i = 1
     if nargc > i then
          if srcFile$ = "" then
               srcFile$ = nargv$[i]
               i = 2
          endif
          if nargc > i then outFile$ = nargv$[i]
     endif

     if srcFile$ = "" or showUsage then
          print UsageLine
          goto Exit
     endif
return

' ****************************************************
' **
' **  Check arguments to see if they're valid
' **
' **

CheckArgs:
     & getinfo srcFile$, info$
     if info$ = "" then
          print argv$[0]" "srcFile$" not found"
          goto Exit
     else
          if asc (mid$(info$, 5)) <> 4 then
               print argv$[0]": "srcFile$" not text"
               goto Exit
          endif
     endif

     ChkAccess (srcFile$, accRead)
     if not AccOK then
          print argv$[0]": can't read " srcFile$
          goto Exit
     endif

     if outFile$ > "" then
          & spc(outFile$, 62), outFile$
          if outFile$ = "" or outFile$ = srcFile$ then
                print argv$[0]": invalid output file '" outFile$ "'"
                goto Exit
          endif
          & getinfo outFile$, info$
          ChkAccess (outFile$, accWrite + (accDestroy * (info$ > "")))
          if AccOK and info$ > "" then AccOK = asc(mid$(info$,5)) = 4
          if not AccOK then
               print argv$[0]": can't write to " outFile$
               goto Exit
          endif

          if info$ > "" then
               print outFile$ " exists.  Append";
               gosub GetAnswer
               if YN$ = "n" then
                    print "Replace";
                    gosub GetAnswer
                    if YN$ = "y" then fDelete outFile$
               endif
          endif
     endif
return

     
' ****************************************************************
' **
' ** Install Rot13 call machine code
' **
' **

PokeRot13:
     & poke Rot13,32,190,222,32,123,221,160,2,177,160,153,155,0,136,\
	16,248,164,155,136,192,255,240,37,177,156,170,41,32,133,0,138,\
	41,95,201,65,144,237,201,91,176,233,105,13,201,65,144,5,201,\
	91,144,3,24,105,230,5,0,145,156,208,214,96,96
return

     
' ****************************************************************
' **
' ** Encode or decode the file given in srcFile$.  Print to screen
' ** or destination file (given in outFile$).
' **
' **

ProcessFile:
     fOpen srcFile$
     if outFile$ > "" then
          & print argv$[0]": " srcFile$ " --> " outFile$ "...";
          fAppend outFile$
     endif
     onerr goto srcFileEOF
     do
          fRead srcFile$
          & get a$
          if skipHeader then
               if a$ = "" then skipHeader = False
          else
               call Rot13, a$
          endif
          if outFile$ > "" then fWrite outFile$
          print a$
     loop

     srcFileEOF:
     & onerr errCode, errLine
     fClose
     if outFile$ > "" then print "done!"
     if errCode <> EndOfData then
          print argv$[0] ": err " errCode "@" errLine
          goto Exit
     endif
return


' ****************************************************************
' **
' ** Loop until user inputs Y or N.  Echo it when found.
' **
' **

GetAnswer:
     print "? (y/n) ";
     repeat
          get YN$
          & lcase (YN$)
     until YN$ = "y" or YN$  = "n"
     print YN$
return


' ****************************************************************
' **
' ** Standard ProLine library routines
' **
' **

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
