' ************************************************************************
' **
' **  ps.b		ProLine status (OMM module shuffler)
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 18oct93 mwd 1.0	Created
' **
' ************************************************************************

#define	IDENT_PROG "ps"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "18oct93"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>


	gosub AppInit

	showStack = argc = 1
	header$	= ommTableHeader

	options$ = "?defhj:k:l:um"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "d" then & load print decFmt
		if optchar$ = "h" then & load print hexFmt
		if optchar$ = "f" then fullFlag = TRUE
		if optchar$ = "e" then
			showList = TRUE
			showStack = TRUE
		endif
		if optchar$ = "m" then showList = TRUE
		if optchar$ = "u" then showStack = TRUE
		if optchar$ = "j" then gosub showModule
		if optchar$ = "k" then gosub killModule
		if optchar$ = "l" then gosub loadModule
	until optchar$ = ""
	
	if showUsage or (nargc > 1) then
		& print "Usage: "argv$[0]" [ -defhmu ] [ -j id ] [ -k id ] [ -l module ]"
		goto Exit
	endif

	if showList then
		print header$
		& load print
	endif

	if showStack or fullFlag then
		if fullFlag then print "UID		";
		print "PID	TTY	COMMAND"
		& restore ProgStack_Cell to a$
		& fn fnOnline, i
		if i then
			tty$ = "modem"
		else
			tty$ = "console"
		endif
		job = 0
		i = len(a$)
		repeat
			& pos right$ (i, a$, ":"),q
			i$ = mid$(a$, q + 1, i - q)
			gosub showCommand
			job = job + 1
			i = q - 1
		until not q
		i$ = AppPath$
		gosub showCommand
	endif
goto Exit

showCommand:
	if not fullFlag then
		& pos right$(i$, "/"), p
	else
		p = 0
	endif
	& left$(ID$[uName], 18), n$
	i$ = n$ + str$(job) + "^I" + tty$ + "^I" + mid$(i$, p + 1)
	print mid$(i$, 1 + (16 * not fullFlag))
return

showModule:
	& load peek ommInfo, val(optarg$), i$
	if i$ = "" then
		&print argv$[0] ": no job " optarg$
	else
		print header$
		print i$
	endif
return

killModule:
	if not SuperUser then
		print argv$[0] ": -k access denied"
	else
		print header$
		& load trace
		& load fre val(optarg$)
		& load notrace
	endif
return

loadModule:
	if not SuperUser then
		print argv$[0] ": -l access denied"
	else
		& pos (optarg$, "/"), p
		if not p then optarg$ = SYS_PATH + "modules/" + optarg$
		print header$
		& load trace
		& load get optarg$, i
		& load notrace
		if i then & print argv$[0]": error #" i " loading " optarg$
	endif
return


#include <proline/proline.lib>
#include <proline/getopt.lib>
