' ***************************************************************************
' **
' **	pc.b		Programmable Calculator
' **			Copyright (C) 1991 Morgan Davis Group
' **
' **	When	Who	Ver	What
' **	=======	======	=======	=============================================
' **	11apr91	mwd	1.0	Creation
' **	24jul91 mwd	1.1	Moved help out into an external text file
' **	13sep93 mwd	1.2	Removed TRUE/FALSE keywords since they
' **				conflict with MD-BASIC 2.0's built-ins
' **

#define	IDENT_PROG "pc"
#define	IDENT_VERS "1.2"
#define	IDENT_DATE "13sep93"
#define	IDENT_NAME "Morgan_Davis"

#include <errors.h>
#include <proline/proline.h>

#reserve PI, RESULT

#declare a$, hLine, hHead, hTail, hSize, cmdList$, vn$, vv$, i, p, command$
#declare varCount, stack, stackPtr, opList$, j, newResult, errCode, errLine
#declare err$, r, k2, k, varName$, varVal$, inDo, hptr, hndx, doEnd, doBegin,
#declare arg$, hist$, opList$, argv$, argc, SysInfo$


#define	MAX_VARS	32
#define	HIST_SIZE	100
#define	STACK_SIZE	32

#define	HELP_FILE	HELP_PATH + "pc"

	gosub AppInit

	dim vn$[MAX_VARS],vv$[MAX_VARS],hist$[HIST_SIZE],r[HIST_SIZE], \
		stack[STACK_SIZE]

	hHead	= -1
	hTail	= 0
	hLine	= 0
	hSize	= 0
	stackPtr = 0

	cmdList$ = "A=q_A=quit_B=clear_B=cl_C=hist_C=history_D=?_D=help_" \
		   "E=do_E=run_F=set_F=let_F=def_F=define_G=print_G=list_" \
		   "G=pr_G=l_H=push_I=pull_I=pop_J=stack_J=st_"

	opList$ = "/*+-^~<>="
	
	' Defined constants for use in formulas
	
	PI	= 3.141592653	
	RESULT	= 0

	onerr goto calcError

	if argc > 1 then
		a$ = ""
		for i = 1 to argc - 1
			a$ = a$ + argv$[i]
		next
		& val a$ to i
		print i
		goto Exit
	endif
	
	mainLoop:
	do
		& pop
		inDo = FALSE
		hLine = hLine + 1
		repeat
			print argv$[0] " [" RESULT "]	" hLine;
			& read "> ",a$
			& spc(a$), a$
		until a$ > ""
		gosub AddToHistory		
		gosub DoCommand
		r[hHead] = RESULT
	loop

calcError:
	& onerr errCode, errLine
	err$ = "code " + str$(errCode) + "@" + str$(errLine)
	if errCode = SyntaxErr		then err$ = "syntax"
	if errCode = IllQuantityErr	then err$ = "illegal quantity"
	if errCode = OverflowErr	then err$ = "overflow"
	if errCode = BadSubscriptErr	then err$ = "subscript"
	if errCode = DivByZeroErr	then err$ = "division by zero"
	if errCode = BadTypeErr		then err$ = "type mismatch"
	if errCode = StrTooLongErr	then err$ = "string too long"
	if errCode = FormulaErr		then err$ = "formula too complex"
	if errCode = NoSuchFuncErr	then err$ = "undefined function"
	if errCode = OutOfMemErr then
		clear
		print "### out of memory error"
		run
	endif
	print "### " err$ " error"
	if argc > 1 then goto Exit
goto mainLoop
	
	
AddToHistory:
	if hSize < HIST_SIZE then
		hSize = hSize + 1
	else
		hTail = hTail + 1
		if hTail > HIST_SIZE then hTail = 0
	endif
	hHead = hHead + 1
	if hHead > HIST_SIZE then hHead = 0
	hist$[hHead] = a$
return
	
DoCommand:
	& pos(a$, " "), p
	if not p then p = len(a$) + 1
	command$ = left$(a$,p - 1)
	&spc(mid$(a$,p + 1)),arg$
	&lcase(command$)
	&pos (cmdList$, "=" + command$ + "_"), p
	if p then
		on asc(mid$(cmdList$, p - 1, 1)) - 64 goto \
			Exit, _clear, _history, _help, _do, _set, \
			_print, _push, _pop, _stack
	endif
	gosub GetNewResult
	RESULT = newResult
return

GetNewResult:
	& pos(opList$, left$(command$, 1)),p
	if p then a$ = "RESULT" + command$ + " " + arg$
	gosub ExpandVars
	& val a$ to newResult
return

' ==============================
	_clear:
' ==============================
	stackPtr = 0
	for i = 1 to varCount
		vn$[i] = ""
		vv$[i] = ""
	next
	varCount = 0
	RESULT = 0
	fFre
return

' ==============================
	_history:
' ==============================
	j = hTail
	k = hLine - hSize
	r[hHead] = RESULT
	for i = 1 to hSize
		print "  " k + i ".	" hist$[j];
		& hlin 6 - (int(len(hist$[j])/8)), 9
		print "= " r[j]
		j = j + 1
		if j > HIST_SIZE then j = 0
	next
return

' ==============================
	_help:
' ==============================
	print
	& list HELP_FILE
	print
return	

' ==============================
	_do:
' ==============================
	if inDo then
		print "### do command skipped"
		return
	endif

	if arg$ = "" then
		print "### no line(s) given"
		return
	endif

	doBegin = val(arg$)
	&pos (arg$, "-"), p
	if not p then &pos (arg$, ","), p
	if p then
		doEnd = val(mid$(arg$,p + 1))
	else
		doEnd = doBegin
	endif

	k = hLine - hSize + 1
	j = hLine - 1

	if (doBegin > j or doBegin < k or doEnd > j or doEnd < k or \
		doEnd < doBegin) then
		print "### invalid line number"
		return
	endif

	inDo = TRUE	
	for hndx = doBegin to doEnd
		hptr = hHead - (hLine - hndx)
		if hptr < 0 then hptr = HIST_SIZE + hptr
		a$ = hist$[hptr]
		print "> " hndx ".	" a$;
		& hlin 6 - (int(len(a$)/8)), 9
		gosub DoCommand
		print "= " RESULT
	next
	inDo = FALSE
return

' ==============================
	_set:
'	_define:
'	_let:
' ==============================
	if arg$ = "" then goto _print
	& pos (arg$, "="), p
	if not p then
		print "### missing = sign"
		return
	endif
	&spc(mid$(arg$, 1, p - 1)), varName$
	a$ = mid$(arg$, p + 1)
	if left$(command$,3) = "def" then
		varVal$ = a$
	else
		gosub ExpandVars
		& val a$ to p
		varVal$ = str$(p)
	endif
goto DefineVar


' ==============================
	_print:
'	_list:
' ==============================
	a$ = arg$
	if a$ > "" then
		gosub ExpandVars
		& val a$ to i
		print "	" i
	else
		if varCount then
			for i = 1 to varCount
				print "	$"vn$[i], " = " vv$[i]
			next
		else
			print "### no variables"
		endif
	endif		
return

' ==============================
	_push:
' ==============================
	if stackPtr < STACK_SIZE then
		if arg$ > "" then
			a$ = arg$
			gosub ExpandVars
			& val a$ to i
		else
			i = RESULT
		endif
		stack[stackPtr] = i
		stackPtr = stackPtr + 1
	else
		print "### stack overflow"
	endif
return

' ==============================
	_pop:
' ==============================
	if stackPtr then
		stackPtr = stackPtr - 1
		i = stack[stackPtr]
		if arg$ > "" then
			varName$ = arg$
			varVal$ = str$(i)
			gosub DefineVar
		else
			RESULT = i
		endif
	else
		print "### empty stack"
	endif
return

' ==============================
	_stack:
' ==============================	
	if stackPtr then
		for i = 0 to stackPtr - 1
			print "	" i ".  " stack[i]
		next
	else
		print "### empty stack"
	endif
return

ExpandVars:
	& pos (a$, "$"),p
	if p then
		k = FALSE
		for j = 1 to varCount
			if mid$(a$, p + 1, len(vn$[j])) = vn$[j] then
				a$ = mid$(a$, 1, p - 1) + vv$[j] + \
					mid$(a$, p + len(vn$[j]) + 1)
				j = varCount
				k = TRUE
			endif
		next
		if k then goto ExpandVars
	endif
return 

DefineVar:
	gosub FindVar
	if not k then
		if varCount = MAX_VARS then
			print "### out of memory"
			return
		endif
		varCount = varCount + 1
		k = varCount
		vn$[k] = varName$
	endif
	vv$[k] = varVal$
return

FindVar:
	k = 0
	for i = 1 to varCount
		if vn$[i] = varName$ then
			k = i
			i = varCount
		endif
	next
return

#include <proline/proline.lib>
