' ************************************************************************
' **
' **  mail.b		ProLine Mail Manager
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' **  4nov90 mwd 1.0	Creation.
' ** 16nov90 mwd 1.1	Fixed "" bug in StripQuote
' ** 25nov90 mwd	Handles multi-line header fields, new $wrtdel
' **			variable added, writes msgs to file w/ or w/o
' **			header.
' ** 26nov90 mwd	Fixed bug in sendexit to return to ReadTop
' ** 30dec90 mwd 1.2	Tests for string too long error in GetHeader-
' **			Info (multiline header fields).
' ** 02jan91 mwd 	Fixed mail> Write bug (TempFile$ clobbering)
' ** 14jan91 mwd	Added -n (new mail) flag option.
' ** 21jan91 mwd	Fixed misc bugs.
' ** 11feb91 mwd	Traps bad filenames when writing to files.
' ** 22feb91 mwd	Removed extra space from MakeFromTime's string.
' ** 05mar91 mwd 1.3	Added array bounds checking when scanning new
' **			mailboxes for message offsets.
' ** 08mar91 mwd	Rewrote UnpackAddress to handle all variations
' **			of convoluted paths (s!s!u@s, s!s!u%s@s, etc.)
' ** 04apr91 mwd 1.4	Alias searches were case sensitive.  Fixed.
' **			Added support for Organization: via $org var.
' ** 09apr91 mwd	Fixed StripQuote to locate comment dilimeters
' **			by getting leftmost and rightmost characters.
' ** 24apr91 mwd	Fixed bug in choosing return address.  Prior
' **			1.4 version always used the "From " path.
' ** 30jul91 mwd 1.5	Fixed "Get File:" if no filename entered.
' ** 20aug91 mwd	Comment argument becomes curMsg
' ** 23aug91 mwd	Aliased Mail to Send (for mush/mail addicts)
' ** 26aug91 mwd	Supports Date: field for dates instead of date
' **			from the From line. Reworked UnpackAddress to
' ** 			treat %'s as @'s (seems to work fine).
' ** 10sep91 mwd	'.' expands to last letter # referenced
' ** 25nov91 mwd 1.6	Added same-second sequencer to UniqueName.
' ** 20feb92 mwd 1.7	Removed Vars editor.  Stripped $ requirement.
' ** 28jan94 mwd 3.0	Updated for ProLine 3.0, expands vars in filenames,
' **			variable update, major reply/comp i/f changes
' ** 10oct94 mwd 3.0.1	Added support for "from" variable to fill From:
' **			field.  If empty, user@site.domain is assumed.
' **
' ************************************************************************

#define	IDENT_PROG "mail"
#define	IDENT_VERS "3.0.1"
#define	IDENT_DATE "10oct94"
#define IDENT_NAME "Morgan_Davis"

#define	XMAILER	"ProLine Mail " IDENT_VERS

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>
#include <proline/parse.h>

	' ====================
	' Constants
	' ====================

#define	MAX_MSGS	99
#define	MAX_VARS	40

#define	MAILRC		"mailrc"

#define	HELP_MAIL	"mail"
#define	HELP_READ	"read"
#define	HELP_SEND	"send"
#define	HELP_ARGS	"args"

#define	MAIL_ENV_FILE	SysInfo$[plTempDir] + "mail.env"
#define	TMPNAME		SysInfo$[plTempDir] + "mail.tmp"

#define	READ_MAIL	1
#define	SEND_MAIL	2
#define	EDIT_VARS	3
#define	SHELL_CMD	4

#define	HEADER_FIELDS	"1:Reply-To;2:From;3:Subject;4:To;5:Cc;6:Bcc;7:Date;"
#define HDR_REPLY_TO	1
#define	HDR_FROM	2
#define	HDR_SUBJECT	3
#define	HDR_TO		4
#define	HDR_CC		5
#define HDR_BCC		6
#Define	HDR_DATE	7
#define	HDR_LAST	7

#define	IOBUF_SIZE	$0400	' 1K
#define	IOBUFL		$00
#define	IOBUFH		$04

	gosub AppInit

	FindFrom = $300
	& poke FindFrom, \
	    $A9,$CA,$20,$70,$BE,$90,$03,$4C,$09,$BE,$A0,$04,$B9,$00,$02,$D9,\
	    $1C,$03,$D0,$EC,$88,$10,$F5,$A9,$CF,$4C,$70,$BE,$46,$72,$6F,$6D,\
	    $20

	PrintBuffer = $328
	& poke PrintBuffer, \
	    $A2,$05,$BD,$D7,$BE,$95,$04,$CA,$10,$F8,$A6,$08,$A0,$00,$B1,$04,\
	    $09,$80,$20,$ED,$FD,$C8,$D0,$02,$E6,$05,$8A,$D0,$02,$C6,$09,$CA,\
	    $8A,$05,$09,$D0,$E9,$60
	
	gosub SetUpEnv
	if TheMode = SEND_MAIL then goto SendMail

' ====================
' ReadMBox:
' ====================

	if ChkNewMBox% and MailBox$ = UsersMBox$ then
		gosub MBoxModDate
		a$ = "lastime"
		gosub GetVarVal
		if a$ = j$ then goto NoNewMail
	endif
	& on int goto ReadTop
	gosub ScanMBox
	if not msgs then
		a$ = "nomail"
		gosub GetVarVal
		if j then
			if mboxRef goto NoNewMail
			goto Exit
		endif
	endif

ReadTop:
	& pop
	& on int goto ReadTop
	fFre
	forwardFlag% = FALSE
	where% = READ_MAIL
	do
		print
		CmdPrompt$ = "mail>"
		CmdKeys$ = "^M NQD?/SMTL;HUCRPW$FEAVO+=-!"
		Cmd$ = ""
		gosub CmdInput
		if ip then
			gosub ShowMsgs
		else
		   on p gosub NextMsg, NextMsg, DelNext, \
			Quit, Delete, Help, Help, Send, Mail, Type, \
			ListSummary, ListSummary, Headers,UnDelete, \
			Comment, Reply, Previous, Write, Variables, Forward, \
			Edit, Again, ViewFile, MBoxSwitch, MoreON, MoreON, \
			MoreOFF, ShellCommand
		endif
	loop

ShowPrompt:
	if curMsg and msgs then
		print curMsg mid$(delMark$,2-(fpos[curMsg] < 0))" of " msgs ": ";
	endif
	print CmdPrompt$ " " Cmd$;
return


' --------------------
  MBoxSwitch:
' --------------------
	& read "Open: ",a$
	gosub GetVar
	if a$ > "" then
		& GETINFO a$, i$
		if i$ = "" then
			print a$": not found"
		else
			AccFile$ = a$
			AccMode = accRead + accWrite + accDestroy
			gosub AccessOK
			if AccOK then
				if mboxRef then
					print "Closing " MailBox$;
					gosub CloseMBox
				endif
				MailBox$ = AccFile$
				gosub ScanMBox
			endif
		endif
	endif
return


' --------------------
  ViewFile:
' --------------------
	& read "View: ", a$
	gosub CheckReadFile
	if AccOK then
		print
		gosub ClearScreen
		& list AccFile$
	endif
return

' --------------------
  MoreON:	& page on : goto moreReport
  MoreOFF:	& page stop
' --------------------

moreReport:
	& page def i
	print "--More-- " mid$("offon", 1 + (3 * i), 3)
return

' --------------------
  ShellCommand:
' --------------------
	print "Shell Command^M"
ShellCommand2:
	& read "!", CommandLine$
	& spc(CommandLine$), CommandLine$
	if CommandLine$ > "" then
		suMode = FALSE
		where2% = where%
		where% = SHELL_CMD
		goto Sublaunch
	endif
return

EdVarReturn:
	gosub ReadVars
ShellReturn:
	& swap(where%, where2%)
	if where2% = SHELL_CMD then gosub ShellCommand2
goto whereLeap


' --------------------
  Edit:
' --------------------
	& read "Edit: ", a$
	gosub GetVar
	if a$ > "" then
		suMode = SuperUser
		f$ = a$
		goto EditFile
	endif
return

' --------------------
  Variables:
' --------------------
	print "$ Edit Vars...";
	gosub WriteVars
	f$ = VarFile$
	where2% = where%
	where% = EDIT_VARS
goto EditFile


ReadVars:
	var$[1]		= "/=" + SysInfo$[plDir]
	var$[2]		= "home=" + ID$[uHome]
	var$[3]		= "mail=" + UsersMBox$
	fixedVars%	= 3
	varCount%	= 3

	fOpen VarFile$
	fRead VarFile$
	onerr goto varEOF
	do
		& get a$
		& pos (a$, "="), p
		if p then
			varCount% = varCount% + 1
			var$[varCount%] = a$
		endif
	loop
	varEOF:
	& onerr
	onerr goto HandleError
	fClose VarFile$
	if varCount% = fixedVars% then
		repeat
			read a$
			if a$ <> "" then
				varCount% = varCount% + 1
				var$[varCount%] = a$
			endif
		until a$ = ""
		data	"addsig=1","askcc=1","clear=1","escape=.","prompt=:",\
			"summary=1",""
		varUpdate% = TRUE
	endif

	a$ = "clear"
	gosub GetVarVal
	clearSet% = j

	a$ = "delmark"
	gosub GetVarVal
	delMark$ = mid$(a$, 1, 1)
	if delMark$ = "" then delMark$ = "*"
return


' --------------------
  Quit:
' --------------------
	print "Quit";
	gosub CloseMBox
	gosub WriteVars
goto Exit
	
CloseMBox:
	j = 0
	k = curMsg
	for i = 1 to msgs
		if fpos[i] < 0 then
			j = j + 1
			if i <= curMsg then k = k - 1
		endif
	next
	if not j then
		print
		goto SetCurrent
	endif
	print " and delete ";
	if j = msgs then
		print "all";
	else
		print j " of " msgs;
	endif
	print msg$ "s";
	gosub GetYN
	curMsg = k
	on not y% goto SetCurrent
	if msgs = j then 
		fClose
		fDelete MailBox$
		curMsg = 0
		goto SetCurrent
	endif

	while fpos[msgs] < 0
		msgs = msgs - 1
		j = j - 1
	wend
	
	if not j then
		j = abs(fpos[msgs + 1]) - 1
		poke24 (_SEOF, j)
		poke _SREFNUM, mboxRef
		& MLI (_SET_EOF, _SSETEOF), errCode
		fClose
		goto SetCurrent
	endif

	& pos (MailBox$, "/"), p
	if p then
		& PREVDIR MailBox$, f$
		f$ = f$ + "/"
	else
		f$ = ""
	endif
	f$ = f$ + "mailtmp"

	fOpen f$
	tmpRef = peek(_OREFNUM)
	for i = 1 to msgs
		if fpos[i] > 0 then gosub WriteMsg
	next
	gosub TruncAtMark
	fClose
	fDelete MailBox$
	fRename f$ "," MailBox$

SetCurrent:
	fClose MailBox$
	mboxRef = 0
	if UsersMBox$ = MailBox$ then
		a$ = "current"
		varVal$ = str$(curMsg)
		gosub SetVar
		gosub MBoxModDate
		a$ = "lastime"
		varVal$ = j$
		gosub SetVar
	endif
return

MBoxModDate:		
	& getinfo MailBox$, i$		
	j$ = ""
	if i$ > "" then
		for i = 11 to 14
			& right$ (str$(asc(mid$(i$,i))),3),a$
			j$ = j$ + a$
		next
	endif
return

WriteVars:
	if varUpdate% then
		fOpen VarFile$
		tmpRef = peek(_OREFNUM)
		fWrite VarFile$
		for i = 1 to fixedVars%
			var$[i] = ""
		next
		& sort (var$, varCount%)
		for i = fixedVars% + 1 to varCount%
			print var$[i]
		next
		gosub TruncAtMark
		fClose
		if rcInfo$ = "" then
			& GETINFO VarFile$, rcInfo$
			& mid$(rcInfo$, 4) = chr$(OS_INVIS_ACCESS)
			& SETINFO VarFile$, rcInfo$
		endif 
	endif
return

TruncAtMark:
	poke _SREFNUM, tmpRef
	& MLI (_GET_MARK, _SGETMRK), errCode
	& MLI (_SET_EOF, _SSETEOF), errCode
return


WriteMsg:
	writeRef = tmpRef
	gosub PrintMsg
	writeRef = 0
return


' --------------------
  DelNext:
' --------------------
	if fpos[curMsg] > 0 then fpos[curMsg] = -fpos[curMsg]
	& ioctl (ioCR)
	gosub ShowPrompt

' --------------------
  NextMsg:
' --------------------
	gosub pNext

' --------------------
  ShowMsgs:
' --------------------
	for i = s to e
		curMsg = i
		print
		gosub ClearScreen
		print curMsg" of "msgs", " \
			abs(fpos[curMsg + 1]) - abs(fpos[curMsg]) " bytes" \
			mid$(", DELETED",1,9 * (fpos[curMsg] < 0))":^M"
		gosub PrintMsg
		if i < e then print
	next 
return

' --------------------
  Again:
' --------------------
	Cmd$ = "Again"
	gosub Check4Msgs
	print Cmd$
	s = curMsg + not curMsg
	e = s
goto ShowMsgs

' --------------------
  Delete:
' --------------------
	Cmd$ = "Delete"
	gosub Check4Msgs
	gosub GetArgs
	for i = s to e
		if fpos[i] > 0 then fpos[i] = -fpos[i]
	next 
return


' --------------------
  Forward:
' --------------------
	Cmd$ = "Forward"
	gosub Check4Msgs
	gosub GetArgs
	forwardFlag% = TRUE
	replyFlag% = FALSE
	To$ = ""
	Cc$ = ""
goto Comment2


' --------------------
  Comment:
  Reply:
' --------------------
	Cmd$ = "Reply to"
	gosub Check4Msgs
	gosub GetArgs
	replyFlag% = s

Comment2:
	i = s
	gosub GetHeaderInfo
	if not forwardFlag%
		gosub getSender
		authorPath$ = a$
		To$ = a$
		Cc$ = ""
		a$ = "askcc"
		gosub GetVarVal
		if j then
			gosub ReplyToAll
			if Cc$ > "" then
				print "Send to all recipients";
				gosub GetYN
				if not y% then Cc$ = ""
			endif
		endif
	endif
	Subject$ = Hdr$[HDR_SUBJECT]
	if forwardFlag% then
		if right$(Subject$, 5) <> "(fwd)" then
			Subject$ = Subject$ + " (fwd)"
		endif
	else
		if left$(Subject$, 3) <> "Re:" then 
			Subject$ = "Re: " + Subject$
		endif
	endif
	print
goto SendMail


getSender:
	a$ = ""
	for k = HDR_REPLY_TO to HDR_FROM
		if Hdr$[k] > "" then
			a$ = Hdr$[k]
			gosub StripAddress
		endif
	next
	if a$ = "" then a$ = From$
return


ReplyToAll:
	j$ = ""
	& pos(authorPath$, "@"), p
	if p then j$ = mid$(authorPath$, p)
 
	user$ = SysInfo$[plNode] + "!" + ID$[uName]
	i$    = SITE_NAME + "!" + ID$[uName]
	path$ = ID$[uName] + "@" + SysInfo$[plNode]
	for i = HDR_TO to HDR_BCC
		r$ = Hdr$[i]
		while r$ > "" then
			& pos (r$, ","), k
			if not k then k = 254
			a$ = mid$(r$, 1, k - 1)
			&spc (mid$(r$, k + 1)), r$
			gosub StripAddress
			& pos(a$, " "), p
			if p then
				& spc(mid$(a$, p + 1) + " " + r$), r$
				a$ = mid$(a$, 1, p - 1)
			endif
			& lcase (a$)
			if a$ <> ID$[uName] and \
				left$(a$, len(path$)) <> path$ and \
				right$(a$, len(user$)) <> user$ and \
				right$(a$, len(i$)) <> i$ then
				if len(Cc$) + len(a$) + 2 < 250 then
					gosub isOffsite
					if not p then a$ = a$ + j$
					Cc$ = Cc$ + a$ + " "
				endif
			endif
		wend
	next
	& spc (Cc$), Cc$
	j$ = ""
	user$ = ""
	path$ = ""
return


StripAddress:
	b$ = q$ + q$
	gosub StripQuote
	Comment$ = b$
	b$ = "()"
	gosub StripQuote
	if b$ > "" then Comment$ = b$
	b$ = "<>"
	gosub StripQuote
	if b$ > "" then
		Comment$ = a$
		a$ = b$
	endif
	& spc(a$), a$
return

StripQuote:
	& pos (a$, left$(b$,1)),p
	if p then
		& pos right$ (a$, right$(b$,1)),q
		if not q or (q = p) then q = 255
		& spc(mid$(a$, p + 1, q - p - 1)), b$
		& spc(mid$(a$, 1, p - 1) + mid$(a$, q + 1)), a$
	else
		b$ = ""
	endif
return

' --------------------
  Mail:
  Send:
' --------------------
	print "Send" msg$
	print
	To$ = ""
	Subject$ = ""
	Cc$ = ""
	replyFlag% = 0
goto SendMail


' --------------------
  Help:
' --------------------
	a$ = HELP_READ
goto PrintHelp

' --------------------  
  Type:
' --------------------  
	Cmd$ = "Type"
	gosub Check4Msgs
	gosub GetArgs
goto ShowMsgs


' --------------------  
  UnDelete:
' --------------------  
	Cmd$ = "Undelete"
	gosub Check4Msgs
	gosub GetArgs
	for i = s to e
		fpos[i] = abs(fpos[i])
	next 
return

' --------------------  
  Previous:
' --------------------  
	gosub pPrevious
goto ShowMsgs


' --------------------  
  ListSummary:
' --------------------  
	Cmd$ = "List"
	gosub Check4Msgs
	print Cmd$
	gosub ClearScreen
	s = 1
	e = msgs
goto Summary

' --------------------
  Headers:
' --------------------
	Cmd$ = "Headers"
	gosub Check4Msgs
	gosub GetArgs

Summary:
	print
	& ioctl(ioULOn)
	print "Msg   ^IDate  ^IFrom" spc(18) "^ISize  ^ISubject" spc(24)
'	print "Msg   ^ISize  ^IDate  ^IFrom" spc(18) "^ISubject" spc(24)
	& ioctl(ioULOff)
	print
	for i = s to e
		gosub GetHeaderInfo
		gosub getSender
		if Comment$ > "" then
			Comment$ = left$(Comment$, 22)
		else
			& pos right$(From$,"!"),k
			Comment$ = mid$(From$,k + 1,22)
		endif
		& left$(Comment$, 22), Comment$
		j$ = Hdr$[HDR_DATE]
		if j$ = "" then & time(j$)
		& pos (j$, " "),p		' Skip over day of week
		if p < 4 then
			p = 1
		else
			p = p + 1
		endif	
		& right$(str$(val(mid$(j$,p))), 3), a$
		&pos (p + 1, j$, " "),p
		j$ = mid$(j$, p + 1, 3) + a$
		& right$(str$(i),3),i$
		& right$(str$(abs(fpos[i + 1]) - abs(fpos[i])),6),a$
		print chr$(32 + 30 * (i = curMsg)) \
			i$ mid$(" " + delMark$, 1 + (fpos[i] < 0),1) "^I" \
			j$ "^I" \
			Comment$ "^I" \
			a$ "^I" \
			left$(Hdr$[HDR_SUBJECT], 31)
	next 
return 

GetHeaderInfo:
	Hdr$[0] = ""
	& erase (Hdr$)
	dim Hdr$[HDR_LAST]

	fRead MailBox$
	gosub SetUpCopy
	& get From$
	& pos (7, From$, " "), p
	From$ = mid$(From$, 6, p - 6)
	repeat
		& get a$
		& pos (a$, ":"), p
		if p then
			i$ = left$(a$, p - 1)
			& spc(mid$(a$, p + 1)), j$
			& spc(j$, 9), j$
			&pos(HdrFields$, ":" + i$ + ";"), p
			if p then Hdr$[val(mid$(HdrFields$, p - 1, 1))] = j$
		endif
	until a$ = ""
	fFre
return



' --------------------  
  Write:
' --------------------  
	Cmd$ = "Write"
	gosub Check4Msgs
	gosub GetArgs
	gosub CheckWrite
	if AccOK then
		TempFile$ = AccFile$
		fAppend TempFile$
		linePfx$ = ""
		inclFlag% = FALSE
		gosub WriteMsgsWOHdr
		a$ = "wrtdel"
		gosub GetVarVal
		if j then
			for i = s to e
				if fpos[i] > 0 then fpos[i] = -fpos[i]
			next
		endif
		fClose TempFile$
	endif
return

WriteMsgsWOHdr:
	for i = s to e
		if inclFlag% then gosub GetHeaderInfo
		gosub SetUpCopy
		fWrite TempFile$
		if skipHdr% then
			if inclFlag% then
				a$ = Hdr$[HDR_FROM]
				gosub StripAddress
				if Comment$ = "" then Comment$ = authorPath$
				print "On " Hdr$[HDR_DATE] ", " Comment$ " wrote:"
				print linePfx$ "Subject: " Hdr$[HDR_SUBJECT]
				print linePfx$
			endif
			fRead MailBox$
			repeat
				& get a$
				k = k - len(a$) - 1
			until a$ = ""
		endif
		repeat
			fRead MailBox$
			& get a$
			k = k - len(a$) - 1
			fWrite TempFile$
			print linePfx$ a$
		until k < 1
	next
return

CheckWrite:
	AccOK = FALSE
	& read "to file: ",a$
	gosub GetVar
	if a$ = "" then return
	AccFile$ = a$
	AccMode = accWrite + accDestroy
	gosub AccessOK
	if not AccOK then return
	& GETINFO AccFile$, i$
	AccOK = FALSE
	if i$ > "" then 
		print AccFile$" exists, append";
		gosub GetYN
		if not y% then 
			print "Replace";
			gosub GetYN
			if not y% then return
			fDelete AccFile$
		endif
	else
		if err <> 7 then
			print "Can't write to " AccFile$
			return
		endif
	endif
	AccOK = TRUE
	print "Include header";
	gosub GetYN
	skipHdr% = not y%
return

CmdInput:
	gosub ShowPrompt
ArgCmdInput:
	ip = 0
	a$ = ""
	repeat
		get v$
		& ucase(v$)
		if (v$ = "^H" or v$ = "^?") then
			if ip then
				print "^H ^H";
				ip = ip - 1
				a$ = mid$(a$, 1, ip)
			endif
		else
			& pos ("1234567890", v$),p
			& pos ("-,.", v$),q
			if not ip and not p then
				& pos (CmdKeys$,v$),p
				if p then return
				if not q then
					print
					print TypeHelp$
					gosub ShowPrompt
				endif
			endif
			if (p or q) and ip < 240 then
				if v$ = "." then v$ = str$(lastSArg)
				ip = ip + len(v$)
				a$ = a$ + v$
				print v$;
			endif
		endif
	until v$ = "^M"
	print
	s = val (a$)
	e = s
	& pos (a$,"-"),p
	& pos (a$,","),j
	p = p + j
	if p then
		e = val (mid$(a$,p + 1))
		if p = 1 then s = 1
		if not e then e = msgs
	endif

	if s < 1 or e > msgs or e < s then
		print "Invalid number."
		goto CmdInput
	endif
	lastSArg = s
return

' --------------------
  GetArgs:
' --------------------
	gosub GoGetArgs
	lastSArg = s
return


' --------------------  
  GoGetArgs:
' --------------------

	CmdKeys$ = "^MCAFLPN?/"
	Cmd$ = Cmd$ + " "
	print Cmd$;
gaAgain:
	gosub ArgCmdInput
	if not ip then
		s = 1
		on p goto pCurrent, pCurrent, pAll, pFirst, pLast, \
			pPrevious, pNext, pHelp, pHelp
	endif
return

pCurrent:
	print "Current"
	s = curMsg + not curMsg
	e = curMsg
return

pHelp:
	a$ = HELP_ARGS
	gosub PrintHelp
	print
	gosub ShowPrompt
goto gaAgain

pAll:
	print "All"
	e = msgs
return 

pFirst:
	print "First"
	e = 1
return 

pLast:
	print "Last"
	s = msgs
	e = msgs
return 

pPrevious:
	print "Previous";
	if curMsg > 1 then 
		s = curMsg - 1
		e = s
		print 
		return 
	endif
	print " -- first"
	pop
return


pNext:
	print "Next";
	if curMsg < msgs then 
		s = curMsg + 1
		e = s
		print
		return 
	endif
	print " -- last"
	pop
return


' --------------------  
  GetYN:
' --------------------  
	print "? Y^H";
	& clear 
	repeat
		get a$
		& ucase(a$)
		& pos ("N^MY", a$), p
	until p
	y% = p - 1
	print mid$("YesNo",1 + 3 * not y%,3)
return 

' --------------------
  GetVar:
' --------------------
	p = 0
	k = 0
	repeat
		& pos (p, a$, "$"),p
		if p then
			for j = 1 to varCount%
				& pos (var$[j],"="),q
				q = q + (not q)
				& spc(mid$(var$[j], 1, q - 1)), i$
				k = len(i$)
				& lcase(i$)
				v$ = mid$(a$, p + 1, k)
				& lcase(v$)
				if v$ = i$ then
					i$ = mid$(var$[j], q + 1)
					a$ = mid$(a$,1, p - 1) + i$ + \
						mid$(a$, p + k + 1)
					j = varCount%
					p = p - 1
				endif
			next
			p = p + 1
		endif
	until not p

	repeat
		& pos (a$,"  "),p
		if p then a$ = left$(a$,p) + mid$(a$,p + 2)
	until not p
	& spc(a$), a$
return 

SetVar:
	gosub GetVarVal
	if not k then
		if varCount% = MAX_VARS then return
		varCount% = varCount% + 1
		k = varCount%
	endif

	if varVal$ <> a$ then	
		var$[k] = v$ + varVal$
		varUpdate% = TRUE
	endif
return

GetVarVal:
	v$ = a$ + "="
	a$ = ""
	k = 0
	for j = 1 to varCount%
		if v$ = left$(var$[j], len(v$)) then
			a$ = mid$(var$[j], len(v$) + 1)
			k = j
			j = varCount%
		endif
	next
	j = val(a$)
return


' ====================
  PrintMsg:
' ====================

	gosub SetUpCopy
	gosub NoNewline

	' Find address of IOBuf%[0] for file I/O buffer space
		
	a1 = 0
	a2 = 0
	j = 0
	l = 0
	IOBuf%[0] = 0
	& erase(IOBuf%)
	fFre
	dim IOBuf%[IOBUF_SIZE / 2]
	IOBuf%[0] = 0
	& poke 0, peek(131), peek(132)

	' ========================================
	' WARNING: Do not introduce any undeclared
	' variables from this point on to the end
	' of the subroutine.
	' ========================================

	a1 = peek(0)
	a2 = peek(1)

	repeat
		j = k
		if k > IOBUF_SIZE then j = IOBUF_SIZE
		& poke _RWREFNUM, mboxRef, a1, a2, \
			j - int(j/256) * 256, int(j/256)
		& MLI (_READ, _SREAD), errCode
		if not errCode then
			l = peek(_RWTRANS)
			j = peek(_RWTRANS + 1)
			k = k - (l + j * 256)
			if not writeRef then
				call PrintBuffer
			else
				& poke _RWREFNUM, writeRef, a1, a2, l, j
				& MLI (_WRITE, _SWRITE), errCode
			endif
		endif
	until k < 1 or errCode
	& erase(IOBuf%)
return			


SetUpCopy:
	poke _SREFNUM, mboxRef
	k = abs(fpos[i]) - 1
	poke24 (_SMARK, k)
	& MLI (_SET_MARK, _SSETMRK), errCode
	k = abs(fpos[i + 1]) - 1 - k
return

NoNewline:
	& poke _NEWLREF, mboxRef, 0
	& MLI (_NEWLINE, _SNEWLIN), errCode
return

NoNewMail:
	print "No new mail."
goto Exit


' --------------------
  AccessOK:
' --------------------
	gosub CheckAccess
	if not AccOK then 
		print AccFile$": no access"
	endif
return 

	
' --------------------
  SetUpEnv:
' --------------------

	MailEnv$ = MAIL_ENV_FILE
	if ReturnFlag% then
		fRestore MailEnv$
		fDelete MailEnv$
		if msgs then
			fOpen MailBox$
			mboxRef = peek(_OREFNUM)
		endif
		whereLeap:
		on where% goto ReadTop, SendTop, EdVarReturn, ShellReturn
	endif

	dim fpos[MAX_MSGS + 1], var$[MAX_VARS]

	q$		= chr$(34)
	s$[0]		= "s"
	HdrFields$	= HEADER_FIELDS
	msg$		= " message"
	VarFile$	= ID$[uHome] + "/" + MAILRC
	EntryFile$	= TMPNAME
	TypeHelp$	= "Type ? for help."
	UsersMBox$	= MAIL_PATH + ID$[uName]	
	ChkNewMBox%	= FALSE

	signature$ = ID$[uHome] + "/signature" + i$
	& GETINFO ADM_PATH + ID$[uName] + "/mailstop",i$
	mailStop% = i$ > ""

	gosub ReadVars

	MailBox$ = UsersMBox$
	TheMode = READ_MAIL

	options$ = "m:sn"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "m" then
			AccFile$ = optarg$
			AccMode = accRead + accWrite + accDestroy
			gosub AccessOK
			if not AccOK then goto Exit
			MailBox$ = AccFile$
		endif
		if optchar$ = "n" then ChkNewMBox% = TRUE
		if optchar$ = "s" then TheMode = SEND_MAIL
		if optchar$ = "?" then
			print "Usage: " argv$[0] " [-m mbox] [-ns]"
			goto Exit
		endif
	until optchar$ = ""

	if nargc > 1 then
		TheMode = SEND_MAIL
		for i = 1 to nargc - 1
			To$ = To$ + nargv$[i] + " "
		next
		Cc$ = ""
	endif
return

ClearScreen:
	if clearSet% then & ioctl(ioClearScreen)
return


' --------------------
  ScanMBox:
' --------------------
	mboxRef = 0
	msgs = 0
	curMsg = 0
	fpos[1] = 1

	& GETINFO MailBox$, i$
	errMsg$ = "No mail."
	if i$ > "" then
		errMsg$ = "Not a mailbox."
		if asc(mid$(i$,5)) = 4 then
			fOpen MailBox$
			mboxRef = peek(_OREFNUM)
		endif
	endif

	& int stop
	& ioctl (ioClearScreen)

	if not heraldShown% then
		a$ = HELP_MAIL
		gosub PrintHelp2
		print XMAILER
		heraldShown% = TRUE
	endif

	if not mboxRef then
		print errMsg$
		return
	endif

	print "^MOpening...";

	poke _SREFNUM, mboxRef
	& MLI (_GET_EOF, _SGETEOF), errCode
	mboxEOF = peek24(_SEOF)
	onerr goto scanEOF
	fRead MailBox$
	repeat
		call FindFrom
		msgs = msgs + 1
		fpos[msgs] = peek24(_SMARK) - peek16(_RWTRANS) + 1
	until msgs = MAX_MSGS
	error (5)
	scanEOF:
	&onerr
	onerr goto HandleError
	fpos[msgs + 1] = mboxEOF + 1

	& ioctl (ioCR)
	& int on

	if msgs then
		if MailBox$ = UsersMBox$ then
			print "You have ";
		else
			print MailBox$ " has ";
		endif
		print msgs ; msg$ s$[msgs = 1] " (" mboxEOF " bytes)"
	else
		print "No mail."
		fClose MailBox$
		mboxRef = 0
		return
	endif

	if UsersMBox$ = MailBox$ then
		a$ = "current"
		gosub GetVarVal
		curMsg = j
	endif
	if curMsg < 0 or curMsg > msgs then curMsg = 0

	a$ = "summary"
	gosub GetVarVal
	if j then
		e = msgs
		s = 1
		if j = 2 then s = curMsg + not curMsg
		gosub Summary
	endif
return


SendMail:
	sendPrompt$ = CmdPrompt$
	& GETINFO EntryFile$, i$
	if i$ > "" then fDelete EntryFile$

	a$ = "replyto"
	gosub GetVarVal
	ReplyTo$ = a$
	
	& spc (To$), To$
	if msgs or To$ = "" then
		gosub EditTo
	else
		a$ = To$
		gosub EditTo2
		print "To: " To$
	endif
	gosub EditSubj
	if Cc$ > "" then gosub EditCc
	Bcc$ = ""

	fCreate EntryFile$ ",T4"

	if forwardFlag% then
		print "Edit before sending";
		gosub GetYN
		if not y% then
			gosub openEntryFile
			gosub appendFwdMsg
			goto sndSend
		endif
	endif

	if replyFlag% then
		print "Include" msg$;
		gosub GetYN
		if y% then
			gosub openEntryFile
			s = replyFlag%
			e = replyFlag%
			skipHdr% = TRUE
			gosub sndMsgIncl2
		endif
	endif
	
	gosub getInputEscape
	if escape$ = "" then
		where% = SEND_MAIL
		goto sndEdit			
	endif
	
	if clearSet% then
		gosub ClearScreen
		print "To: " To$
		print "Subject: " Subject$
	endif
	print

' --------------------
' Input Mode
' --------------------

	print "Enter your" msg$ ".  ";

ReInput:
	gosub getInputEscape
	if escape$ = "" then escape$ = "."
	a$ = "prompt"
	gosub GetVarVal
	j$ = a$
	print "Type " q$ escape$ q$ " on a new line to quit.^M"
	& int stop
	gosub openEntryFile
	i$ = ""
	repeat
		fFre
		print j$;
		& read (75, i$),a$
		k = mid$ (a$,1,1) = escape$ and len(a$) < 3
		fWrite EntryFile$
		if not k then print a$
	until k

	if len(a$) = 2 then 
		a% = asc(mid$(a$,2))
	else
		a% = 0
	endif

	gosub appendFwdMsg
	
' --------------------
' Send Command Level
' --------------------

SendTop:
	if forwardFlag% then
		gosub openEntryFile
		gosub appendFwdMsg
	endif

SendTop2:
	& pop
	& int on
	& on int goto SendTop2
	fFre
	where% = SEND_MAIL
	do
		print
		CmdPrompt$ = sendPrompt$ + "send>"
		CmdKeys$ = "^MSLAQE?/V$MHIFWCBTGO;+=-!R"
		Cmd$ = ""
		if a% then
			a$ = chr$(a%)
			a% = 0
			ip = 0
			& ucase (a$)
			& pos (CmdKeys$, a$), p
			if not p then print TypeHelp$
		else
			gosub CmdInput
		endif

		if ip then
			gosub ShowMsgs
		else
			on p gosub sndList,sndSend,sndList,sndAdd,sndQuit,\
				sndEdit,sndHelp,sndHelp,ViewFile,Variables,\
				sndModify,sndHdrIncl,sndMsgIncl,sndForward,\
				sndWrite,EditCc,EditBcc,EditTo,sndGetFile,\
				MBoxSwitch,ListSummary,MoreON,MoreON,MoreOFF,\
				ShellCommand,sndReplyTo
		endif
	loop

openEntryFile:
	fAppend EntryFile$
	tmpRef = peek(_OREFNUM)
return

appendFwdMsg:
	if forwardFlag% then 
		forwardFlag% = FALSE
		gosub openEntryFile
		gosub sndForwardMsgs
	endif
	fClose EntryFile$
return

getInputEscape:
	a$ = "escape"
	gosub GetVarVal
	escape$ = mid$(a$, 1, 1)
return

	
sndHdrIncl:
	skipHdr% = FALSE
	i$ = "Headers-"
	goto doMsgIncl
	
sndMsgIncl:
	skipHdr% = TRUE
	i$ = ""
doMsgIncl:
	Cmd$ = i$ + "Include"
	gosub Check4Msgs
	gosub GetArgs
sndMsgIncl2:
	a$ = "quote"
	gosub GetVarVal
	if a$ = "" then a$ = "> "
	linePfx$ = a$
	inclFlag% = TRUE
	TempFile$ = EntryFile$
	gosub openEntryFile
	gosub WriteMsgsWOHdr
	fClose EntryFile$
return

sndForward:
	Cmd$ = "Forward"
	gosub Check4Msgs
	gosub GetArgs
	gosub openEntryFile
goto sndForwardMsgs

	
Check4Msgs:
	if not msgs then
		print Cmd$ " -- no" msg$ "s"
		pop
		return
	endif	
return

sndModify:
	print "Modify^M"
	gosub EditTo
	gosub EditSubj
	gosub sndReplyTo
	gosub EditCc
EditBCc:
	& read (-250, Bcc$), "Bcc: ", a$
	gosub CheckAdrs
	Bcc$ = a$
return

EditTo:
	& spc(To$), To$
	& read (-250, To$), "To: ",a$
EditTo2:
	gosub CheckAdrs
	To$ = a$
	if To$ = "" then
		print "No mail sent."
		goto SendExit
	endif
return

EditCc:
	& read (-250, Cc$), "Cc: ", a$
	gosub CheckAdrs
	Cc$ = a$
return

EditSubj:	
	i$ = Subject$
	& read (-69,i$),"Subject: ", Subject$
return

sndReplyTo:
	i$ = ReplyTo$
	& read (-240, ReplyTo$), "Reply-To: ", ReplyTo$
return
	

sndSend:
	print "Sent to " To$ " ";
	if Cc$ > "" then print Cc$ " ";
	if Bcc$ > "" then print Bcc$ " ";
	a$ = "addsig"
	gosub GetVarVal
	if j then
		& GETINFO signature$,i$
		fFre
		if i$ > "" then & add(signature$ to EntryFile$)
	endif
	for ip = 0 to (Bcc$ > "")
		gosub UniqueName
		f$ = SPOOL_MAIL_PATH + msgID$
		fAppend f$
		gosub newHeader
		fClose f$
		fFre
		& add (EntryFile$ to f$)
	next 
	fDelete EntryFile$
	print 

SendExit:
	if TheMode = READ_MAIL then goto ReadTop
	gosub WriteVars
goto Exit

sndList:
	print "List^M"
	gosub ClearScreen
	ip = TRUE
	gosub newHeader
	& list EntryFile$
return

sndAdd:
	print "Add^M"
	pop
goto ReInput

sndQuit:
	print "Quit";
	gosub GetYN
	if y% then
		fDelete EntryFile$
		goto SendExit
	endif
return


newHeader:
	gosub MakeFromTime
	print "From " ID$[uName] " " fromTime$
	print "Date: " t$ " " SysInfo$[plZone]
	a$ = "from"
	gosub GetVarVal
	if a$ = "" then a$ = ID$[uName] + "@" + SITE_NAME
	print "From: " a$ " (" ID$[uFullName] ")"
	if ReplyTo$ > "" then print "Reply-To: " ReplyTo$
	a$ = "org"
	gosub GetVarVal
	if a$ > "" then print "Organization: " a$
	print "X-Mailer: " XMAILER
	print "To: " To$
	if Cc$ > "" then print "Cc: "Cc$
	if ip and Bcc$ > "" then print "Bcc: "Bcc$
	print "Subject: " Subject$
	print 
return 

sndEdit:
	print "Editor...";
	suMode = TRUE
	f$ = EntryFile$

EditFile:
	CommandLine$ = ID$[uEditor] + " " + f$

Sublaunch:
	fClose
	if asc(MailBox$) <> $2F then
		fPrefix
		& get a$
		MailBox$ = a$ + MailBox$
	endif
	fStore MailEnv$
Launch(CommandLine$, AppPath$, suMode)

sndGetFile:
	& read "Get: ",a$
	gosub CheckReadFile
	if AccOK then
		fFre
		& add(AccFile$ to EntryFile$)
	endif
return

CheckReadFile:
	& spc(a$),a$
	gosub GetVar
	AccOK = FALSE
	if a$ > "" then
		AccFile$ = a$
		AccMode = accRead
		gosub AccessOK
		if AccOK then
			& GETINFO AccFile$,i$
			if i$ = "" then
				print AccFile$": not found"
				AccOK = FALSE
			endif
		endif
	endif
return

sndWrite:
	print "Write ";
	gosub CheckWrite
	if AccOK then
		if not skipHdr% then
			fAppend AccFile$
			gosub newHeader
			fClose AccFile$
		endif
		fFre
		& add (EntryFile$ to AccFile$)
	endif
return

sndHelp:
	a$ = HELP_SEND
PrintHelp:
	print "Help^M"
	gosub ClearScreen
PrintHelp2:
	& list ETC_PATH + "help/mail." + a$
return


CheckAdrs:
	gosub GetVar
	if a$ > "" and mailStop% then
		gosub isOffsite
		if p then
			print "Can't send network mail."
			a$ = ""
		endif
	endif
return 

isOffsite:
	& pos (a$,"@"),p
	if not p then & pos(a$, "!"), p
	if not p then & pos(a$, "%"), p
return


sndForwardMsgs:
	f$ = EntryFile$
	i$ = " Forwarded Message "
	for i = s to e
		print "^M------" i$ "------"
		fFlush EntryFile$
		gosub WriteMsg
		fWrite EntryFile$
		print   "---- End" i$ "----^M"
	next 
	fClose f$
return


' ====================
  UniqueName:
' ====================
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
	j = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + \
		val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),a$
	msgID$ = chr$ (64 + i / 2) + chr$ (48 + j + 7 * (j > 9)) + a$
	& lcase (msgID$)
	if msgID$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = msgID$
	msgID$ = msgID$ + seq$
return


' ====================
  MakeFromTime:
' ====================
	& time(t$)
	fromTime$ = left$ (t$,3) + mid$ (t$,8,5) + mid$ (t$,6,3) + \
		right$ (t$,8) + " 19" + mid$ (t$,13,2)
return


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>

#define LAUNCH_PARSE
#include <proline/launch.lib>
