 ' ==================================================================
'
'	inspect.b	Inspects file archives, reports content info
'			Copyright (C) 1992-94 Jon C. Thomason
'			All Rights Reserved
'
' When     Who  Ver	What
' -------  ---	-----	--------------------------------------------
'          jct  2.0	Creation
' 28sep93  mwd	2.0b7	Changes for new CRC module.  Localized name,
'			version, date, and module name

#define	IDENT_PROG "inspect"		' Command name
#define	IDENT_VERS "3.0"		' Version number
#define	IDENT_DATE "12apr94"		' Modification date
#define	IDENT_NAME "Jon_C._Thomason"

'don't #define TCS
'don't #define APP_STAND_ALONE		' Always define if TCS is defined

#include <omm.h>
#include <fileio.h>
#include <amperworks.h>

#ifndef APP_STAND_ALONE
#include <modemworks.h>
#include <proline/proline.h>
#endif APP_STAND_ALONE

'---------------------------------------
' most of these are defined in <basic.h>

#define LoByte(v)	(v-int(v/$100)*$100)
#define HiByte(v)	int(v/$100)
#define LoWord(v)	(v-int(v/$100)*$100+(int(v-int(v/$10000)*$10000)/$100)*$100)
#define HiWord(v)	(int(v-int(v/$1000000)*$1000000)/$10000+int(v/$1000000)*$100)

#define Peek16(l)	(peek(l)+peek(l+1)*$100)
#define Peek32(l)	(peek(l)+peek(l+1)*$100+peek(l+2)*$10000+peek(l+3)*$1000000)

#define Peek16M(l)	(peek(l)*$100+peek(l+1))
#define Peek32M(l)	(peek(l)*$1000000+peek(l+1)*$10000+peek(l+2)*$100+peek(l+3))

#define Match3(a,b1,b2,b3)	(peek(a)=b1 and peek(a+1)=b2 and peek(a+2)=b3)
#define VisChar(i)	(i > 31) * i + (i < 32) * 32

#ifdef TCS
#include <modemworks.h>
#reserve D$, K$		' don't want to trample TCS variables
#else
#declare k$
#endif TCS

#declare argc,argv$,AccFile$,AccMode,AccOK,SysInfo$,optchar$,options$,nargc,nargv$
	' why aren't these in headers?
	' because when #declare is used, it forces all code that follows
	' to declare all their variables -- painful for converted programs.


#define CRC_ID		$5243		' ID of CRC module
#define CRC_MODULE	"CRC"		' Name of CRC module
#reserve CRC				' Command name

#declare	BufAddr, BufLen, FileID, base, FilePos

#declare	i%, j%, k%, r% 
#declare	i, j 
#declare	queued$, t$, o$, i$, j$
#declare	t, d, r, v

#declare	BinaryOption, RedirectOption, IdentifyOption
#declare	OutFile$, ErrPrefix$, Usage$

#declare	ver$, NotRecognized$, ColumnHeader$, P8TypesHex$, P8TypesAsc$


'****************************************************************************
'
' Start the bidding
'
'----------------------------------------------------------------------------

#ifdef APP_STAND_ALONE
	rem " " IDENT_PROG " " IDENT_VERS
#endif APP_STAND_ALONE
	rem " Copyright 1992-94 by Jon C. Thomason^J"

#ifndef APP_STAND_ALONE
	ver$ = IDENT_PROG " " IDENT_VERS
#endif APP_STAND_ALONE

	goto Initialize


'****************************************************************************
'
' Useful subroutines
'
'----------------------------------------------------------------------------

'=====================
' RedirectOutput

RedirectOutput:
	if RedirectOption then
		fAppend OutFile$
	endif
	return

'=====================
' GetMacType
'
' input: i% = offset from base
' output: i$ = four-character string

GetMacType:
	i$ = ""
	for i = 0 to 3
		i$ = i$ + chr$ ( VisChar( peek (base + i% + i)))
	next 
	return 

'=====================
' GetPString
'
' input: i% = offset from base
' output: i$ = string
GetPString:
	i$ = ""
	j% = peek (base + i%)
	on j% > 0 goto GetString
	return 					'null string

'=====================
' GetC1String
'
' input: i% = offset from base
' output: i$ = string
GetC1String:
	i$ = ""
	j% = peek (base + i%)
	i% = i% + 1
	on j% and (j% < 256) goto GetString
	j% = (j% > 0) * 255
	if not j% then 
		return 
	endif

'=====================
' GetPString
'
' input: i% = offset from base, j% = length
' output: i$ = string
GetString:
	for i = base + i% + 1 to base + i% + j%
		i$ = i$ + chr$ ( VisChar( peek (i)))
	next 
	return 

'=====================
' GetOffsetHexByte
'
' input: i% = offset from base
' output: i$ = hex string
GetOffsetHexByte:
	i% = peek (base + i%)

'=====================
' GetHexByte
'
' input: i% = byte
' output: i$ = hex string
GetHexByte:
	i$ = ""
	j% = i% / 16
	gosub PrintHexNibble
	j% = i% - j% * 16
	gosub PrintHexNibble
	return 

'=====================
' PrintHexNibble
'
' input: i% = nibble
' output: i$ = hex string
PrintHexNibble:
	i$ = i$ + mid$ ("0123456789ABCDEF",j% + 1,1)
	return 

'=====================
' ReadBuffer
'
' input: FilePos = file mark offset
ReadBuffer:
	& poke 768, 2, FileID, LoByte(FilePos), LoByte(HiByte(FilePos)), \
		HiByte(HiByte(FilePos)), 0, 4, FileID, LoByte(BufAddr), \
		HiByte(BufAddr), LoByte(BufLen), HiByte(BufLen), 0
	& mli(206,768),i%
	on i% > 0 goto MLIError
	& mli(202,774),i%
	on i% > 0 goto MLIError
	base = BufAddr
	return 

'=====================
' GetP8Filetype
'
' input: i$ = hex representation
' output: i$ = filetype
GetP8Filetype:
	&pos(P8TypesHex$,i$),i
	if i then
		i$=mid$(P8TypesAsc$,i,3)
	endif
	return


'****************************************************************************
'
' StartInfo - open file and identify it
'
'----------------------------------------------------------------------------
StartInfo:
	NotRecognized$ = "Not a recognized file structure."
	ColumnHeader$ = "Size   Filetype"
	read P8TypesHex$, P8TypesAsc$
	& CRC peek BufAddr, BufLen
	base = BufAddr
	& ucase(AccFile$)
	& / AccFile$,i$
	if not len (i$) then 
		print ErrPrefix$"File does not exist."
		goto FileDone
	endif
	AccFile$ = AccFile$ + ",T" + str$ ( asc ( mid$ (i$,5)))
	fOpen AccFile$
	FileID = peek(48848)
	FilePos = 0
#ifdef MODEMWORKS_ID
	& on int goto UserCancel
	& int on 
#endif MODEMWORKS_ID

ExamineHeader:
	gosub ReadBuffer
	on Match3(base,10,71,76) \
		goto ViewBNYFile							'check for Binary II signature
	on Match3(base,78,245,70) and Match3(base+3,233,108,229) \
		goto ViewSHKFile							'check NuFile
	on Match3(base,71,73,70) \
		goto ViewGIFFile							'check for GIF87a or GIF89a
	& crc new 0
	& crc (base, 124)
	& crc get j
	on (j = Peek16(base + 124)) \ 
		goto ViewMacFile			'check for valid MacBinary II header
	i% = 65
	gosub GetMacType
	on i$ = "PACT" or i$ = "SIT!" or i$ = "SITD" \ 
		goto ViewMacFile
	& pos (AccFile$,","),j%
	& pos right$ (AccFile$,"/"),i%
	on (j%-i%>4 and (mid$(AccFile$,i%+1,4)="MOD." or mid$(AccFile$,j%-4,4)=".MOD")) \
		goto ViewMODFile
	if not FilePos or not BinaryOption then 
		print ErrPrefix$ NotRecognized$
	endif

FileDone:
#ifdef MODEMWORKS_ID
	& int stop 
#endif MODEMWORKS_ID
	fClose
	& load fre CRC_ID
	goto Exit

#ifdef MODEMWORKS_ID
UserCancel:
	& int stop 
	print "ABORTED"
	goto FileDone
#endif MODEMWORKS_ID

MLIError:
#ifdef MODEMWORKS_ID
	& int stop 
#endif MODEMWORKS_ID
	& pop 
	fClose
	gosub GetHexByte
	print ErrPrefix$"MLI err "i$
	& load fre CRC_ID
	goto Exit


'------------------------------------------------------------
' ViewGIFFile
'
' knows at least GIF87a and GIF89a files.

ViewGIFFile:
	gosub RedirectOutput
	if FilePos and BinaryOption then
		print
	endif
	if IdentifyOption then
		print "File is a ";
	endif
	for i = 0 to 5							'display GIF version number
		print chr$ ( peek (base + i));
	next
	if IdentifyOption then
		print " graphic."
		goto FileDone
	endif
	print " image is " Peek16(base + 6)"x" Peek16(base + 8);
	i = int ( peek (base + 10) / 16)
	if i > 7 then 
		i = i - 8
	endif
	print " using "2 ^ (i + 1)" colors or greys."
	goto FileDone


'------------------------------------------------------------
' ViewBNYFile
'
' This is a known Binary II file. Display header and
' return to examine internal contents.

ViewBNYFile:
	gosub RedirectOutput
	if peek(base+127) then				'more than one file in BNY archive
		if IdentifyOption then
			print "This is a ProLine PAR archive."
		else
			print ErrPrefix$ NotRecognized$
		endif
		goto FileDone
	endif
	if BinaryOption then
		gosub RedirectOutput
		print "Binary II file"
		i% = 23
		gosub GetPString
		print "Filename: "i$
		i% = 4
		gosub GetOffsetHexByte
		i$ = "$" + i$
		gosub GetP8Filetype
		print "Filetype: "i$"/$";
		i% = 6
		gosub GetOffsetHexByte
		print i$;
		i% = 5
		gosub GetOffsetHexByte
		print i$
	endif 
	FilePos = FilePos + 128
	base = base + 128
	goto ExamineHeader		' look for an internal header


'------------------------------------------------------------
' ViewMacFile
'
' This is a known Mac file. Display header and dispatch
' to SIT and CPT routines when appropriate.

ViewMacFile:
	if BinaryOption then
		gosub RedirectOutput
		i% = 1
		gosub GetPString
		print "Filename: "i$
	endif
	i% = 65
	gosub GetMacType
	j$ = i$
	i% = 69
	gosub GetMacType
	if BinaryOption then
		print "Filetype: "j$"/"i$
		i = Peek32M(base + 83)
		if i then 
			print "    Data: "i" bytes"
		endif
		i = Peek32M(base + 87)
		if i then 
			print "Resource: "i" bytes"
		endif
	endif
	FilePos = FilePos + 128
	base = base + 128
	if j$ = "PACT" or (j$ = "APPL" and i$ = "CPCT") then 
		goto ViewCPTFile
	endif
	if j$ = "SIT!" or j$ = "SITD" or (j$ = "APPL" and i$ = "aust")
		goto ViewSITFile
	endif
	if IdentifyOption then
		print "This is an unrecognized Mac file."
	else
		if not BinaryOption then
			print ErrPrefix$ NotRecognized$
		endif
	endif
	goto FileDone


'------------------------------------------------------------
' ViewMODFile
'
' Very crude; no identification bytes.  Just prints name.

ViewMODFile:
	gosub RedirectOutput
	if FilePos and BinaryOption then
		print
	endif
	print "MOD music file is internally named " chr$ (34);
	for i = 0 to 19
		if peek (base + i) > 31 then 
			print chr$ ( peek (base + i));
		endif
	next 
	print chr$ (34)
	goto FileDone


'------------------------------------------------------------
' ViewSHKFile
'
' knows at least ShrinkIt 1.0 through ShrinkIt 3.4 files.
' GShk 1.1 files as well, but not self-extracting SEA ones.

ViewSHKFile:
	gosub RedirectOutput
	if FilePos and BinaryOption then
		print
	endif
	if IdentifyOption then
		print "This is a "mid$("BXYSHK",(not FilePos)*3+1)" archive."
		goto FileDone
	endif
	if not (Match3(base,78,245,70) and Match3(base+3,233,108,229)) then
		print ErrPrefix$"NuFX master header damaged."
		goto FileDone
	endif
	r% = Peek16(base + 8)
	print "Total entries: "r% spc(42-len(str$(r%))) ColumnHeader$
	FilePos = FilePos + 48
	base = base + 48
	if BufLen > 512 then 
		BufLen = 512
	endif

ViewSHKEntry:
	on (base > BufAddr + BufLen - 512) gosub ReadBuffer
	if not (Match3(base,78,245,70) and peek(base+3)=216) then
		fClose
		print ErrPrefix$"NuFX local header damaged."
		goto FileDone
	endif
	i% = 22
	gosub GetOffsetHexByte
	i$ = "$" + i$
	gosub GetP8Filetype
	t$ = i$
	i% = 27
	gosub GetOffsetHexByte
	t$ = t$ + " $" + i$
	i% = 26
	gosub GetOffsetHexByte
	t$ = t$ + i$
	k% = Peek16(base + 10)
	t = 0
	i% = Peek16(base + 6)
	FilePos = FilePos + i%
	base = base + i%
	i% = - 2
	gosub GetC1String
	k$ = i$
	FilePos = FilePos + len (k$)
	base = base + len (k$)
	d = 0
	r = 0
	v = 0
	for j = 1 to k%
		i% = Peek16(base + 0)
		j% = Peek16(base + 4)
#ifdef DEBUG
	print "threads: "k%"  thread: "J"  class: "I%"  kind: "J%
#endif DEBUG
		if i% = 2 and j% = 0 then 
			d = Peek32(base + 8)
		endif
		if i% = 2 and j% = 1 then 
			v = Peek32(base + 8)
		endif
		if i% = 2 and j% = 2 then 
			r = Peek32(base + 8)
		endif
		if i% = 3 and j% = 0 then 
			i$ = ""
			j% = Peek16(base + 8)
			i% = k% * 16 + t - 1
			gosub GetString
			k$ = i$
		endif
		t = t + Peek32(base + 12)
		FilePos = FilePos + 16
		base = base + 16
	next 
#ifdef DEBUG
	print "data: "D"  resource: "R"  volume: "V
#endif DEBUG
	if r then 
		d = d + r
		& mid$ (t$,4,1) = "+"
	endif
	if v and right$ (t$,4) = "0640" then 
		t$ = "800k disk"
		d = v
	endif
	if v and right$ (t$,4) = "0118" then 
		t$ = "140k disk"
		d = v
	endif
	if len (k$) > 50 then 
		k$ = ".." + right$ (k$,48)
	endif
	& left$ (k$,51),k$
	gosub RedirectOutput								'is this necessary?
	print "  "k$ right$ ("       " + str$ (d),8)"  "t$
	FilePos = FilePos + t
	base = 65536
	r% = r% - 1
	on r% > 0 goto ViewSHKEntry
	goto FileDone


'------------------------------------------------------------
' ViewCPTFile
'
' knows at least Compactor 1.0 through Compact Pro 1.33 files.

ViewCPTFile:
	gosub RedirectOutput
	if FilePos and BinaryOption then
		print
	endif
	i = Peek32M(base + 4)
	if not i then 
		print "This is segment " peek (base + 1)" of a multi-segment CPT archive."
		print "The list of files is kept in the last segment."
		goto FileDone
	endif
	if IdentifyOption then
		print "This is a"left$(" self-extracting ",16*(j$="APPL")+1)"CPT archive."
		goto FileDone
	endif
	FilePos = FilePos + i
	gosub ReadBuffer
	gosub RedirectOutput
	i% = 6
	gosub GetPString
	if len (i$) > 2 then 
		print "Archive comment: " len (i$)" bytes"
		print i$
	endif
	queued$ = str$ ( Peek16M(base + 4))
	o$ = "  "
	print "Total entries: "queued$ spc(42-len(queued$)) ColumnHeader$
	queued$ = queued$ + ";"
	FilePos = FilePos + 7 + peek (base + 6)
	base = base + 7 + peek (base + 6)

ViewCPTEntry:
	if not len (queued$) then 
		goto FileDone
	endif
	if not val (queued$) then 
		queued$ = mid$ (queued$,3)
		o$ = mid$ (o$,3)
		goto ViewCPTEntry
	endif
	i = val (queued$)
	& pos (queued$,";"),i%
	i = i - 1
	queued$ = str$ (i) + mid$ (queued$,i%)
	if (base > BufAddr + BufLen - 96) then
		gosub ReadBuffer
		gosub RedirectOutput
	endif
	if peek (base) < 128 then 
		goto NextCPTEntry
	endif
	poke base, peek (base) - 128
	i% = 0
	gosub GetPString
	& pos (queued$,";"),i%
	j = Peek16M(base +  len (i$) + 1)
	FilePos = FilePos + len (i$) + 3
	base = base + len (i$) + 3
	queued$ = str$ (j) + ";" + str$ ( val (queued$) - j) + mid$ (queued$,i%)
	i$ = o$ + i$
	& left$ (i$,72),i$
			' used to be: j$ = str$ (j) + left$(" items",6-(j=1)) + "     folder"
	j$ = "(folder)    "
	o$ = o$ + "  "
	print left$ (i$,72 - len (j$))j$
	goto ViewCPTEntry

NextCPTEntry:
	i% = 0
	gosub GetPString
	k% = peek (base) + 1
	k$ = i$
	i% = k% + 5
	gosub GetMacType
	j$ = i$
	i% = k% + 9
	gosub GetMacType
	j$ = str$ ( Peek32M(base+k%+29) + Peek32M(base+k%+33)) + "  " + j$ + "/" + i$
	i$ = o$ + k$
	if len(i$)>72 then
		&mid$(i$,70,2) = ".."
	endif
	& left$ (i$,72),i$
	print left$ (i$,72 - len (j$))j$
	FilePos = FilePos + peek (base) + 46
	base = base + peek (base) + 46
	goto ViewCPTEntry


'------------------------------------------------------------
' ViewSITFile
'
' knows at least StuffIt 1.0 through StuffIt Deluxe 3.0 files.

ViewSITFile:
	gosub RedirectOutput
	if FilePos and BinaryOption then
		print
	endif
	if IdentifyOption then
		print "This is a"left$(" self-extracting ",16*(j$="APPL")+1)"SIT archive."
		goto FileDone
	endif
	i% = 0
	gosub GetMacType
	j$ = i$
	i% = 10
	gosub GetMacType
	if j$ < > "SIT!" or i$ < > "rLau" then 
		fClose
		print ErrPrefix$"StuffIt archive header damaged."
		goto FileDone
	endif
	r% = Peek16M(base + 4)
	o$ = "  "
	print "Total records: "r% spc(42-len(str$(r%))) ColumnHeader$
	FilePos = FilePos + 22
	base = base + 22
	if BufLen > 512 then 
		BufLen = 512
	endif

ViewSITEntry:
	on (base > BufAddr + BufLen - 128) gosub ReadBuffer
	i% = 2
	gosub GetPString
	k$ = i$
	i% = 66
	gosub GetMacType
	j$ = i$
	i% = 70
	gosub GetMacType
	j = Peek32M(base + 84)
	i = Peek32M(base + 88)
	j$ = " " + str$ (j + i) + "  " + j$ + "/" + i$
	if peek (base) = 33 then 
		j = 0
		o$ = mid$ (o$,3)
		goto NextSITEntry
	endif
	if peek (base) = 32 then 
		j$ = "(folder)    "
	endif
	& left$ (o$ + k$,72),k$
	gosub RedirectOutput
	print left$ (k$,72 - len (j$))j$
	j = Peek32M(base + 92) + Peek32M(base + 96)
	if peek (base) = 32 then 
		FilePos = FilePos + 112
		base = base + 112
		o$ = o$ + "  "
		goto ViewSITEntry
	endif

NextSITEntry:
	FilePos = FilePos + j + 112
	base = base + j + 112
	r% = r% - ( len (o$) = 2)
	on r% > 0 goto ViewSITEntry
	goto FileDone


'****************************************************************************
'
' Libraries, initialize/exit
'
'----------------------------------------------------------------------------

#ifdef APP_STAND_ALONE

#ifdef TCS      '-------------------- TCS module stuff ---------------------
Initialize:
	& store D$(1)+"FILEINFO" to 2
	fStore D$(1)"FILEINFO"
	print
	fClose
	& load fre CRC_ID
	& load get (D$(0) + "omm/" CRC_MODULE)
	clear
	BinaryOption = 1
	& restore 1 to AccFile$
	goto StartInfo
Exit:
	fClose
	& load fre CRC_ID
	& restore 2 to k$
	fRestore k$
	& restore 2 to k$
	fDelete k$
	& restore 0 to k$
	fChain k$
#else			'-------------------- standalone module stuff ----------------
Initialize:
	fLaunch "omm.loader"
	fOutPort 3
	& load notrace
	& load get ("amperworks")
	& load get (CRC_MODULE)
	fCatalog
	print "Enter a filename: ";
	& read (60),AccFile$
	input "  Binary: ";BinaryOption
	input "Identify: ";IdentifyOption
	input "Redirect: ";RedirectOption
	OutFile$ = "/ram/test"
	&/OutFile$,i$
	if len(i$) then
		fDelete OutFile$
	endif
	goto StartInfo
Exit:
	fClose
	if RedirectOption then
		&/OutFile$,i$
		if len(i$) then
			print "File output:"
			&list(OutFile$)
			print "[eof]"
		endif
	endif
	& load fre 0
	end
#endif TCS

#else			'-------------------- Proline module stuff -----------------
Initialize:
	gosub AppInit
	ErrPrefix$ = argv$[0]+": "
	Usage$ = "Usage: "+argv$[0]+" [ -bi ] filename..."
	BinaryOption = 0
	IdentifyOption = 0
	optchar$ = ""
	options$ = "bi"
	&rept
		gosub getopt
		BinaryOption = BinaryOption + (optchar$ = "b")
		IdentifyOption = IdentifyOption + (optchar$ = "i")
		if optchar$ = "?" then
			print usage$
			goto FileDone
		endif
	&until (not len(optchar$))
	RedirectOption = asc(nargv$[nargc-1]) = 62
	if RedirectOption then
		nargc = nargc - 1
		OutFile$ = mid$(nargv$[nargc],2)
		AccFile$ = OutFile$
		&/AccFile$,i$
		i = i$ > ""
		AccMode = accRead + accDelete*i
		gosub CheckAccess
		if not AccOK then
			print ErrPrefix$"can't write to "AccFile$
			goto FileDone
		endif
		if i then
			fDelete OutFile$
		endif
	endif
	if nargc <> 2 then
		print ver$
		print usage$
		goto Exit
	endif
	& load fre CRC_ID
	& load get (SysInfo$[plModulesDir] + CRC_MODULE),i
	if i then
		print ErrPrefix$"could not load OMM module " CRC_MODULE
		goto Exit
	endif
	AccFile$ = nargv$[1]
	AccMode = accRead
	gosub CheckAccess
	if not AccOK then
		print ErrPrefix$"access denied."
		goto Exit
	endif
	goto StartInfo

#define	APP_AT_EXIT	cleanupModules
cleanupModules:
	& load fre CRC_ID
return

#include <proline/proline.lib>
#include <proline/getopt.lib>
#include <proline/access.lib>
#endif APP_STAND_ALONE


'****************************************************************************
'
' ProDOS 8 filetype lookup table
'
'----------------------------------------------------------------------------

	rem	" extensible filetype table^J"

' types in hex notation
	data "$00$01$04$06$0F$19$1A$1B$42$50$51$52$53$54$55$5A$B0$B1$B2$B3$B4$B5$B6$B7$B8$B9$BA$BB$BC$BD$BF$C0$C1$C2$C7$C8$C9$CA$D5$D6$D7$D8$E0$E2$F0$FA$FB$FC$FD$FE$FF"

' same types in ASCII notation
	data "UNKBADTXTBINDIRADBAWPASPFTDGWPGSSGDBDRWGDPHMDCFGSRCOBJLIBS16RTLEXEPIFTIFNDACDATOLDRVLDFFSTDOCPNTPICANICDVFONFNDICNMUSINSMDISNDLBRATKCMDINTIVRBASVARRELSYS"
