' **********************************************************************
' ***
' ***	find.b		Searches directories for a file
' ***			(C)opright 1994 Morgan Davis Group
' ***
' *** 30jan94 mwd 3.0	Completely rewritten with all new features

#define IDENT_PROG "find"
#define IDENT_VERS "3.0"
#define IDENT_DATE "31jan94"
#define IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <ctype.h>
#include <proline/proline.h>

#define	INIT_SELECTOR		inName, inAttribute, inType, inAuxType, \
				inSize, inLittler, inBigger, inModDate, \
				inOlder, inNewer

#define	MATCH_SELECTOR		doName, doAttribute, doType, doAuxType, \
				doSize, doLittler, doBigger, doModDate, \
				doOlder, doNewer

#define	MAXFILES	512
#define	MAXDIRDEPTH	16
#define	MAXSELECTORS	20

#define	PR_DEFAULT	""

	gosub AppInit

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif

	dim selector[MAXSELECTORS], selectArg$[MAXSELECTORS], \
		selectArg[MAXSELECTORS], selectArg2[MAXSELECTORS], \
		selectNeg[MAXSELECTORS]

	selected	= 0
	negate		= FALSE
	info$		= ""
	needInfo	= FALSE
	attr$		= "rwi34bnd"
	dateLen		= 2

	prString$	= PR_DEFAULT
	visMode		= visible_only
	maxDepth	= MAXDIRDEPTH
	maxMatches	= 0
	totalMatches	= 0
	printMatches	= FALSE
	
	selectorOpts$ = "N:A:T:X:S:L:B:M:O:Y:"
	options$ = "?!icad:f:hp:q:tv" + selectorOpts$
	optchar$ = ""
	repeat
		gosub getopt
		& pos (selectorOpts$, optchar$), sel
		if sel then
			sel = (sel + 1) / 2
			on sel gosub INIT_SELECTOR
			if sel > 1 then needInfo = TRUE
			selected = selected + 1
			selector[selected] = sel
			selectArg$[selected] = optarg$
			selectArg[selected] = optarg
			selectArg2[selected] = optarg2
			selectNeg[selected] = negate
			negate = FALSE
		else
			if optchar$ = "?" or optchar$ = "h" then showUsage = TRUE
			if optchar$ = "!" then negate = TRUE
			if optchar$ = "i" then visMode = invisible_only
			if optchar$ = "a" then visMode = vis_and_invis
			if optchar$ = "c" then printMatches = TRUE
			if optchar$ = "d" then maxDepth = val(optarg$)
			if optchar$ = "f" then gosub inCompareToFile
			if optchar$ = "p" then prString$ = optarg$
			if optchar$ = "q" then maxMatches = val(optarg$)
			if optchar$ = "t" then dateLen = 4
			if optchar$ = "v" then progress = TRUE
		endif
	until optchar$ = ""			

	if showUsage then
		if outputFile$ > "" then fAppend outputFile$
		print "Usage: " argv$[0] " [ options ] [ path... ] [ >output ]"
		print "Options:"
		print "	-a		check all files"
		print "	-c		report match count"
		print "	-d levels	search n directory levels deep"
		print "	-f file		compare with file"
		print "	-i		check only invisible files"
		print "	-p pattern	output pattern (with %, %s, %p, %n, %x)"
		print "	-q n		quit after n matches"
		print "	-t		include time in date searches"
		print "	-v		verbose"
		print "Selectors:"
		print "	-A attrib	attributes"
		print "	-N pattern	name"
		print "	-T type		type"
		print "	-X auxtype	auxiliary type"
		print "	-S blocks	size"
		print "	-B blocks	bigger than"
		print "	-L blocks	smaller than"
		print "	-M date		modified"
		print "	-O date		older than"
		print "	-Y date		younger than"
		goto ExitError
	endif

	dim pathIndex[maxDepth + 1]

	if nargc = 1 then
		fPrefix
		& get nargv$[1]
		if prString$ = PR_DEFAULT then prString$ = "./%x"
	endif

	if not selected then
		selector[1] = 1
		selectArg$[1] = "*"
		selectArg[1] = 1
		selected = 1
	endif
	
	for cd = 1 to nargc - 1
		path$ = nargv$[cd]
		if path$ = "/" then
			& pos(2, SysInfo$[plDir], "/"), p
			path$ = left$(SysInfo$[plDir], p - 1)
		endif
		if right$(path$, 1) = "/" then
			path$ = left$(path$, len(path$) - 1)
		endif
		& getinfo path$, i$
		if i$ = "" or mid$(i$,5,1) <> chr$(15) then
			print argv$[0]": can't open " path$
		else
			origPath$ = path$
			gosub searchPath
		endif
	next

	if printMatches then
		if outputFile$ > "" and not opened then fAppend outputFile$
		print totalMatches
	endif
goto Exit


inName:
	& ucase(optarg$)
	& pos (optarg$,"*"), optarg
	& pos (optarg + 1, optarg$,"*"), optarg2
return

checkEqualArg:
	if optarg$ = "=" and info$ = "" then
		& print argv$[0] ": can't use = without -f first"
		goto ExitError
	endif
return

inAttribute:
	attrBits = $00
	for i = 0 to len(optarg$) - 1
		a$ = mid$(optarg$, i + 1, 1)
		&pos (attr$, a$), p
		if not p then
			print argv$[0]": unknown attribute '"a$"'"
			goto ExitError
		endif
		attrBits = attrBits + 2 ^ (p - 1)
	next
	optarg = attrBits
return

inType:
	gosub checkEqualArg
	if optarg$ = "=" then
		optarg = asc(mid$(info$, 5, 1))
	else
		optarg = val(optarg$)
	endif
return

inAuxType:
	gosub checkEqualArg
	if optarg$ = "=" then
		optarg = asc(mid$(info$, 6, 1)) + asc(mid$(info$, 7, 1)) * 256
	else
		optarg = val(optarg$)
	endif
return

inSize:
inLittler:
inBigger:
	gosub checkEqualArg
	if optarg$ = "=" then
		optarg = asc(mid$(info$,9)) + \
			asc(mid$(info$,10)) * 256
	else
		optarg = val(optarg$)
	endif
return

inModDate:
inOlder:
inNewer:
	gosub checkEqualArg
	if optarg$ = "=" then
		date$ = mid$(info$,12,1) + mid$(info$,11,1) + \
			mid$(info$,14,1) + mid$(info$,13,1)
	else
		a$ = optarg$
		gosub parseDate
	endif
	optarg$ = date$
return

inCompareToFile:
	& getinfo optarg$, info$
	if info$ = "" then
		& print argv$[0] ": comparison file '" optarg$ "' not found"
		goto ExitError
	endif
return


searchPath:
	depth = 0
	thePath$ = ""
	gosub pushDir
	repeat
		dirFlag = FALSE
		if opened then
			fClose
			opened = FALSE
		endif
		if progress then
			& lcase(thePath$)
			print argv$[0]": searching " thePath$;
			& ioctl(ioClearEOL)
			& ioctl(ioCR)
			progressON% = TRUE
		endif
		dim f$[MAXFILES]
		& tfiles(thePath$, f$, , visMode),f
		if f >= pathIndex[depth] then
			& sort (f$, f)
			for cf = pathIndex[depth] to f
				f$ = f$[cf]
				& pos ("*/", right$(f$,1)), dirFlag
				if dirFlag then
					f$ = left$(f$, len(f$) - 1)
					dirFlag = dirFlag - 1
				endif
				gosub findFile
				if dirFlag then
					if depth < maxDepth then
						path$ = f$
						pathIndex[depth] = cf + 1
						gosub pushDir
						cf = f
					else
						dirFlag = 0
					endif
				endif
			next
		endif
		& erase(f$)
		fFre
		if not dirFlag then gosub popDir
	until not depth
	if progress then & ioctl(ioClearEOL)
return

pushDir:
	depth = depth + 1
	thePath$ = thePath$ + path$ + "/"
	pathIndex[depth] = 1
return

popDir:
	depth = depth - 1
	if depth then
		& < thePath$, thePath$
		thePath$ = thePath$ + "/"
	endif
return


findFile:
	if needInfo then
		& getinfo thePath$ + f$, info$
	else
		info$ = ""
	endif
	match = 1
	repeat
		on selector[match] gosub MATCH_SELECTOR
		if found = selectNeg[match] then return
		match = match + 1	
	until match > selected

	totalMatches = totalMatches + 1
	
	if progressON% then
		& ioctl(ioClearEOL)
		progressON% = FALSE
	endif

	& lcase(f$)
	& lcase(thePath$)
	a$ = thePath$ + f$

	if prString$ > "" then
		if prString$ = "%" then return
		q = 0
		i$ = prString$
		repeat
			k$ = "%"
			& pos (q + 1, i$, k$), p
			if p then
				& pos ("fpnxs", mid$(i$, p + 1, 1)), k
				on k gosub pFull, pPrfx, pName, pExcl, pBlks
				i$ = mid$ (i$,1,p - 1) + k$ + mid$ (i$,p + 2)
				q = p + len(k$)
			endif
		until not p
		a$ = i$
	endif

	if outputFile$ > "" and not opened then
		fAppend outputFile$
		opened = TRUE
	endif
	print a$

	if totalMatches = maxMatches then
		dirFlag = TRUE
		depth = 0
		maxDepth = 0
		cf = f
	endif
return

pFull:	k$ = a$ : return
pPrfx:	k$ = thePath$ : return
pName:	k$ = f$ : return
pExcl:	k$ = mid$(a$, len(origPath$) + 2) : return
pBlks:	if info$ = "" then & getinfo a$, info$
	k$ = str$(asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256)
	return

doName:
	name$ = selectArg$[match]
	if not selectArg[match] then 
		found = f$ = name$
		return 
	endif

	if name$ = "*" then 
		found = TRUE
		return 
	endif

	wc = selectArg[match]
	w2 = selectArg2[match]
	
	if wc and w2 then
		& pos (f$, mid$ (name$,wc + 1,w2 - wc - 1)),found
		return
	endif

	if wc = 1 then
		found = mid$ (name$,2) = right$ (f$, len (mid$ (name$,2)))
	else
		found = left$ (f$,wc - 1) = left$ (name$,wc - 1)
	endif
return 

doAttribute:
	& poke $300, \
		$A9, asc(mid$(info$, 4)), \
		$29, selectArg[match], \
		$49, selectArg[match], \
		$85, $00, \
		$60
	call $300
	found = not peek(0)
return

doType:
	found = asc(mid$(info$, 5)) = selectArg[match]
return	

doAuxType:
	found = asc(mid$(info$, 6, 1)) +  \
		asc(mid$(info$, 7, 1)) * 256 = selectArg[match]
return	

doSize:
	found = (asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256) = selectArg[match]
return

doLittler:
	found = (asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256) < selectArg[match]
return

doBigger:
	found = (asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256) > selectArg[match]
return


#define	filedate	left$(mid$(info$,12,1) + mid$(info$,11,1) + \
			mid$(info$,14,1) + mid$(info$,13,1), dateLen)
#define	finddate	left$(selectArg$[match], dateLen)

doModDate:
	found = filedate = finddate
return

doOlder:
	found = filedate < finddate
return

doNewer:
	found = filedate > finddate
return


testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return


#define	ValidDate(n,vmin,vmax)	_vn = n : _vmin = vmin : _vmax = vmax : \
				gosub _validDate

parseDate:
	&lcase (a$)
	if a$ = "." then
		& time(a$)	' Thu, 12 Jan 94 00:11:22
		& pos ("?anebarprayunulugepctovec", mid$ (a$, 10, 2)), mo
		mo = mo / 2
		dd = val(mid$(a$, 6))
		yy = val(mid$(a$, 13))
		hh = val(mid$(a$, 16))
		mm = val(mid$(a$, 19))
		return
	endif
		
	mo	= val(mid$(a$, 1, 2))
	ValidDate (mo, 1, 12)
	dd = val(mid$(a$, 4, 2))
	ValidDate (dd, 1, 31)
	yy = val(mid$(a$, 7, 2))
	ValidDate (yy, 0, 99)

	if len(a$) < 13 then
		& time(a$)
		a$ = mid$(a$, 16, 5)
	else
		a$ = mid$(a$, 10)
	endif
	hh = val(a$)
	if hh < 12 and mid$(a$, 7, 1) = "p" then
		hh = hh + 12
	endif
	if hh = 12 and mid$(a$, 7, 1) = "a" then
		hh = 0
	endif
	ValidDate (hh, 0, 23)
	mm = val(mid$(a$, 4, 2))
	ValidDate (mm, 0, 59)

	monthBit = mo > 7
	date$ = chr$(yy * 2 + monthBit) + \
		chr$(dd + ((mo - (monthBit * 8)) * 32)) + \
		chr$(hh) + \
		chr$(mm)
return

_validDate:
	if _vn < _vmin or _vn > _vmax then
		print argv$[0] ": invalid date"
		goto ExitError
	endif
return


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
