' ************************************************************************
' **
' **  dstat.b		Change directory access status
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 30sep93 mwd 1.1	Created
' ** 16mar94 mwd 3.0	Allow users to dstat their own directories.  Sigh.
' **

#define IDENT_PROG "dstat"
#define IDENT_VERS "3.0"
#define IDENT_DATE "16mar94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>


	gosub AppInit

	perm$[1] = "read"
	perm$[2] = "write"
	perm$[3] = "destroy"
	perm$[4] = "execute"

	if argc = 1 then 
		gosub addCurDir
		goto reportStatus
	endif

	& pos ("-=+", left$(argv$[1],1)), opcode
	if not opcode then goto reportStatus
	
	opcode = opcode - 2

	' opcode:	-1 = remove permission
	'		 0 = set absolute permission
	'		 1 = add permission

	a$ = mid$ (argv$[1], 2)
	& lcase(a$)
	if a$ = "" then
		permbits = $0F
	else
		for i = 1 to len(a$)
			i$ = mid$(a$, i, 1)
			& pos ("rwdx", i$),p
			if not p then
				&print argv$[0] ": invalid option `" i$ "'"
				showUsage = TRUE
			else
				if not perm[p]
					permbits = permbits + (2 ^ p) / 2
					perm[p] = TRUE
				endif
			endif
		next 
	
		if showUsage then
			&print "Usage: "argv$[0]" [opcode-permission] [directory ...]"
			goto Exit
		endif
	
		if argc = 2 then gosub addCurDir
	endif
	
	' Set status

	for i = 2 to argc - 1
		accFile$ = argv$[i]
		& getinfo accFile$, info$
		gosub checkFileInfo
		accMode = accRead + accWrite + accDestroy + accRun
		if accFile$ <> ID$[uHome] then
			gosub CheckAccess
			if not accOK then 
				&print argv$[0]": can't access " accFile$
				goto ExitError
			endif
		endif

		' See if target is a root volume and don't allow
	
		& prevdir accFile$,i$
		if accFile$ = i$ then 
			&print argv$[0]": can't modify " accFile$
			goto ExitError
		endif
		if opcode then
			a% = asc(mid$(info$,6))
			if opcode = 1 then
				& poke 768,169,a%,9,permbits,133,0,96
			else
				& poke 768,169,permbits,73,15,41,a%,133,0,96
			endif
			call 768
			permbits = peek(0)
		endif
		& mid$ (info$,6) = chr$(permbits)
		& setinfo accFile$, info$
		gosub showStatus2
	next 
goto Exit


' ====================
  reportStatus:
' ====================
	for i = 1 to argc -1
		accFile$ = argv$[i]
		gosub showStatus
	next 
goto Exit


showStatus:
	& getinfo accFile$, info$
	gosub checkFileInfo
	permbits = asc(mid$(info$,6))

showStatus2:
	if not permbits then goto nonownReport
	& prevdir accFile$, j$
	if accFile$ = j$ then goto nonownReport
	j = 1
	l = 0
	for k = 1 to 4
		j = j + j
		if int ((permbits / j - int (permbits / j)) * 2) then 
			l = l + 1
			rperm[l] = k
		endif
	next 
	print "Non-owners of " accFile$ " can ";
	for k = 1 to l
		print perm$[rperm[k]];
		if k < (l - 1) then print ",";
		print " ";
		if k = l - 1 then print "and ";
	next 
	print "files."
return 


nonownReport:
	print "Non-owners of " accFile$ " cannot access its files."
return 



' ====================
  addCurDir:
' ====================
	fPrefix
	& get argv$[argc]
	& lcase(argv$[argc])
	argc = argc + 1
return 

' ====================
  checkFileInfo:
' ====================
	&lcase(accFile$)
	if right$(accFile$, 1) = "/" then
		accFile$ = mid$(accFile$, 1, len(accFile$) - 1)
	endif
	if info$ = "" then 
		&print argv$[0]": " accFile$ " not found"
		goto ExitError
	endif
	if asc (mid$(info$,5)) < > 15 then 
		print argv$[0]": " accFile$ " not a directory"
		goto ExitError
	endif
return 

#include <proline/proline.lib>
#include <proline/access.lib>
